/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.ext;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.jgrapht.Graph;
import org.jgrapht.WeightedGraph;
import org.jgrapht.ext.CSVBaseListener;
import org.jgrapht.ext.CSVFormat;
import org.jgrapht.ext.CSVLexer;
import org.jgrapht.ext.CSVParser;
import org.jgrapht.ext.DSVUtils;
import org.jgrapht.ext.EdgeProvider;
import org.jgrapht.ext.GraphImporter;
import org.jgrapht.ext.ImportException;
import org.jgrapht.ext.VertexProvider;

public class CSVImporter<V, E>
implements GraphImporter<V, E> {
    private static final char DEFAULT_DELIMITER = ',';
    private CSVFormat format;
    private VertexProvider<V> vertexProvider;
    private EdgeProvider<V, E> edgeProvider;
    private char delimiter;
    private final Set<CSVFormat.Parameter> parameters;

    public CSVImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider) {
        this(vertexProvider, edgeProvider, CSVFormat.ADJACENCY_LIST, ',');
    }

    public CSVImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider, CSVFormat format) {
        this(vertexProvider, edgeProvider, format, ',');
    }

    public CSVImporter(VertexProvider<V> vertexProvider, EdgeProvider<V, E> edgeProvider, CSVFormat format, char delimiter) {
        if (vertexProvider == null) {
            throw new IllegalArgumentException("Vertex provider cannot be null");
        }
        this.vertexProvider = vertexProvider;
        if (edgeProvider == null) {
            throw new IllegalArgumentException("Edge provider cannot be null");
        }
        this.edgeProvider = edgeProvider;
        this.format = format;
        if (!DSVUtils.isValidDelimiter(delimiter)) {
            throw new IllegalArgumentException("Character cannot be used as a delimiter");
        }
        this.delimiter = delimiter;
        this.parameters = new HashSet<CSVFormat.Parameter>();
    }

    public CSVFormat getFormat() {
        return this.format;
    }

    public void setFormat(CSVFormat format) {
        this.format = format;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        if (!DSVUtils.isValidDelimiter(delimiter)) {
            throw new IllegalArgumentException("Character cannot be used as a delimiter");
        }
        this.delimiter = delimiter;
    }

    public boolean isParameter(CSVFormat.Parameter p) {
        return this.parameters.contains((Object)p);
    }

    public void setParameter(CSVFormat.Parameter p, boolean value) {
        if (value) {
            this.parameters.add(p);
        } else {
            this.parameters.remove((Object)p);
        }
    }

    @Override
    public void importGraph(Graph<V, E> graph, Reader input) throws ImportException {
        switch (this.format) {
            case EDGE_LIST: 
            case ADJACENCY_LIST: {
                this.read(graph, input, new AdjacencyListCSVListener(graph));
                break;
            }
            case MATRIX: {
                this.read(graph, input, new MatrixCSVListener(graph));
            }
        }
    }

    private void read(Graph<V, E> graph, Reader input, CSVBaseListener listener) throws ImportException {
        try {
            ThrowingErrorListener errorListener = new ThrowingErrorListener();
            CSVLexer lexer = new CSVLexer(new ANTLRInputStream(input));
            lexer.setSep(this.delimiter);
            lexer.removeErrorListeners();
            lexer.addErrorListener(errorListener);
            CSVParser parser = new CSVParser(new CommonTokenStream(lexer));
            parser.removeErrorListeners();
            parser.addErrorListener(errorListener);
            CSVParser.FileContext graphContext = parser.file();
            ParseTreeWalker walker = new ParseTreeWalker();
            walker.walk(listener, graphContext);
        }
        catch (IOException e) {
            throw new ImportException("Failed to import CSV graph: " + e.getMessage(), e);
        }
        catch (ParseCancellationException pe) {
            throw new ImportException("Failed to import CSV graph: " + pe.getMessage(), pe);
        }
        catch (IllegalArgumentException iae) {
            throw new ImportException("Failed to import CSV graph: " + iae.getMessage(), iae);
        }
    }

    private abstract class RowCSVListener
    extends CSVBaseListener {
        protected Graph<V, E> graph;
        protected List<String> row;
        protected Map<String, V> vertices;
        protected boolean header;

        public RowCSVListener(Graph<V, E> graph) {
            this.graph = graph;
            this.row = new ArrayList<String>();
            this.vertices = new HashMap();
            this.header = false;
        }

        @Override
        public void enterHeader(CSVParser.HeaderContext ctx) {
            this.header = true;
        }

        @Override
        public void exitHeader(CSVParser.HeaderContext ctx) {
            this.header = false;
        }

        @Override
        public void enterRecord(CSVParser.RecordContext ctx) {
            this.row.clear();
        }

        @Override
        public void exitRecord(CSVParser.RecordContext ctx) {
            if (this.row.isEmpty()) {
                throw new ParseCancellationException("Empty CSV record");
            }
            this.handleRow();
        }

        @Override
        public void exitTextField(CSVParser.TextFieldContext ctx) {
            this.row.add(ctx.TEXT().getText());
        }

        @Override
        public void exitStringField(CSVParser.StringFieldContext ctx) {
            this.row.add(DSVUtils.unescapeDSV(ctx.STRING().getText(), CSVImporter.this.delimiter));
        }

        @Override
        public void exitEmptyField(CSVParser.EmptyFieldContext ctx) {
            this.row.add("");
        }

        protected abstract void handleRow();
    }

    private class MatrixCSVListener
    extends RowCSVListener {
        private boolean assumeNodeIds;
        private boolean assumeEdgeWeights;
        private boolean assumeZeroWhenNoEdge;
        private int verticesCount;
        private int currentVertex;
        private String currentVertexName;
        private Map<Integer, String> columnIndex;

        public MatrixCSVListener(Graph<V, E> graph) {
            super(graph);
            this.assumeNodeIds = CSVImporter.this.parameters.contains((Object)CSVFormat.Parameter.MATRIX_FORMAT_NODEID);
            this.assumeEdgeWeights = CSVImporter.this.parameters.contains((Object)CSVFormat.Parameter.MATRIX_FORMAT_EDGE_WEIGHTS);
            this.assumeZeroWhenNoEdge = CSVImporter.this.parameters.contains((Object)CSVFormat.Parameter.MATRIX_FORMAT_ZERO_WHEN_NO_EDGE);
            this.verticesCount = 0;
            this.currentVertex = 1;
            this.currentVertexName = null;
            this.columnIndex = new HashMap<Integer, String>();
        }

        @Override
        protected void handleRow() {
            if (this.assumeNodeIds) {
                if (!this.header) {
                    this.currentVertexName = (String)this.row.get(0);
                }
                this.row.remove(0);
            } else {
                this.currentVertexName = String.valueOf(this.currentVertex);
            }
            if (this.header) {
                if (this.assumeNodeIds) {
                    this.createVerticesFromNodeIds();
                } else {
                    this.createVertices();
                    this.createEdges();
                    ++this.currentVertex;
                }
            } else {
                this.createEdges();
                ++this.currentVertex;
            }
        }

        private void createVerticesFromNodeIds() {
            this.verticesCount = this.row.size();
            if (this.verticesCount < 1) {
                throw new ParseCancellationException("Failed to parse header with vertices");
            }
            int v = 1;
            for (String vertexName : this.row) {
                if (vertexName.trim().isEmpty()) {
                    throw new ParseCancellationException("Failed to parse header with vertices (empty name)");
                }
                Object vertex = CSVImporter.this.vertexProvider.buildVertex(vertexName, new HashMap<String, String>());
                this.vertices.put(vertexName, vertex);
                this.graph.addVertex(vertex);
                this.columnIndex.put(v, vertexName);
                ++v;
            }
        }

        private void createVertices() {
            this.verticesCount = this.row.size();
            if (this.verticesCount < 1) {
                throw new ParseCancellationException("Failed to parse header with vertices");
            }
            int v = 1;
            for (v = 1; v <= this.verticesCount; ++v) {
                String vertexName = String.valueOf(v);
                Object vertex = CSVImporter.this.vertexProvider.buildVertex(vertexName, new HashMap<String, String>());
                this.vertices.put(vertexName, vertex);
                this.graph.addVertex(vertex);
                this.columnIndex.put(v, vertexName);
            }
        }

        private void createEdges() {
            if (this.row.size() != this.verticesCount) {
                throw new ParseCancellationException("Row contains fewer than " + this.verticesCount + " entries");
            }
            int target = 1;
            for (String entry : this.row) {
                try {
                    Integer entryAsInteger = Integer.parseInt(entry);
                    if (entryAsInteger == 0) {
                        if (!this.assumeZeroWhenNoEdge && this.assumeEdgeWeights) {
                            this.createEdge(this.currentVertexName, this.columnIndex.get(target), 0.0);
                        }
                    } else if (this.assumeEdgeWeights) {
                        this.createEdge(this.currentVertexName, this.columnIndex.get(target), (double)entryAsInteger);
                    } else {
                        this.createEdge(this.currentVertexName, this.columnIndex.get(target), null);
                    }
                    ++target;
                }
                catch (NumberFormatException entryAsInteger) {
                    try {
                        Double entryAsDouble = Double.parseDouble(entry);
                        if (!this.assumeEdgeWeights) {
                            throw new ParseCancellationException("Double entry found when expecting no weights");
                        }
                        this.createEdge(this.currentVertexName, this.columnIndex.get(target), entryAsDouble);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++target;
                }
            }
        }

        private void createEdge(String sourceName, String targetName, Double weight) {
            try {
                Object source = this.vertices.get(sourceName);
                Object target = this.vertices.get(targetName);
                String label = "e_" + source + "_" + target;
                Object e = CSVImporter.this.edgeProvider.buildEdge(source, target, label, new HashMap<String, String>());
                this.graph.addEdge(source, target, e);
                if (weight != null && this.graph instanceof WeightedGraph) {
                    ((WeightedGraph)this.graph).setEdgeWeight(e, weight);
                }
            }
            catch (IllegalArgumentException e) {
                throw new ParseCancellationException("Provided graph does not support input: " + e.getMessage(), e);
            }
        }
    }

    private class AdjacencyListCSVListener
    extends RowCSVListener {
        public AdjacencyListCSVListener(Graph<V, E> graph) {
            super(graph);
        }

        @Override
        protected void handleRow() {
            String sourceKey = (String)this.row.get(0);
            if (sourceKey.isEmpty()) {
                throw new ParseCancellationException("Source vertex cannot be empty");
            }
            Object source = this.vertices.get(sourceKey);
            if (source == null) {
                source = CSVImporter.this.vertexProvider.buildVertex(sourceKey, new HashMap<String, String>());
                this.vertices.put(sourceKey, source);
                this.graph.addVertex(source);
            }
            this.row.remove(0);
            for (String key : this.row) {
                if (key.isEmpty()) {
                    throw new ParseCancellationException("Target vertex cannot be empty");
                }
                Object target = this.vertices.get(key);
                if (target == null) {
                    target = CSVImporter.this.vertexProvider.buildVertex(key, new HashMap<String, String>());
                    this.vertices.put(key, target);
                    this.graph.addVertex(target);
                }
                try {
                    String label = "e_" + source + "_" + target;
                    Object e = CSVImporter.this.edgeProvider.buildEdge(source, target, label, new HashMap<String, String>());
                    this.graph.addEdge(source, target, e);
                }
                catch (IllegalArgumentException e) {
                    throw new ParseCancellationException("Provided graph does not support input: " + e.getMessage(), e);
                }
            }
        }
    }

    private class ThrowingErrorListener
    extends BaseErrorListener {
        private ThrowingErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) throws ParseCancellationException {
            throw new ParseCancellationException("line " + line + ":" + charPositionInLine + " " + msg);
        }
    }
}

