/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.exception;

import com.ubnt.net.v2.exception.ErrorMessage;
import com.ubnt.net.v2.exception.NotImplementedOnDeviceException;
import com.ubnt.net.v2.exception.RequestValidationException;
import com.ubnt.net.v2.exception.ResourceNotFoundException;
import com.ubnt.service.ooOO.L;
import org.slf4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class CustomExceptionHandler {
    private static final Logger o00000 = L.\u00d6o0000;

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public ErrorMessage handleResourceNotFound(ResourceNotFoundException resourceNotFoundException) {
        o00000.info("Resource not found, message: {}", (Object)resourceNotFoundException.getMessage());
        return new ErrorMessage().setMessage(resourceNotFoundException.getMessage()).setErrorCode(HttpStatus.NOT_FOUND.value());
    }

    @ExceptionHandler(value={NotImplementedOnDeviceException.class})
    @ResponseStatus(value=HttpStatus.NOT_IMPLEMENTED)
    public ErrorMessage handleNotImplementedOnDevice(NotImplementedOnDeviceException notImplementedOnDeviceException) {
        return new ErrorMessage().setMessage(notImplementedOnDeviceException.getMessage()).setErrorCode(HttpStatus.NOT_IMPLEMENTED.value());
    }

    @ExceptionHandler(value={RequestValidationException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorMessage handleRequestValidationException(RequestValidationException requestValidationException) {
        o00000.info("Request validation exception: {}", (Object)requestValidationException.getMessage());
        return new ErrorMessage().setErrorCode(HttpStatus.BAD_REQUEST.value()).setMessage(requestValidationException.getMessage());
    }
}

