/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.ubnt.data.Device;
import com.ubnt.data.X;
import com.ubnt.net.v2.exception.ResourceNotFoundException;
import com.ubnt.service.ooOO.oo0O;
import com.ubnt.service.super.D;
import com.ubnt.service.super.OoOO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestController
@RequestMapping(produces={"application/json;charset=UTF-8"})
public class NetworkStatusController {
    public static final int EXCELLENT_SATISFACTION_THRESHOLD = 95;
    public static final int GOOD_SATISFACTION_THRESHOLD = 50;
    public static final int FAIR_SATISFACTION_THRESHOLD = 25;
    private final D \u00d300000;
    private final oo0O o00000;
    private final OoOO new;

    @Autowired
    public NetworkStatusController(D d2, oo0O oo0O2, OoOO ooOO2) {
        this.\u00d300000 = d2;
        this.o00000 = oo0O2;
        this.new = ooOO2;
    }

    @RequestMapping(value={"/api/site/default/network_status"}, method={RequestMethod.GET})
    public NetworkStatus getNetworkStatus() {
        return this.getNetworkStatus(this.o00000.\u00f8\u00d20000());
    }

    @RequestMapping(value={"/api/site/{siteId}/network_status"}, method={RequestMethod.GET})
    public NetworkStatus getNetworkStatus(@PathVariable(value="siteId") String string) {
        Status status;
        if (this.o00000.\u00f4\u00d30000(string) == null) {
            throw new ResourceNotFoundException("Site does not exist");
        }
        List<Device> list = this.\u00d300000.\u00f4\u00d80000(string);
        double d2 = list.stream().filter(device -> device.containsField("satisfaction")).mapToInt(device -> device.getInt("satisfaction", 0)).average().orElse(0.0);
        long l2 = list.stream().filter(device -> device.getInt("state", 0) != 1).count();
        ArrayList<Reason> arrayList = new ArrayList<Reason>();
        if (l2 == 0L) {
            if (d2 >= 95.0) {
                status = Status.EXCELLENT;
            } else {
                arrayList.add(new Reason().setCode(ReasonCode.DEVICE_SATISFACTION).setValue(String.valueOf(Math.round(d2))));
                status = d2 >= 50.0 ? Status.GOOD : Status.FAIR;
            }
        } else {
            arrayList.add(new Reason().setCode(ReasonCode.DEVICE_NOT_CONNECTED).setValue(String.valueOf(l2)));
            if (d2 < 95.0) {
                arrayList.add(new Reason().setCode(ReasonCode.DEVICE_SATISFACTION).setValue(String.valueOf(Math.round(d2))));
            }
            status = d2 >= 25.0 ? Status.FAIR : (d2 > 0.0 ? Status.POOR : Status.BAD);
        }
        Device device2 = this.\u00d300000.\u00f8\u00d80000(string);
        if (device2 != null) {
            int n = -1;
            X x = device2.getX("uplink", X.\u00f6o0000);
            if (x != X.\u00f6o0000) {
                String string2 = x.getString("ip");
                n = x.getInt("latency", n);
                if (string2 == null || n <= 0) {
                    status = Status.BAD;
                    arrayList.add(new Reason().setCode(ReasonCode.NO_INTERNET));
                }
            } else {
                String string3 = this.new.Object(device2, "WAN");
                if (string3 == null) {
                    status = Status.BAD;
                    arrayList.add(new Reason().setCode(ReasonCode.NO_INTERNET));
                }
            }
        }
        return new NetworkStatus().setHealth(status).setAverageSatisfaction((int)Math.round(d2)).setReasons(arrayList);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class NetworkStatus {
        private Status new;
        private List<Reason> \u00d300000;
        @JsonProperty(value="average_satisfaction")
        private int o00000;

        public Status getHealth() {
            return this.new;
        }

        public NetworkStatus setHealth(Status status) {
            this.new = status;
            return this;
        }

        public List<Reason> getReasons() {
            return this.\u00d300000;
        }

        public NetworkStatus setReasons(List<Reason> list) {
            this.\u00d300000 = list;
            return this;
        }

        public int getAverageSatisfaction() {
            return this.o00000;
        }

        public NetworkStatus setAverageSatisfaction(int n) {
            this.o00000 = n;
            return this;
        }
    }

    public static class Reason {
        private ReasonCode o00000;
        private String \u00d200000;

        public ReasonCode getCode() {
            return this.o00000;
        }

        public Reason setCode(ReasonCode reasonCode) {
            this.o00000 = reasonCode;
            return this;
        }

        public String getValue() {
            return this.\u00d200000;
        }

        public Reason setValue(String string) {
            this.\u00d200000 = string;
            return this;
        }
    }

    public static enum ReasonCode {
        DEVICE_SATISFACTION,
        DEVICE_NOT_CONNECTED,
        NO_INTERNET;


        @JsonValue
        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static enum Status {
        EXCELLENT,
        GOOD,
        FAIR,
        POOR,
        BAD,
        UNAVAILABLE;


        @JsonValue
        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

