/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.data;

import com.ubnt.data.A;
import com.ubnt.data.PortalFile;
import com.ubnt.data.RadiusProfile;
import com.ubnt.data.ReferClasses;
import com.ubnt.data.Sanitizable;
import com.ubnt.data.X;
import com.ubnt.service.ooOO.L;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.FileCopyUtils;

public class Setting
extends X
implements Sanitizable {
    @ReferClasses
    public static final List<Class> \u00d4\u00d40000 = Collections.unmodifiableList(Arrays.asList(PortalFile.class, RadiusProfile.class));
    private static final Logger \u00f6\u00d40000 = L.\u00d6o0000;
    public static final String \u00d6\u00d40000 = "https://fw-download.ubnt.com/data/baresip/2885-U7PG2-v1.0.3-4513ee103bf0490a98847a19e0773295.gz";
    public static final int floatObject = 4;
    public static final String \u00f8\u00d40000 = "auto";
    public static final String \u00d2\u00d40000 = "custom";
    public static final String \u00d8\u00d40000 = "disabled";
    public static final int voidObject = 1452;
    public static final int publicObject = 1328;
    public static String[] innerClasses;
    private static X \u00f4\u00d40000;
    public static A \u00d3\u00d40000;
    public static final Setting \u00f6o0000;

    public static String name() {
        return "setting";
    }

    public static int mask() {
        return \u00d4\u00d20000 | \u00f600000 | Setting.class | \u00d8O0000;
    }

    private static synchronized X o00000() {
        if (\u00f4\u00d40000 == null) {
            try {
                \u00f4\u00d40000 = X.parseJSON(FileCopyUtils.copyToString((Reader)new InputStreamReader(new DefaultResourceLoader().getResource("classpath:event_defs.json").getInputStream())));
            }
            catch (IOException iOException) {
                \u00f6\u00d40000.warn("Failed to read default event configurations. " + iOException.getMessage());
                return X.\u00f6o0000;
            }
        }
        \u00f4\u00d40000.makeImmutable();
        return \u00f4\u00d40000;
    }

    public static Map<String, X> getSettingPattern() {
        List<X> list = X.do;
        try {
            list = X.parseJSONArray(FileCopyUtils.copyToString((Reader)new InputStreamReader(new DefaultResourceLoader().getResource("classpath:api/fields/Setting.json").getInputStream())), X.do);
        }
        catch (IOException iOException) {
            \u00f6\u00d40000.error("Unable to parse setting fields pattern!");
        }
        HashMap<String, X> hashMap = new HashMap<String, X>();
        for (X x : list) {
            X x2 = new X();
            for (String string : x.keySet()) {
                Pattern pattern = Pattern.compile(x.getString(string));
                x2.put(string, (Object)pattern);
            }
            hashMap.put(x.getString("key"), x2);
        }
        return hashMap;
    }

    private void o00000(X x, String string) {
        if (x.getX("super_fwupdate", X.\u00f6o0000).containsField(string)) {
            \u00f6\u00d40000.warn("Trying to set read-only key 'super_fwupdate.{}'.", (Object)string);
            throw Sanitizable.InvalidPayload.\u00d400000;
        }
    }

    @Override
    public void sanitize(X x) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : x.keySet()) {
            Object object;
            X x2;
            X x3;
            if (string.equals("guest_access")) {
                x3 = \u00d3\u00d40000.getX(string, X.\u00f6o0000);
                x2 = x.getX(string, X.\u00f6o0000);
                for (String string2 : x2.keySet()) {
                    if (!string2.startsWith("restricted_subnet_") && !string2.startsWith("allowed_subnet_")) continue;
                    if (!string2.matches("restricted_subnet_[\\d]+") && !string2.matches("allowed_subnet_[\\d]+")) {
                        \u00f6\u00d40000.warn("Invalid key in setting exists, key={}:{}", (Object)string, (Object)string2);
                        throw Sanitizable.InvalidPayload.\u00d400000;
                    }
                    String string3 = x2.getString(string2);
                    object = (Pattern)x3.get(string2.substring(0, string2.lastIndexOf(95) + 1));
                    if (!object.toString().equals("") && !object.matcher(string3).matches()) {
                        \u00f6\u00d40000.warn("Pattern not matched, '{}':{'{}':'{}'} invalid", new Object[]{string, string2, string3});
                        throw Sanitizable.InvalidPayload.\u00d300000;
                    }
                    hashSet.add(string2);
                }
                continue;
            }
            if (string.equals("super_events")) {
                x3 = x.getX(string, X.\u00f6o0000);
                x2 = Setting.o00000();
                A a2 = A.\u00d200000("super_event", new X("event_enabled", "true|false", "alert_enabled", "true|false", "email_enabled", "true|false"));
                for (String string3 : x3.keySet()) {
                    if (!string3.startsWith("EVT_")) continue;
                    if (!x2.containsField(string3)) {
                        \u00f6\u00d40000.warn("Invalid key in setting exists, key={}:{}", (Object)string, (Object)string3);
                        throw Sanitizable.InvalidPayload.\u00d400000;
                    }
                    object = x3.getX(string3, X.\u00f6o0000);
                    a2.Object((X)((Object)object));
                    hashSet.add(string3);
                }
                continue;
            }
            if ("mgmt".equals(string)) {
                hashSet.add("x_ssh_keys");
                continue;
            }
            if (!"super_fwupdate".equals(string)) continue;
            this.o00000(x, "x_sso_token");
            this.o00000(x, "allowed_controller_channels");
            this.o00000(x, "allowed_firmware_channels");
        }
        hashSet.add("key");
        \u00d3\u00d40000.o00000(x, hashSet);
    }

    public Setting() {
    }

    public Setting(String string) {
        super("key", string);
    }

    static {
        X x = Setting.o00000();
        Set<String> set = x.keySet();
        List<String> list = Arrays.asList("x_ssh_keys", "suppression", "suppression.alerts", "suppression.alerts.tracking", "suppression.whitelist", "dns_filters", "honeypot");
        innerClasses = (String[])Stream.concat(set.stream(), list.stream()).distinct().toArray(String[]::new);
        \u00d3\u00d40000 = A.\u00f400000(Setting.class.getSimpleName());
        \u00f6o0000 = (Setting)new Setting().makeImmutable();
    }

    public static class Defaults {
        public static final String \u00d200000 = "unifi.yourdomain.com";
        public static final String o00000 = "UniFi";
    }
}

