/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.data;

import com.googlecode.ipv6.IPv6Address;
import com.googlecode.ipv6.IPv6AddressRange;
import com.googlecode.ipv6.IPv6Network;
import com.ubnt.ace.D;
import com.ubnt.ace.E;
import com.ubnt.data.A;
import com.ubnt.data.DhcpOption;
import com.ubnt.data.DpiGroup;
import com.ubnt.data.RadiusProfile;
import com.ubnt.data.ReferClasses;
import com.ubnt.data.Sanitizable;
import com.ubnt.data.UserGroup;
import com.ubnt.data.X;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.util.SubnetUtils;

public class NetworkConf
extends X
implements Sanitizable {
    @ReferClasses
    public static final List<Class> OOO000 = Collections.unmodifiableList(new ArrayList<Class>(Arrays.asList(UserGroup.class, DpiGroup.class, RadiusProfile.class, DhcpOption.class)));
    public static String \u00d4\u00f60000 = "LAN";
    public static String \u00d4OO000 = "WAN_LTE_FAILOVER";
    public static final String \u00f8\u00f60000 = "LAN";
    public static final String \u00f8oO000 = "LAN2";
    public static final String \u00f6oO000 = "LAN3";
    public static final String intif = "LAN4";
    public static final String \u00d8oO000 = "LAN5";
    public static final String classif = "LAN6";
    public static final String \u00d4oO000 = "LAN7";
    public static final String \u00d2oO000 = "LAN8";
    public static final String[] \u00f6\u00f60000 = new String[]{"LAN", "LAN2", "LAN3", "LAN4", "LAN5", "LAN6", "LAN7", "LAN8"};
    public static final String \u00f4oO000 = "WAN";
    public static final String \u00d3OO000 = "WAN2";
    public static final String \u00d8\u00f50000 = "WAN_LTE_FAILOVER";
    public static final String[] \u00d3\u00f60000 = new String[]{"WAN", "WAN2", "WAN_LTE_FAILOVER"};
    public static final String Objectint = "localdomain";
    public static final String \u00f8OO000 = "vlan-only";
    public static final String floatint = "corporate";
    public static final String voidvoid = "guest";
    public static final String \u00d8OO000 = "wan";
    public static final String \u00f40O000 = "remote-user-vpn";
    public static final String \u00d80O000 = "site-vpn";
    public static final String \u00d6oO000 = "vpn-client";
    public static final String \u00f80O000 = "unknown";
    public static final int \u00f6\u00f50000 = 86400;
    public static final int O0O000 = 86400;
    public static final int O\u00f80000 = 14400;
    public static final int OoO000 = 30;
    public static final int \u00f4\u00f50000 = 1280;
    public static final int \u00d30O000 = 4;
    public static final int donull = 3;
    public static final String \u00f4\u00f60000 = "auto";
    public static final String publicvoid = "ipsec-vpn";
    public static final String \u00d20O000 = "openvpn-vpn";
    public static final String \u00d3oO000 = "pptp-client";
    public static final String \u00f4OO000 = "pptp-server";
    public static final String \u00f6OO000 = "l2tp-server";
    public static final String \u00d60O000 = "dhcpd_user_option_";
    public static final String \u00d6\u00f60000 = "dhcpd_user_option_%s";
    public static final String superif = "192.168.1.1/24";
    public static final String \u00f60O000 = "10.255.254.0/24";
    public static final String publicint = "100.127.125.128";
    public static final String \u00f8\u00f50000 = "100.127.125.129";
    public static final String interfacenull = "255.255.255.254";
    public static final String \u00d6OO000 = "tun900";
    public static final String[] floatvoid = new String[]{"ip_subnet", "dhcpd_enabled", "dhcpd_start", "dhcpd_stop", "dhcpd_tftp_server", "dhcpd_wpad_url", "dhcpd_time_offset", "dhcpd_time_offset_enabled", "dhcpd_unifi_controller", "dhcpd_boot_filename", "dhcpd_boot_server", "dhcpd_boot_enabled", "dhcpd_ntp_enabled", "dhcpd_ntp_1", "dhcpd_ntp_2", "dhcpd_wins_enabled", "dhcpd_wins_1", "dhcpd_wins_2", "dhcpd_leasetime", "dhcpd_dns_enabled", "dhcpd_dns_1", "dhcpd_dns_2", "dhcpd_dns_3", "dhcpd_dns_4", "dhcpd_gateway", "dhcpd_gateway_enabled"};
    public static final int \u00d40O000 = 1;
    public static final int intnull = 4012;
    public static final int \u00d8\u00f80000 = 4013;
    public static final int \u00d6\u00f80000 = 4014;
    public static final int classnull = 4015;
    public static final int \u00d4\u00f80000 = 4016;
    public static final int \u00d3\u00f80000 = 4017;
    public static final int \u00d2\u00f80000 = 4018;
    public static final int \u00f8\u00f80000 = 31536000;
    public static final int Objectvoid = 500000;
    public static final int \u00d2\u00f60000 = 3;
    public static final int \u00f4\u00f80000 = 86400;
    public static final int voidint = -86400;
    public static final int supernull = 1194;
    public static final int \u00d8\u00f60000 = 127;
    public static final int \u00f6\u00f80000 = 64;
    public static A \u00d2OO000 = A.\u00f400000(NetworkConf.class.getSimpleName());
    public static final NetworkConf O\u00f60000 = (NetworkConf)new NetworkConf().makeImmutable();

    public static String name() {
        return "networkconf";
    }

    public static int mask() {
        return \u00d4\u00d20000 | \u00d6o0000;
    }

    @Override
    public void sanitize(X x) {
        String string2 = x.getString("purpose");
        if ((floatint.equals(string2) || voidvoid.equals(string2)) && !x.containsField("networkgroup")) {
            x.put("networkgroup", (Object)\u00f8\u00f60000);
        }
        String[] stringArray = x.keySet().stream().filter(string -> string.startsWith(\u00d60O000)).collect(Collectors.toSet()).toArray(new String[0]);
        X x2 = new X();
        x2.copyAttrsIfPresent(x, stringArray);
        x.removeFields(stringArray);
        \u00d2OO000.Object(x);
        x.mergeFrom(x2);
    }

    public static NetworkConf createDefaultLocalAreaNetworkConfForSite(String string) {
        NetworkConf networkConf = new NetworkConf();
        networkConf.put("attr_no_delete", (Object)true);
        networkConf.put("attr_hidden_id", (Object)\u00d4\u00f60000);
        networkConf.put("name", (Object)\u00f8\u00f60000);
        networkConf.put("site_id", (Object)string);
        networkConf.put("vlan_enabled", (Object)false);
        networkConf.put("purpose", (Object)floatint);
        networkConf.put("ip_subnet", (Object)superif);
        networkConf.put("ipv6_interface_type", (Object)"none");
        networkConf.put("domain_name", (Object)Objectint);
        networkConf.put("is_nat", (Object)true);
        networkConf.put("dhcpd_enabled", (Object)true);
        networkConf.put("dhcpd_start", (Object)networkConf.getDefaultDHCPStartIP());
        networkConf.put("dhcpd_stop", (Object)networkConf.getDefaultDHCPStopIP());
        networkConf.put("dhcpdv6_enabled", (Object)false);
        networkConf.put("ipv6_ra_enabled", (Object)false);
        networkConf.put("lte_lan_enabled", (Object)true);
        return networkConf;
    }

    public static NetworkConf createLteFailoverWanNetworkConf(String string) {
        NetworkConf networkConf = new NetworkConf();
        networkConf.put("attr_hidden_id", (Object)\u00d4OO000);
        networkConf.put("wan_networkgroup", (Object)\u00d8\u00f50000);
        networkConf.put("purpose", (Object)\u00d8OO000);
        networkConf.put("name", (Object)"LTE Failover WAN");
        networkConf.put("site_id", (Object)string);
        networkConf.put("wan_type", (Object)"static");
        networkConf.put("report_wan_event", (Object)true);
        networkConf.put("wan_load_balance_type", (Object)"failover-only");
        networkConf.put("wan_ip", (Object)\u00f8\u00f50000);
        networkConf.put("wan_gateway", (Object)publicint);
        networkConf.put("wan_netmask", (Object)interfacenull);
        return networkConf;
    }

    public static NetworkConf createWanNetworkConfFromConfigNetworkWan(X x, String string, String string2) {
        String[] stringArray;
        NetworkConf networkConf = new NetworkConf();
        if (\u00f4oO000.equals(string2)) {
            networkConf.put("attr_no_delete", (Object)true);
            networkConf.put("attr_hidden_id", (Object)\u00f4oO000);
        }
        networkConf.put("wan_networkgroup", (Object)string2);
        networkConf.put("site_id", (Object)string);
        networkConf.put("purpose", (Object)\u00d8OO000);
        networkConf.put("name", (Object)string2);
        for (String string3 : stringArray = new String[]{"type", "ip", "netmask", "gateway", "username", "dns1", "dns2", "dns3", "dns4", "load_balance_type", "type_v6", "ipv6", "gateway_v6"}) {
            String string4 = x.getString(string3);
            if (!StringUtils.isNotEmpty((String)string4)) continue;
            networkConf.put("wan_" + string3, (Object)string4);
        }
        for (String string3 : stringArray = new String[]{"vlan", "smartq_up_rate", "smartq_down_rate", "dhcpv6_pd_size", "load_balance_weight", "prefixlen", "egress_qos"}) {
            if (!x.containsField(string3)) continue;
            int n = x.getInt(string3);
            networkConf.put("wan_" + string3, (Object)n);
        }
        for (String string3 : stringArray = new String[]{"vlan_enabled", "smartq_enabled"}) {
            if (!x.containsField(string3)) continue;
            networkConf.put("wan_" + string3, (Object)x.is(string3, false));
        }
        String string5 = x.getString("x_password");
        if (StringUtils.isNotEmpty((String)string5)) {
            networkConf.put("x_wan_password", (Object)string5);
        }
        return networkConf;
    }

    public String getNetworkGroup() {
        if (this.isLocalSiteNetwork()) {
            return this.getString("networkgroup");
        }
        if (this.isWanNetwork()) {
            return this.getString("wan_networkgroup");
        }
        return \u00f80O000;
    }

    public int getMaskbits() {
        SubnetUtils.SubnetInfo subnetInfo = new SubnetUtils(this.getString("ip_subnet", superif)).getInfo();
        return Integer.bitCount(subnetInfo.asInteger(subnetInfo.getNetmask()));
    }

    public int getPrefixLength() {
        String string = this.getString("ipv6_subnet");
        String string2 = this.getString("type_v6", "none");
        if (StringUtils.equals((String)string2, (String)"track")) {
            return 64;
        }
        if (!E.\u00d400000(string)) {
            return 0;
        }
        String[] stringArray = this.getString("ipv6_subnet").split("/");
        Integer n = Integer.parseInt(stringArray[1]);
        return n;
    }

    public String getIpv4() {
        String string = this.getString("ip_subnet");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        String[] stringArray = string.split("/");
        return stringArray[0];
    }

    public String getIpv6() {
        String string = this.getString("ipv6_subnet");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        String[] stringArray = string.split("/");
        return stringArray[0];
    }

    public String getSubnet() {
        SubnetUtils subnetUtils = new SubnetUtils(this.getString("ip_subnet", superif));
        SubnetUtils.SubnetInfo subnetInfo = subnetUtils.getInfo();
        return String.format("%s/%d", subnetInfo.getNetworkAddress(), Integer.bitCount(subnetInfo.asInteger(subnetInfo.getNetmask())));
    }

    public String getSubnetv6() {
        String string = this.getString("ipv6_subnet");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        IPv6Network iPv6Network = IPv6Network.fromString((String)string);
        String string2 = iPv6Network.getFirst().toString();
        String string3 = Integer.toString(iPv6Network.getNetmask().asPrefixLength());
        return string2 + "/" + string3;
    }

    public boolean containsIp(String string) {
        SubnetUtils subnetUtils = new SubnetUtils(this.getString("ip_subnet", superif));
        SubnetUtils.SubnetInfo subnetInfo = subnetUtils.getInfo();
        try {
            return subnetInfo.isInRange(string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean containsIpv6(String string) {
        String string2 = this.getString("ipv6_subnet");
        if (!E.\u00d400000(string2)) {
            return false;
        }
        IPv6Network iPv6Network = IPv6Network.fromString((String)string2);
        IPv6AddressRange iPv6AddressRange = IPv6AddressRange.fromFirstAndLast((IPv6Address)iPv6Network.getFirst(), (IPv6Address)iPv6Network.getLast());
        try {
            return iPv6AddressRange.contains(IPv6Address.fromString((String)string));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getDefaultDHCPStartIP() {
        SubnetUtils subnetUtils = new SubnetUtils(this.getString("ip_subnet", superif));
        subnetUtils.setInclusiveHostCount(false);
        SubnetUtils.SubnetInfo subnetInfo = subnetUtils.getInfo();
        int n = Integer.bitCount(subnetInfo.asInteger(subnetInfo.getNetmask()));
        int n2 = n < 25 ? (25 - n) * 5 : 1;
        int n3 = subnetInfo.asInteger(subnetInfo.getLowAddress());
        int n4 = n3 + n2;
        int[] nArray = new int[4];
        for (int j = 3; j >= 0; --j) {
            int n5 = j;
            nArray[n5] = nArray[n5] | n4 >>> 8 * (3 - j) & 0xFF;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int j = 0; j < nArray.length; ++j) {
            stringBuilder.append(nArray[j]);
            if (j == nArray.length - 1) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public String getDefaultDHCPStopIP() {
        SubnetUtils subnetUtils = new SubnetUtils(this.getString("ip_subnet", superif));
        subnetUtils.setInclusiveHostCount(false);
        return subnetUtils.getInfo().getHighAddress();
    }

    public boolean isLocalSiteNetwork() {
        String string = this.getString("purpose");
        return floatint.equals(string) || voidvoid.equals(string);
    }

    public boolean isCorpNetwork() {
        return floatint.equals(this.getString("purpose"));
    }

    public boolean isGuestNetwork() {
        return voidvoid.equals(this.getString("purpose"));
    }

    public boolean isSiteVpnNetwork() {
        return \u00d80O000.equals(this.getString("purpose")) && \u00f4\u00f60000.equals(this.getString("vpn_type", \u00f4\u00f60000));
    }

    public boolean isVpnClientNetwork() {
        return \u00d6oO000.equals(this.getString("purpose"));
    }

    public boolean isManualSiteVpnNetwork() {
        return \u00d80O000.equals(this.getString("purpose")) && !\u00f4\u00f60000.equals(this.getString("vpn_type", \u00f4\u00f60000));
    }

    public boolean isSiteIpsecVpnNetwork() {
        return \u00d80O000.equals(this.getString("purpose")) && publicvoid.equals(this.getString("vpn_type"));
    }

    public boolean isSiteOpenvpnVpnNetwork() {
        return \u00d80O000.equals(this.getString("purpose")) && \u00d20O000.equals(this.getString("vpn_type"));
    }

    public boolean isPptpClientNetwork() {
        return \u00d6oO000.equals(this.getString("purpose")) && \u00d3oO000.equals(this.getString("vpn_type"));
    }

    public boolean isRemoteUserVpnNetwork() {
        return \u00f40O000.equals(this.getString("purpose"));
    }

    public boolean isRemoteUserL2tpVpnNetwork() {
        return \u00f40O000.equals(this.getString("purpose")) && \u00f6OO000.equals(this.getString("vpn_type"));
    }

    public boolean isVlanOnlyNetwork() {
        return \u00f8OO000.equals(this.getString("purpose"));
    }

    public boolean isWanNetwork() {
        return \u00d8OO000.equals(this.getString("purpose"));
    }

    public boolean isLteWanNetwork() {
        return \u00d8OO000.equals(this.getString("purpose")) && \u00d4OO000.equals(this.getString("attr_hidden_id"));
    }

    public boolean isLteLanEnabled() {
        return this.is("lte_lan_enabled", false);
    }

    public boolean isLocalSiteLayer2Network() {
        return this.isLocalSiteNetwork() || this.isVlanOnlyNetwork();
    }

    public boolean inNetworkGroup(String string) {
        return StringUtils.equals((String)this.getNetworkGroup(), (String)string);
    }

    public static int getNetworkGroupInternalVlan(String string) {
        if (string.equals(\u00f8\u00f60000)) {
            return 1;
        }
        if (string.equals(\u00f8oO000)) {
            return 4012;
        }
        if (string.equals(\u00f6oO000)) {
            return 4013;
        }
        if (string.equals(intif)) {
            return 4014;
        }
        if (string.equals(\u00d8oO000)) {
            return 4015;
        }
        if (string.equals(classif)) {
            return 4016;
        }
        if (string.equals(\u00d4oO000)) {
            return 4017;
        }
        if (string.equals(\u00d2oO000)) {
            return 4018;
        }
        return 1;
    }

    public int getVlan() {
        int n = this.getInt("vlan", 1);
        if (n > 1 && n < 4094 && this.is("vlan_enabled", false)) {
            return n;
        }
        String string = this.getString("networkgroup", \u00f80O000);
        return NetworkConf.getNetworkGroupInternalVlan(string);
    }

    public NetworkConf toConfigNetworkWan() {
        NetworkConf networkConf = new NetworkConf();
        for (String string : this.keySet()) {
            if (string.startsWith("wan_")) {
                networkConf.put(string.substring(4), this.get(string, null));
                continue;
            }
            networkConf.put(string, this.get(string, null));
        }
        String string = networkConf.getString("x_wan_password");
        if (StringUtils.isNotEmpty((String)string)) {
            networkConf.put("x_password", (Object)string);
        }
        if (networkConf.containsField("dhcpv6_pd_size")) {
            networkConf.put("dhcpv6_pd_size", (Object)networkConf.getInt("dhcpv6_pd_size"));
        }
        if (this.isLteWanNetwork()) {
            networkConf.put("type", (Object)"lte-failover");
        }
        return networkConf;
    }

    public int getPriority() {
        int n = this.getInt("priority", -1);
        return n;
    }

    public NetworkConf setTunnelIpAddrForLTE(String string) {
        if (this.isLteWanNetwork() && E.\u00f5o0000(string)) {
            this.put("ip_subnet", (Object)(string + "/30"));
        }
        return this;
    }

    public String getLTETunnelAddrCidr() {
        if (!this.isLteWanNetwork()) {
            return null;
        }
        return D.o00000(this.getString("wan_ip"), this.getString("wan_netmask"));
    }

    public String getLTETunnelNetwork() {
        try {
            SubnetUtils subnetUtils = new SubnetUtils(this.getString("wan_ip"), this.getString("wan_netmask"));
            SubnetUtils.SubnetInfo subnetInfo = subnetUtils.getInfo();
            return String.format("%s/%d", subnetInfo.getNetworkAddress(), Integer.bitCount(subnetInfo.asInteger(subnetInfo.getNetmask())));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isIpsecInUse(List<NetworkConf> list) {
        for (NetworkConf networkConf : list) {
            if (!networkConf.isSiteVpnNetwork() && !networkConf.isSiteIpsecVpnNetwork() && !networkConf.isRemoteUserL2tpVpnNetwork()) continue;
            return true;
        }
        return false;
    }
}

