/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.data;

import com.ubnt.ace.E;
import com.ubnt.data.A;
import com.ubnt.data.ReferClasses;
import com.ubnt.data.Sanitizable;
import com.ubnt.data.X;
import com.ubnt.service.ooOO.L;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DhcpOption
extends X
implements Sanitizable {
    @ReferClasses
    public static final List<Class> \u00d8\u00d8o000 = X.\u00d3O0000;
    public static final Logger voidclasssuper = L.\u00d6o0000;
    public static final String \u00f4\u00d8o000 = "name";
    public static final String Objectclasssuper = "code";
    public static final String \u00d4\u00d8o000 = "type";
    public static final String \u00d2\u00f4o000 = "width";
    public static final String \u00d6\u00d8o000 = "signed";
    public static int interfaceStringsuper = 254;
    public static int \u00f8\u00d8o000 = 7;
    public static List<Integer> \u00d3\u00d8o000 = new ArrayList<Integer>(Arrays.asList(15, 42, 43, 44, 51, 66, 67, 252));
    public static A \u00f6\u00d8o000 = A.\u00f400000(DhcpOption.class.getSimpleName());
    private static final Pattern O\u00f4o000 = Pattern.compile("^([0-9A-Fa-f]{2}[:]){0,100}[0-9A-Fa-f]{2}$");

    public static String name() {
        return "dhcpoption";
    }

    public static int mask() {
        return \u00d4\u00d20000 | \u00d6o0000;
    }

    @Override
    public void sanitize(X x) {
        int n;
        \u00f6\u00d8o000.Object(x);
        DHCP_OPTION_TYPE dHCP_OPTION_TYPE = DHCP_OPTION_TYPE.get(x.getString(\u00d4\u00d8o000));
        if (dHCP_OPTION_TYPE == DHCP_OPTION_TYPE.\u00d300000 && (n = x.getInt(\u00d2\u00f4o000, 0)) != 8 && n != 16 && n != 32) {
            voidclasssuper.warn("Invalid value for key width, value={}", (Object)n);
            throw Sanitizable.InvalidPayload.\u00d300000;
        }
    }

    public DhcpOption() {
    }

    public String getId() {
        return this.getString("_id");
    }

    public String getName() {
        return this.getString(\u00f4\u00d8o000);
    }

    public DHCP_OPTION_TYPE getType() {
        return DHCP_OPTION_TYPE.get(this.getString(\u00d4\u00d8o000));
    }

    public int getCode() {
        return this.getInt(Objectclasssuper);
    }

    public int getWidth() {
        return this.getInt(\u00d2\u00f4o000, 0);
    }

    public boolean getSigned() {
        return this.getBoolean(\u00d6\u00d8o000, false);
    }

    public boolean isValid() {
        boolean bl = true;
        DHCP_OPTION_TYPE dHCP_OPTION_TYPE = this.getType();
        String string = this.getName();
        int n = this.getCode();
        if (bl) {
            boolean bl2 = bl = StringUtils.isNotBlank((String)string) && n >= \u00f8\u00d8o000 && n <= interfaceStringsuper && !\u00d3\u00d8o000.contains(n);
        }
        if (bl && dHCP_OPTION_TYPE == DHCP_OPTION_TYPE.\u00d300000) {
            int n2 = this.getWidth();
            bl = n2 == 8 || n2 == 16 || n2 == 32;
        }
        return bl;
    }

    private boolean \u00d400000(String string) {
        return StringUtils.isNotBlank((String)string) && O\u00f4o000.matcher(string).find();
    }

    private boolean \u00d500000(String string) {
        boolean bl = true;
        try {
            long l2 = Long.parseLong(string, 10);
            int n = this.getWidth();
            boolean bl2 = this.getSigned();
            long l3 = bl2 ? (long)Math.pow(2.0, n) / -2L : 0L;
            long l4 = bl2 ? (long)Math.pow(2.0, n) / 2L - 1L : (long)Math.pow(2.0, n) - 1L;
            bl = l3 <= l2 && l2 <= l4;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    private boolean \u00d600000(String string) {
        return StringUtils.isNotBlank((String)string);
    }

    private boolean Object(String string) {
        return E.\u00f5o0000(string) || E.\u00d4o0000(string);
    }

    private boolean \u00d200000(String string) {
        return E.new(string, false);
    }

    private boolean void(String string) {
        return string != null && (string.equals("true") || string.equals("false"));
    }

    public boolean verify(String string, String string2) {
        String string3 = this.getId();
        boolean bl = string3.equals(string);
        if (!bl) {
            return false;
        }
        DHCP_OPTION_TYPE dHCP_OPTION_TYPE = this.getType();
        switch (dHCP_OPTION_TYPE) {
            case \u00d500000: {
                bl = this.void(string2);
                break;
            }
            case o00000: {
                bl = this.\u00d400000(string2);
                break;
            }
            case \u00d300000: {
                bl = this.\u00d500000(string2);
                break;
            }
            case \u00d800000: {
                bl = this.Object(string2);
                break;
            }
            case \u00f500000: {
                bl = this.\u00d200000(string2);
                break;
            }
            case null: {
                bl = this.\u00d600000(string2);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public String getGlobalString() throws InvalidDhcpOptionException {
        String string = "";
        String string2 = this.getString(\u00f4\u00d8o000);
        int n = this.getInt(Objectclasssuper);
        switch (this.getType()) {
            case \u00d500000: {
                string = String.format("option %s code %d = boolean;", string2, n);
                break;
            }
            case \u00d300000: {
                String string3 = this.is(\u00d6\u00d8o000, false) ? \u00d6\u00d8o000 : "unsigned";
                int n2 = this.getInt(\u00d2\u00f4o000, 8);
                string = String.format("option %s code %d = %s integer %d;", string2, n, string3, n2);
                break;
            }
            case \u00d800000: {
                string = String.format("option %s code %d = ip-address;", string2, n);
                break;
            }
            case o00000: 
            case \u00f500000: 
            case null: {
                string = String.format("option %s code %d = string;", string2, n);
                break;
            }
            default: {
                throw new InvalidDhcpOptionException();
            }
        }
        return string;
    }

    public String getSubnetString(String string) throws InvalidDhcpOptionException {
        String string2 = "";
        if (!this.verify(this.getId(), string)) {
            throw new InvalidDhcpOptionException();
        }
        switch (this.getType()) {
            case \u00d500000: {
                String string3 = Boolean.parseBoolean(string) ? "on" : "off";
                string2 = String.format("option %s %s;", this.getName(), string3);
                break;
            }
            case o00000: {
                string2 = String.format("option %s %s;", this.getName(), string);
                break;
            }
            case \u00d300000: {
                long l2 = Long.parseLong(string);
                string2 = String.format("option %s %d;", this.getName(), l2);
                break;
            }
            case \u00d800000: {
                string2 = String.format("option %s %s;", this.getName(), string);
                break;
            }
            case \u00f500000: {
                string2 = String.format("option %s %s;", this.getName(), string);
                break;
            }
            case null: {
                try {
                    byte[] byArray = string.getBytes("UTF-8");
                    StringBuilder stringBuilder = new StringBuilder();
                    boolean bl = true;
                    for (byte by : byArray) {
                        if (!bl) {
                            stringBuilder.append(":");
                        }
                        stringBuilder.append(Integer.toHexString(by));
                        bl = false;
                    }
                    string = stringBuilder.toString();
                    string2 = String.format("option %s %s;", this.getName(), string);
                    break;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new InvalidDhcpOptionException();
                }
            }
            default: {
                throw new InvalidDhcpOptionException();
            }
        }
        return string2;
    }

    public DhcpOption(String string) {
        super("key", string);
    }

    public class InvalidDhcpOptionException
    extends Exception {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum DHCP_OPTION_TYPE {
        \u00d500000("boolean"),
        o00000("hexarray"),
        \u00d300000("integer"),
        \u00d800000("ipaddress"),
        \u00f500000("macaddress"),
        null("text");

        private String \u00d200000;
        private static final Map<String, DHCP_OPTION_TYPE> String;

        private DHCP_OPTION_TYPE(String string2) {
            this.\u00d200000 = string2;
        }

        public String getName() {
            return this.\u00d200000;
        }

        public static DHCP_OPTION_TYPE get(String string) {
            return String.get(string);
        }

        static {
            ConcurrentHashMap<String, DHCP_OPTION_TYPE> concurrentHashMap = new ConcurrentHashMap<String, DHCP_OPTION_TYPE>();
            for (DHCP_OPTION_TYPE dHCP_OPTION_TYPE : DHCP_OPTION_TYPE.values()) {
                concurrentHashMap.put(dHCP_OPTION_TYPE.getName(), dHCP_OPTION_TYPE);
            }
            String = Collections.unmodifiableMap(concurrentHashMap);
        }
    }
}

