/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.data;

import com.ubnt.ace.E;
import com.ubnt.data.A;
import com.ubnt.data.Chipset;
import com.ubnt.data.DeviceFeature;
import com.ubnt.data.DeviceType;
import com.ubnt.data.Map;
import com.ubnt.data.Model;
import com.ubnt.data.NetworkConf;
import com.ubnt.data.PortConf;
import com.ubnt.data.RadiusProfile;
import com.ubnt.data.ReferClasses;
import com.ubnt.data.Sanitizable;
import com.ubnt.data.UserGroup;
import com.ubnt.data.WlanConf;
import com.ubnt.data.WlanGroup;
import com.ubnt.data.X;
import com.ubnt.service.super.null;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Device
extends X
implements Sanitizable {
    private static final Logger O\u00d4o000 = LoggerFactory.getLogger(Device.class);
    private static final String \u00f4\u00d3O000 = "3.8.0";
    @ReferClasses
    public static final List<Class> \u00f6\u00d6O000 = Collections.unmodifiableList(new ArrayList<Class>(Arrays.asList(Map.class, NetworkConf.class, WlanGroup.class, RadiusProfile.class, UserGroup.class, WlanConf.class, PortConf.class)));
    public static A \u00f6\u00f4O000 = A.\u00f400000(Device.class.getSimpleName());
    public static String[] innerClasses = new String[]{"radio_table", "scan_radio_table", "port_table", "port_overrides", "vwire_table", "wlan_overrides", "ethernet_table", "config_network", "elite", "ethernet_overrides", "switch_caps"};
    private static final int \u00d2\u00d3o000 = 4;
    private static final int \u00d3\u00d4o000 = 52;
    private static final int \u00d4Oo000 = 4;
    private static final int \u00d8\u00d4o000 = 16;
    private static final int voidpublic = 16;
    private static final int floatfloat = 9;
    private static final int \u00f4Oo000 = 150;
    public static final String[] O\u00d2o000 = new String[]{"na", "ng"};
    public static final int \u00d3\u00f6O000 = 0;
    public static final int O\u00f6O000 = 1;
    public static final int \u00d3\u00d3O000 = 2;
    public static final int O\u00f8O000 = 3;
    public static final int publicfloat = 4;
    public static final int \u00d6\u00d2o000 = 5;
    public static final int \u00d6oo000 = 6;
    public static final int publicpublic = 7;
    public static final int \u00d60o000 = 8;
    public static final int \u00d3\u00d4O000 = 9;
    public static final int \u00f8\u00d5O000 = 10;
    public static final int \u00d40o000 = 11;
    public static final int \u00d4\u00d3O000 = 25;
    public static final String \u00f8\u00d2o000 = "off";
    public static final String voidfloat = "#0000ff";
    public static final int \u00f4\u00d3o000 = 1;
    public static final int \u00d8\u00d5O000 = 2;
    public static final int doprivate = 4;
    public static final int intwhile = 8;
    public static final int \u00d6\u00f6O000 = 16;
    public static final int intprivate = 32;
    public static final int Objectinterface = 64;
    public static final int donewsuper = 128;
    public static final int \u00f8Oo000 = 256;
    public static final int \u00d4\u00f4O000 = 512;
    public static final int \u00d8\u00f8O000 = 1024;
    public static final int \u00f4\u00f4O000 = 2048;
    public static final int \u00d4\u00f6O000 = 4096;
    public static final int superwhile = 8192;
    public static final int \u00f40o000 = 16384;
    public static final int \u00f8\u00f8O000 = 32768;
    public static final int O0o000 = 65536;
    public static final int \u00d6\u00d4O000 = 131072;
    public static final int \u00d6\u00d4o000 = 262144;
    public static final int \u00d6\u00d6O000 = 524288;
    public static final int \u00f4\u00d4O000 = 0x200000;
    public static final int \u00d3\u00f4O000 = 0x400000;
    public static final int \u00d3\u00d5O000 = 1;
    public static final int \u00d6\u00f8O000 = 2;
    public static final int Ooo000 = 4;
    public static final int \u00d2Oo000 = 8;
    public static final int \u00d2oo000 = 16;
    public static final int voiddo = 32;
    public static final int O\u00d6O000 = 64;
    public static final int classprivate = 128;
    public static final int \u00f8\u00f5O000 = 512;
    public static final int \u00f4\u00d2o000 = 1024;
    public static final int \u00f4\u00d8O000 = 2048;
    public static final int \u00d4\u00d4o000 = 4096;
    public static final int \u00d3\u00f5O000 = 8192;
    public static final int \u00d30o000 = 16384;
    public static final int \u00f6\u00d3O000 = 32768;
    public static final int interfaceprivate = 65536;
    public static final int \u00d4oo000 = 1;
    public static final int \u00f8\u00d3O000 = 2;
    public static final int \u00d6\u00d3o000 = 4;
    public static final int \u00f6\u00d8O000 = 8;
    public static final int classfor = 16;
    public static final int \u00f8\u00d3o000 = 32;
    public static final int \u00d2\u00f5O000 = 64;
    public static final int \u00d2\u00f4O000 = 128;
    public static final int classwhile = 256;
    public static final int OOo000 = 512;
    public static final int \u00d6\u00f4O000 = 1;
    public static final int \u00d4\u00d8O000 = 2;
    public static final int floatdo = 4;
    public static final int \u00f60o000 = 8;
    public static final int \u00f4\u00f6O000 = 16;
    public static final int \u00f6\u00d5O000 = 32;
    public static final int Objectsupersuper = 1;
    public static final int classnewsuper = 2;
    public static final int \u00f4\u00d4o000 = 4;
    public static final int O\u00f4O000 = 8;
    public static final int \u00f4\u00f5O000 = 16;
    public static final int \u00d8\u00d2o000 = 32;
    public static final int \u00d8\u00d6O000 = 64;
    public static final int \u00f6\u00d4O000 = 128;
    public static final int O\u00d3o000 = 256;
    public static final int \u00d8oo000 = 512;
    public static final int supernewsuper = 1024;
    public static final int \u00d2\u00d5O000 = 2048;
    public static final int \u00d6\u00f5O000 = 4096;
    public static final int voidinterface = 8192;
    public static final int \u00d2\u00f8O000 = 16384;
    public static final int interfacethissuper = 32768;
    public static final int \u00d3Oo000 = 65536;
    public static final int \u00f80o000 = 131072;
    public static final int publicdo = 262144;
    public static final int O\u00d5O000 = 524288;
    public static final int \u00d4\u00d5O000 = 1;
    public static final int superthissuper = 2;
    public static final int \u00d8\u00f6O000 = 4;
    public static final int \u00f6Oo000 = 8;
    public static final int \u00f4oo000 = 1;
    public static final int \u00d3\u00d2o000 = 2;
    public static final int \u00d4\u00f5O000 = 4;
    public static final int \u00d3\u00d3o000 = 8;
    public static final int \u00d8\u00d3O000 = 1;
    public static final int \u00d4\u00d3o000 = 2;
    public static final int \u00f8oo000 = 4;
    public static final int \u00d8\u00d8O000 = 8;
    public static final int floatsupersuper = 16;
    public static final int O\u00d8O000 = 32;
    public static final int \u00d20o000 = 64;
    public static final int \u00f6\u00f8O000 = 128;
    public static final int intfor = 256;
    public static final int \u00d8\u00d4O000 = 512;
    public static final int \u00d3\u00d8O000 = 1024;
    public static final int \u00f6\u00d3o000 = 2048;
    public static final int Objectdo = 4096;
    public static final int dowhile = 8192;
    public static final int \u00d8\u00f4O000 = 16384;
    public static final int \u00d3\u00f8O000 = 32768;
    public static final int \u00d6\u00d3O000 = 65536;
    public static final int Objectpublic = 131072;
    public static final int classthissuper = 0x1000000;
    public static final int \u00d8Oo000 = 0x2000000;
    public static final int voidsupersuper = 0x4000000;
    public static final int \u00d3\u00d6O000 = 0x8000000;
    public static final int publicinterface = 0x10000000;
    public static final int intthissuper = 0x20000000;
    public static final int \u00f6\u00f5O000 = 1;
    public static final int superprivate = 2;
    public static final int \u00f8\u00d8O000 = 4;
    public static final int \u00d6\u00d8O000 = 8;
    public static final int O\u00f5O000 = 16;
    public static final int \u00f8\u00f6O000 = 32;
    public static final int \u00d2\u00d4O000 = 7;
    public static final int \u00f8\u00f4O000 = 96;
    public static final String[] interfacefor = new String[]{"UNKNOWN", "CONNECTED", "PENDING", "FIRMWARE_MISMATCH", "UPGRADING", "PROVISIONING", "HEARTBEAT_MISSED", "ADOPTING", "DELETING", "INFORM_ERROR", "ADOPT_FAILED", "ISOLATED"};
    private Model \u00d2\u00d4o000 = null;
    public static final int \u00d2\u00d6O000 = 0;
    public static final int \u00d4\u00d4O000 = 1;
    public static final int \u00d4\u00d2o000 = 2;
    public static final int \u00f6\u00f6O000 = 3;
    public static final int interfacewhile = 4;
    public static final String \u00d4\u00d6O000 = "uap";
    public static final String \u00d2\u00d2o000 = "usw";
    public static final String \u00f6oo000 = "ugw";
    public static final String \u00f8\u00d4o000 = "udm";
    public static final String \u00d3oo000 = "unknown";
    public static final int \u00f4\u00d6O000 = -1;
    public static final String floatpublic = "wan";
    public static final String \u00d8\u00f5O000 = "wan2";
    public static final String ObjectObjectsuper = "lan";
    public static final String \u00d2\u00d3O000 = "lan2";
    public static final String O\u00d3O000 = "lan3";
    public static final String \u00f8\u00d2O000 = "lan4";
    public static final String \u00f6\u00d2O000 = "lan5";
    public static final String Objectfloat = "lan6";
    public static final String \u00f4\u00d2O000 = "lan7";
    public static final String \u00f6\u00d4o000 = "lan8";
    public static final int[] \u00d2\u00d8O000 = new int[]{1, 2, 6};
    public static final String dothissuper = "lan";
    public static final String \u00f4\u00d5O000 = "switch";
    public static final String \u00f4\u00f8O000 = "mirror";
    public static final String \u00f8\u00d4O000 = "aggregate";
    public static final String \u00d80o000 = "auto";
    public static final String \u00d2\u00f6O000 = "pasv24";
    public static final String \u00d6Oo000 = "off";
    public static final String interfacenewsuper = "passthrough";
    public static final String \u00f8\u00d6O000 = "rate";
    public static final String floatinterface = "level";
    public static final String dofor = "auto";
    public static final String \u00f6\u00d2o000 = "force_authorized";
    public static final String \u00d6\u00d5O000 = "force_unauthorized";
    public static final String superfor = "mac_based";
    public static final String \u00d8\u00d3o000 = "multi_host";
    public static final String intnewsuper = "failover";
    public static final long publicsupersuper = 0x40000000L;
    public static final long O\u00d4O000 = 0x80000000L;
    private static final String[] \u00d4\u00f8O000 = new String[]{"type", "vwire_table", "cfgversion"};

    public static String name() {
        return "device";
    }

    public static int mask() {
        return \u00d4\u00d20000 | Device.class | Oo0000;
    }

    @Override
    public void sanitize(X x) {
        \u00f6\u00f4O000.Object(x);
    }

    public Model getModel() {
        if (this.\u00d2\u00d4o000 == null) {
            this.\u00d2\u00d4o000 = Model.o00000(this.getString("model", "UNKNOWN"));
        }
        return this.\u00d2\u00d4o000;
    }

    public Device() {
        super(150);
    }

    public Device(Object ... objectArray) {
        super(150, objectArray);
    }

    public static String getStateName(int n) {
        return interfacefor[n];
    }

    public void setState(int n) {
        this.put("state", (Object)n);
        if (n == 2) {
            this.put("adopt_status", (Object)0);
        }
    }

    public boolean isAdopted() {
        return this.is("adopted", false);
    }

    public boolean hasFeature(DeviceFeature deviceFeature) {
        return this.getFeatures().contains((Object)deviceFeature);
    }

    public Set<DeviceFeature> getFeatures() {
        return this.getModel().getFeatures();
    }

    public int getState() {
        return this.getInt("state", 0);
    }

    public static boolean consideredConnected(int n) {
        return n == 1 || n == 5;
    }

    public boolean consideredConnected() {
        return Device.consideredConnected(this.getState());
    }

    public boolean isBusy() {
        int n = this.getState();
        return n == 7 || n == 5 || n == 4 || n == 8;
    }

    public static String getDeviceType(String string) {
        return Model.o00000(string).getType().toString();
    }

    public String getMacArg() {
        return this.getType().substring(1);
    }

    @Deprecated
    public String getType() {
        return this.getModel().getType().toString();
    }

    public DeviceType getDeviceType() {
        return this.getModel().getType();
    }

    public String getMgmtDev() {
        if (this.isAtherosAP() || this.isBroadcomAP() || this.isMediaTekAP() || this.isUDM()) {
            return "br0";
        }
        if (this.getDeviceType() == DeviceType.o00000) {
            return null;
        }
        return "eth0";
    }

    public int getFwupdateTimeRequired() {
        return this.getFwupdateTimeRequired(true);
    }

    public int getFwupdateTimeRequired(boolean bl) {
        if (this.isAkroniteAP()) {
            return 450;
        }
        if (this.isBroadcomSwitch()) {
            return 300;
        }
        if (this.isCaviumRouter()) {
            return 600;
        }
        return 180;
    }

    public boolean isSafeForAutoUpgrade() {
        if (this.getDeviceType() != DeviceType.return) {
            return false;
        }
        return !this.supportVwire() || !StringUtils.isNotEmpty((String)this.getString("uplink_ap_mac")) && this.getVwireCount("ng") + this.getVwireCount("na") <= 0;
    }

    public boolean hasLTE() {
        return this.getModel() == Model.nullObject;
    }

    public boolean isAtherosAP() {
        Model model = this.getModel();
        return model.getChipset().typeOf(Chipset.\u00f500000) && model.getType() == DeviceType.return;
    }

    public boolean isMediaTekAP() {
        Model model = this.getModel();
        return model.getChipset().typeOf(Chipset.OO0000) && model.getType() == DeviceType.return;
    }

    public boolean isAkroniteAP() {
        Model model = this.getModel();
        return model.getChipset().typeOf(Chipset.\u00f400000) && model.getType() == DeviceType.return;
    }

    public boolean isAkroniteAPWith10GPort() {
        Model model = this.getModel();
        switch (model) {
            case newnew: 
            case \u00d8O0000: 
            case \u00d3\u00d20000: 
            case oo0000: {
                return true;
            }
        }
        return false;
    }

    public boolean isAtherosSwitch() {
        Model model = this.getModel();
        return model.getChipset().typeOf(Chipset.\u00f500000) && model.getType() == DeviceType.new;
    }

    public boolean isBroadcomSwitch() {
        Model model = this.getModel();
        return model.getChipset().typeOf(Chipset.\u00d200000) && model.getType() == DeviceType.new;
    }

    public boolean isMicrosemiSwitch() {
        Model model = this.getModel();
        return model.getChipset().typeOf(Chipset.\u00d500000) && model.getType() == DeviceType.new;
    }

    public boolean isMediaTekSwitch() {
        Model model = this.getModel();
        return model.getChipset().typeOf(Chipset.OO0000) && model.getType() == DeviceType.new;
    }

    public boolean isRealTekSwitch() {
        Model model = this.getModel();
        return model.getChipset().typeOf(Chipset.o00000) && model.getType() == DeviceType.new;
    }

    public boolean isCaviumRouter() {
        Model model = this.getModel();
        return model.getChipset().typeOf(Chipset.Object) && model.getType() == DeviceType.o00000;
    }

    public boolean isUDM() {
        return this.getModel().getType() == DeviceType.\u00d400000;
    }

    public List<X> seedPortTable() {
        ArrayList<X> arrayList;
        block5: {
            Model model;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block6: {
                                    block4: {
                                        model = this.getModel();
                                        arrayList = new ArrayList<X>();
                                        if (model != Model.\u00d4\u00d30000) break block4;
                                        List<X> list = this.getList("config_port_table", new ArrayList<X>());
                                        if (list.size() >= this.getPortNum()) {
                                            arrayList.addAll(list);
                                        } else {
                                            arrayList.add(new X("name", floatpublic, "ifname", "eth0"));
                                            arrayList.add(new X("name", "lan", "ifname", "eth1"));
                                            arrayList.add(new X("name", \u00d2\u00d3O000, "ifname", "eth2"));
                                        }
                                        break block5;
                                    }
                                    if (model != Model.\u00d3\u00d30000) break block6;
                                    arrayList.add(new X("name", "lan", "ifname", "eth0"));
                                    arrayList.add(new X("name", \u00d2\u00d3O000, "ifname", "eth1"));
                                    arrayList.add(new X("name", floatpublic, "ifname", "eth2"));
                                    arrayList.add(new X("name", \u00d8\u00f5O000, "ifname", "eth3"));
                                    break block5;
                                }
                                if (model != Model.\u00f5\u00d20000) break block7;
                                arrayList.add(new X("name", "lan", "ifname", "eth0"));
                                arrayList.add(new X("name", \u00d2\u00d3O000, "ifname", "eth1"));
                                arrayList.add(new X("name", O\u00d3O000, "ifname", "eth2"));
                                arrayList.add(new X("name", \u00f8\u00d2O000, "ifname", "eth3"));
                                arrayList.add(new X("name", \u00f6\u00d2O000, "ifname", "eth4"));
                                arrayList.add(new X("name", Objectfloat, "ifname", "eth5"));
                                arrayList.add(new X("name", floatpublic, "ifname", "eth6"));
                                arrayList.add(new X("name", \u00d8\u00f5O000, "ifname", "eth7"));
                                break block5;
                            }
                            if (model != Model.privatesuper) break block8;
                            arrayList.add(new X("name", "lan", "ifname", "eth1"));
                            arrayList.add(new X("name", floatpublic, "ifname", "eth0"));
                            arrayList.add(new X("name", \u00d2\u00d3O000, "ifname", "eth2"));
                            arrayList.add(new X("name", \u00d8\u00f5O000, "ifname", "eth8"));
                            arrayList.add(new X("name", O\u00d3O000, "ifname", "eth3"));
                            arrayList.add(new X("name", \u00f8\u00d2O000, "ifname", "eth4"));
                            arrayList.add(new X("name", \u00f6\u00d2O000, "ifname", "eth5"));
                            arrayList.add(new X("name", Objectfloat, "ifname", "eth6"));
                            arrayList.add(new X("name", \u00f4\u00d2O000, "ifname", "eth7"));
                            break block5;
                        }
                        if (model != Model.\u00d8\u00d40000) break block9;
                        arrayList.add(new X("name", "lan", "ifname", "eth0"));
                        arrayList.add(new X("name", "", "ifname", "eth1"));
                        arrayList.add(new X("name", "", "ifname", "eth2"));
                        arrayList.add(new X("name", "", "ifname", "eth3"));
                        arrayList.add(new X("name", floatpublic, "ifname", "eth4"));
                        break block5;
                    }
                    if (model != Model.\u00d4\u00d20000) break block10;
                    arrayList.add(new X("name", "lan", "ifname", "eth0"));
                    arrayList.add(new X("name", "", "ifname", "eth1"));
                    arrayList.add(new X("name", "", "ifname", "eth2"));
                    arrayList.add(new X("name", "", "ifname", "eth3"));
                    arrayList.add(new X("name", "", "ifname", "eth4"));
                    arrayList.add(new X("name", "", "ifname", "eth5"));
                    arrayList.add(new X("name", floatpublic, "ifname", "eth6"));
                    arrayList.add(new X("name", \u00d8\u00f5O000, "ifname", "eth7"));
                    break block5;
                }
                if (!this.isMicrosemiSwitch() && !this.isBroadcomSwitch() && !this.isAtherosSwitch() && !this.isMediaTekSwitch() && !this.isRealTekSwitch()) break block11;
                for (int j = 1; j <= this.getPortNum(); ++j) {
                    arrayList.add(new X("port_idx", j));
                }
                break block5;
            }
            if (model != Model.nullsuper && model != Model.\u00d4O0000 && model != Model.O\u00d30000) break block5;
            for (int j = 1; j <= this.getPortNum(); ++j) {
                arrayList.add(new X("port_idx", j));
            }
        }
        return arrayList;
    }

    public boolean isBroadcomAP() {
        Model model = this.getModel();
        return model.getChipset().typeOf(Chipset.\u00d200000) && model.getType() == DeviceType.return;
    }

    public boolean isMediumTxPowerDesired() {
        return this.isBroadcomAP();
    }

    public boolean hasStationStat() {
        switch (this.getDeviceType()) {
            case return: 
            case o00000: 
            case \u00d400000: {
                return true;
            }
        }
        return false;
    }

    public int getPortNum() {
        if (this.is("has_eth1", false)) {
            return 2;
        }
        return this.getModel().getPortNum();
    }

    public int getMaxMirrorSession() {
        int n = 0;
        if (this.getModel() == Model.newString) {
            n = 2;
        } else if (this.isBroadcomSwitch() || this.isMicrosemiSwitch() || this.isMediaTekSwitch()) {
            n = 1;
        }
        return this.getX("switch_caps", X.\u00f6o0000).getInt("max_mirror_sessions", n);
    }

    public int getMaxAggregation() {
        int n = 0;
        if (this.isBroadcomSwitch() || this.isMicrosemiSwitch()) {
            n = 6;
        }
        return this.getX("switch_caps", X.\u00f6o0000).getInt("max_aggregate_sessions", n);
    }

    public boolean hasRadio(String string) {
        if ("ng".equals(string)) {
            return this.hasRadioNG();
        }
        if ("na".equals(string)) {
            return this.hasRadioNA();
        }
        return false;
    }

    public boolean hasRadioNA() {
        Model model = this.getModel();
        if (model.getType() != DeviceType.return && model.getType() != DeviceType.\u00d400000) {
            return false;
        }
        switch (model) {
            case newnew: 
            case \u00d8O0000: 
            case \u00d3\u00d20000: 
            case oo0000: 
            case Stringsuper: 
            case \u00d4\u00d50000: 
            case \u00d300000: 
            case \u00d5\u00d50000: 
            case o00000: 
            case \u00f400000: 
            case StringObject: 
            case ifnew: 
            case \u00f4\u00d30000: 
            case \u00d8\u00d30000: 
            case OO0000: 
            case \u00d4O0000: 
            case O\u00d30000: 
            case \u00f8o0000: 
            case \u00f5\u00d30000: 
            case \u00f4O0000: 
            case \u00f8\u00d40000: 
            case forsuper: 
            case \u00d8\u00d40000: 
            case \u00d4\u00d20000: {
                return true;
            }
        }
        return false;
    }

    public boolean hasRadioNG() {
        Model model = this.getModel();
        if (model.getType() != DeviceType.return && model.getType() != DeviceType.\u00d400000) {
            return false;
        }
        switch (model) {
            case \u00d8O0000: 
            case oo0000: 
            case Stringsuper: {
                return false;
            }
        }
        return true;
    }

    public int getRadioNum() {
        List<X> list = this.getList("radio_table", X.do);
        if (!list.isEmpty()) {
            return list.size();
        }
        return (this.hasRadioNA() ? 1 : 0) + (this.hasRadioNG() ? 1 : 0);
    }

    public int getWlanNum() {
        return this.getRadioNum() * 8;
    }

    public boolean hasQCASwitch() {
        if (this.hasCapability(16)) {
            return true;
        }
        return this.getModel() == Model.nullsuper;
    }

    public boolean hasOWRTSwitch() {
        return this.hasCapability(256);
    }

    public boolean hasUDPI() {
        return this.hasCapability(64);
    }

    public boolean supportsSNMPv3() {
        if (this.hasCapability(16384)) {
            return true;
        }
        return this.getDeviceType() == DeviceType.o00000 && this.hasUSGCapability(4096);
    }

    public boolean supportsSha512Password() {
        if (this.hasCapability(1024)) {
            return true;
        }
        return this.getDeviceType() == DeviceType.o00000;
    }

    public boolean hasCapability(int n) {
        return (n & this.getInt("fw_caps")) == n;
    }

    public boolean supportsSshUpgrade() {
        return true;
    }

    public boolean supportsHttpsUpgrade() {
        if (this.hasCapability(2048)) {
            return true;
        }
        switch (this.getDeviceType()) {
            case o00000: {
                return true;
            }
            case return: 
            case new: {
                return E.\u00d800000(this.getString("version"), \u00f4\u00d3O000);
            }
        }
        return true;
    }

    public boolean supportsUpgradeExternal() {
        return true;
    }

    public boolean hasWifiCapability(int n) {
        return (n & this.getInt("wifi_caps")) == n;
    }

    public boolean hasHardwareCapability(int n) {
        return (n & this.getInt("hw_caps")) == n;
    }

    public boolean hasSystemError(int n) {
        return (n & this.getInt("sys_error_caps")) == n;
    }

    public boolean supportMinRateCtrl() {
        return this.hasWifiCapability(512);
    }

    public boolean supportMultiAclList() {
        return this.hasWifiCapability(1024);
    }

    public boolean supportRadiusMacAuth() {
        return this.hasWifiCapability(4096);
    }

    public boolean supportOpenHostapd() {
        return this.hasWifiCapability(8192);
    }

    public boolean supportVwire() {
        return this.hasWifiCapability(1);
    }

    public boolean supportMesh() {
        return this.supportVwire() && this.hasWifiCapability(128);
    }

    public boolean supportMeshv3() {
        return this.supportVwire() && this.hasWifiCapability(2048);
    }

    public boolean supportMultiVport() {
        return this.supportVwire() && this.hasWifiCapability(16384);
    }

    public boolean supportElement() {
        return this.hasWifiCapability(32768);
    }

    public boolean supportHideChWidth() {
        return this.hasWifiCapability(65536);
    }

    public boolean supportBonding() {
        return this.hasCapability(128);
    }

    public boolean supportDnsMasq() {
        if (this.hasCapability(8)) {
            return true;
        }
        return this.isAtherosAP() || this.isCaviumRouter();
    }

    public boolean supportIPSet() {
        return this.hasCapability(262144);
    }

    public boolean supportSpectrumScan() {
        return this.hasWifiCapability(16);
    }

    public boolean supportZeroHandoff() {
        return this.hasWifiCapability(2);
    }

    public boolean supportATFConfig() {
        return this.hasWifiCapability(32);
    }

    public boolean supportBandsteering() {
        return this.hasWifiCapability(4);
    }

    public boolean supportVapBasedBandsteering() {
        return this.hasWifiCapability(8);
    }

    public boolean supportBaresip() {
        return this.getModel() == Model.StringObject;
    }

    public boolean supportScreen() {
        return this.hasHardwareCapability(1);
    }

    public boolean supportLedBar() {
        return this.hasHardwareCapability(2);
    }

    public boolean supportLCM() {
        return this.hasHardwareCapability(8);
    }

    public boolean supportMultiBlockWlanSchedule() {
        return this.hasCapability(4096);
    }

    public boolean supportWlanScheduleInvert() {
        return this.hasCapability(0x400000);
    }

    public boolean supportMultiDevDnsmasq() {
        return this.hasCapability(0x200000);
    }

    public boolean hasUSGCapability(int n) {
        return (n & this.getInt("usg_caps")) == n;
    }

    public boolean supportDPI() {
        return this.hasUSGCapability(1);
    }

    public boolean supportIPS() {
        return this.hasUSGCapability(128);
    }

    public boolean supportIPSSignature() {
        return this.hasUSGCapability(8192);
    }

    public boolean supportIPSAutoHomenet() {
        return this.hasUSGCapability(65536);
    }

    public boolean supportIPSOptin() {
        return this.hasUSGCapability(524288);
    }

    public boolean supportDHCPStaticHostRecordDisable() {
        return this.hasUSGCapability(32768);
    }

    public boolean supportPorta() {
        return this.hasUSGCapability(2);
    }

    public boolean supportDefaultRouteDistance() {
        return this.hasUSGCapability(4);
    }

    public boolean supportSSHDisable() {
        return this.hasUSGCapability(8);
    }

    public boolean supportRadius() {
        return this.hasUSGCapability(16);
    }

    public boolean supportFirewallSchedulingContiguous() {
        return this.hasUSGCapability(32);
    }

    public boolean supportGeoIpFiltering() {
        return this.hasUSGCapability(64);
    }

    public boolean supportPortReassignment() {
        return this.hasUSGCapability(2048);
    }

    public boolean supportDDNSExtended() {
        return this.hasUSGCapability(256);
    }

    public boolean supportWanEventReport() {
        return this.hasUSGCapability(512);
    }

    public boolean supportDpiWithoutOffload() {
        return this.hasUSGCapability(1024);
    }

    public boolean supportFlushOnActive() {
        return this.hasUSGCapability(131072);
    }

    public boolean hasRadioCapability(X x, int n) {
        return (n & x.getInt("radio_caps")) == n;
    }

    public boolean supportMinRssiStrictMode(X x) {
        return this.hasRadioCapability(x, 131072);
    }

    public boolean supportEncodedRadiusPassword() {
        return this.hasUSGCapability(16384);
    }

    public boolean supportRedirectorInitialEC() {
        return this.hasCapability(524288);
    }

    public boolean hasTemperatureSensor() {
        switch (this.getModel()) {
            case thissuper: 
            case \u00d5\u00d30000: 
            case Oo0000: 
            case o\u00d30000: 
            case \u00f5O0000: 
            case whilenew: 
            case \u00f8O0000: 
            case forObject: 
            case \u00f8\u00d30000: 
            case \u00f5\u00d40000: 
            case new: 
            case oO0000: 
            case privateObject: 
            case \u00d800000: 
            case \u00f4\u00d20000: 
            case \u00d3\u00d40000: 
            case newString: 
            case if: {
                return true;
            }
        }
        return false;
    }

    public static String getDefaultPoEMode(int n) {
        if ((n & 3) != 0) {
            return "auto";
        }
        return "off";
    }

    public boolean hasPoeCapability(X x, int n) {
        return (n & x.getInt("poe_caps", 7)) == n;
    }

    public boolean hasSpeedCapability(int n, int n2) {
        List<X> list = this.getList("port_table", X.do);
        X x = X.findOne(list, new X("port_idx", n));
        if (x != null) {
            return (n2 & x.getInt("speed_caps", 1048623)) == n2;
        }
        return false;
    }

    public boolean isConfigCloneableFrom(Device device) {
        if (this.isBroadcomSwitch() && device.isBroadcomSwitch() || this.isMicrosemiSwitch() && device.isMicrosemiSwitch() || this.isMediaTekSwitch() && device.isMediaTekSwitch() || this.isRealTekSwitch() && device.isRealTekSwitch()) {
            if (X.equals((X)this, (X)device, "model")) {
                return true;
            }
            return this.getPortNum() == device.getPortNum();
        }
        if (this.getDeviceType() == DeviceType.return && device.getDeviceType() == DeviceType.return) {
            return X.equals((X)this, (X)device, "model");
        }
        return false;
    }

    public static int getMediaMaxSpeed(String string) {
        if ("FE".equals(string)) {
            return 100;
        }
        if ("GE".equals(string)) {
            return 1000;
        }
        if ("10GE".equals(string)) {
            return 10000;
        }
        if ("SFP".equals(string)) {
            return 1000;
        }
        if ("SFP+".equals(string)) {
            return 10000;
        }
        return 1000;
    }

    public int getRadioNum(String string) {
        return (int)this.getList("radio_table", X.do).stream().filter(x -> x.getString("radio", "").equals(string)).count();
    }

    public String getDefaultPortName(int n) {
        switch (this.getModel()) {
            case \u00f8O0000: 
            case forObject: 
            case \u00f8\u00d30000: 
            case \u00f5\u00d40000: 
            case new: 
            case oO0000: {
                if (n > 50) {
                    return "SFP " + (n - 50);
                }
                if (n <= 48) break;
                return "SFP+ " + (n - 48);
            }
            case \u00d8o0000: {
                if (n <= 48) break;
                return "SFP " + (n - 48);
            }
            case thissuper: 
            case \u00d5\u00d30000: 
            case Oo0000: 
            case o\u00d30000: 
            case \u00f5O0000: 
            case whilenew: 
            case \u00f800000: {
                if (n <= 24) break;
                return "SFP " + (n - 24);
            }
            case \u00d800000: 
            case \u00d3\u00d40000: 
            case \u00d4\u00d40000: {
                if (n <= 16) break;
                return "SFP " + (n - 16);
            }
            case privateObject: 
            case \u00f4\u00d20000: 
            case \u00f4o0000: {
                if (n <= 8) break;
                return "SFP " + (n - 8);
            }
            case newString: {
                if (n >= 13) break;
                return "SFP+ " + n;
            }
            case if: {
                if (n <= 4) break;
                return "SFP+ " + (n - 4);
            }
            case o\u00d20000: {
                if (n <= 24) break;
                return "SFP+ " + (n - 24);
            }
            case \u00d3O0000: {
                if (n <= 48) break;
                return "SFP+ " + (n - 48);
            }
            case \u00d4O0000: 
            case O\u00d30000: 
            case nullsuper: {
                switch (n) {
                    case 1: {
                        return "PoE Out + Data";
                    }
                    case 2: {
                        return "Data";
                    }
                    case 3: {
                        return "PoE In + Data";
                    }
                }
                break;
            }
            case forsuper: {
                switch (n) {
                    case 0: {
                        return "PoE In + Data";
                    }
                    case 1: {
                        return "PoE Out + Data";
                    }
                }
                return "Data";
            }
            case O\u00d50000: {
                if (n != 0) break;
                return "PoE In + Data";
            }
        }
        return "Port " + n;
    }

    public int ethMaxSpeed() {
        switch (this.getModel()) {
            case Stringsuper: 
            case nullsuper: 
            case \u00d400000: 
            case \u00f8\u00d20000: 
            case \u00f500000: 
            case O\u00d40000: 
            case \u00d3\u00d50000: 
            case O\u00d20000: 
            case thisObject: {
                return 100;
            }
        }
        return 1000;
    }

    public int wifiMaxSpeed(String string) {
        Model model = this.getModel();
        if (this.isBroadcomAP()) {
            return "na".equals(string) ? 1300 : 450;
        }
        if (this.isAtherosAP()) {
            switch (model) {
                case \u00d4\u00d50000: {
                    return "na".equals(string) ? 300 : 450;
                }
                case nullsuper: 
                case \u00d3\u00d50000: 
                case o\u00d40000: {
                    return 150;
                }
                case \u00f400000: 
                case StringObject: 
                case ifnew: 
                case O\u00d30000: {
                    return "na".equals(string) ? 1300 : 450;
                }
                case \u00f4\u00d30000: {
                    return "na".equals(string) ? 867 : 450;
                }
                case \u00d8\u00d30000: 
                case OO0000: 
                case \u00d4O0000: {
                    return "na".equals(string) ? 867 : 300;
                }
                case \u00f8o0000: 
                case \u00f5\u00d30000: {
                    return "na".equals(string) ? 1733 : 800;
                }
                case newnew: 
                case \u00d3\u00d20000: {
                    return "na".equals(string) ? 1733 : 800;
                }
                case \u00d8O0000: 
                case oo0000: {
                    return "na".equals(string) ? 1733 : 0;
                }
            }
            return 300;
        }
        switch (model) {
            case \u00f8\u00d40000: 
            case forsuper: 
            case \u00d8\u00d40000: {
                return "na".equals(string) ? 1733 : 300;
            }
        }
        return 0;
    }

    public int getAdoptState() {
        return this.getInt("adopt_state", 0);
    }

    public int getAdoptTries() {
        return this.getInt("adopt_tries", 0);
    }

    public boolean hasInterface(String string) {
        List<X> list = this.getPortTable();
        return X.findOne(list, new X("ifname", string)) != null;
    }

    public List<X> getPortTable() {
        return this.getList("port_table", this.seedPortTable());
    }

    public static boolean isEOLModel(String string) {
        Device device = new Device();
        device.put("model", (Object)string);
        return device.isEOL();
    }

    public boolean isEOL() {
        return this.getModel() == Model.\u00d3\u00d50000 || this.isBroadcomAP();
    }

    public static boolean isEOLPendingModel(String string) {
        Device device = new Device();
        device.put("model", (Object)string);
        return device.isEOLPending();
    }

    public boolean isEOLPending() {
        return this.getModel() == Model.\u00d3\u00d50000 || this.isBroadcomAP();
    }

    public static long getEOLDateForModel(String string) {
        Device device = new Device();
        device.put("model", (Object)string);
        return device.getEOLDate();
    }

    public long getEOLDate() {
        if (this.getModel() == Model.\u00d3\u00d50000 || this.isBroadcomAP()) {
            return 1541548799L;
        }
        return -1L;
    }

    public static String getEOLVersionForModel(String string) {
        Device device = new Device();
        device.put("model", (Object)string);
        return device.getEOLVersion();
    }

    public String getEOLVersion() {
        if (this.getModel() == Model.\u00d3\u00d50000 || this.isBroadcomAP()) {
            return "5.7.0";
        }
        return \u00d3oo000;
    }

    public List<String> getLanInterfaceNames() {
        List<X> list = this.getPortTable();
        return list.stream().filter(x -> StringUtils.startsWith((String)x.getString("name"), (String)"lan")).map(x -> x.getString("ifname")).collect(Collectors.toList());
    }

    public X getDefaultNetworkConfig() {
        return X.newInstanceWithoutNullValue("type", "dhcp", "ip", this.getString("ip", null));
    }

    public boolean exceedAdoptTries() {
        int n = this.getAdoptTries();
        int n2 = this.getAdoptState();
        return n >= 3 && n2 == 2 | n2 == 3 | n2 == 4;
    }

    public static List<X> getUGW3PortaEnabledPortTable() {
        ArrayList<X> arrayList = new ArrayList<X>();
        arrayList.add(new X("name", floatpublic, "ifname", "eth0"));
        arrayList.add(new X("name", "lan", "ifname", "eth1"));
        arrayList.add(new X("name", \u00d8\u00f5O000, "ifname", "eth2"));
        return arrayList;
    }

    public void incAdoptTries() {
        this.put("adopt_tries", (Object)(this.getAdoptTries() + 1));
    }

    public void resetAdoptState() {
        this.setAdoptState(0);
    }

    public void setAdoptState(int n) {
        this.put("adopt_state", (Object)n);
        if (n == 0) {
            this.put("adopt_tries", (Object)0);
        }
    }

    public void setConfigWanChanged(boolean bl) {
        if (bl) {
            this.put("config_network_wan_changed", (Object)true);
        } else {
            this.removeField("config_network_wan_changed");
        }
    }

    public String getUplinkRadio() {
        return this.hasRadioNA() ? "na" : "ng";
    }

    @Deprecated
    public X getRadioNG() {
        List<X> list = X.find(this.getList("radio_table", X.do), "radio", "ng");
        return !list.isEmpty() ? list.get(0) : null;
    }

    @Deprecated
    public X getRadioNA() {
        List<X> list = X.find(this.getList("radio_table", X.do), "radio", "na");
        return !list.isEmpty() ? list.get(0) : null;
    }

    @Deprecated
    public X getRadio(String string) {
        return X.findOne(this.getList("radio_table", X.do), "radio", string);
    }

    public List<X> getRadioList() {
        return this.getList("radio_table", X.do);
    }

    public X getRadioByName(String string) {
        return X.findOne(this.getList("radio_table", X.do), "name", string);
    }

    public X getRadioByWlangroupId(String string) {
        List<X> list = X.find(this.getList("radio_table", X.do), "wlangroup_id", string);
        return !list.isEmpty() ? list.get(0) : null;
    }

    public boolean hasVwireTo(String string) {
        if (!this.containsField("vwire_table")) {
            return false;
        }
        return X.findOne(this.getList("vwire_table", X.do), "ap_mac", string) != null;
    }

    public int getVwireCount(String string) {
        return X.find(this.getList("vwire_table", X.do), "radio", string).size();
    }

    public boolean isElite() {
        return this.getX("elite", X.\u00f6o0000).is("valid", false);
    }

    public boolean isEliteMessageSent() {
        return this.is("x_elite_message_sent", false);
    }

    public boolean isMaxVwireConfigured(String string) {
        if (!this.supportVwire()) {
            return true;
        }
        if (this.isEOL()) {
            return true;
        }
        if (this.is("disabled", false)) {
            return true;
        }
        return this.getVwireCount(string) == 4;
    }

    public boolean isWiredUplink() {
        X x = this.getX("uplink", X.\u00f6o0000);
        return "wire".equals(x.getString("type", "wireless"));
    }

    public boolean isWirelessUplink() {
        X x = this.getX("uplink", X.\u00f6o0000);
        return "wireless".equals(x.getString("type", "wire"));
    }

    public String getWirelessUplinkApMac() {
        X x = this.getX("uplink", X.\u00f6o0000);
        return x.getString("ap_mac", "none");
    }

    public boolean requireRadiusProfile() {
        return this.is("dot1x_portctrl_enabled", false);
    }

    public boolean aesGcmInformEncryptionOnly() {
        return this.is("x_aes_gcm", false);
    }

    @Override
    public synchronized Object put(String string, Object object) {
        if (this.isImmutable()) {
            throw new UnsupportedOperationException();
        }
        if (ArrayUtils.contains((Object[])\u00d4\u00f8O000, (Object)string) && this.containsField(string) && object == null) {
            O\u00d4o000.warn(String.format("dev[%s] updating %s %s -> %s", this.getString("mac"), string, this.getString(string), object));
        }
        return super.put(string, object);
    }

    @Override
    public synchronized Object removeField(String string) {
        if (ArrayUtils.contains((Object[])\u00d4\u00f8O000, (Object)string) && this.containsField(string)) {
            O\u00d4o000.warn(String.format("dev[%s] removing %s %s", this.getString("mac"), string, this.getString(string)));
        }
        return super.removeField(string);
    }

    @Override
    public synchronized Object remove(Object object) {
        String string;
        if (object != null && this.containsKey(object) && ArrayUtils.contains((Object[])\u00d4\u00f8O000, (Object)(string = object.toString()))) {
            O\u00d4o000.warn(String.format("dev[%s] removing %s %s", this.getString("mac"), string, this.get(object)));
        }
        return super.remove(object);
    }

    public String getMAC() {
        return this.getString("mac", "");
    }

    public boolean isLTEWANFailoverMode() {
        if (!this.hasLTE()) {
            return false;
        }
        return intnewsuper.equals(this.getString("lte_failover_mode", intnewsuper));
    }

    public boolean isUnsupported() {
        return this.is("unsupported", false);
    }

    public boolean hasIncompatibleFirmware() {
        return this.isUnsupported() && null.o00000(this.getInt("unsupported_reason")) == null.\u00d400000;
    }

    public boolean isInTwoPhaseAdoption() {
        return this.is("two_phase_adopt", false);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum UpgradeState {
        \u00d800000("Not in upgradeing state"),
        \u00f400000("upgrade preparing reboot"),
        \u00d600000("upgrade failed reboot"),
        \u00d300000("firmware downloading"),
        int("device firmware download completed"),
        class("device firmware writing"),
        super("firmware download start");

        private String \u00d200000;

        private UpgradeState(String string2) {
            this.\u00d200000 = string2;
        }

        public String toString() {
            return this.\u00d200000;
        }
    }
}

