/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.patterns;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TagsBuilder<T extends TagsBuilder<T>> {
    protected final List<Tag> extraTags = new ArrayList<Tag>();

    protected TagsBuilder() {
    }

    public T withTag(String k, String v) {
        this.extraTags.add(new BasicTag(k, v));
        return (T)this;
    }

    public T withTag(String k, Boolean v) {
        this.extraTags.add(new BasicTag(k, Boolean.toString(v)));
        return (T)this;
    }

    public T withTag(Tag t) {
        this.extraTags.add(t);
        return (T)this;
    }

    public T withTags(String ... tags) {
        for (int i = 0; i < tags.length; i += 2) {
            this.extraTags.add(new BasicTag(tags[0], tags[1]));
        }
        return (T)this;
    }

    public T withTags(Tag ... tags) {
        Collections.addAll(this.extraTags, tags);
        return (T)this;
    }

    public T withTags(Iterable<Tag> tags) {
        for (Tag t : tags) {
            this.extraTags.add(t);
        }
        return (T)this;
    }

    public T withTags(Map<String, String> tags) {
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            this.extraTags.add(new BasicTag(entry.getKey(), entry.getValue()));
        }
        return (T)this;
    }
}

