/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.berndpruenster.netlayer.tor.OsType;
import org.berndpruenster.netlayer.tor.TorKt;
import org.berndpruenster.netlayer.tor.WriteObserver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/berndpruenster/netlayer/tor/NativeWatchObserver;", "Lorg/berndpruenster/netlayer/tor/WriteObserver;", "fileToWatch", "Ljava/io/File;", "(Ljava/io/File;)V", "key", "Ljava/nio/file/WatchKey;", "lastModified", "", "length", "watchService", "Ljava/nio/file/WatchService;", "poll", "", "timeout", "unit", "Ljava/util/concurrent/TimeUnit;", "tor.native"})
public final class NativeWatchObserver
implements WriteObserver {
    private final WatchService watchService;
    private final WatchKey key;
    private final long lastModified;
    private final long length;
    private final File fileToWatch;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean poll(long timeout, @NotNull TimeUnit unit) {
        block10: {
            Intrinsics.checkParameterIsNotNull((Object)unit, (String)"unit");
            result = false;
            try {
                remainingTimeoutInNanos = unit.toNanos(timeout);
lbl6:
                // 2 sources

                while (remainingTimeoutInNanos > 0L) {
                    startTimeInNanos = System.nanoTime();
                    receivedKey = this.watchService.poll(remainingTimeoutInNanos, TimeUnit.NANOSECONDS);
                    timeWaitedInNanos = System.nanoTime() - startTimeInNanos;
                    if (receivedKey == null) ** GOTO lbl35
                    if (Intrinsics.areEqual((Object)receivedKey, (Object)this.key) ^ true) {
                        throw (Throwable)new RuntimeException("This really shouldn't have happened. EEK!" + receivedKey.toString());
                    }
                    for (WatchEvent<?> event : receivedKey.pollEvents()) {
                        kind = event.kind();
                        if (Intrinsics.areEqual(kind, StandardWatchEventKinds.OVERFLOW)) {
                            TorKt.getLogger().error("We got an overflow, there shouldn't have been enough activity to make that happen.");
                        }
                        v0 = event.context();
                        if (v0 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.nio.file.Path");
                        }
                        changedEntry = (Path)v0;
                        if (!this.fileToWatch.toPath().endsWith(changedEntry)) continue;
                        var16_14 = result = true;
                        break block10;
                    }
                    ** GOTO lbl-1000
                }
                ** GOTO lbl38
            }
            catch (Throwable var5_5) {
                if (result == false) throw var5_5;
                this.watchService.close();
                throw var5_5;
            }
        }
        this.watchService.close();
        return var16_14;
lbl-1000:
        // 1 sources

        {
            block11: {
                if (!this.key.reset()) {
                    TorKt.getLogger().error("The key became invalid which should not have happened.");
                }
lbl35:
                // 4 sources

                if (timeWaitedInNanos >= remainingTimeoutInNanos) break block11;
                remainingTimeoutInNanos -= timeWaitedInNanos;
                ** GOTO lbl6
            }
            if (this.fileToWatch.lastModified() == this.lastModified) {
                if (this.fileToWatch.length() == this.length) return false;
            }
            v1 = true;
            var7_7 = result = v1;
            if (result == false) return var7_7;
        }
        this.watchService.close();
        return var7_7;
    }

    public NativeWatchObserver(@NotNull File fileToWatch) {
        Intrinsics.checkParameterIsNotNull((Object)fileToWatch, (String)"fileToWatch");
        this.fileToWatch = fileToWatch;
        if (!this.fileToWatch.exists()) {
            throw (Throwable)new RuntimeException("" + this.fileToWatch + " does not exist");
        }
        this.lastModified = this.fileToWatch.lastModified();
        this.length = this.fileToWatch.length();
        WatchService watchService = FileSystems.getDefault().newWatchService();
        Intrinsics.checkExpressionValueIsNotNull((Object)watchService, (String)"FileSystems.getDefault().newWatchService()");
        this.watchService = watchService;
        if (Intrinsics.areEqual((Object)OsType.Companion.getCurrent(), (Object)OsType.MACOS) ^ true) {
            WatchKey watchKey = this.fileToWatch.getParentFile().toPath().register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            Intrinsics.checkExpressionValueIsNotNull((Object)watchKey, (String)"fileToWatch.parentFile.t\u2026hEventKinds.ENTRY_MODIFY)");
            this.key = watchKey;
        } else {
            Object[] objectArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
            WatchService watchService2 = this.watchService;
            Path path = this.fileToWatch.getParentFile().toPath();
            NativeWatchObserver nativeWatchObserver = this;
            Object[] objectArray2 = objectArray;
            WatchKey watchKey = path.register(watchService2, (WatchEvent.Kind[])objectArray2, new WatchEvent.Modifier[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)watchKey, (String)"fileToWatch.parentFile.t\u2026EventKinds.ENTRY_MODIFY))");
            nativeWatchObserver.key = watchKey;
        }
    }
}

