/*
 * Decompiled with CFR 0.152.
 */
package org.berndpruenster.netlayer.tor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.berndpruenster.netlayer.tor.FileUtilitiesKt;
import org.berndpruenster.netlayer.tor.NativeContext;
import org.berndpruenster.netlayer.tor.NativeContext$WhenMappings;
import org.berndpruenster.netlayer.tor.NativeWatchObserver;
import org.berndpruenster.netlayer.tor.OsType;
import org.berndpruenster.netlayer.tor.TorContext;
import org.berndpruenster.netlayer.tor.WriteObserver;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0006H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\u00068TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\n\u0010\bR\u0014\u0010\r\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u001b\u0010\u000f\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u0010\u0010\bR\u001b\u0010\u0012\u001a\u00020\u00068TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\f\u001a\u0004\b\u0013\u0010\b\u00a8\u0006\u001d"}, d2={"Lorg/berndpruenster/netlayer/tor/NativeContext;", "Lorg/berndpruenster/netlayer/tor/TorContext;", "workingDirectory", "Ljava/io/File;", "(Ljava/io/File;)V", "pathToRC", "", "getPathToRC", "()Ljava/lang/String;", "pathToTorExecutable", "getPathToTorExecutable", "pathToTorExecutable$delegate", "Lkotlin/Lazy;", "processId", "getProcessId", "rcPath", "getRcPath", "rcPath$delegate", "torExecutableFileName", "getTorExecutableFileName", "torExecutableFileName$delegate", "generateWriteObserver", "Lorg/berndpruenster/netlayer/tor/WriteObserver;", "file", "getAssetOrResourceByName", "Ljava/io/InputStream;", "fileName", "installFiles", "", "tor.native"})
public final class NativeContext
extends TorContext {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Lazy pathToTorExecutable$delegate;
    private final Lazy rcPath$delegate;
    @NotNull
    private final String pathToRC;
    @NotNull
    private final Lazy torExecutableFileName$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NativeContext.class), "pathToTorExecutable", "getPathToTorExecutable()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NativeContext.class), "rcPath", "getRcPath()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(NativeContext.class), "torExecutableFileName", "getTorExecutableFileName()Ljava/lang/String;"))};
    }

    @NotNull
    public String getProcessId() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return (String)StringsKt.split$default((CharSequence)processName, (String[])new String[]{"@"}, (boolean)false, (int)0, (int)6, null).get(0);
    }

    @NotNull
    protected String getPathToTorExecutable() {
        Lazy lazy = this.pathToTorExecutable$delegate;
        NativeContext nativeContext = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (String)lazy.getValue();
    }

    private final String getRcPath() {
        Lazy lazy = this.rcPath$delegate;
        NativeContext nativeContext = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (String)lazy.getValue();
    }

    @NotNull
    public String getPathToRC() {
        return this.pathToRC;
    }

    @NotNull
    protected String getTorExecutableFileName() {
        Lazy lazy = this.torExecutableFileName$delegate;
        NativeContext nativeContext = this;
        KProperty kProperty = $$delegatedProperties[2];
        return (String)lazy.getValue();
    }

    @NotNull
    public InputStream getAssetOrResourceByName(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream('/' + fileName);
        if (inputStream == null) {
            throw (Throwable)new IOException("Could not load " + fileName);
        }
        return inputStream;
    }

    @NotNull
    public WriteObserver generateWriteObserver(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return new NativeWatchObserver(file);
    }

    public void installFiles() {
        super.installFiles();
        switch (NativeContext$WhenMappings.$EnumSwitchMapping$3[OsType.Companion.getCurrent().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                FileUtilitiesKt.extractContentFromArchive((File)this.getWorkingDirectory(), (InputStream)this.getAssetOrResourceByName(this.getPathToTorExecutable() + "tor.tar.xz"));
                break;
            }
            default: {
                throw (Throwable)new RuntimeException("We don't support Tor on this OS");
            }
        }
    }

    public NativeContext(@NotNull File workingDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)workingDirectory, (String)"workingDirectory");
        super(workingDirectory);
        this.pathToTorExecutable$delegate = LazyKt.lazy((Function0)pathToTorExecutable.2.INSTANCE);
        this.rcPath$delegate = LazyKt.lazy((Function0)rcPath.2.INSTANCE);
        this.pathToRC = "" + this.getRcPath() + "" + TorContext.Companion.getFILE_TORRC_NATIVE();
        this.torExecutableFileName$delegate = LazyKt.lazy((Function0)torExecutableFileName.2.INSTANCE);
    }
}

