/*
 * Decompiled with CFR 0.152.
 */
package com.ca.jndiproviders.dsml;

import com.ca.commons.cbutil.CBBase64;
import com.ca.commons.cbutil.CBBase64EncodingException;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.jndiproviders.dsml.DsmlParser;
import com.ca.jndiproviders.dsml.SoapClient;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InvalidAttributesException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;

public class DsmlContext
implements LdapContext {
    private static int TABLEN = 4;
    private static String TAB = "    ";
    private static String TAB2 = TAB + TAB;
    private static String TAB3 = TAB2 + TAB;
    private static String TAB4 = TAB3 + TAB;
    private static String TAB5 = TAB4 + TAB;
    private static String TAB6 = TAB5 + TAB;
    private static String SOAPHEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + TAB + "<soap-env:Envelope xmlns:soap-env=\"http://schemas.xmlsoap.org/soap/envelope/\">\n" + TAB2 + "<soap-env:Body>\n";
    private static String SOAPFOOTER = TAB2 + "</soap-env:Body>\n" + TAB + "</soap-env:Envelope>";
    private static String DSMLHEADER = TAB3 + "<dsml:batchRequest xmlns:dsml=\"urn:oasis:names:tc:DSML:2:0:core\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n";
    private static String DSMLFOOTER = TAB3 + "</dsml:batchRequest>\n";
    private static String SEARCHFOOTER = TAB3 + "</dsml:searchRequest>\n";
    private static String STANDARDHEADER = SOAPHEADER + DSMLHEADER;
    private static String STANDARDFOOTER = DSMLFOOTER + SOAPFOOTER;
    private static String BASEOBJECT = "baseObject";
    private static String SINGLELEVEL = "singleLevel";
    private static String WHOLESUBTREE = "wholeSubtree";
    private static String[] SCOPEOPTIONS = new String[]{BASEOBJECT, SINGLELEVEL, WHOLESUBTREE};
    private static String NEVER = "neverDerefAliases";
    private static String SEARCHING = "derefInSearching";
    private static String FINDING = "derefFindingBaseObj";
    private static String ALWAYS = "derefAlways";
    private static String[] ALIASOPTIONS = new String[]{NEVER, SEARCHING, FINDING, ALWAYS};
    private static SearchControls DEFAULT_SEARCH_CONTROLS = new SearchControls();
    protected Hashtable environment;
    private String contextName = "";
    private static Logger log = Logger.getLogger(DsmlContext.class.getName());
    private static Pattern errorResult = Pattern.compile("errorResponse.*?type=\"(.*?)\"", 32);
    private static Pattern errorMessage = Pattern.compile("message>(.*?)</", 32);
    private static Pattern errorDetail = Pattern.compile("detail>(.*?)</", 32);
    private static Pattern ldapResultCode = Pattern.compile("code=\"(.*?)\"", 32);
    private static Pattern ldapResultDesc = Pattern.compile("resultCode.*?descr=\"(.*?)\"", 32);
    private static Pattern ldapResultMsg = Pattern.compile("errorMessage>(.*?)</", 32);
    private static Pattern searchResultEntry = Pattern.compile("searchResultEntry.*?dn=\"(.*?)\">(.*?)searchResultEntry>", 32);
    private static Pattern searchResultAttribute = Pattern.compile("attr name=\"(.*?)\">(.*?)attr>", 32);
    private static Pattern searchResultAttributeValues = Pattern.compile("value(.*?)>(.*?)<.*?value>", 32);
    private static Pattern searchTestType = Pattern.compile("type=\"(.*?)\"", 32);
    private static Pattern escapeGTPattern = Pattern.compile("(&gt;)", 32);
    private static Pattern escapeLTPattern = Pattern.compile("(&lt;)", 32);
    private static Pattern escapeAMPPattern = Pattern.compile("(&amp;)", 32);
    private static Pattern escapeQUOTPattern = Pattern.compile("(&quot;)", 32);
    private static Pattern escapeAPOSPattern = Pattern.compile("(&apos;)", 32);
    private static Pattern escapeOCTOPattern = Pattern.compile("(&#.*?;)", 32);

    private static StringBuffer getSearchRequestHeader(StringBuffer searchHeader, String dn, String scope, String derefAliases, long sizeLimit, int timeLimit, boolean typesOnly) throws NamingException {
        if (!DsmlContext.checkValidity(SCOPEOPTIONS, scope)) {
            throw new NamingException("search scope argument '" + scope + "' is invalid");
        }
        if (!DsmlContext.checkValidity(ALIASOPTIONS, derefAliases)) {
            if (derefAliases != null) {
                log.info("bad alias option passed '" + derefAliases + "'");
            }
            derefAliases = SEARCHING;
        }
        if (searchHeader == null) {
            searchHeader = new StringBuffer();
        }
        searchHeader.append(TAB4 + "<dsml:searchRequest dn=\"");
        searchHeader.append(DsmlContext.escapeName(dn));
        searchHeader.append("\" scope=\"").append(scope);
        searchHeader.append("\" derefAliases=\"").append(derefAliases);
        if (sizeLimit > 0L) {
            searchHeader.append("\" sizeLimit=\"").append(sizeLimit);
        }
        if (timeLimit > 0) {
            searchHeader.append("\" timeLimit=\"").append(timeLimit);
        }
        if (typesOnly) {
            searchHeader.append("\" typesOnly=\"").append(typesOnly);
        }
        searchHeader.append("\">\n");
        log.finest("created search header: " + searchHeader);
        return searchHeader;
    }

    private static StringBuffer getSearchRequestAttributes(StringBuffer searchAttributes, String[] attributes) {
        if (attributes == null || attributes.length == 0) {
            return searchAttributes;
        }
        if (searchAttributes == null) {
            searchAttributes = new StringBuffer(40 + 80 * attributes.length);
        }
        searchAttributes.append(TAB5 + "<dsml:attributes>\n");
        int len = attributes.length;
        for (int i = 0; i < len; ++i) {
            searchAttributes.append(TAB6 + "<dsml:attribute name=\"").append(attributes[i]).append("\"/>\n");
        }
        searchAttributes.append(TAB5 + "</dsml:attributes>\n");
        log.finest("created search attribute list: " + searchAttributes);
        return searchAttributes;
    }

    private static boolean checkValidity(String[] options, String checkme) {
        if (checkme != null) {
            for (int i = 0; i < options.length; ++i) {
                if (!options[i].equals(checkme)) continue;
                return true;
            }
        }
        return false;
    }

    private NamingEnumeration getTestEnumeration(Name name, int num) {
        log.finest("generating " + num + " test names from '" + name.toString() + "'");
        String itemBase = "c=AU";
        if (name.size() == 1) {
            itemBase = "o=beta";
        } else if (name.size() == 2) {
            itemBase = "ou=gamma";
        } else if (name.size() == 3) {
            itemBase = "ou=delta";
        }
        DXNamingEnumeration testEnumeration = new DXNamingEnumeration();
        for (int i = 0; i < num; ++i) {
            String itemName = itemBase + i;
            testEnumeration.add(new SearchResult(itemName, (Object)null, this.getTestAttributes(itemName)));
        }
        return testEnumeration;
    }

    private BasicAttributes getTestAttributes(String name) {
        log.finest("generating test data from name '" + name + "'");
        BasicAttributes testAttributes = new BasicAttributes("cn", name);
        testAttributes.put(new BasicAttribute("objectClass", "person"));
        testAttributes.put(new BasicAttribute("sn", "Test"));
        return testAttributes;
    }

    private DsmlContext() {
        log.setLevel(Level.FINEST);
    }

    private DsmlContext(String baseDN, Hashtable env) {
        log.setLevel(Level.FINEST);
        this.contextName = baseDN == null ? "" : baseDN;
        this.environment = env;
    }

    DsmlContext(Hashtable env) {
        log.setLevel(Level.FINEST);
        this.environment = env == null ? new Hashtable() : env;
        log.fine("Created DsmlContext");
    }

    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(name, null);
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        ModificationItem[] mods = new ModificationItem[attrs.size()];
        NamingEnumeration<? extends Attribute> attObjects = attrs.getAll();
        int i = 0;
        while (attObjects.hasMoreElements()) {
            mods[i++] = new ModificationItem(mod_op, (Attribute)attObjects.nextElement());
        }
        this.modifyAttributes(name, mods);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name, null);
    }

    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(name.toString(), mod_op, attrs);
    }

    public LdapContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException("DsmlContext does not support reading schema (yet)");
    }

    public LdapContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException("DsmlContext does not support reading schema (yet)");
    }

    public LdapContext getSchema(Name name) throws NamingException {
        throw new OperationNotSupportedException("DsmlContext does not support reading schema (yet)");
    }

    public LdapContext getSchemaClassDefinition(Name name) throws NamingException {
        throw new OperationNotSupportedException("DsmlContext does not support reading schema (yet)");
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        log.finest("modify Atts of (" + name + ")");
        StringBuffer modRequestBuffer = this.constructModRequest(name, mods);
        String response = this.sendDSMLRequest(modRequestBuffer);
        this.parseModResponse(response);
    }

    private StringBuffer constructModRequest(String name, ModificationItem[] mods) throws NamingException {
        StringBuffer message = new StringBuffer(200);
        message.append(STANDARDHEADER);
        DsmlContext.getModRequestElement(message, name, mods);
        message.append(STANDARDFOOTER);
        return message;
    }

    static void getModRequestElement(StringBuffer message, String name, ModificationItem[] mods) throws NamingException {
        message.append(TAB4).append("<dsml:modifyRequest dn=\"").append(DsmlContext.escapeName(name)).append("\">\n");
        block5: for (int i = 0; i < mods.length; ++i) {
            Attribute att = mods[i].getAttribute();
            NamingEnumeration<?> values = att.getAll();
            switch (mods[i].getModificationOp()) {
                case 1: {
                    message.append(TAB5).append("<dsml:modification name=\"").append(att.getID()).append("\" operation=\"add\">\n");
                    while (values.hasMore()) {
                        DsmlContext.createDsmlValueElement(values.next(), message);
                    }
                    message.append(TAB5).append("</dsml:modification>\n");
                    continue block5;
                }
                case 2: {
                    message.append(TAB5).append("<dsml:modification name=\"").append(att.getID()).append("\" operation=\"replace\">\n");
                    while (values.hasMore()) {
                        DsmlContext.createDsmlValueElement(values.next(), message);
                    }
                    message.append(TAB5).append("</dsml:modification>\n");
                    continue block5;
                }
                case 3: {
                    message.append(TAB5).append("<dsml:modification name=\"").append(att.getID()).append("\" operation=\"delete\">\n");
                    while (values.hasMore()) {
                        DsmlContext.createDsmlValueElement(values.next(), message);
                    }
                    message.append(TAB5).append("</dsml:modification>\n");
                }
            }
        }
        message.append(TAB4).append("</dsml:modifyRequest>\n");
    }

    void parseModResponse(String response) throws NamingException {
        DsmlContext.checkForError(response);
        if (response.indexOf("modifyResponse>") == -1) {
            throw new NamingException("Unexpected DSML Response to Modify Request:\n " + response);
        }
    }

    static void checkForError(String response) throws NamingException {
        Matcher error = errorResult.matcher(response);
        if (error.find()) {
            Matcher detail;
            String errorMsg = "Error Processing DSML Request: " + error.group(1);
            Matcher message = errorMessage.matcher(response);
            if (message.find()) {
                errorMsg = errorMsg + "\n" + message.group(1);
            }
            if ((detail = errorDetail.matcher(response)).find()) {
                errorMsg = errorMsg + "\n" + detail.group(1);
            }
            throw new NamingException(errorMsg);
        }
        try {
            Matcher resultMatcher = ldapResultCode.matcher(response);
            resultMatcher.find();
            String resultCode = resultMatcher.group(1);
            int i = Integer.parseInt(resultCode);
            if (i == 0) {
                return;
            }
            Matcher descMatcher = ldapResultDesc.matcher(response);
            String desc = "";
            if (descMatcher.find()) {
                desc = descMatcher.group(1);
            }
            Matcher msgMatcher = ldapResultMsg.matcher(response);
            String msg = "";
            if (msgMatcher.find()) {
                msg = msgMatcher.group(1);
            }
            throw new NamingException(desc + " Exception (LDAP " + resultCode + ")\n" + msg);
        }
        catch (NumberFormatException e) {
            throw new NamingException("Unable to parse result code in DSML Response\n" + response);
        }
        catch (IllegalStateException e) {
            throw new NamingException("Unable to find result code in DSML Response\n" + response);
        }
    }

    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(name.toString(), mods);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, matchingAttributes, null);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes) throws NamingException {
        return this.search(name, matchingAttributes, null);
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects is not supported by the DsmlContext");
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects is not supported by the DsmlContext");
    }

    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects is not supported by the DsmlContext");
    }

    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects is not supported by the DsmlContext");
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        log.finest("getAttributes (" + name.toString() + ")");
        NamingEnumeration en = this.doDsmlSearch(name.toString(), BASEOBJECT, SEARCHING, 0L, 0, false, "(objectClass=*)", attrIds);
        if (!en.hasMoreElements()) {
            return new BasicAttributes();
        }
        SearchResult result = (SearchResult)en.next();
        return result.getAttributes();
    }

    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        return this.getAttributes(name.toString(), attrIds);
    }

    public LdapContext createSubcontext(String name, Attributes attrs) throws NamingException {
        log.finest("createSubcontext (" + name.toString() + ")");
        StringBuffer addRequestBuffer = DsmlContext.constructAddRequest(name, attrs);
        String response = this.sendDSMLRequest(addRequestBuffer);
        this.parseAddResponse(response);
        return new DsmlContext(name, this.environment);
    }

    void parseAddResponse(String response) throws NamingException {
        DsmlContext.checkForError(response);
        if (response.indexOf("addResponse>") == -1) {
            throw new NamingException("Unexpected DSML Response to Add Request:\n " + response);
        }
    }

    public LdapContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        return this.createSubcontext(name.toString(), attrs);
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        String filter = DsmlContext.getAttributeMatchFilter(matchingAttributes);
        return this.doDsmlSearch(name, WHOLESUBTREE, SEARCHING, 0L, 0, false, filter, attributesToReturn);
    }

    public NamingEnumeration search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search(name.toString(), matchingAttributes, attributesToReturn);
    }

    static String getAttributeMatchFilter(Attributes matchingAttributes) {
        String filter;
        int numbAtts;
        int n = numbAtts = matchingAttributes == null ? 0 : matchingAttributes.size();
        if (numbAtts == 0) {
            filter = "(objectClass=*)";
        } else {
            StringBuffer filterBuffer = new StringBuffer();
            if (numbAtts > 1) {
                filterBuffer.append("(&");
            }
            NamingEnumeration<String> atts = matchingAttributes.getIDs();
            while (atts.hasMoreElements()) {
                String att = (String)atts.nextElement();
                filterBuffer.append("(").append(att).append("=*)");
            }
            if (numbAtts > 1) {
                filterBuffer.append(")");
            }
            filter = filterBuffer.toString();
        }
        return filter;
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        return this.search(name, filter, null, cons);
    }

    public NamingEnumeration search(Name name, String filter, SearchControls cons) throws NamingException {
        return this.search(name, filter, null, cons);
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        String searchScope;
        if (filterExpr == null) {
            throw new NamingException("null ldap filter in DsmlContext search");
        }
        if (filterArgs != null && filterArgs.length > 0) {
            throw new NamingException("filter arguments not implemented in com.ca.jndiproviders.dsml provider");
        }
        log.finest("search III (" + name.toString() + ") + filter: " + filterExpr);
        if (cons == null) {
            cons = DEFAULT_SEARCH_CONTROLS;
        }
        switch (cons.getSearchScope()) {
            case 0: {
                searchScope = BASEOBJECT;
                break;
            }
            case 1: {
                searchScope = SINGLELEVEL;
                break;
            }
            case 2: {
                searchScope = WHOLESUBTREE;
                break;
            }
            default: {
                throw new NamingException("unexpected error; unknown search scope in SearchControl object: " + cons.getSearchScope());
            }
        }
        String jndiAliasHandling = (String)this.environment.get("java.naming.ldap.derefAliases");
        if (jndiAliasHandling == null) {
            jndiAliasHandling = "always";
        }
        String aliasHandling = "derefAlways";
        if (jndiAliasHandling.equals("always")) {
            aliasHandling = ALWAYS;
        } else if (jndiAliasHandling.equals("never")) {
            aliasHandling = NEVER;
        } else if (jndiAliasHandling.equals("finding")) {
            aliasHandling = FINDING;
        } else if (jndiAliasHandling.equals("searching")) {
            aliasHandling = SEARCHING;
        }
        NamingEnumeration returnEnum = this.doDsmlSearch(name, searchScope, aliasHandling, cons.getCountLimit(), cons.getTimeLimit(), false, filterExpr, cons.getReturningAttributes());
        return returnEnum;
    }

    public NamingEnumeration search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(name.toString(), filterExpr, filterArgs, cons);
    }

    public void close() throws NamingException {
        log.finest("close()");
    }

    public String getNameInNamespace() throws NamingException {
        log.finest("getNameInNamespace()");
        return this.contextName;
    }

    public void destroySubcontext(String name) throws NamingException {
        log.finest("destroySubcontext (" + name.toString() + ")");
        StringBuffer deleteRequestBuffer = DsmlContext.constructDeleteRequest(name);
        String response = this.sendDSMLRequest(deleteRequestBuffer);
        this.parseDeleteResponse(response);
    }

    void parseDeleteResponse(String response) throws NamingException {
        DsmlContext.checkForError(response);
        if (response.indexOf("delResponse>") == -1) {
            throw new NamingException("Unexpected DSML Response to Delete Request:\n " + response);
        }
    }

    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException("DsmlContext does not support storing java objects");
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException("DsmlContext does not support storing java objects");
    }

    public Object lookup(String name) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects is not supported by the DsmlContext");
    }

    public Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects is not supported by the DsmlContext");
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects is not supported by the DsmlContext");
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects is not supported by the DsmlContext");
    }

    public Object lookup(Name name) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects is not supported by the DsmlContext");
    }

    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects is not supported by the DsmlContext");
    }

    public void bind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects is not supported by the DsmlContext");
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects is not supported by the DsmlContext");
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.rename(new DN(oldName), new DN(newName));
    }

    StringBuffer constructModDNRequest(String oldName, String newName) throws NamingException {
        StringBuffer message = new StringBuffer(200);
        message.append(STANDARDHEADER);
        this.getModDNRequestElement(message, oldName, newName);
        message.append(STANDARDFOOTER);
        return message;
    }

    void getModDNRequestElement(StringBuffer message, String oldName, String newRDN) {
        message.append(TAB4).append("<dsml:modDNRequest dn=\"").append(DsmlContext.escapeName(oldName)).append("\" newrdn=\"").append(DsmlContext.escapeName(newRDN)).append("\" ");
        if (this.environment.get("java.naming.ldap.deleteRDN").toString().equalsIgnoreCase("false")) {
            message.append("deleteoldrdn=\"false\"/>");
        } else {
            message.append("deleteoldrdn=\"true\"/>");
        }
    }

    void parseModDNResponse(String response) throws NamingException {
        DsmlContext.checkForError(response);
        if (response.indexOf("modDNResponse>") == -1) {
            throw new NamingException("Unexpected DSML Response to Modify DN Request:\n " + response);
        }
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new InvalidAttributesException("cannot create directory object without attributes");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new InvalidAttributesException("cannot create directory object without attributes");
    }

    public void rename(Name oldName, Name rdn) throws NamingException {
        log.finest("rename (" + oldName + " to " + rdn);
        String oldNameString = oldName.toString();
        if (rdn.size() != 1) {
            throw new NamingException("cannot perform rename operation '" + rdn + "' is not an RDN \n");
        }
        String newRDN = rdn.toString();
        StringBuffer modDNRequestBuffer = this.constructModDNRequest(oldNameString, newRDN);
        String response = this.sendDSMLRequest(modDNRequestBuffer);
        this.parseModDNResponse(response);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return DsmlParser.parser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return DsmlParser.parser;
    }

    public NamingEnumeration list(String name) throws NamingException {
        log.finest("list (" + name.toString() + ")");
        return this.doDsmlSearch(name, SINGLELEVEL, SEARCHING, 0L, 0, false, "(objectClass=*)", null);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects is not supported by the DsmlContext");
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException("binding of java objects is not supported by the DsmlContext");
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        log.finest("addToEnvironment (" + propName + ": " + propVal.toString());
        if (propName == null) {
            return null;
        }
        if (propVal == null) {
            return this.environment.remove(propName);
        }
        return this.environment.put(propName, propVal);
    }

    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException("DsmlContext does not support composing names - use DN methods directly");
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException("DsmlContext does not support composing names - use DN methods directly");
    }

    public NamingEnumeration doDsmlSearch(String name, String scope, String derefAliases, long sizeLimit, int timeLimit, boolean typesOnly, String filter, String[] attributesToReturn) throws NamingException {
        StringBuffer searchRequestBuffer = DsmlContext.constructSearchRequest(name, scope, derefAliases, sizeLimit, timeLimit, typesOnly, filter, attributesToReturn);
        String response = this.sendDSMLRequest(searchRequestBuffer);
        return DsmlContext.parseSearchResponse(response, name);
    }

    static NamingEnumeration parseSearchResponse(String response, String searchBase) throws NamingException {
        DsmlContext.checkForError(response);
        DXNamingEnumeration en = new DXNamingEnumeration();
        Matcher responseMatcher = searchResultEntry.matcher(response);
        while (responseMatcher.find()) {
            String dn = responseMatcher.group(1);
            BasicAttributes atts = new BasicAttributes();
            if (dn.indexOf("requestID") > -1) {
                int reqPos = dn.indexOf("requestID");
                int endPos = dn.lastIndexOf(34, reqPos);
                dn = dn.substring(0, endPos);
            }
            if (dn.indexOf("&") > -1) {
                dn = DsmlContext.unescape(dn);
            }
            log.finest("Parsing DSML: read DN: " + dn);
            dn = new CompositeName(dn).toString();
            log.finest("converted DN to: " + dn);
            String attribute = responseMatcher.group(2);
            Matcher attributeMatcher = searchResultAttribute.matcher(attribute);
            while (attributeMatcher.find()) {
                String attributeName = attributeMatcher.group(1);
                BasicAttribute att = new BasicAttribute(attributeName);
                String attributeValues = attributeMatcher.group(2);
                log.finest("Parsing DSML: Attribute Name " + attributeName + " length: " + attributeValues.length());
                Matcher valueMatcher = searchResultAttributeValues.matcher(attributeValues);
                while (valueMatcher.find()) {
                    String typeInfo = valueMatcher.group(1);
                    String type = "string";
                    if (typeInfo != null && typeInfo.length() > 6) {
                        int typeInfoStart = typeInfo.indexOf("type=\"");
                        int typeInfoEnd = typeInfo.indexOf(34, typeInfoStart + 6);
                        if (typeInfoStart != -1 && typeInfoEnd > typeInfoStart && (typeInfoStart = (type = typeInfo.substring(typeInfoStart + 6, typeInfoEnd)).indexOf(58)) > -1) {
                            type = type.substring(typeInfoStart + 1);
                        }
                    }
                    String value = valueMatcher.group(2);
                    if (type.equals("string")) {
                        if (value != null && value.indexOf(38) > -1) {
                            value = DsmlContext.unescape(value);
                        }
                        att.add(value);
                        continue;
                    }
                    if (type.equals("anyURI")) {
                        throw new NamingException("CA JNDI DSML Provider does not support 'anyURI' values");
                    }
                    if (!type.equals("base64Binary")) continue;
                    try {
                        System.out.println("PROCESSING BINARY VALUE " + attributeName);
                        byte[] data = CBBase64.decode(value);
                        System.out.println("RAW DATA: " + value.length() + " byte data " + data.length);
                        att.add(CBBase64.decode(value));
                    }
                    catch (CBBase64EncodingException e) {
                        NamingException ne = new NamingException("unable to parse base64 value in entry: " + dn);
                        ne.setRootCause(e);
                        throw ne;
                    }
                }
                atts.put(att);
            }
            SearchResult currentResult = new SearchResult(dn, (Object)null, atts);
            if (dn.endsWith(searchBase)) {
                currentResult.setRelative(false);
            }
            en.add(currentResult);
        }
        log.finest("Parsing DSML: final enumeration - \n" + en.toString());
        return en;
    }

    private String sendDSMLRequest(StringBuffer searchRequestBuffer) throws NamingException {
        String response;
        try {
            String searchRequest = new String(searchRequestBuffer);
            byte[] rawBytes = searchRequest.getBytes("UTF-8");
            String URL2 = this.environment.get("java.naming.provider.url").toString();
            log.finest("----SENDING XML OVER WIRE-----\nURL: " + URL2 + "\nlength: " + rawBytes.length);
            String usr = null;
            String pwd = null;
            if (this.environment.get("java.naming.security.authentication") == "simple") {
                usr = (String)this.environment.get("java.naming.security.principal");
                pwd = (String)this.environment.get("java.naming.security.credentials");
            }
            response = SoapClient.sendSoapMsg(URL2, rawBytes, "#batchRequest", usr, pwd);
        }
        catch (UnsupportedEncodingException e) {
            NamingException ne = new NamingException("unexpected exception encoding UTF-8 string for DSML message");
            ne.setRootCause(e);
            throw ne;
        }
        catch (IOException e) {
            NamingException ne = new NamingException("error contacting DSML Server");
            ne.setRootCause(e);
            throw ne;
        }
        return response;
    }

    static StringBuffer constructAddRequest(String name, Attributes atts) throws NamingException {
        StringBuffer message = new StringBuffer(200);
        message.append(STANDARDHEADER);
        DsmlContext.getAddRequestElement(message, name, atts);
        message.append(STANDARDFOOTER);
        return message;
    }

    static void getAddRequestElement(StringBuffer message, String name, Attributes atts) throws NamingException {
        message.append(TAB4).append("<dsml:addRequest dn=\"").append(DsmlContext.escapeName(name)).append("\">\n");
        NamingEnumeration<? extends Attribute> attEnum = atts.getAll();
        while (attEnum.hasMore()) {
            Attribute att = attEnum.next();
            String attName = att.getID();
            message.append(TAB5).append("<dsml:attr name=\"").append(attName).append("\">\n");
            NamingEnumeration<?> values = att.getAll();
            while (values.hasMore()) {
                Object value = values.next();
                DsmlContext.createDsmlValueElement(value, message);
            }
            message.append(TAB5).append("</dsml:attr>\n");
        }
        message.append(TAB4).append("</dsml:addRequest>\n");
    }

    static void createDsmlValueElement(Object value, StringBuffer message) throws NamingException {
        if (value instanceof String) {
            String stringVal = DsmlContext.escape((String)value);
            message.append(TAB6).append("<dsml:value>").append(stringVal).append("</dsml:value>\n");
        } else {
            try {
                byte[] data = (byte[])value;
                String base64Data = new String(CBBase64.encode(data), "US-ASCII");
                System.out.println("SENDING BINARY DATA; byte length: " + data.length + " encoded: " + base64Data.length());
                message.append(TAB6).append("<dsml:value xsi:type=\"xsd:base64Binary\">").append(base64Data).append("</dsml:value>\n");
            }
            catch (UnsupportedEncodingException e) {
                NamingException ne = new NamingException("unexpected encoding exception adding attribute value of type " + value.getClass());
                ne.setRootCause(e);
                throw ne;
            }
            catch (ClassCastException e) {
                NamingException ne = new NamingException("unexpected error adding attribute value of type " + value.getClass());
                ne.setRootCause(e);
                throw ne;
            }
        }
    }

    static StringBuffer constructDeleteRequest(String name) {
        StringBuffer message = new StringBuffer(200);
        message.append(STANDARDHEADER);
        DsmlContext.getDeleteRequestElement(message, name);
        message.append(STANDARDFOOTER);
        return message;
    }

    static void getDeleteRequestElement(StringBuffer message, String name) {
        message.append(TAB4 + "<dsml:delRequest dn=\"").append(DsmlContext.escapeName(name)).append("\"/>\n");
    }

    static StringBuffer constructSearchRequest(String name, String scope, String derefAliases, long sizeLimit, int timeLimit, boolean typesOnly, String filter, String[] attributesToReturn) throws NamingException {
        StringBuffer message = new StringBuffer(500);
        message.append(STANDARDHEADER);
        DsmlContext.getSearchRequestHeader(message, name, scope, derefAliases, sizeLimit, timeLimit, typesOnly);
        DsmlContext.getSearchRequestFilter(message, filter, TAB4);
        DsmlContext.getSearchRequestAttributes(message, attributesToReturn);
        message.append(SEARCHFOOTER).append(STANDARDFOOTER);
        return message;
    }

    static String unescape(String value) {
        if (value.indexOf(38) == -1) {
            return value;
        }
        value = escapeGTPattern.matcher(value).replaceAll(">");
        value = escapeLTPattern.matcher(value).replaceAll("<");
        value = escapeQUOTPattern.matcher(value).replaceAll("\"");
        value = escapeAPOSPattern.matcher(value).replaceAll("'");
        value = escapeAMPPattern.matcher(value).replaceAll("&");
        Matcher OCTOMatcher = escapeOCTOPattern.matcher(value);
        while (OCTOMatcher.find()) {
            String escapeChar = OCTOMatcher.group(1);
            int len = escapeChar.length();
            char char1 = '\u0000';
            char char2 = '\u0000';
            if (len >= 5) {
                char1 = escapeChar.charAt(len - 3);
                char2 = escapeChar.charAt(len - 2);
            }
            if (Character.isDigit(char1) && Character.isDigit(char2)) {
                int val = Character.digit(char1, 16) * 16 + Character.digit(char2, 16);
                try {
                    String replacement = new String(new byte[]{new Integer(val).byteValue()}, "US-ASCII");
                    value = OCTOMatcher.replaceFirst(replacement);
                }
                catch (UnsupportedEncodingException e) {
                    log.log(Level.SEVERE, "Unexpected exception trying to decode escaped value " + OCTOMatcher.group(1), e);
                }
            } else {
                log.info("unable to decode escaped value: " + escapeChar);
                break;
            }
            OCTOMatcher = escapeOCTOPattern.matcher(value);
        }
        return value;
    }

    static String escapeName(String value) {
        return DsmlContext.escape(value);
    }

    static String escape(String value) {
        int len = value.length();
        boolean needsEscaping = false;
        for (int i = 0; i < len; ++i) {
            switch (value.charAt(i)) {
                case '>': {
                    needsEscaping = true;
                    break;
                }
                case '<': {
                    needsEscaping = true;
                    break;
                }
                case '&': {
                    needsEscaping = true;
                    break;
                }
                case '\"': {
                    needsEscaping = true;
                    break;
                }
                case '\'': {
                    needsEscaping = true;
                }
            }
            if (!needsEscaping) continue;
            i = len;
        }
        if (!needsEscaping) {
            return value;
        }
        StringBuffer buffy = new StringBuffer(value);
        block15: for (int i = len - 1; i >= 0; --i) {
            switch (value.charAt(i)) {
                case '>': {
                    buffy.replace(i, i + 1, "&gt;");
                    continue block15;
                }
                case '<': {
                    buffy.replace(i, i + 1, "&lt;");
                    continue block15;
                }
                case '&': {
                    buffy.replace(i, i + 1, "&amp;");
                    continue block15;
                }
                case '\"': {
                    buffy.replace(i, i + 1, "&quot;");
                    continue block15;
                }
                case '\'': {
                    buffy.replace(i, i + 1, "&apos;");
                }
            }
        }
        return buffy.toString();
    }

    static String getSearchRequestFilter(StringBuffer message, String filter, String indent) throws NamingException {
        if (filter == null) {
            throw new NamingException("null filter expression in get SearchRequestFilter");
        }
        if ((filter = filter.trim()).length() == 0) {
            throw new NamingException("empty filter expression in get SearchRequestFilter");
        }
        log.finest("translating ldap filter '" + filter + "'");
        StringBuffer padding = new StringBuffer(indent);
        Stack<String> stack = new Stack<String>();
        StringTokenizer filterElements = new StringTokenizer(filter, "()", true);
        message.append(padding).append("<dsml:filter>\n");
        block7: while (filterElements.hasMoreTokens()) {
            String filterToken = filterElements.nextToken();
            try {
                if (filterToken.charAt(0) == '(') {
                    filterToken = filterElements.nextToken();
                    padding.append(TAB);
                    message.append(padding);
                    if (filterToken.length() == 1) {
                        switch (filterToken.charAt(0)) {
                            case '&': {
                                message.append("<dsml:and>\n");
                                stack.push("</dsml:and>\n");
                                continue block7;
                            }
                            case '|': {
                                message.append("<dsml:or>\n");
                                stack.push("</dsml:or>\n");
                                continue block7;
                            }
                            case '!': {
                                message.append("<dsml:not>\n");
                                stack.push("</dsml:not>\n");
                                continue block7;
                            }
                            default: {
                                throw new NamingException("unexpected token '" + filterToken + "' in ldap filter: " + filter);
                            }
                        }
                    }
                    stack.push("");
                    DsmlContext.translateFilterItem(filterToken, padding, message);
                    padding.setLength(padding.length() - TABLEN);
                    continue;
                }
                if (filterToken.charAt(0) == ')') {
                    String closingElement = (String)stack.pop();
                    if (closingElement.length() <= 0) continue;
                    message.append(padding).append(closingElement);
                    padding.setLength(padding.length() - TABLEN);
                    continue;
                }
                throw new NamingException("unexpected token '" + filterToken + "' in search filter: " + filter);
            }
            catch (EmptyStackException e) {
                throw new NamingException("unexpected end of ldap search filter (empty or non matching brackets?): " + filter);
            }
        }
        message.append(padding).append("</dsml:filter>\n");
        return message.toString();
    }

    static void translateFilterItem(String filterToken, StringBuffer padding, StringBuffer dsmlFilter) throws NamingException {
        int equalpos = filterToken.indexOf(61);
        if (equalpos < 1 || equalpos > filterToken.length() - 2) {
            throw new NamingException("Unable to parse ldap filter element '" + filterToken + "'");
        }
        String attribute = filterToken.substring(0, equalpos);
        String expression = filterToken.substring(equalpos + 1);
        char endOfAttribute = attribute.charAt(equalpos - 1);
        if (endOfAttribute == '<' || endOfAttribute == '>' || endOfAttribute == '~') {
            attribute = attribute.substring(0, equalpos - 1);
            String value = new StringBuffer(100).append(" name=\"").append(attribute).append("\">").append(padding).append(TAB).append("<dsml:value>").append(DsmlContext.escape(expression)).append("</dsml:value>").append(padding).toString();
            switch (endOfAttribute) {
                case '<': {
                    dsmlFilter.append("<dsml:lessOrEqual").append(value).append("</dsml:lessOrEqual>\n");
                    break;
                }
                case '>': {
                    dsmlFilter.append("<dsml:greaterOrEqual").append(value).append("</dsml:greaterOrEqual>\n");
                    break;
                }
                case '~': {
                    dsmlFilter.append("<dsml:approxMatch").append(value).append("</dsml:approxMatch>\n");
                }
            }
        } else if (expression.indexOf(42) == -1) {
            dsmlFilter.append("<dsml:equalityMatch name=\"").append(attribute).append("\">").append(padding).append("    ").append("<dsml:value>").append(DsmlContext.escape(expression)).append("</dsml:value>").append(padding).append("</dsml:equalityMatch>\n");
        } else if (expression.equals("*")) {
            dsmlFilter.append("<dsml:present name=\"").append(attribute).append("\"/>\n");
        } else {
            dsmlFilter.append("<dsml:substrings name=\"").append(attribute).append("\">\n");
            padding.append(TAB);
            StringTokenizer substringFilter = new StringTokenizer(expression, "*", true);
            String initial = substringFilter.nextToken();
            if (!initial.equals("*")) {
                dsmlFilter.append(padding).append("<dsml:initial>").append(DsmlContext.escape(initial)).append("</dsml:initial>\n");
            }
            while (substringFilter.hasMoreTokens()) {
                String filterElement = substringFilter.nextToken();
                if (filterElement.equals("*")) continue;
                if (!substringFilter.hasMoreTokens()) {
                    dsmlFilter.append(padding).append("<dsml:final>").append(DsmlContext.escape(filterElement)).append("</dsml:final>\n");
                    continue;
                }
                dsmlFilter.append(padding).append("<dsml:any>").append(DsmlContext.escape(filterElement)).append("</dsml:any>\n");
            }
            padding.setLength(padding.length() - TABLEN);
            dsmlFilter.append(padding).append("</dsml:substrings>\n");
        }
    }

    public ExtendedResponse extendedOperation(ExtendedRequest extendedRequest) throws NamingException {
        return null;
    }

    public LdapContext newInstance(Control[] controls) throws NamingException {
        return null;
    }

    public void reconnect(Control[] controls) throws NamingException {
    }

    public Control[] getConnectControls() throws NamingException {
        return new Control[0];
    }

    public void setRequestControls(Control[] controls) throws NamingException {
    }

    public Control[] getRequestControls() throws NamingException {
        return new Control[0];
    }

    public Control[] getResponseControls() throws NamingException {
        return new Control[0];
    }
}

