/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.viewer.tableviewer;

import com.ca.directory.jxplorer.viewer.tableviewer.AttributeValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class AttributeValueCellRenderer
extends DefaultTableCellRenderer {
    Font normalFont = this.getFont();
    Font boldFont = this.normalFont.deriveFont(1);
    Font boldBlueFont = this.normalFont.deriveFont(1);

    public String truncateLongString(String truncateMe, int len) {
        return truncateMe.substring(0, len) + "...";
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value instanceof AttributeValue) {
            AttributeValue attVal = (AttributeValue)value;
            String attString = attVal.toString();
            if (attString.length() > 256) {
                attString = this.truncateLongString(attString, 256);
            }
            Component c = super.getTableCellRendererComponent(table, attString, isSelected, hasFocus, row, column);
            if (attVal.isNaming()) {
                c.setForeground(isSelected ? Color.white : Color.blue);
                c.setFont(this.boldFont);
                if (!isSelected) {
                    if (row % 2 == 1) {
                        c.setBackground(new Color(249, 249, 249));
                    } else {
                        c.setBackground(Color.white);
                    }
                }
            } else if (!attVal.isEditable()) {
                c.setFont(this.boldFont);
                c.setForeground(new Color(64, 96, 64));
                if (row % 2 == 1) {
                    c.setBackground(new Color(249, 249, 249));
                } else {
                    c.setBackground(Color.white);
                }
            } else {
                c.setForeground(isSelected ? Color.white : Color.black);
                c.setFont(this.normalFont);
                if (!isSelected) {
                    if (row % 2 == 1) {
                        c.setBackground(new Color(249, 249, 249));
                    } else {
                        c.setBackground(Color.white);
                    }
                }
            }
            return c;
        }
        return super.getTableCellRendererComponent(table, new String("error"), isSelected, hasFocus, row, column);
    }
}

