/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.viewer.tableviewer;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.jndi.SchemaOps;
import com.ca.commons.naming.DN;
import com.ca.commons.security.cert.CertViewer;
import com.ca.directory.jxplorer.broker.DataBrokerQueryInterface;
import com.ca.directory.jxplorer.editor.abstractbinaryeditor;
import com.ca.directory.jxplorer.editor.basicbinaryeditor;
import com.ca.directory.jxplorer.editor.booleaneditor;
import com.ca.directory.jxplorer.editor.defaultbinaryeditor;
import com.ca.directory.jxplorer.editor.generalizedtimeeditor;
import com.ca.directory.jxplorer.editor.largestringeditor;
import com.ca.directory.jxplorer.editor.postaladdresseditor;
import com.ca.directory.jxplorer.viewer.tableviewer.AbstractCellEditor;
import com.ca.directory.jxplorer.viewer.tableviewer.AttributeValue;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;

public class AttributeValueCellEditor
extends AbstractCellEditor {
    Frame owner;
    JTextField textField = new JTextField();
    JLabel label = new JLabel("");
    CBJComboBox combobox = new CBJComboBox();
    JComponent editorComponent = this.textField;
    abstractbinaryeditor abstractEditor = null;
    Object value;
    boolean binaryEditFlag = false;
    boolean specialStringEditor = false;
    protected ClassLoader myLoader = null;
    public DataBrokerQueryInterface datasource = null;
    public DN currentDN = null;
    int lastSelectedRow = 0;
    public boolean enabled = true;
    public static final String BINARY_SYNTAX = "1.3.6.1.4.1.1466.115.121.1.5";
    public static final String BOOLEAN_SYNTAX = "1.3.6.1.4.1.1466.115.121.1.7";
    public static final String CERTIFICATE_SYNTAX = "1.3.6.1.4.1.1466.115.121.1.8";
    public static final String GENERALIZED_TIME_SYNTAX = "1.3.6.1.4.1.1466.115.121.1.24";
    public static final String POSTAL_ADDRESS_SYNTAX = "1.3.6.1.4.1.1466.115.121.1.41";
    private static Logger log = Logger.getLogger(AttributeValueCellEditor.class.getName());

    public AttributeValueCellEditor(Frame parent) {
        this.owner = parent;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.binaryEditFlag = false;
        this.specialStringEditor = false;
        table.setRowHeight(this.lastSelectedRow, 16);
        table.setRowHeight(row, 24);
        this.lastSelectedRow = row;
        if (value instanceof AttributeValue) {
            AttributeValue att = (AttributeValue)value;
            if (this.hasSyntax(att, CERTIFICATE_SYNTAX)) {
                this.setCertificateEditor(att);
            } else if (att.isNonStringData()) {
                this.setBinaryEditor(att);
            } else if (this.hasSyntax(att, POSTAL_ADDRESS_SYNTAX)) {
                this.setPostalAddressEditor(att);
            } else if (this.hasSyntax(att, GENERALIZED_TIME_SYNTAX)) {
                this.setGeneralizedTimeEditor(att);
            } else if (this.hasSyntax(att, BOOLEAN_SYNTAX)) {
                this.setBooleanEditor(att);
            } else if (att.hasOptions()) {
                this.setOptions(att);
            } else {
                this.setString(att);
            }
            this.setCellEditorValue(att);
        }
        return this.editorComponent;
    }

    public boolean hasSyntax(AttributeValue att, String syntax) {
        String attSyntax = this.getAttributeSyntax(att);
        return attSyntax != null && attSyntax.indexOf(syntax) > -1;
    }

    private void setCertificateEditor(AttributeValue att) {
        CertViewer.CertAndFileName returnVal = CertViewer.editCertificate(this.owner, att.getValue());
        X509Certificate cert = returnVal.cert;
        if (cert != null) {
            try {
                byte[] newData = cert.getEncoded();
                if (!Arrays.equals(newData, att.getValue())) {
                    att.setValue(newData);
                }
            }
            catch (Exception e) {
                CBUtility.error(CBIntText.get("Error: unable to modify certificate."), e);
            }
        }
        this.binaryEditFlag = true;
        if (att.isEmpty()) {
            this.label.setText(" ");
        } else {
            this.label.setText(CBIntText.get("(non string data)"));
        }
        this.editorComponent = this.label;
    }

    private void setString(AttributeValue att) {
        String textValue = att.toString();
        if (textValue.length() > 100) {
            this.setLargeStringEditor(att);
        } else {
            textValue = textValue.trim();
            this.textField.setText(textValue);
            this.editorComponent = this.textField;
        }
    }

    private void setLargeStringEditor(AttributeValue att) {
        largestringeditor lse = new largestringeditor(this.owner, att);
        this.specialStringEditor = true;
        CBUtility.center(lse, this.owner);
        lse.setVisible(true);
        this.label.setText(att.getStringValue().substring(0, 100));
        this.editorComponent = this.label;
    }

    private void setOptions(AttributeValue att) {
        this.combobox.removeAllItems();
        String[] ops = att.getOptions();
        for (int i = 0; i < ops.length; ++i) {
            this.combobox.addItem(ops[i]);
        }
        this.editorComponent = this.combobox;
    }

    private void setBinaryEditor(AttributeValue att) {
        this.startBinaryEditor(att);
        this.binaryEditFlag = true;
        if (att.isEmpty()) {
            this.label.setText(" ");
        } else {
            this.label.setText(CBIntText.get("(non string data)"));
        }
        this.editorComponent = this.label;
    }

    private void setGeneralizedTimeEditor(AttributeValue att) {
        generalizedtimeeditor timeEditor = null;
        timeEditor = att == null ? new generalizedtimeeditor(this.owner, "", true) : new generalizedtimeeditor(this.owner, att.toString(), true);
        this.specialStringEditor = true;
        CBUtility.center(timeEditor, this.owner);
        timeEditor.setStringValue(att);
        timeEditor.setVisible(true);
        if (att.isEmpty()) {
            this.label.setText(" ");
        } else {
            this.label.setText(att.getStringValue());
        }
        this.editorComponent = this.label;
    }

    private void setPostalAddressEditor(AttributeValue att) {
        postaladdresseditor postalEditor = new postaladdresseditor(this.owner, att);
        this.specialStringEditor = true;
        CBUtility.center(postalEditor, this.owner);
        postalEditor.setStringValue(att);
        postalEditor.setVisible(true);
        if (att.isEmpty()) {
            this.label.setText(" ");
        } else {
            this.label.setText(att.getStringValue());
        }
        this.editorComponent = this.label;
    }

    private void setBooleanEditor(AttributeValue att) {
        booleaneditor booleanEditor = new booleaneditor(this.owner, att);
        this.specialStringEditor = true;
        CBUtility.center(booleanEditor, this.owner);
        booleanEditor.setStringValue(att);
        booleanEditor.setVisible(true);
        if (att.isEmpty()) {
            this.label.setText(" ");
        } else {
            this.label.setText(att.getStringValue());
        }
        this.editorComponent = this.label;
    }

    public String getAttributeSyntax(AttributeValue att) {
        String attID = att.getID();
        return this.getAttributeSyntaxFromName(attID);
    }

    private String getAttributeSyntaxFromName(String attID) {
        if (attID.indexOf(59) > 0) {
            attID = attID.substring(0, attID.indexOf(59));
        }
        try {
            if (this.datasource == null) {
                throw new NamingException("No datasource!");
            }
            SchemaOps schema = this.datasource.getSchemaOps();
            if (schema == null) {
                throw new NamingException("No schema!");
            }
            Attributes attSchema = schema.getAttributes("AttributeDefinition/" + attID);
            if (attSchema == null) {
                throw new NamingException("No schema for AttributeDefinition/" + attID);
            }
            Attribute attSyntax = attSchema.get("SYNTAX");
            if (attSyntax == null) {
                Attribute supSchema = attSchema.get("SUP");
                if (supSchema == null) {
                    throw new NamingException("Error processing attribute definition for " + attID + " no schema and no sup entry found");
                }
                if (supSchema.get().toString().equals(attID)) {
                    throw new NamingException("recursive schema definition: " + attID + " sup of itself");
                }
                return this.getAttributeSyntaxFromName(supSchema.get().toString());
            }
            String syntax = attSyntax.toString();
            if (syntax.startsWith("SYNTAX: ")) {
                syntax = syntax.substring(8);
            }
            return syntax;
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "Problem processing attribute definition: ", e);
            return "1.3.6.1.4.1.1466.115.121.1.15";
        }
    }

    public boolean stopCellEditing() {
        if (this.binaryEditFlag) {
            return super.stopCellEditing();
        }
        if (this.specialStringEditor) {
            return super.stopCellEditing();
        }
        Object o = this.getCellEditorValue();
        if (o == null) {
            return true;
        }
        if (o instanceof AttributeValue) {
            AttributeValue v = (AttributeValue)o;
            if (this.editorComponent instanceof JTextField) {
                String userData = ((JTextField)this.editorComponent).getText();
                int len = userData.length();
                if (len > 0) {
                    userData.trim();
                    if (userData.length() == 0) {
                        userData = " ";
                    }
                    if (userData.length() != len) {
                        ((JTextField)this.editorComponent).setText(userData);
                    }
                }
                v.update(userData);
            } else if (this.editorComponent instanceof CBJComboBox) {
                v.update(((CBJComboBox)this.editorComponent).getSelectedItem());
            } else {
                log.warning("unknown editorComponent = " + this.editorComponent.getClass());
            }
        } else {
            log.warning("(AttValCellEdit) Not an Att Val: is " + o.getClass());
        }
        this.setCellEditorValue(o);
        return super.stopCellEditing();
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
    }

    public boolean isCellEditable(EventObject e) {
        if (!this.enabled) {
            return false;
        }
        boolean editable = true;
        if (e instanceof MouseEvent) {
            editable = ((MouseEvent)e).getClickCount() >= this.clickCountToStart;
        }
        return editable;
    }

    public void startBinaryEditor(AttributeValue att) {
        if (this.abstractEditor != null && this.abstractEditor instanceof Component && ((Component)((Object)this.abstractEditor)).isVisible()) {
            return;
        }
        if (!att.isNonStringData()) {
            log.warning("Error: non binary value passed to binary editor!");
            return;
        }
        String attName = att.getID();
        int trim = attName.indexOf(";binary");
        if (trim > 0) {
            attName = attName.substring(0, trim);
        }
        String className = "com.ca.directory.jxplorer.editor." + attName + "editor";
        try {
            Class<?> c = null;
            c = this.myLoader == null ? Class.forName(className) : this.myLoader.loadClass(className.toLowerCase());
            if (abstractbinaryeditor.class.isAssignableFrom(c)) {
                if (this.owner instanceof Frame) {
                    Constructor<?> constructor = c.getConstructor(Frame.class);
                    this.abstractEditor = (abstractbinaryeditor)constructor.newInstance(this.owner);
                } else {
                    Constructor<?> constructor = c.getConstructor(new Class[0]);
                    this.abstractEditor = (abstractbinaryeditor)constructor.newInstance(new Object[0]);
                }
                this.abstractEditor.setValue(att);
                if (this.abstractEditor instanceof basicbinaryeditor) {
                    ((basicbinaryeditor)this.abstractEditor).setDN(this.currentDN);
                } else if (this.abstractEditor instanceof defaultbinaryeditor) {
                    ((defaultbinaryeditor)this.abstractEditor).setDN(this.currentDN);
                }
                if (this.abstractEditor instanceof defaultbinaryeditor) {
                    ((defaultbinaryeditor)this.abstractEditor).showDialog();
                    this.abstractEditor = null;
                } else if (this.abstractEditor instanceof Component) {
                    ((Component)((Object)this.abstractEditor)).setVisible(true);
                }
                this.fireEditingStopped();
                return;
            }
            log.warning("error: can't load editor class " + className + " since it is not inherited from AbstractBinaryEditor\n");
        }
        catch (NoSuchMethodException e) {
            log.log(Level.WARNING, "coding error in editor " + className + " - using default binary editor instead.", e);
        }
        catch (ClassNotFoundException e) {
            log.info("(expected) can not find editor " + className + "\n" + e.toString());
            try {
                defaultbinaryeditor dbe = new defaultbinaryeditor(this.owner);
                dbe.setDN(this.currentDN);
                CBUtility.center(dbe, this.owner);
                dbe.setValue(att);
                dbe.showDialog();
            }
            catch (Exception e2) {
                log.log(Level.WARNING, "unable to start backup editor", e2);
                e2.printStackTrace();
            }
        }
        catch (Exception e3) {
            log.log(Level.WARNING, "error loading editor " + className, e3);
            e3.printStackTrace();
        }
    }

    public void registerClassLoader(ClassLoader loader) {
        this.myLoader = loader;
    }

    public void setDataSource(DataBrokerQueryInterface ds) {
        this.datasource = ds;
    }

    public void setDN(DN dn) {
        this.currentDN = dn;
    }

    public void cleanupEditor() {
        this.abstractEditor = null;
    }
}

