/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.viewer;

import com.ca.commons.cbutil.CBBase64;
import com.ca.commons.cbutil.CBCache;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBLauncher;
import com.ca.commons.cbutil.CBParse;
import com.ca.commons.cbutil.CBResourceLoader;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.Theme;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.directory.jxplorer.DataSink;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.broker.DataBrokerQueryInterface;
import com.ca.directory.jxplorer.tree.SmartTree;
import com.ca.directory.jxplorer.viewer.MyHTMLEditorKit;
import com.ca.directory.jxplorer.viewer.PluggableEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HTMLTemplateDisplay
extends JPanel
implements DataSink,
PluggableEditor {
    JScrollPane scrollDisplay;
    DataBrokerQueryInterface currentDataSource = null;
    JEditorPane editor;
    JViewport viewport;
    JTextArea bloop;
    String baseText;
    StringBuffer htmlText;
    Component display;
    public static final String DEFAULTTEXT = "<html><head><title>Default Template</title></head><body> <dxtemplate:get-all-attributes> <br> </body></html>";
    public static final String ATTRIBTAG = "<dxtemplate:";
    public static String NOVALUEFOUND;
    public static final String JPEGEXTENSION = ".jpg";
    public static final String DOCEXTENSION = ".doc";
    public static final String XLSEXTENSION = ".xls";
    public static final String WAVEXTENSION = ".wav";
    public static final String AVIEXTENSION = ".avi";
    public static final String MIDEXTENSION = ".mid";
    public static final String startFile = "start";
    public static final int MAX_LEGAL_VALUE_LENGTH = 500;
    public static final String ILLEGAL_VALUE = "[ATTRIBUTE TOO LARGE TO DISPLAY]";
    public static final String DEFAULT = "defaulttemplate";
    JToolBar toolBar;
    CBJComboBox viewTemplates;
    Hashtable viewTemplatesPos = new Hashtable();
    Hashtable templates = new Hashtable(100);
    String oldObjectClassesSignature = "";
    File baseTemplateDir;
    File pluginTemplateDirectory = null;
    DXEntry currentEntry = null;
    static String currentTemplateName;
    public static String NODATA;
    public boolean showHTMLErrors = true;
    protected MyHyperlinkListener hyperlinkListener;
    protected MyHTMLEditorKit htmlEditorKit;
    protected boolean settingUpTemplates = false;
    Vector currentBinaryAttributes = new Vector(0);
    CBResourceLoader resourceLoader = null;
    protected String currentDN;
    SmartTree smartTree = null;
    private static Logger log;

    public HTMLTemplateDisplay(Component owner, CBResourceLoader resourceLoader) {
        this.commonConstructorCode(owner, resourceLoader);
        this.setToDefault();
    }

    protected void setToDefault() {
        this.htmlText = new StringBuffer(DEFAULTTEXT);
        this.baseText = new String(DEFAULTTEXT);
    }

    public void setEditorText(String htmlText) {
        Dimension current = null;
        if (this.editor != null) {
            try {
                this.editor.setText(htmlText);
            }
            catch (Exception e) {
                this.recreateEditor(current, htmlText);
            }
        } else {
            this.recreateEditor(current, htmlText);
        }
        this.editor.validate();
        try {
            this.viewport.setView(this.editor);
        }
        catch (Exception e) {
            this.viewport = new JViewport();
            this.viewport.setView(this.editor);
            this.scrollDisplay.setViewport(this.viewport);
        }
    }

    private void recreateEditor(Dimension current, String htmlText) {
        this.editor = this.getNewEditor();
        if (current == null) {
            current = new Dimension(400, 400);
        }
        this.editor.setSize(current);
        this.editor.setText(htmlText);
    }

    protected JEditorPane getNewEditor() {
        JEditorPane newEditor = new JEditorPane();
        newEditor.setEditorKitForContentType("text/html", this.htmlEditorKit);
        newEditor.addHyperlinkListener(this.hyperlinkListener);
        newEditor.setEditable(false);
        newEditor.setMinimumSize(new Dimension(400, 400));
        newEditor.setContentType("text/html");
        return newEditor;
    }

    private void commonConstructorCode(Component owner, CBResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.setupTemplateLists();
        this.initGUI(owner);
        this.setStartPage();
    }

    private void setupTemplateLists() {
        try {
            this.initZipTemplates();
            this.baseTemplateDir = this.getBaseTemplateDirectory();
            String baseTemplate = this.baseTemplateDir.getCanonicalPath();
            String[] defaultTemplates = CBUtility.readFilteredDirectory(baseTemplate, new String[]{"html", "htm"});
            this.addToGlobalTemplateList(defaultTemplates, DEFAULT);
            if (this.pluginTemplateDirectory != null) {
                defaultTemplates = CBUtility.readFilteredDirectory(this.pluginTemplateDirectory.getCanonicalPath(), new String[]{"html", "htm"});
                this.addToGlobalTemplateList(defaultTemplates, "");
            }
            if (defaultTemplates == null || defaultTemplates.length == 0) {
                log.warning("Warning - can't find any default html templates in " + baseTemplate);
            }
            String[] objectClassFolders = this.getAllTemplateSubDirectories(this.baseTemplateDir);
            this.addIndividualObjectClassTemplates(objectClassFolders, baseTemplate);
            if (this.pluginTemplateDirectory != null) {
                objectClassFolders = this.getAllTemplateSubDirectories(this.pluginTemplateDirectory);
                this.addIndividualObjectClassTemplates(objectClassFolders, this.pluginTemplateDirectory.toString());
            }
        }
        catch (FileNotFoundException e) {
            log.warning("Error initialising HTML Template: " + e.toString());
        }
        catch (IOException e2) {
            log.warning("Error initialising HTML Template file paths: " + e2.toString());
        }
    }

    private void addIndividualObjectClassTemplates(String[] objectClassFolders, String baseTemplate) {
        for (int i = 0; i < objectClassFolders.length; ++i) {
            String folderName = baseTemplate + File.separator + objectClassFolders[i];
            String objectClass = objectClassFolders[i];
            String[] ocTemplates = CBUtility.readFilteredDirectory(folderName, new String[]{"html", "htm"});
            this.addToGlobalTemplateList(ocTemplates, objectClass);
        }
    }

    private void addToGlobalTemplateList(String[] fileNames, String folderName) {
        if (fileNames == null) {
            return;
        }
        String objectClass = folderName.toLowerCase();
        File[] fileList = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            fileList[i] = DEFAULT.equals(folderName) ? new File(fileNames[i]) : new File(folderName, fileNames[i]);
        }
        this.templates.put(objectClass, fileList);
    }

    private String[] getAllTemplateSubDirectories(File baseTemplateDir) {
        String[] childDirectories = baseTemplateDir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File candidate = new File(dir, name);
                return candidate.isDirectory();
            }
        });
        return childDirectories;
    }

    private File getBaseTemplateDirectory() throws FileNotFoundException {
        File baseTemplateDir = new File(Theme.getInstance().getDirTemplates());
        if (!baseTemplateDir.exists()) {
            log.warning("can't find html template directory " + baseTemplateDir + " - trying to find /templates directory");
            baseTemplateDir = new File(JXConfig.localDir + "templates" + File.separator);
            if (!baseTemplateDir.exists()) {
                throw new FileNotFoundException("ERROR - Cannot find backup /template directory in " + baseTemplateDir);
            }
        }
        return baseTemplateDir;
    }

    private void initZipTemplates() {
        String[] zipTemplates = null;
        File pluginDirectory = new File(JXConfig.getProperty("dir.plugins"));
        if (!pluginDirectory.exists()) {
            pluginDirectory.mkdirs();
        }
        if ((zipTemplates = this.resourceLoader.getPrefixedResources("templates/")).length == 0) {
            return;
        }
        this.pluginTemplateDirectory = new File(pluginDirectory, "templates/");
        int prefixSize = "templates/".length();
        for (int i = 0; i < zipTemplates.length; ++i) {
            String templateName = zipTemplates[i];
            if (templateName.length() <= prefixSize) continue;
            String templateRelativeFileName = CBParse.replaceAllChar(new StringBuffer(templateName), '/', File.separator);
            File pluginTemplateFile = new File(pluginDirectory + File.separator + templateRelativeFileName);
            try {
                if (pluginTemplateFile.exists() && pluginTemplateFile.lastModified() >= this.resourceLoader.getLastModified(templateName)) continue;
                if (templateRelativeFileName.endsWith(File.separator)) {
                    pluginTemplateFile.mkdirs();
                    continue;
                }
                if (!pluginTemplateFile.getParentFile().exists()) {
                    pluginTemplateFile.getParentFile().mkdirs();
                }
                byte[] b = this.resourceLoader.getResource(templateName);
                try {
                    FileOutputStream output = new FileOutputStream(pluginTemplateFile);
                    output.write(b);
                    output.close();
                }
                catch (IOException e) {
                    CBUtility.error("Problem writing unpacked plugin template file: " + pluginTemplateFile + " to disk \n  ", e);
                }
                continue;
            }
            catch (ZipException e) {
                CBUtility.error("Problem accessing plugin zip file: " + e);
            }
        }
    }

    private void setStartPage() {
        if (this.editor == null) {
            this.editor = this.getNewEditor();
        }
        String htmldocs = Theme.getInstance().getDirHtmlDocs();
        try {
            String locale = Locale.getDefault().toString();
            File localeSpecificStartFile = new File(htmldocs + startFile + "_" + locale + ".html");
            if (!localeSpecificStartFile.exists() && !(localeSpecificStartFile = new File(htmldocs + startFile + ".html")).exists()) {
                log.info("unable to find locale specific start file: " + localeSpecificStartFile);
                this.editor.setText("<html><head><title>JXplorer Start Screen</title></head><body><h2><font face=\"arial\">Welcome to JXplorer...</font></h2><p><font face=\"arial\">This panel will display the results of your directory browsing and searches.</font></p><p><font face=\"arial\">If you need any assistance, use the help option on the menu bar above.</font></p></body></html>");
                this.validate();
                return;
            }
            this.openPage(localeSpecificStartFile.toURL());
            this.validate();
        }
        catch (IOException e) {
            log.warning("unable to open welcome page.  " + e);
        }
    }

    private void initGUI(Component owner) {
        this.setLayout(new BorderLayout());
        NODATA = "<html><head><title>" + CBIntText.get("No Data") + "</title></head><body><h2><font face=\"arial\">" + CBIntText.get("Select an entry to view data") + "</font></h2></body></html>";
        NOVALUEFOUND = "<i>" + CBIntText.get("No Value Found") + "</i>";
        this.viewport = new JViewport();
        this.scrollDisplay = new JScrollPane();
        this.initToolBar();
        this.add((Component)this.toolBar, "North");
        this.add(this.scrollDisplay);
        this.htmlEditorKit = new MyHTMLEditorKit(this);
        this.hyperlinkListener = new MyHyperlinkListener();
        this.editor = this.getNewEditor();
        this.viewport.setView(this.editor);
        this.scrollDisplay.setViewport(this.viewport);
        this.display = owner;
    }

    protected boolean templateExists(String candidate) {
        for (int i = 0; i < this.viewTemplates.getItemCount(); ++i) {
            String name = (String)this.viewTemplates.getItemAt(i);
            if (!name.equalsIgnoreCase(candidate)) continue;
            return true;
        }
        return false;
    }

    public void initToolBar() {
        this.toolBar = new JToolBar();
        String[] errorMessage = new String[]{CBIntText.get("no templates found")};
        Object[] templates = this.readTemplateNames(new String[0]);
        if (templates == null || templates.length == 0) {
            templates = errorMessage;
        }
        this.viewTemplates = new CBJComboBox(templates);
        this.viewTemplates.setEditable(false);
        this.viewTemplates.setAlignmentY(0.0f);
        this.viewTemplates.setToolTipText(CBIntText.get("Select a template to view attributes with"));
        this.toolBar.add(this.viewTemplates);
        this.viewTemplates.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (HTMLTemplateDisplay.this.settingUpTemplates) {
                    return;
                }
                if (e == null || e.getSource() == null) {
                    return;
                }
                if (HTMLTemplateDisplay.this.viewTemplates.getSelectedItem() == null) {
                    return;
                }
                String templateName = HTMLTemplateDisplay.this.viewTemplates.getSelectedItem().toString();
                if (templateName.equalsIgnoreCase(currentTemplateName)) {
                    return;
                }
                HTMLTemplateDisplay.this.setNewTemplate(templateName);
                HTMLTemplateDisplay.this.repaint();
            }
        });
    }

    public void setNewTemplate(String templateName) {
        String current = (String)this.viewTemplates.getSelectedItem();
        if (!templateName.equalsIgnoreCase(current)) {
            this.viewTemplates.setSelectedItem(templateName);
        }
        currentTemplateName = templateName;
        this.openNewTemplate(templateName);
        this.displayEntry(this.currentEntry, this.currentDataSource);
    }

    private void addFileListToTemplateNames(ArrayList templateNames, File[] fileList) {
        if (fileList == null) {
            return;
        }
        for (int i = 0; i < fileList.length; ++i) {
            templateNames.add(fileList[i].toString());
        }
    }

    public String[] readTemplateNames(String[] objectClassNames) {
        ArrayList templateNames = new ArrayList();
        this.addFileListToTemplateNames(templateNames, (File[])this.templates.get(DEFAULT));
        for (int classNo = 0; classNo < objectClassNames.length; ++classNo) {
            String className = objectClassNames[classNo].toLowerCase();
            this.addFileListToTemplateNames(templateNames, (File[])this.templates.get(className));
        }
        Object[] templates = templateNames.toArray(new String[templateNames.size()]);
        Arrays.sort(templates);
        return templates;
    }

    public boolean openNewTemplate(String templateName) {
        File templateFile = new File(this.baseTemplateDir, templateName);
        if (!templateFile.exists() && !(templateFile = new File(this.pluginTemplateDirectory, templateName)).exists()) {
            return CBUtility.error(this.display, CBIntText.get("Can't find html template!") + " " + templateName);
        }
        try {
            this.htmlText = new StringBuffer(CBUtility.readTextFile(templateFile));
            this.htmlText = this.parseNewTemplate(this.htmlText, templateFile.toURI().toURL());
            this.baseText = this.htmlText.toString();
        }
        catch (IOException e) {
            return CBUtility.error(this.display, CBIntText.get("Can't read html template!") + " " + templateFile.getAbsolutePath());
        }
        return true;
    }

    public StringBuffer parseNewTemplate(StringBuffer templateText, URL url) {
        String baseTagURL = url.getPath();
        baseTagURL = "file://" + baseTagURL.substring(0, baseTagURL.lastIndexOf(47) + 1);
        int headPos = templateText.toString().indexOf("<head>");
        String baseTag = "\n<base href=\"" + baseTagURL + "\">\n";
        templateText.insert(headPos + 7, baseTag);
        return templateText;
    }

    public File getTemplateFile(String fileNameAndPath) {
        String fileName = fileNameAndPath + ".html";
        File templateFile = new File(fileName);
        if (!templateFile.exists()) {
            templateFile = new File(fileNameAndPath + ".htm");
        }
        return templateFile;
    }

    public String[] getObjectClasses(DXAttributes atts) {
        try {
            DXAttribute a = atts.getAllObjectClasses();
            if (a == null) {
                return new String[0];
            }
            DXNamingEnumeration en = new DXNamingEnumeration(a.getAll());
            en.sort();
            String[] ret = en.toStringArray();
            return ret;
        }
        catch (NamingException e) {
            log.warning("unable to read object classes in AttributeDisplay: " + e.toString());
            return null;
        }
    }

    public String getObjectClassSignature(String[] objectClasses) {
        String ret = "";
        if (objectClasses == null) {
            return "";
        }
        for (int i = 0; i < objectClasses.length; ++i) {
            ret = ret + objectClasses[i];
        }
        return ret;
    }

    public boolean objectClassesChanged(String classesSignature) {
        return this.oldObjectClassesSignature == null || !this.oldObjectClassesSignature.equals(classesSignature);
    }

    public void displayEntry(DXEntry entry, DataBrokerQueryInterface formDataSource) {
        if (entry == null || entry.size() == 0) {
            this.setEditorText(NODATA);
            return;
        }
        this.currentDataSource = formDataSource;
        this.currentEntry = entry;
        String[] objectClasses = this.getObjectClasses(entry);
        if (objectClasses == null) {
            log.warning("unable to find any object classes for " + entry.getDN().toString());
            this.setEditorText(NODATA);
            return;
        }
        this.setupTemplates(objectClasses, entry);
        if (entry == null) {
            CBUtility.error(this, CBIntText.get("Error: No data for this node!"), null);
            this.setEditorText(NODATA);
            return;
        }
        this.displayData(entry);
    }

    void setupTemplates(String[] objectClasses, DXEntry entry) {
        String objectClassesSignature = this.getObjectClassSignature(objectClasses);
        if (this.objectClassesChanged(objectClassesSignature)) {
            this.viewTemplatesPos.put(this.oldObjectClassesSignature, new Integer(this.viewTemplates.getSelectedIndex()));
            this.oldObjectClassesSignature = objectClassesSignature;
            this.settingUpTemplates = true;
            this.viewTemplates.removeAllItems();
            String[] templates = this.readTemplateNames(objectClasses);
            if (templates == null || templates.length == 0) {
                log.warning("No templates found for objectClasses " + objectClassesSignature);
            } else {
                for (int i = 0; i < templates.length; ++i) {
                    this.viewTemplates.addItem(templates[i]);
                }
                if (this.viewTemplatesPos.containsKey(objectClassesSignature)) {
                    int indexPos = (Integer)this.viewTemplatesPos.get(objectClassesSignature);
                    if (indexPos < templates.length) {
                        this.viewTemplates.setSelectedIndex(indexPos);
                    }
                } else {
                    this.viewTemplates.setSelectedIndex(0);
                    this.attemptToSetOCSpecificTemplate(entry, templates);
                }
                String templateName = this.viewTemplates.getSelectedItem().toString();
                this.openNewTemplate(templateName);
            }
            this.settingUpTemplates = false;
        }
    }

    protected void attemptToSetOCSpecificTemplate(DXAttributes entry, String[] templates) {
        ArrayList<String> ocs = entry.getOrderedOCs();
        for (int i = 0; i < ocs.size(); ++i) {
            String oc = ocs.get(i).toLowerCase();
            for (int j = 0; j < templates.length; ++j) {
                String template = templates[j].toLowerCase();
                if (!template.startsWith(oc)) continue;
                this.settingUpTemplates = true;
                this.viewTemplates.setSelectedIndex(j);
                this.settingUpTemplates = false;
                return;
            }
        }
    }

    protected void displayData(DXEntry entry) {
        if (entry == null) {
            this.setEditorText(NODATA);
            return;
        }
        int tagstart = 0;
        this.htmlText = new StringBuffer(this.baseText);
        this.htmlText = HTMLTemplateDisplay.parseXHTML(this.htmlText);
        this.mediaCheck(entry, "jpegPhoto");
        this.mediaCheck(entry, "audio");
        this.mediaCheck(entry, "odDocumentDOC");
        this.mediaCheck(entry, "odSpreadSheetXLS");
        this.mediaCheck(entry, "odMusicMID");
        this.mediaCheck(entry, "odSoundWAV");
        this.mediaCheck(entry, "odMovieAVI");
        tagstart = this.htmlText.indexOf(ATTRIBTAG, tagstart);
        while (tagstart >= 0) {
            int tagend = this.htmlText.indexOf(">", tagstart);
            String tempTag = this.htmlText.substring(tagstart, tagend);
            try {
                if (tempTag.indexOf("name='") > -1) {
                    tempTag = tempTag.replaceAll("'", "\"");
                }
                String attName = "";
                attName = tempTag.indexOf("get-all-attributes") > 0 ? "all" : tempTag.substring(tempTag.indexOf("name=\"") + 6, tempTag.indexOf("\"", tempTag.indexOf("name=\"") + 6));
                String modifier = null;
                if (tempTag.indexOf("style=\"") > 0) {
                    modifier = tempTag.substring(tempTag.indexOf("style=\"") + 7, tempTag.indexOf("\"", tempTag.indexOf("style=\"") + 7));
                }
                this.htmlText.delete(tagstart, tagend + 1);
                if (attName.equalsIgnoreCase("all")) {
                    this.htmlText.insert(tagstart, this.formattedAllAttributes(this.currentEntry, modifier));
                } else {
                    this.htmlText.insert(tagstart, this.formattedAttribute(attName, this.currentEntry, modifier));
                }
                tagstart = this.htmlText.indexOf(ATTRIBTAG, tagstart);
            }
            catch (Exception e) {
                this.htmlText.delete(tagstart, tagend + 1);
                String errorMsg = "error parsing {" + tempTag + "}";
                this.htmlText.insert(tagstart, errorMsg);
                tagstart = this.htmlText.indexOf(ATTRIBTAG, tagstart + errorMsg.length());
            }
        }
        if (this.htmlText == null || this.htmlText.length() == 0) {
            log.warning("HTMLTemplateDisplay:displayNodeData - bad html String " + (this.htmlText == null ? " (is null!)" : ""));
            this.setEditorText(NODATA);
            return;
        }
        String htmlString = this.htmlText.toString().trim();
        htmlString = this.insertFormData(htmlString, entry);
        try {
            this.setEditorText(htmlString);
        }
        catch (EmptyStackException e) {
            log.warning("Another Bug in Sun HTML Component: " + e);
        }
        this.scrollDisplay.getVerticalScrollBar().setValue(0);
        this.viewport.setViewPosition(new Point(0, 0));
    }

    protected void mediaCheck(DXEntry entry, String type) {
        DXAttribute attribute = null;
        attribute = entry.get(type);
        if (attribute == null) {
            return;
        }
        this.currentDN = entry.getDN().toString();
        this.currentDN = Integer.toString(this.currentDN.hashCode());
        int size = attribute.size();
        if (attribute != null) {
            CBCache.createCache(entry.getDN().toString(), entry, type, size);
        }
    }

    public static StringBuffer parseXHTML(StringBuffer html) {
        return CBParse.replaceAllBufferString(html, "/>", ">");
    }

    protected String insertFormData(String htmlString, DXEntry entry) {
        block4: {
            if (htmlString.indexOf("<form") < 0) {
                if (this.currentBinaryAttributes.size() > 0) {
                    this.currentBinaryAttributes.clear();
                }
                return htmlString;
            }
            try {
                htmlString = this.insertFormInputData(htmlString, entry);
                htmlString = this.insertFormSelectData(htmlString, entry);
                htmlString = this.insertFormTextAreaData(htmlString, entry);
                htmlString = this.insertFormImageData(htmlString, entry);
                htmlString = this.insertFormAudioData(htmlString, entry);
            }
            catch (Exception e) {
                if (!this.showHTMLErrors) break block4;
                log.warning("Error parsing form html for value insertion in HTMLTemplateDisplay. \n  " + e);
                e.printStackTrace();
            }
        }
        return htmlString;
    }

    protected String getTagValue(String tagName, String tag) {
        tag = tag.toLowerCase();
        tagName = tagName.toLowerCase();
        try {
            int start = tag.indexOf(tagName) + tagName.length();
            start = tag.indexOf("\"", start) + 1;
            if (start < 0) {
                return null;
            }
            int end = tag.indexOf("\"", start);
            if (end < 0) {
                return null;
            }
            String val = tag.substring(start, end);
            return val.trim();
        }
        catch (Exception e) {
            if (this.showHTMLErrors) {
                log.warning("error parsing: " + tagName + "\n  " + e);
            }
            return null;
        }
    }

    protected String insertFormInputData(String htmlString, DXEntry entry) {
        int pos = 0;
        StringBuffer multiValuedTag = new StringBuffer(0);
        while ((pos = htmlString.indexOf("<input", pos)) >= 0) {
            int i;
            int tagStart = pos;
            int tagEnd = htmlString.indexOf(">", pos);
            String tag = htmlString.substring(tagStart, tagEnd + 1);
            String type = this.getTagValue("type", tag);
            String name = this.getTagValue("name", tag);
            DXAttribute attribute = null;
            attribute = entry.get(name);
            int size = 0;
            if (attribute != null) {
                size = attribute.size();
            }
            if ("text".equalsIgnoreCase(type) && name != null && attribute != null) {
                if (size == 1) {
                    tag = this.insertFormValue(tag, entry, name);
                } else if (size > 1) {
                    for (i = 0; i < size; ++i) {
                        multiValuedTag.append(new String(this.insertFormValue(tag, entry, name, i) + "<br>"));
                    }
                    tag = multiValuedTag.toString();
                    multiValuedTag.setLength(0);
                }
            } else if ("hidden".equalsIgnoreCase(type) && name != null) {
                tag = this.insertFormValue(tag, entry, name);
            } else if ("password".equalsIgnoreCase(type) && name != null && attribute != null) {
                if (attribute.size() == 1) {
                    tag = this.insertFormValue(tag, entry, name);
                } else if (attribute.size() > 1) {
                    for (i = 0; i < size; ++i) {
                        multiValuedTag.append(new String(this.insertFormValue(tag, entry, name, i) + "<br>"));
                    }
                    tag = multiValuedTag.toString();
                    multiValuedTag.setLength(0);
                }
            }
            pos = tagStart + tag.length();
            htmlString = htmlString.substring(0, tagStart) + tag + htmlString.substring(tagEnd + 1);
        }
        return htmlString;
    }

    protected String insertFormSelectData(String htmlString, DXEntry entry) {
        int pos = 0;
        while ((pos = htmlString.indexOf("<select", pos)) >= 0) {
            int tagEnd;
            block6: {
                int tagStart = pos;
                tagEnd = htmlString.indexOf("</select>", pos) + "</select>".length();
                String tag = htmlString.substring(tagStart, tagEnd);
                String name = this.getTagValue("name", tag);
                if (name != null) {
                    try {
                        DXAttribute a = entry.get(name);
                        if (a == null || a.get() == null) {
                            return htmlString;
                        }
                        String entryValue = ((String)a.get()).toLowerCase();
                        String lowerCaseTag = tag.toLowerCase();
                        String selectedRemovedTag = lowerCaseTag.replaceAll("[ \\t]*\\bselected\\b[ \\t]*", "");
                        String resultTag = selectedRemovedTag.replaceAll("value[ \\t]*=[ \\t]*([\"']*)\\b" + entryValue + "\\b\\1[ \\t]*", "value=\"" + entryValue + "\" selected");
                        if (selectedRemovedTag.length() != resultTag.length()) {
                            htmlString = htmlString.substring(0, tagStart) + resultTag + htmlString.substring(tagEnd);
                            tagEnd = tagEnd - tag.length() + resultTag.length();
                        }
                    }
                    catch (Exception e) {
                        if (!this.showHTMLErrors) break block6;
                        e.printStackTrace();
                        log.warning("Error getting value for " + name + " value :\n " + e);
                    }
                }
            }
            pos = tagEnd;
        }
        return htmlString;
    }

    protected String insertFormTextAreaData(String htmlString, DXEntry entry) {
        int pos = 0;
        while ((pos = htmlString.indexOf("<textarea", pos)) >= 0) {
            String betweenTagText;
            int nextTag;
            int tagStart = pos;
            int tagEnd = htmlString.indexOf(">", pos);
            String tag = htmlString.substring(tagStart, tagEnd);
            String name = this.getTagValue("name", tag);
            DXAttribute attribute = null;
            attribute = entry.get(name);
            int size = 0;
            if (attribute != null) {
                size = attribute.size();
            }
            if ((nextTag = htmlString.indexOf("</textarea>", tagEnd)) > 0 && (betweenTagText = htmlString.substring(tagEnd + 1, nextTag)).trim().length() == 0) {
                String text;
                if (size == 1) {
                    text = this.getAttValue(name, entry);
                    if (text != null && attribute != null) {
                        if (name.toLowerCase().indexOf("address") > 0) {
                            text = text.replace('$', '\n');
                        }
                        htmlString = htmlString.substring(0, tagEnd + 1) + text + htmlString.substring(nextTag);
                    }
                } else if (size > 1) {
                    String textAreaStartTag = htmlString.substring(tagStart, tagEnd + 1);
                    String textAreaEndTag = htmlString.substring(tagEnd + 1, htmlString.indexOf(">", tagEnd + 1) + 1);
                    StringBuffer multiValuedTag = new StringBuffer();
                    for (int i = 0; i < size; ++i) {
                        text = this.getAttValue(name, entry, i);
                        text = text.replace('$', '\n');
                        multiValuedTag.append(new String(textAreaStartTag + text + textAreaEndTag + "<br>"));
                    }
                    String multiTag = multiValuedTag.toString();
                    htmlString = htmlString.substring(0, tagStart) + multiTag + htmlString.substring(nextTag);
                }
            }
            pos = tagEnd;
        }
        return htmlString;
    }

    protected String insertFormImageData(String htmlString, DXEntry entry) {
        int pos = 0;
        DXAttribute attribute = null;
        attribute = entry.get("jpegPhoto");
        while ((pos = htmlString.indexOf("Image N/A", pos)) >= 0) {
            int tagStart = pos;
            int tagEnd = htmlString.indexOf("<", pos);
            String tag = htmlString.substring(tagStart, tagEnd);
            if ("Image N/A".equalsIgnoreCase(tag) && tag != null && attribute != null && attribute.size() != 0) {
                int tagPos = htmlString.indexOf(tag);
                String htmlCopyStart = htmlString.substring(0, tagPos);
                String htmlCopyEnd = htmlString.substring(htmlString.indexOf("<", tagPos));
                File fileDir = CBCache.getCacheDirectory();
                File[] imageFiles = fileDir.listFiles(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(HTMLTemplateDisplay.JPEGEXTENSION);
                    }
                });
                StringBuffer imageTags = new StringBuffer();
                for (File imageFile : imageFiles) {
                    String imageTag = "<img src=\"" + imageFile.toURI() + "\" border=\"1\"><br>";
                    imageTags.append(imageTag);
                }
                htmlString = htmlCopyStart + imageTags.toString() + htmlCopyEnd;
            }
            pos = tagEnd;
        }
        return htmlString;
    }

    protected String insertFormAudioData(String htmlString, DXEntry entry) {
        int pos = 0;
        DXAttribute attribute = null;
        attribute = entry.get("audio");
        while ((pos = htmlString.indexOf("Audio N/A", pos)) >= 0) {
            int tagStart = pos;
            int tagEnd = htmlString.indexOf("<", pos);
            String tag = htmlString.substring(tagStart, tagEnd);
            if ("Audio N/A".equalsIgnoreCase(tag) && tag != null && attribute != null && attribute.size() != 0) {
                int tagPos = htmlString.indexOf(tag);
                String htmlCopyStart = htmlString.substring(0, tagPos);
                String htmlCopyEnd = htmlString.substring(htmlString.indexOf("<", tagPos));
                File fileDir = CBCache.getAudioCacheDirectory();
                String[] allFiles = fileDir.list();
                String[] currentFiles = new String[allFiles.length];
                StringBuffer audioTags = new StringBuffer();
                int x = 0;
                for (int i = 0; i < allFiles.length; ++i) {
                    if (!allFiles[i].startsWith(this.currentDN) || allFiles[i].endsWith(JPEGEXTENSION)) continue;
                    currentFiles[x] = allFiles[i].toString();
                    String audiotag = "<a href=\"" + CBCache.getAudioDirPath() + currentFiles[x] + "\">Sound File</a><br>";
                    audioTags.append(audiotag);
                    ++x;
                }
                htmlString = htmlCopyStart + audioTags.toString() + htmlCopyEnd;
            }
            pos = tagEnd;
        }
        return htmlString;
    }

    protected String insertFormValue(String tag, DXEntry entry, String name) {
        String newTag = this.insertFormValue(tag, entry, name, 0);
        return newTag;
    }

    protected String insertFormValue(String tag, DXEntry entry, String name, int position) {
        String val = this.getTagValue(" value", tag);
        if (val == null) {
            return tag;
        }
        if (val.trim().length() > 0) {
            return tag;
        }
        int pos = tag.indexOf(" value");
        pos = tag.indexOf("\"", pos) + 1;
        int end = tag.indexOf("\"", pos);
        String entryValue = this.getAttValue(name, entry, position);
        if (entryValue != null) {
            tag = tag.substring(0, pos) + entryValue + tag.substring(end);
        }
        return tag;
    }

    protected String getAttValue(String name, DXEntry entry) {
        String newTag = this.getAttValue(name, entry, 0);
        return this.checkLength(newTag);
    }

    private String checkLength(String checkString) {
        return checkString.length() > 500 ? ILLEGAL_VALUE : checkString;
    }

    protected String getAttValue(String name, DXEntry entry, int position) {
        if (name == null) {
            return "No name given in HTMLTemplateDisplay.getAttValue()";
        }
        try {
            DXAttribute a = entry.get(name);
            if (a == null) {
                return null;
            }
            int numberValues = a.size();
            if (numberValues == 0 || a.get() == null) {
                return null;
            }
            if (numberValues <= position) {
                return null;
            }
            Object attValue = a.get(position);
            if (numberValues > 1) {
                boolean namingMagic = false;
                String namingValue = null;
                String[] namingTypes = entry.getRDN().getAttIDs();
                if (namingTypes != null) {
                    for (int i = 0; i < namingTypes.length; ++i) {
                        if (!namingTypes[i].equalsIgnoreCase(name)) continue;
                        namingMagic = true;
                        namingValue = entry.getRDN().getRawVals()[i];
                    }
                }
                if (namingMagic) {
                    if (position == 0) {
                        return this.checkLength(namingValue);
                    }
                    if (attValue.equals(namingValue)) {
                        return this.checkLength((String)a.get(0));
                    }
                }
            }
            if (attValue instanceof String) {
                return this.checkLength((String)attValue);
            }
            if (attValue instanceof byte[]) {
                this.currentBinaryAttributes.add(name);
                if (a.getID().equalsIgnoreCase("userpassword")) {
                    return this.getPasswordText(attValue);
                }
                return CBBase64.binaryToString((byte[])attValue);
            }
            return "Unable to get Att Value for " + name + "!";
        }
        catch (NamingException e) {
            if (this.showHTMLErrors) {
                log.warning("Form Value Error getting value for " + name + " value :\n " + e);
            }
            return "";
        }
    }

    String getPasswordText(Object val) {
        if (val == null) {
            return "";
        }
        if (!(val instanceof byte[])) {
            if (val instanceof String) {
                return (String)val;
            }
            return "error parsing pwd";
        }
        byte[] data = (byte[])val;
        try {
            if (data == null || data.length == 0) {
                return "";
            }
            if (CBParse.isUTF8(data)) {
                return new String(data, "UTF-8");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return CBBase64.binaryToString(data);
    }

    public String formattedAttribute(String attType, Attributes attributes, String modifier) {
        Attribute theAttribute = attributes.get(attType);
        if (theAttribute == null) {
            log.warning("can't find attribute: '" + attType + "'");
            return "";
        }
        return this.formattedAttribute(theAttribute, modifier);
    }

    public String formattedAttribute(Attribute theAttribute, String modifier) {
        try {
            NamingEnumeration<?> values;
            if (theAttribute == null) {
                return NOVALUEFOUND;
            }
            String syntaxOID = "";
            if (theAttribute instanceof DXAttribute) {
                syntaxOID = ((DXAttribute)theAttribute).getSyntaxOID();
            }
            if (theAttribute.size() == 1) {
                Object o = theAttribute.get();
                if (o == null) {
                    return NOVALUEFOUND;
                }
                if (o instanceof String) {
                    if ("1.3.6.1.4.1.1466.115.121.1.12".equals(syntaxOID)) {
                        return "<a href=\"dn:" + o.toString() + "\">" + o.toString() + "</a>";
                    }
                    if ("1.3.6.1.4.1.1466.115.121.1.26".equalsIgnoreCase(syntaxOID)) {
                        return "<a href=\"mailto:" + o.toString() + "\">" + o.toString() + "</a>";
                    }
                    if (((String)o).toLowerCase().startsWith("http://")) {
                        return "<a href=\"" + o + "\">" + o + "</a>";
                    }
                    return CBParse.toHTML(this.syntaxParse(o.toString(), syntaxOID));
                }
            }
            if ((values = theAttribute.getAll()) == null) {
                return NOVALUEFOUND;
            }
            return this.formattedListAttribute(values, modifier, syntaxOID, theAttribute.getID());
        }
        catch (NamingException e) {
            return "<i>" + CBIntText.get("Error: exception reading value") + "</i>";
        }
    }

    public String syntaxParse(String s, String syntaxOID) {
        if (!"".equals(syntaxOID) && "1.3.6.1.4.1.1466.115.121.1.41".equals(syntaxOID)) {
            s = s.replace('$', '\n');
        }
        return s;
    }

    public String formattedListAttribute(NamingEnumeration attlist, String modifier, String syntaxOID, String syntaxID) {
        String listStart = "";
        String listEnd = "";
        String itemStart = "";
        String itemEnd = "";
        if (modifier == null || modifier.equalsIgnoreCase("list")) {
            listStart = "<ul>\n";
            listEnd = "</ul>\n";
            itemStart = "<li>";
            itemEnd = "</li>";
        } else if (modifier.equalsIgnoreCase("table")) {
            listStart = "<table>\n";
            listEnd = "</table>\n";
            itemStart = "<tr><td valign=top>";
            itemEnd = "</td></tr>";
        } else if (modifier.equalsIgnoreCase("options")) {
            listStart = "";
            listEnd = "";
            itemStart = "<option";
            itemEnd = "</option>";
        } else if (modifier.equalsIgnoreCase("plain")) {
            itemEnd = "\n";
        }
        return this.formattedListWithModifiers(attlist, listStart, listEnd, itemStart, itemEnd, syntaxOID, syntaxID);
    }

    private String formattedListWithModifiers(NamingEnumeration attlist, String listStart, String listEnd, String itemStart, String itemEnd, String syntaxOID, String syntaxID) {
        if (attlist == null) {
            return NOVALUEFOUND;
        }
        if (syntaxOID != null) {
            if (syntaxOID.equalsIgnoreCase("1.3.6.1.4.1.1466.115.121.1.28")) {
                return new String(this.getMediaTags(listStart, listEnd, itemStart, itemEnd, "jpegPhoto"));
            }
            if (syntaxOID.equalsIgnoreCase("1.3.6.1.4.1.1466.115.121.1.4")) {
                return new String(this.getMediaTags(listStart, listEnd, itemStart, itemEnd, "audio"));
            }
        }
        if (syntaxID.equalsIgnoreCase("odDocumentDOC")) {
            return new String(this.getMediaTags(listStart, listEnd, itemStart, itemEnd, "odDocumentDOC"));
        }
        if (syntaxID.equalsIgnoreCase("odSpreadSheetXLS")) {
            return new String(this.getMediaTags(listStart, listEnd, itemStart, itemEnd, "odSpreadSheetXLS"));
        }
        if (syntaxID.equalsIgnoreCase("odMusicMID")) {
            return new String(this.getMediaTags(listStart, listEnd, itemStart, itemEnd, "odMusicMID"));
        }
        if (syntaxID.equalsIgnoreCase("odMovieAVI")) {
            return new String(this.getMediaTags(listStart, listEnd, itemStart, itemEnd, "odMovieAVI"));
        }
        if (syntaxID.equalsIgnoreCase("odSoundWAV")) {
            return new String(this.getMediaTags(listStart, listEnd, itemStart, itemEnd, "odSoundWAV"));
        }
        StringBuffer formattedList = new StringBuffer();
        while (attlist.hasMoreElements()) {
            Object temp = attlist.nextElement();
            String value = "";
            if (temp != null) {
                value = temp instanceof String ? temp.toString() : (syntaxID.equals("userPassword") ? this.getPasswordText(temp) : "(Binary Value)");
            }
            if (value.length() > 2 && (value.charAt(0) == '\u0000' || value.charAt(1) == '\u0000')) {
                value = "(Binary Data in String)";
            }
            if (syntaxOID != null && syntaxOID.equalsIgnoreCase("1.3.6.1.4.1.1466.115.121.1.12")) {
                formattedList.append(itemStart + "<a href=\"dn:" + value + "\">" + value + "</a>" + itemEnd);
                continue;
            }
            if (syntaxOID != null && syntaxOID.equalsIgnoreCase("1.3.6.1.4.1.1466.115.121.1.26")) {
                formattedList.append(itemStart + "<a href=\"mailto:" + value + "\">" + value + "</a>" + itemEnd);
                continue;
            }
            if (value.toLowerCase().startsWith("http://")) {
                formattedList.append(itemStart + "<a href=\"" + value + "\">" + value + "</a>" + itemEnd);
                continue;
            }
            String val = CBParse.toHTML(this.syntaxParse(value, syntaxOID));
            if (itemStart.equals("<option")) {
                formattedList.append(itemStart + " value=\"" + val + "\">" + val + itemEnd);
                continue;
            }
            formattedList.append(itemStart + val + itemEnd);
        }
        return new String(listStart + formattedList.toString() + listEnd);
    }

    public String getMediaTags(String listStart, String listEnd, String itemStart, String itemEnd, String type) {
        String[] allFiles;
        StringBuffer htmlStringBuffer = new StringBuffer();
        File fileDir = type.equalsIgnoreCase("audio") ? CBCache.getAudioCacheDirectory() : CBCache.getCacheDirectory();
        for (String file : allFiles = fileDir.list()) {
            String fileName = file.toString();
            if (!file.startsWith(this.currentDN)) continue;
            if (type.equalsIgnoreCase("audio") && !file.endsWith(JPEGEXTENSION)) {
                htmlStringBuffer.append(new String(listStart + itemStart + "<a href=\"" + CBCache.getAudioDirPath() + fileName + "\" + >audio</a>" + itemEnd + listEnd));
                continue;
            }
            if (type.equalsIgnoreCase("odMusicMID") && file.startsWith(this.currentDN) && file.endsWith(MIDEXTENSION)) {
                htmlStringBuffer.append(new String(listStart + itemStart + "<a href=\"" + CBCache.getDirPath() + fileName + "\" + >audio</a>" + itemEnd + listEnd));
                continue;
            }
            if (type.equalsIgnoreCase("odSoundWAV") && file.startsWith(this.currentDN) && file.endsWith(WAVEXTENSION)) {
                htmlStringBuffer.append(new String(listStart + itemStart + "<a href=\"" + CBCache.getDirPath() + fileName + "\" + >audio</a>" + itemEnd + listEnd));
                continue;
            }
            if (type.equalsIgnoreCase("jpegPhoto") && file.startsWith(this.currentDN) && file.endsWith(JPEGEXTENSION)) {
                htmlStringBuffer.append(new String(listStart + itemStart + "<img src=\"" + CBCache.getDirPath() + fileName + "\" " + "border=\"1\">" + itemEnd + listEnd));
                continue;
            }
            if (type.equalsIgnoreCase("odDocumentDOC") && file.startsWith(this.currentDN) && file.endsWith(DOCEXTENSION)) {
                htmlStringBuffer.append(new String(listStart + itemStart + "<a href=\"" + CBCache.getDirPath() + fileName + "\" + >document</a>" + itemEnd + listEnd));
                continue;
            }
            if (type.equalsIgnoreCase("odSpreadSheetXLS") && file.startsWith(this.currentDN) && file.endsWith(XLSEXTENSION)) {
                htmlStringBuffer.append(new String(listStart + itemStart + "<a href=\"" + CBCache.getDirPath() + fileName + "\" + >spreadsheet</a>" + itemEnd + listEnd));
                continue;
            }
            if (!type.equalsIgnoreCase("odMovieAVI") || !file.startsWith(this.currentDN) || !file.endsWith(AVIEXTENSION)) continue;
            htmlStringBuffer.append(new String(listStart + itemStart + "<a href=\"" + CBCache.getDirPath() + fileName + "\" + >movie</a>" + itemEnd + listEnd));
        }
        return htmlStringBuffer.toString();
    }

    public String formattedAllAttributes(DXEntry attributes, String modifier) {
        if (modifier == null) {
            modifier = "list";
        }
        NamingEnumeration attributeList = attributes.getAllNonNull();
        StringBuffer list = new StringBuffer("");
        if (modifier.equalsIgnoreCase("list")) {
            list.append("<table>");
        }
        try {
            while (attributeList.hasMore()) {
                String syntaxOID;
                Attribute theAttribute = (Attribute)attributeList.next();
                String string = syntaxOID = theAttribute instanceof DXAttribute ? ((DXAttribute)theAttribute).getSyntaxOID() : "";
                if (modifier.equalsIgnoreCase("list")) {
                    list.append("<tr>" + theAttribute.getID() + "</td><td valign=top>");
                    list.append(this.formattedListAttribute(theAttribute.getAll(), modifier, syntaxOID, theAttribute.getID()) + "</tr>\n");
                    continue;
                }
                if (modifier.equalsIgnoreCase("table")) {
                    list.append(this.formattedListAttribute(theAttribute.getAll(), modifier, syntaxOID, theAttribute.getID()));
                    continue;
                }
                list.append(theAttribute.getID() + ":\n" + this.formattedAttribute(theAttribute, "plain") + "\n\n");
            }
            if (modifier.equalsIgnoreCase("list")) {
                list.append("</table>");
            }
        }
        catch (NamingException e) {
            log.warning("naming exception in formattedAllAttributes() " + e);
        }
        return list.toString();
    }

    public boolean openDocumentURL(String docURL) {
        if (docURL.startsWith("http:")) {
            return this.openPage(docURL);
        }
        File document = new File(Theme.getInstance().getDirHtmlDocs() + docURL);
        try {
            return this.openPage(document.toURL());
        }
        catch (MalformedURLException e) {
            log.warning("Bad URL '" + document.toString() + "'\n" + e);
            return false;
        }
    }

    public void launchClient(String desc) {
        try {
            File file = new File("temp.bat");
            file.deleteOnExit();
            FileWriter output = new FileWriter(file);
            output.write("start " + desc);
            output.close();
            Runtime r = Runtime.getRuntime();
            r.exec("temp.bat");
        }
        catch (Exception e) {
            CBUtility.error("Error launching default mail client " + e);
        }
    }

    public boolean openPage(String urlString) {
        if (urlString == null) {
            return false;
        }
        if (urlString.toLowerCase().startsWith("dn:")) {
            DN linkDN;
            String dn = urlString.substring(3);
            if (dn.startsWith("/")) {
                dn = dn.substring(1);
            }
            if (dn.startsWith("/")) {
                dn = dn.substring(1);
            }
            if ((linkDN = new DN(dn)).size() > 0) {
                this.currentDataSource.getEntry(linkDN);
            }
            return true;
        }
        try {
            URL url = new URL(urlString);
            return this.openPage(url);
        }
        catch (MalformedURLException e) {
            log.warning("Bad URL '" + urlString + "'\n" + e);
            return false;
        }
    }

    public boolean openPage(URL url) {
        if (url == null) {
            return false;
        }
        URL original = this.editor.getPage();
        try {
            this.setEditor(url);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, CBIntText.get("Can't follow link") + " " + url.toString(), CBIntText.get("Invalid URL"), 0);
            log.warning("unable to follow url " + url.toString() + "\n" + e);
            try {
                if (original != null) {
                    this.editor.setPage(original);
                } else {
                    this.setToDefault();
                }
            }
            catch (Exception e3) {
                log.warning("fnord:  " + e3);
                this.setToDefault();
            }
            return false;
        }
        catch (Exception e2) {
            log.warning("Wierd Java exception thrown on setPage in AttributeDisplay\n" + e2);
            try {
                if (original != null) {
                    this.editor.setPage(original);
                } else {
                    this.setToDefault();
                }
            }
            catch (Exception e3) {
                this.setToDefault();
            }
            return false;
        }
    }

    protected void setEditor(URL url) throws IOException {
        if (this.editor == null) {
            this.editor = this.getNewEditor();
        }
        this.editor.setPage(url);
        this.validate();
    }

    public JComponent getDisplayComponent() {
        return this;
    }

    public String toString() {
        return this.htmlText == null ? "" : this.htmlText.toString();
    }

    public String getName() {
        return CBIntText.get("HTML View");
    }

    public ImageIcon getIcon() {
        return new ImageIcon(Theme.getInstance().getDirImages() + "html.gif");
    }

    public String getToolTip() {
        return CBIntText.get("The HTML View is used to view and edit the data in purpose constructed HTML templates.");
    }

    public Component getPrintComponent() {
        return this.editor;
    }

    public boolean isUnique() {
        return false;
    }

    public DataSink getDataSink() {
        return this;
    }

    public boolean canCreateEntry() {
        return false;
    }

    public void registerComponents(JMenuBar menu, JToolBar buttons, JTree tree, JPopupMenu treeMenu, JFrame jx) {
        this.smartTree = (SmartTree)tree;
    }

    public void unload() {
    }

    public ImageIcon getTreeIcon(String rdn) {
        return null;
    }

    public JPopupMenu getPopupMenu(String rdn) {
        return null;
    }

    public boolean hideSubEntries(String rdn) {
        return false;
    }

    public void checkForUnsavedChanges() {
    }

    static {
        currentTemplateName = "";
        log = Logger.getLogger(HTMLTemplateDisplay.class.getName());
    }

    class MyHyperlinkListener
    implements HyperlinkListener {
        MyHyperlinkListener() {
        }

        public void hyperlinkUpdate(final HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        String desc = e.getDescription();
                        if (desc.toLowerCase().startsWith("dn:")) {
                            String dn = desc.substring(desc.indexOf(":") + 1);
                            if (HTMLTemplateDisplay.this.smartTree != null) {
                                HTMLTemplateDisplay.this.smartTree.readAndExpandDN(new DN(dn));
                            }
                        } else if (desc.startsWith(CBCache.getAudioDirPath())) {
                            if (CBUtility.isWindows()) {
                                String extension = desc.substring(desc.lastIndexOf("."));
                                if (extension.equalsIgnoreCase(".xxx")) {
                                    CBUtility.error(CBIntText.get("Unable to play unknown audio file type"));
                                } else {
                                    System.out.println("LAUNCHING: " + desc);
                                    CBLauncher.launchProgram(extension, desc);
                                }
                            } else {
                                CBUtility.error(CBIntText.get("content only opens under windows"));
                            }
                        } else if (desc.startsWith(CBCache.getDirPath())) {
                            if (CBUtility.isWindows()) {
                                String extension = desc.substring(desc.lastIndexOf("."));
                                CBLauncher.launchProgram(extension, desc);
                            } else {
                                CBUtility.error(CBIntText.get("content only opens under windows"));
                            }
                        } else if (!System.getProperty("os.name").equalsIgnoreCase("SunOS") && desc.toLowerCase().startsWith("mailto")) {
                            HTMLTemplateDisplay.this.launchClient(desc);
                        } else {
                            URL url = e.getURL();
                            if (url.getProtocol().equals("file")) {
                                String fullFileName = "";
                                String baseTemplateDirPath = "";
                                String pluginTemplateDirectoryPath = "";
                                try {
                                    fullFileName = new File(URLDecoder.decode(url.getFile(), "UTF-8")).getCanonicalPath();
                                    baseTemplateDirPath = HTMLTemplateDisplay.this.baseTemplateDir.getCanonicalPath();
                                    if (HTMLTemplateDisplay.this.pluginTemplateDirectory != null) {
                                        pluginTemplateDirectoryPath = HTMLTemplateDisplay.this.pluginTemplateDirectory.getCanonicalPath();
                                    }
                                }
                                catch (IOException e2) {
                                    log.log(Level.WARNING, "Exception trying to access HTML file urls " + url.getFile().toString(), e2);
                                }
                                String fileName = "";
                                if (fullFileName.startsWith(baseTemplateDirPath)) {
                                    fileName = fullFileName.substring(baseTemplateDirPath.length());
                                } else if (HTMLTemplateDisplay.this.pluginTemplateDirectory != null && fullFileName.startsWith(pluginTemplateDirectoryPath)) {
                                    fileName = fullFileName.substring(pluginTemplateDirectoryPath.length());
                                }
                                if (fileName.startsWith(File.separator)) {
                                    fileName = fileName.substring(1);
                                }
                                if (HTMLTemplateDisplay.this.templateExists(fileName = new File(fileName).toString())) {
                                    HTMLTemplateDisplay.this.setNewTemplate(fileName);
                                } else {
                                    HTMLTemplateDisplay.this.openPage(url);
                                }
                            } else if (Desktop.isDesktopSupported()) {
                                try {
                                    Desktop.getDesktop().browse(e.getURL().toURI());
                                }
                                catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                                catch (URISyntaxException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                    }
                });
            }
        }
    }
}

