/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.tree;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.tree.SmartNode;
import com.ca.directory.jxplorer.tree.SmartTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.naming.NamingException;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

public class SmartTreeCellEditor
extends DefaultTreeCellEditor {
    Panel display = new Panel();
    TextField standard;
    boolean useIcons = true;
    Object value = null;

    public SmartTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
        super(tree, renderer);
        this.display.setBackground(Color.green);
        this.standard = new TextField("bloop");
        this.display.add(this.standard);
    }

    protected boolean shouldStartEditingTimer(EventObject event) {
        if (((SmartTree)this.tree).popupToolVisible()) {
            return false;
        }
        return super.shouldStartEditingTimer(event);
    }

    protected TreeCellEditor createTreeCellEditor() {
        MyTreeCellEditor editor = new MyTreeCellEditor();
        editor.setClickCountToStart(1);
        return editor;
    }

    public void actionPerformed(ActionEvent e) {
        if (((SmartTree)this.tree).dragging) {
            return;
        }
        super.actionPerformed(e);
    }

    protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (value != null) {
            this.editingIcon = ((SmartNode)value).getIcon();
            this.offset = this.editingIcon != null ? 4 + this.editingIcon.getIconWidth() : 4;
        } else {
            this.editingIcon = null;
            this.offset = 0;
        }
    }

    public Object getCellEditorValue() {
        try {
            SmartNode node = (SmartNode)this.value;
            if (node.isMultiValued()) {
                return this.value.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject event) {
        if (this.tree == null) {
            return false;
        }
        if (!((SmartTree)this.tree).isModifiable()) {
            return false;
        }
        TreePath path = this.tree.getSelectionPath();
        if (path == null) {
            return false;
        }
        SmartNode node = (SmartNode)path.getLastPathComponent();
        if (node == null) {
            return false;
        }
        if (node != null && node.isDummy() || node.isStructural() || node.isRoot()) {
            return false;
        }
        return super.isCellEditable(event);
    }

    public class MyTreeCellEditor
    extends DefaultCellEditor {
        CellEditorGUI cellDisplay;

        public MyTreeCellEditor() {
            super(new JCheckBox());
            this.cellDisplay = new CellEditorGUI();
            this.editorComponent = this.cellDisplay;
            this.clickCountToStart = 2;
            this.delegate = new DefaultCellEditor.EditorDelegate(){

                public void setValue(Object value) {
                    MyTreeCellEditor.this.cellDisplay.setValue((SmartNode)value);
                }

                public Object getCellEditorValue() {
                    return MyTreeCellEditor.this.cellDisplay.getValue();
                }
            };
            this.cellDisplay.addActionListener(this.delegate);
        }

        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            this.cellDisplay.setBackground(tree.getBackground());
            this.delegate.setValue(value);
            return this.editorComponent;
        }
    }

    class CellEditorGUI
    extends CBPanel {
        ActionListener listener;
        boolean multi = false;
        JTextField first;
        Border thinBorder;
        SmartNode node;
        RDN displayRDN;

        CellEditorGUI() {
            this.makeHeavy();
            this.thinBorder = UIManager.getBorder("Tree.editorBorder");
            this.first = new JTextField();
            this.first.setBorder(this.thinBorder);
            this.first.setText("bloop!");
            this.add(this.first);
        }

        void setValue(SmartNode node) {
            this.node = node;
            RDN rdn = node.getRDN();
            int size = rdn.size();
            this.multi = node.isMultiValued();
            this.trimExcessComponents();
            Dimension prefSize = SmartTreeCellEditor.this.renderer.getPreferredSize();
            this.setSize(prefSize);
            this.first.setText(rdn.getRawVal(0));
            for (int i = 1; i < size; ++i) {
                this.makeLight();
                JLabel plus = new JLabel("+");
                plus.setForeground(Color.red);
                this.add(plus);
                this.makeHeavy();
                JTextField nextField = new JTextField(rdn.getRawVal(i));
                nextField.setBorder(this.thinBorder);
                nextField.addActionListener(this.listener);
                this.add(nextField);
            }
        }

        protected void trimExcessComponents() {
            for (int i = this.getComponentCount() - 1; i > 0; --i) {
                this.remove(i);
            }
        }

        RDN getValue() {
            RDN returnRDN = this.node.getRDN();
            try {
                int size = this.getComponentCount();
                for (int i = 0; i < size; i += 2) {
                    JTextField currentTextField = (JTextField)this.getComponent(i);
                    String text = currentTextField.getText();
                    if ((text = text.trim()).length() == 0) {
                        text = " ";
                    }
                    returnRDN.setRawVal(text, i / 2);
                }
                return returnRDN;
            }
            catch (NamingException e) {
                CBUtility.error(CBIntText.get("Invalid Name"), null);
                return returnRDN;
            }
        }

        void addActionListener(ActionListener l) {
            this.listener = l;
            this.first.addActionListener(l);
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            if (SmartTreeCellEditor.this.renderer != null) {
                Dimension rSize = SmartTreeCellEditor.this.renderer.getPreferredSize();
                size.height = rSize.height;
            }
            if (this.multi) {
                size.width += 30;
            }
            return size;
        }
    }
}

