/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.tree;

import com.ca.commons.cbutil.CBErrorWin;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBResourceLoader;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.BookMarks;
import com.ca.directory.jxplorer.DataListener;
import com.ca.directory.jxplorer.DataSink;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.broker.DataBroker;
import com.ca.directory.jxplorer.broker.DataBrokerQueryInterface;
import com.ca.directory.jxplorer.broker.DataQuery;
import com.ca.directory.jxplorer.broker.OfflineDataBroker;
import com.ca.directory.jxplorer.event.JXplorerEvent;
import com.ca.directory.jxplorer.event.JXplorerEventGenerator;
import com.ca.directory.jxplorer.search.SearchGUI;
import com.ca.directory.jxplorer.tree.NewEntryWin;
import com.ca.directory.jxplorer.tree.SmartModel;
import com.ca.directory.jxplorer.tree.SmartNode;
import com.ca.directory.jxplorer.tree.SmartPopupTool;
import com.ca.directory.jxplorer.tree.SmartTreeCellEditor;
import com.ca.directory.jxplorer.tree.SmartTreeCellRenderer;
import com.ca.directory.jxplorer.viewer.AttributeDisplay;
import com.ca.directory.jxplorer.viewer.PluggableEditor;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartTree
extends JTree
implements TreeSelectionListener,
DataListener,
TreeExpansionListener,
JXplorerEventGenerator,
DragGestureListener,
DropTargetListener,
DragSourceListener {
    boolean setup = false;
    public static DN NODATA_DN = new DN(CBIntText.get("cn=no entries"));
    JXplorerEventGenerator eventPublisher;
    JXplorerBrowser browser;
    SmartNode rootNode;
    SmartNode rootDNBaseNode;
    DN rootDN;
    SmartModel treeModel;
    DN currentDN;
    SmartPopupTool popupTreeTool;
    DefaultTreeCellEditor treeCellEditor;
    SmartTreeCellRenderer treeCellRenderer;
    DataBroker treeDataSource;
    ArrayList<DataSink> treeDataSinks = new ArrayList();
    public DXEntry entry;
    String name;
    AttributeDisplay pluggableEditorSource = null;
    private SearchGUI searchGUI = null;
    static int treeNo = 0;
    public boolean dragging = false;
    private DragSource dragSource = null;
    private Point cursorLocation = null;
    public int numOfResults = 0;
    private static Logger log = Logger.getLogger(SmartTree.class.getName());

    public SmartTree(JXplorerBrowser Owner, String name, CBResourceLoader resourceLoader) {
        ++treeNo;
        this.browser = Owner;
        this.name = name;
        this.setRootDN(NODATA_DN);
        this.setup = true;
        SmartNode.initIcons(resourceLoader);
        this.treeCellRenderer = new SmartTreeCellRenderer();
        this.setCellRenderer(this.treeCellRenderer);
        this.treeCellEditor = new SmartTreeCellEditor(this, this.treeCellRenderer);
        this.setCellEditor(this.treeCellEditor);
        this.treeModel = new SmartModel(this.rootNode);
        this.setModel(this.treeModel);
        if (this.browser != null) {
            this.registerPopupTool(new SmartPopupTool(this, this.browser));
        }
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeSelectionListener(this);
        this.addTreeExpansionListener(this);
        this.setTreeMouseListener();
        this.setTreeCellEditorListener();
        this.setEditable(true);
        this.setupDragAndDrop();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    protected SmartNode getSelectedNode() {
        if (this.getSelectionPath() == null) {
            return null;
        }
        return (SmartNode)this.getSelectionPath().getLastPathComponent();
    }

    public void registerPopupTool(SmartPopupTool tool) {
        this.popupTreeTool = tool;
    }

    public ArrayList<DN> getAllNodes(DN start) {
        if (start == null) {
            return new ArrayList<DN>(0);
        }
        SmartNode apex = this.treeModel.getNodeForDN(start);
        if (apex == null) {
            return new ArrayList<DN>(0);
        }
        try {
            ArrayList<DN> result = new ArrayList<DN>(10);
            result.add(start);
            Enumeration<TreeNode> children = apex.children();
            while (children.hasMoreElements()) {
                DN next = new DN(start);
                SmartNode child = (SmartNode)children.nextElement();
                next.addChildRDN(child.getRDN());
                result.addAll(this.getAllNodes(next));
            }
            return result;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "error in SmartTree dump: ", e);
            return new ArrayList<DN>(0);
        }
    }

    public ArrayList<DN> getAllSearchResultNodes(DN start) {
        if (start == null) {
            return new ArrayList<DN>(0);
        }
        SmartNode startNode = this.treeModel.getNodeForDN(start);
        if (startNode == null) {
            return new ArrayList<DN>(0);
        }
        try {
            ArrayList<DN> result = new ArrayList<DN>(10);
            if (!startNode.isStructural()) {
                result.add(start);
            }
            Enumeration<TreeNode> children = startNode.children();
            while (children.hasMoreElements()) {
                DN next = new DN(start);
                SmartNode child = (SmartNode)children.nextElement();
                next.addChildRDN(child.getRDN());
                result.addAll(this.getAllSearchResultNodes(next));
            }
            return result;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "error in SmartTree dump: ", e);
            return new ArrayList<DN>(0);
        }
    }

    public void setRootDN(DN newRootDN) {
        if (newRootDN == null) {
            newRootDN = NODATA_DN;
        }
        if (newRootDN == NODATA_DN) {
            this.rootDNBaseNode = this.rootNode = new SmartNode(NODATA_DN.getLowestRDN());
            this.rootDN = newRootDN;
            if (this.treeModel != null) {
                this.treeModel.setRoot(this.rootNode);
                this.treeModel.reload();
            }
            return;
        }
        this.rootDN = newRootDN;
        this.rootNode = new SmartNode("");
        this.rootNode.setRoot(true);
        this.rootNode.setStructural(true);
        this.treeModel.setRoot(this.rootNode);
        SmartNode parent = this.rootNode;
        this.rootDNBaseNode = this.rootNode;
        for (int i = 0; i < newRootDN.size(); ++i) {
            SmartNode child = new SmartNode(newRootDN.getRDN(i));
            child.setStructural(true);
            parent.add(child);
            parent = child;
        }
        this.rootDNBaseNode = parent;
        this.rootDNBaseNode.add(new SmartNode());
        this.treeModel.reload();
    }

    public void expandRootDN() {
        if (this.rootDN.size() > 0) {
            this.expandPath(this.treeModel.getPathForNode(this.rootDNBaseNode));
        } else {
            this.collapseRow(0);
        }
    }

    public boolean isEmpty() {
        return this.rootNode == null || this.rootDN == NODATA_DN;
    }

    public void expandDN(DN dn) {
        TreePath path = this.treeModel.getPathForDN(dn);
        this.expandPath(path.getParentPath());
    }

    public void expandRoot() {
        this.expandRow(0);
    }

    public void expandAll() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            this.expandRow(row);
        }
    }

    public void expandAllExceptRoot() {
        for (int row = 1; row < this.getRowCount(); ++row) {
            this.expandRow(row);
        }
    }

    public DN getRootDN() {
        return this.rootDN;
    }

    public SmartNode getRootNode() {
        return this.rootNode;
    }

    public SmartNode getLowestRootNode() {
        return this.rootDNBaseNode;
    }

    public SmartModel getTreeModel() {
        return this.treeModel;
    }

    public void registerDataSource(DataBroker s) {
        if (s == null) {
            this.treeDataSource = null;
        } else {
            log.fine("registering data source for tree " + this.getName());
            this.treeDataSource = s;
            this.treeDataSource.addDataListener(this);
            this.setEditable(this.treeDataSource.isModifiable());
        }
    }

    public DataBroker getDataSource() {
        return this.treeDataSource;
    }

    public void registerDataSink(DataSink s) {
        this.treeDataSinks.add(s);
        if (s instanceof AttributeDisplay) {
            this.registerPluggableEditorSource((AttributeDisplay)s);
        }
    }

    public void clearTree() {
        this.rootNode.removeAllChildren();
        this.setRootDN(NODATA_DN);
        this.treeModel.setRoot(this.rootNode);
        this.treeModel.reload();
        this.clearEntry();
        for (int i = 0; i < this.treeDataSinks.size(); ++i) {
            this.treeDataSinks.get(i).displayEntry(null, null);
        }
    }

    public void goOffline(OfflineDataBroker broker) {
        this.clearTree();
        this.registerDataSource(broker);
    }

    public void addCutting(SmartNode parent, NamingEnumeration children) {
        if (parent == null) {
            return;
        }
        if (children == null) {
            log.warning("null child list in addCutting...!");
            return;
        }
        if (children != null) {
            if (parent.getChildCount() == 1 && ((SmartNode)parent.getChildAt(0)).isDummy()) {
                parent.removeAllChildren();
            }
            while (children.hasMoreElements()) {
                NameClassPair np = (NameClassPair)children.nextElement();
                DN temp = new DN(np.getName());
                SmartNode child = new SmartNode(temp.getRDN(temp.size() - 1));
                if (!parent.hasChild(child.toString())) {
                    parent.add(child);
                    if (np instanceof SearchResult) {
                        this.doObjectClassSpecificHandling(child, (SearchResult)np);
                    }
                }
                if (!child.getAllowsChildren()) continue;
                child.add(new SmartNode());
            }
            parent.sort();
            this.treeModel.nodeStructureChanged(parent);
        }
    }

    public void registerPluggableEditorSource(AttributeDisplay display) {
        this.pluggableEditorSource = display;
    }

    protected void doObjectClassSpecificHandling(SmartNode child, SearchResult ocs) {
        if (ocs == null) {
            return;
        }
        Attributes atts = ocs.getAttributes();
        if (atts == null || atts.size() == 0) {
            return;
        }
        try {
            Attribute test;
            Attribute OC = atts.get("objectClass");
            if (OC == null) {
                OC = atts.get("objectclass");
            }
            if (OC == null && "objectclass".equals((test = atts.getAll().next()).getID().toLowerCase())) {
                OC = test;
            }
            if (OC == null) {
                return;
            }
            if (!(OC instanceof DXAttribute)) {
                OC = new DXAttribute(OC);
            }
            OC = DXAttributes.getAllObjectClasses((DXAttribute)OC);
            this.doObjectClassSpecificHandling(child, OC);
        }
        catch (Exception e) {
            log.warning("Warning error doing object class specific handling for tree nodes: " + e);
        }
    }

    protected void doObjectClassSpecificHandling(SmartNode child, Attribute OC) {
        PluggableEditor editor;
        if (!(OC instanceof DXAttribute)) {
            OC = new DXAttribute(OC);
        }
        child.setTrueObjectClass((DXAttribute)OC);
        if (this.pluggableEditorSource != null && (editor = this.pluggableEditorSource.getUniqueEditor(OC)) != null) {
            ImageIcon newIcon;
            if (editor.hideSubEntries(child.toString())) {
                child.setAllowsChildren(false);
            }
            if ((newIcon = editor.getTreeIcon(child.toString())) != null) {
                child.setIcon(newIcon);
            }
            if (editor.getPopupMenu(child.toString()) != null) {
                child.setPopupMenu(editor.getPopupMenu(child.toString()));
            }
        }
    }

    public SmartNode addNode(DN newDN) {
        if (newDN == null) {
            return null;
        }
        SmartNode child = null;
        if (this.rootDN == null || this.rootDN == NODATA_DN) {
            this.setRootDN(new DN(newDN.getRootRDN().toString()));
        }
        SmartNode parent = this.rootNode;
        for (int i = 0; i < newDN.size(); ++i) {
            RDN rdn = newDN.getRDN(i);
            Enumeration<TreeNode> children = parent.children();
            child = null;
            while (children.hasMoreElements()) {
                child = (SmartNode)children.nextElement();
                if (child.isDummy()) {
                    parent.remove(child);
                } else if (child.rdnEquals(rdn)) break;
                child = null;
            }
            if (child == null) {
                child = new SmartNode(rdn);
                if (i < newDN.size() - 1) {
                    child.setStructural(true);
                }
                parent.add(child);
                parent.sort();
                this.treeModel.nodeStructureChanged(parent);
                parent = child;
                continue;
            }
            parent = child;
            if (i != newDN.size() - 1) continue;
            child.setStructural(false);
        }
        return parent;
    }

    public void refresh(DN dn) {
        if (dn != null) {
            this.treeDataSource.getChildren(dn);
        }
    }

    public void refreshEditorPane() {
        this.pluggableEditorSource.refreshEditors(this.entry, this.treeDataSource);
    }

    public DN getCurrentDN() {
        return this.currentDN == null ? this.rootDN : this.currentDN;
    }

    public void clearEntry() {
        this.setEntry(null);
        this.pluggableEditorSource.displayEntry(null, this.treeDataSource);
    }

    public void collapse() {
        if (this.isEmpty()) {
            return;
        }
        try {
            DXNamingEnumeration en = this.treeDataSource.getChildren(this.rootDN).getEnumeration();
            if (en != null) {
                this.clearTree();
                this.setRootDN(this.rootDN);
                this.addCutting(this.rootDNBaseNode, en);
            }
        }
        catch (NamingException e) {
            CBUtility.error(CBIntText.get("threaded broker error") + ": ", e);
        }
    }

    protected void deleteTreeNode(SmartNode apex) {
        this.treeModel.removeNodeFromParent(apex);
    }

    public void renameTreeNode(SmartNode node, DN newDN) {
        node.update(newDN.getLowestRDN());
    }

    public void moveTreeNode(SmartNode node, DN to) {
        DN from = this.treeModel.getDNForNode(node);
        if (from.sharesParent(to)) {
            this.renameTreeNode(node, to);
        } else {
            SmartNode parent = (SmartNode)node.getParent();
            this.treeModel.removeNodeFromParent(node);
            this.treeModel.nodeStructureChanged(parent);
            node.update(to.getLowestRDN());
            parent = this.treeModel.getNodeForDN(to.getParent());
            if (parent.getChildCount() == 1 && ((SmartNode)parent.getChildAt(0)).isDummy()) {
                return;
            }
            parent.add(node);
            parent.sort();
            this.treeModel.nodeStructureChanged(parent);
        }
    }

    public void copyTreeNode(SmartNode node, DN to) {
        SmartNode parent = this.treeModel.getNodeForDN(to.getParent());
        if (parent == null) {
            CBUtility.error(this, CBIntText.get("unable to copy node {0}.", new String[]{node.toString()}), null);
            return;
        }
        SmartNode newCopy = this.copyTreeNodes(node, parent);
        if (!newCopy.getRDN().equals(to.getLowestRDN())) {
            newCopy.update(to.getLowestRDN());
        }
        parent.sort();
        this.treeModel.nodeStructureChanged(parent);
    }

    public SmartNode copyTreeNodes(SmartNode from, SmartNode toParent) {
        SmartNode fromCopy = new SmartNode(from);
        if (toParent.hasDummy()) {
            return fromCopy;
        }
        toParent.add(fromCopy);
        Enumeration<TreeNode> children = from.children();
        while (children.hasMoreElements()) {
            SmartNode child = (SmartNode)children.nextElement();
            this.copyTreeNodes(child, fromCopy);
        }
        fromCopy.sort();
        return fromCopy;
    }

    public JTree getTree() {
        return this;
    }

    public void makeNewEntry(DN parentDN) {
        if (this.treeDataSource.getSchemaOps() == null) {
            JOptionPane.showMessageDialog(this.browser, CBIntText.get("Because there is no schema currently published by the\ndirectory, adding a new entry is unavailable."), CBIntText.get("No Schema"), 1);
            return;
        }
        SmartNode parent = this.treeModel.getNodeForDN(parentDN);
        DN childDN = null;
        if (parent == null) {
            log.warning("unable to find " + parentDN + " in tree!");
            return;
        }
        if (parent.getChildCount() > 0) {
            SmartNode child = (SmartNode)parent.getChildAt(0);
            if (child != null && !child.isDummy()) {
                RDN childRDN = child.getRDN();
                childDN = new DN(parentDN);
                try {
                    childDN.addChildRDN(childRDN);
                }
                catch (InvalidNameException e) {
                    log.log(Level.WARNING, "ERROR: makeNewEntry(DN parentDN) " + parentDN, e);
                }
            } else {
                this.refresh(parentDN);
            }
        }
        DataSink editor = null;
        for (int i = 0; i < this.treeDataSinks.size(); ++i) {
            if (!this.treeDataSinks.get(i).canCreateEntry()) continue;
            editor = this.treeDataSinks.get(i);
        }
        if (editor == null) {
            CBUtility.error("Unable to create a new entry!", new Exception("No available entry editors"));
            return;
        }
        NewEntryWin userData = new NewEntryWin(parentDN, childDN, this.treeDataSource, editor, this.browser);
        userData.setSize(400, 300);
        CBUtility.center(userData, this.browser);
        userData.setVisible(true);
    }

    public SmartPopupTool getPopupTool() {
        return this.popupTreeTool;
    }

    public boolean popupToolVisible() {
        return this.popupTreeTool.isVisible();
    }

    public void registerEventPublisher(JXplorerEventGenerator gen) {
        this.eventPublisher = gen;
    }

    @Override
    public void fireJXplorerEvent(JXplorerEvent e) {
        if (this.eventPublisher != null) {
            this.eventPublisher.fireJXplorerEvent(e);
        }
    }

    public boolean isModifiable() {
        return this.treeDataSource.isModifiable();
    }

    public void modifyEntry(DXEntry oldEntry, DXEntry newEntry) {
        if (oldEntry == null && newEntry == null) {
            return;
        }
        this.treeDataSource.modifyEntry(oldEntry, newEntry);
    }

    public void copyTree(DN oldNodeDN, DN newNodeDN) {
        String uniqueRDN = this.treeModel.getUniqueCopyRDN(newNodeDN, oldNodeDN);
        try {
            newNodeDN.addChildRDN(uniqueRDN);
        }
        catch (InvalidNameException e) {
            CBUtility.error(this, CBIntText.get("Unable to add {0} due to bad name", new String[]{newNodeDN.toString()}), (Exception)e);
            return;
        }
        this.treeDataSource.copyTree(oldNodeDN, newNodeDN);
    }

    public void copyTreeFromExternalDirectory(DN oldNodeDN, DN newNodeDN, SmartTree fromTree) {
        DN testTargetDN = new DN(oldNodeDN.getLowestRDN().toString() + "," + newNodeDN.toString());
        boolean overwriteExistingData = true;
        try {
            if (this.treeModel.exists(testTargetDN)) {
                Object[] possibleValues = new Object[]{CBIntText.get("Copy"), CBIntText.get("Replace"), CBIntText.get("Merge")};
                Object selectedValue = JOptionPane.showInputDialog(this.browser, CBIntText.get("There is already a branch with that name.\nDo you want to:\n a) create a new copy,\nb) replace the existing tree,\nc) merge the new data with the old?"), "Input", 1, null, possibleValues, possibleValues[0]);
                if (selectedValue.equals(CBIntText.get("Copy"))) {
                    String uniqueRDN = this.treeModel.getUniqueCopyRDN(newNodeDN, oldNodeDN);
                    newNodeDN.addChildRDN(uniqueRDN);
                } else if (selectedValue.equals(CBIntText.get("Replace"))) {
                    newNodeDN.addChildRDN(oldNodeDN.getLowestRDN());
                } else if (selectedValue.equals(CBIntText.get("Merge"))) {
                    newNodeDN.addChildRDN(oldNodeDN.getLowestRDN());
                    overwriteExistingData = false;
                } else {
                    log.warning("Unexpected Error determining value - reverting to 'Copy'");
                    String uniqueRDN = this.treeModel.getUniqueCopyRDN(newNodeDN, oldNodeDN);
                    newNodeDN.addChildRDN(uniqueRDN);
                }
            } else {
                String uniqueRDN = this.treeModel.getUniqueCopyRDN(newNodeDN, oldNodeDN);
                newNodeDN.addChildRDN(uniqueRDN);
            }
        }
        catch (InvalidNameException e) {
            CBUtility.error(this, CBIntText.get("Unable to add {0} due to bad name", new String[]{newNodeDN.toString()}), (Exception)e);
            return;
        }
        this.treeDataSource.copyTreeBetweenWindows(oldNodeDN, newNodeDN, fromTree.treeDataSource, overwriteExistingData);
        this.refresh(newNodeDN);
    }

    protected void displayExpandedNodeResult(DataQuery result) {
        SmartNode node = this.treeModel.getNodeForDN(result.requestDN());
        if (node == null) {
            node = this.addNode(result.requestDN());
        }
        try {
            if (node.isAlwaysRefresh() && result.getEnumeration().size() == 0 && (node.getChildCount() != 1 || !((SmartNode)node.getChildAt(0)).isDummy())) {
                return;
            }
            node.removeAllChildren();
            this.addCutting(node, result.getEnumeration());
            if (node == this.getLowestRootNode() && node.getChildCount() == 0) {
                this.pluggableEditorSource.displaySpecialEntry(null, this.treeDataSource, JXConfig.getProperty("null.entry.editor"));
            }
            this.expandPath(this.treeModel.getPathForDN(result.requestDN()));
            this.browser.setStatus("   " + node.getDN().toString() + ": (" + node.getChildCount() + ")");
        }
        catch (NamingException e) {
            result.setException(e);
            node.removeAllChildren();
        }
    }

    public void readAndExpandDN(DN dn) {
        if (this.currentDN.size() < this.rootDN.size()) {
            this.refresh(this.rootDN);
            this.setSelectionPath(this.treeModel.getPathForDN(this.rootDN));
        }
        if (dn.size() < this.rootDN.size() || !dn.getPrefix(this.rootDN.size()).toString().equalsIgnoreCase(this.rootDN.toString())) {
            JOptionPane.showMessageDialog(this.browser, CBIntText.get("The entry {0}\nwill not be displayed because it is either above the baseDN\n{1}\nthat you are connected with or it has a different prefix.", new String[]{dn.toString(), this.rootDN.toString()}), CBIntText.get("Display Error"), 0);
            return;
        }
        log.warning("Opening '" + dn + "' from root DN '" + this.getRootDN());
        for (int level = 1; level <= dn.size(); ++level) {
            DN ancestor = (DN)dn.getPrefix(level);
            if (ancestor.size() < this.rootDN.size()) continue;
            SmartNode node = this.treeModel.getNodeForDN(ancestor);
            if (node == null) {
                this.treeDataSource.getChildren(ancestor.getParent());
                continue;
            }
            if (node.isStructural()) {
                this.treeDataSource.getChildren(ancestor);
                continue;
            }
            if (node.isDummy()) {
                this.treeDataSource.getChildren(ancestor.getParent());
                continue;
            }
            this.treeDataSource.getChildren(ancestor.getParent());
        }
        this.treeDataSource.getEntry(dn);
    }

    public void displayReadNodeResult(DataQuery node) {
        if (this.treeDataSinks.size() == 0) {
            log.warning("no data sink in display Node");
            return;
        }
        this.setEntry(null);
        try {
            if (node != null) {
                this.setEntry(node.getEntry());
                this.currentDN = node.requestDN();
            } else {
                this.currentDN = null;
            }
            this.publishData(this.entry, this.treeDataSource);
        }
        catch (NamingException e) {
            CBUtility.error("unexpected naming error trying to \ndisplay: " + node, e);
        }
        if (node != null) {
            TreePath current = this.treeModel.getPathForDN(node.requestDN());
            if (current == null) {
                log.warning("Unable to find tree path for DN: " + node.requestDN());
                return;
            }
            if (!this.isExpanded(current.getParentPath())) {
                this.expandPath(current.getParentPath());
            }
            if (!current.equals(this.getSelectionPath())) {
                this.setSelectionPath(current);
            }
            if (this.currentDN.size() <= this.rootDN.size()) {
                this.rootDN = this.currentDN;
            }
            int row = this.getRowForPath(current);
            this.scrollRowToVisible(row);
        }
    }

    public void setEntry(DXEntry newEntry) {
        this.entry = newEntry;
    }

    public void publishData(DXEntry entry, DataBrokerQueryInterface dataSource) {
        for (int i = 0; i < this.treeDataSinks.size(); ++i) {
            this.treeDataSinks.get(i).displayEntry(entry, this.treeDataSource);
        }
    }

    protected void displayModifyResult(DataQuery result) {
        try {
            if (result.getStatus()) {
                DXEntry oldEntry = result.oldEntry();
                DXEntry newEntry = result.newEntry();
                if (oldEntry == null || newEntry != null && newEntry.isNewEntry()) {
                    SmartNode node = this.addNode(newEntry.getDN());
                    node.add(new SmartNode());
                    this.doObjectClassSpecificHandling(node, newEntry.getAllObjectClasses());
                    newEntry.setStatus(2);
                    this.publishData(newEntry, this.treeDataSource);
                } else if (newEntry == null) {
                    DN parentDN = oldEntry.getDN().getParent();
                    this.deleteTreeNode(this.treeModel.getNodeForDN(oldEntry.getDN()));
                    if (parentDN != null && parentDN.size() > this.rootDN.size()) {
                        this.setSelectionPath(this.treeModel.getPathForDN(parentDN));
                    }
                } else if (!oldEntry.getDN().equals(newEntry.getDN())) {
                    SmartNode node = this.treeModel.getNodeForDN(oldEntry.getDN());
                    if (node != null) {
                        this.moveTreeNode(node, newEntry.getDN());
                        this.treeModel.nodeChanged(node);
                    }
                    if (newEntry.size() == 0) {
                        newEntry.put(oldEntry.getAll());
                    }
                    this.treeDataSource.getEntry(newEntry.getDN());
                } else {
                    this.treeDataSource.getEntry(newEntry.getDN());
                }
            }
        }
        catch (NamingException e) {
            result.setException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void displayCopyResult(DataQuery result) {
        try {
            if (result.getStatus()) {
                this.copyTreeNode(this.treeModel.getNodeForDN(result.oldDN()), result.requestDN());
                this.setSelectionPath(this.treeModel.getPathForDN(result.requestDN()));
            }
        }
        catch (NamingException e) {
            result.setException(e);
        }
    }

    protected void displayXWinCopyResult(DataQuery result) {
        this.setNumOfResults(0);
        try {
            DXNamingEnumeration results = result.getEnumeration();
            while (results != null && results.hasMoreElements()) {
                SearchResult sr = (SearchResult)results.nextElement();
                String search = sr.getName();
                if (search == null || search.length() == 0) {
                    this.addNode(NODATA_DN);
                    continue;
                }
                DN searchDN = new DN(search);
                this.addNode(searchDN);
                ++this.numOfResults;
            }
            this.setSelectionPath(this.treeModel.getPathForDN(result.requestDN()));
        }
        catch (NamingException e) {
            result.setException(e);
        }
    }

    protected void displaySearchResult(DataQuery result) {
        this.setNumOfResults(0);
        this.clearTree();
        try {
            DXNamingEnumeration results = result.getEnumeration();
            if (results.hasMoreElements()) {
                this.setRootDN(result.getRequestDN());
                while (results.hasMoreElements()) {
                    SearchResult sr = (SearchResult)results.nextElement();
                    String search = sr.getName();
                    if (search == null || search.length() == 0) {
                        log.severe("Unexpected problem getting name of search result: " + sr);
                        continue;
                    }
                    DN searchDN = new DN(search);
                    this.addNode(searchDN);
                    ++this.numOfResults;
                }
                this.browser.setStatus("   " + result.getRequestDN().toString() + ":+ (" + String.valueOf(this.numOfResults) + ")");
                this.expandAllExceptRoot();
            }
        }
        catch (NamingException e) {
            result.setException(e);
        }
    }

    public int getNumOfResults() {
        return this.numOfResults;
    }

    public void setNumOfResults(int numOfResults) {
        this.numOfResults = numOfResults;
    }

    protected void setTreeCellEditorListener() {
        CellEditorListener cl = new CellEditorListener(){

            public void editingCanceled(ChangeEvent e) {
                this.changeDN();
            }

            public void editingStopped(ChangeEvent e) {
                this.changeDN();
            }

            protected void changeDN() {
                if (!SmartTree.this.isActive()) {
                    return;
                }
                RDN rdn = (RDN)SmartTree.this.treeCellEditor.getCellEditorValue();
                DN newDN = new DN(SmartTree.this.currentDN);
                newDN.setRDN(rdn, newDN.size() - 1);
                if (SmartTree.this.currentDN.toString().equals(newDN.toString())) {
                    return;
                }
                if (SmartTree.this.treeModel.checkForAnotherNodeWithSameRDN(newDN)) {
                    new CBErrorWin((Frame)SmartTree.this.browser, "The name you are trying to use already exists - please choose another name or delete the original entry.", "Name already exists");
                    SmartTree.this.refresh(SmartTree.this.currentDN.getParent());
                    return;
                }
                SmartTree.this.treeDataSource.modifyEntry(new DXEntry(SmartTree.this.currentDN), new DXEntry(newDN));
            }
        };
        this.treeCellEditor.addCellEditorListener(cl);
    }

    protected void setTreeMouseListener() {
        MouseListener[] listeners;
        for (MouseListener listener : listeners = this.getMouseListeners()) {
            this.removeMouseListener(listener);
        }
        PopupMouseListener mouseListener = new PopupMouseListener();
        this.addMouseListener(mouseListener);
        for (MouseListener listener : listeners) {
            this.addMouseListener(listener);
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent e) {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent e) {
        if (!this.isActive()) {
            return;
        }
        SmartNode current = (SmartNode)e.getPath().getLastPathComponent();
        try {
            if (((SmartNode)current.getFirstChild()).isDummy()) {
                this.treeDataSource.getChildren(this.treeModel.getDNForNode(current));
            } else if (current.isAlwaysRefresh()) {
                this.treeDataSource.getChildren(this.treeModel.getDNForNode(current));
            }
        }
        catch (NoSuchElementException err) {
            System.out.println("unexpected exception expanding tree node " + err.getMessage());
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!this.isActive()) {
            return;
        }
        if (this.getSelectionPath() == null) {
            return;
        }
        if (!e.isAddedPath()) {
            this.setSelectionPath(null);
            this.displayReadNodeResult(null);
        } else {
            DN addedDN = this.treeModel.getDNForPath(this.getSelectionPath());
            if (!addedDN.equals(this.currentDN)) {
                this.treeDataSource.getEntry(this.treeModel.getDNForNode(this.getSelectedNode()));
            }
        }
    }

    protected boolean isActive() {
        if (this.treeDataSource == null) {
            return false;
        }
        return this.treeDataSource.isActive();
    }

    @Override
    public void dataReady(DataQuery result) {
        int type = result.getType();
        if (result.hasException()) {
            SmartNode node;
            String exception = result.getException().toString();
            if (exception.indexOf("Socket closed") > -1 && this.browser instanceof JXplorerBrowser) {
                this.browser.setDisconnectView();
            }
            CBUtility.error("Unable to perform " + result.getTypeString() + " operation.", result.getException());
            if (type == 4 && !(node = this.treeModel.getNodeForDN(result.requestDN())).isAlwaysRefresh()) {
                node.removeAllChildren();
                this.treeModel.nodeStructureChanged(node);
            }
            return;
        }
        switch (type) {
            case 4: {
                this.displayExpandedNodeResult(result);
                break;
            }
            case 32: {
                this.displayCopyResult(result);
                break;
            }
            case 64: {
                this.displayXWinCopyResult(result);
                break;
            }
            case 16: {
                this.displayModifyResult(result);
                break;
            }
            case 8: {
                this.displaySearchResult(result);
                break;
            }
            case 2: {
                this.displayReadNodeResult(result);
            }
        }
        if (result.hasException()) {
            CBUtility.error("Exception occurred during tree display of " + result.getTypeString() + ".\n\n(Error caught by display tree)", result.getException());
            return;
        }
    }

    @Override
    public void validate() {
        super.validate();
    }

    protected void setupDragAndDrop() {
        if (CBUtility.isSolaris()) {
            return;
        }
        if ("true".equals(JXConfig.getProperty("lock.read.only"))) {
            return;
        }
        if (!"true".equals(JXConfig.getProperty("option.drag.and.drop"))) {
            return;
        }
        this.dragSource = new DragSource(){

            protected DragSourceContext createDragSourceContext(DragSourceContextPeer dscp, DragGestureEvent dgl, Cursor dragCursor, Image dragImage, Point imageOffset, Transferable t, DragSourceListener dsl) {
                return new DragSourceContext(dscp, dgl, dragCursor, dragImage, imageOffset, t, dsl){

                    protected void updateCurrentCursor(int dropOp, int targetAct, int status) {
                    }
                };
            }
        };
        DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        dgr.setSourceActions(dgr.getSourceActions() + 16);
        new DropTarget(this, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent e) {
        SmartNode dragNode = this.getSelectedNode();
        if (dragNode != null) {
            this.dragging = true;
            SmartNode transferable = dragNode;
            Cursor cursor = DragSource.DefaultCopyDrop;
            int action = e.getDragAction();
            if (action == 2) {
                cursor = DragSource.DefaultMoveDrop;
            }
            this.dragSource.startDrag(e, cursor, transferable, this);
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.dragging = false;
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
        this.setCursor(dsde);
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
        this.setCursor(dsde);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dsde) {
    }

    private void setCursor(DragSourceDragEvent dsde) {
        if (this.cursorLocation == null) {
            return;
        }
        TreePath destinationPath = this.getPathForLocation(this.cursorLocation.x, this.cursorLocation.y);
        DragSourceContext dsc = dsde.getDragSourceContext();
        if (this.testDropTarget(destinationPath, this.getSelectionPath()) == null && dsde.getDropAction() == 1) {
            dsc.setCursor(DragSource.DefaultCopyDrop);
        } else if (dsde.getDropAction() == 1) {
            dsc.setCursor(DragSource.DefaultCopyNoDrop);
        } else if (this.testDropTarget(destinationPath, this.getSelectionPath()) == null && dsde.getDropAction() == 2) {
            dsc.setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsc.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        try {
            boolean copyAction;
            Transferable tr = e.getTransferable();
            if (!tr.isDataFlavorSupported(SmartNode.UNICODETEXT)) {
                e.rejectDrop();
                return;
            }
            String bloop = tr.getTransferData(SmartNode.UNICODETEXT).toString();
            Point loc = e.getLocation();
            TreePath destinationPath = this.getPathForLocation(loc.x, loc.y);
            final String msg = this.testDropTarget(destinationPath, this.getSelectionPath());
            if (msg != null) {
                e.rejectDrop();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CBUtility.error(msg);
                    }
                });
                return;
            }
            SmartNode newParent = (SmartNode)destinationPath.getLastPathComponent();
            DN parentDN = this.treeModel.getDNForNode(newParent);
            SmartNode oldNode = this.getSelectedNode();
            DN oldDN = this.treeModel.getDNForNode(oldNode);
            int action = e.getDropAction();
            boolean bl = copyAction = action == 1;
            if (copyAction) {
                if (System.getProperty("java.version").startsWith("1.4.0")) {
                    this.popupTreeTool.dragCopy(oldDN, parentDN);
                } else {
                    this.popupTreeTool.copy(oldDN, parentDN);
                }
            } else if (System.getProperty("java.version").startsWith("1.4.0")) {
                this.popupTreeTool.dragMove(oldDN, parentDN);
            } else {
                this.popupTreeTool.move(oldDN, parentDN);
            }
            e.acceptDrop(action);
            e.getDropTargetContext().dropComplete(true);
        }
        catch (IOException io) {
            e.rejectDrop();
        }
        catch (UnsupportedFlavorException ufe) {
            e.rejectDrop();
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        this.cursorLocation = e.getLocation();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private String testDropTarget(TreePath destination, TreePath dropper) {
        boolean destinationPathIsNull;
        boolean bl = destinationPathIsNull = destination == null;
        if (destinationPathIsNull) {
            return CBIntText.get("Invalid drop location.");
        }
        if (destination.equals(dropper)) {
            return CBIntText.get("Destination cannot be same as source");
        }
        if (dropper.isDescendant(destination)) {
            return CBIntText.get("Destination node cannot be a descendant.");
        }
        if (dropper.getParentPath().equals(destination)) {
            return CBIntText.get("Destination node cannot be a parent.");
        }
        return null;
    }

    public void openDeleteBookmarkDialog() {
        BookMarks bm = new BookMarks(this.browser);
        bm.getDeleteDialog();
    }

    public void openEditBookmarkDialog() {
        BookMarks bm = new BookMarks(this.browser);
        bm.getEditDialog();
    }

    public void openAddBookmarkDialog(DN dn) {
        BookMarks bm = new BookMarks(this.browser);
        BookMarks.AddDialog addDialog = bm.getAddDialog(dn.toString(), false);
        addDialog.setVisible(true);
    }

    public void openSearch() {
        this.openSearch(this.currentDN);
    }

    public void openSearch(DN dn) {
        JXplorerBrowser jx = this.browser;
        if (this.searchGUI == null) {
            this.searchGUI = new SearchGUI(dn, jx);
        }
        this.searchGUI.setBaseDN(dn);
        this.searchGUI.setVisible(true);
    }

    public SearchGUI getSearchGUI() {
        return this.searchGUI;
    }

    public void setSearchGUI(SearchGUI searchGUI) {
        this.searchGUI = searchGUI;
    }

    public void unthreadedRefresh(ArrayList<DN> topNodes) {
        if (this.isEmpty()) {
            for (DN root : topNodes) {
                this.setRootDN(root);
                this.expandRootDN();
                this.getRootNode().setStructural(true);
            }
        }
        for (DN root : topNodes) {
            if (root.size() <= 1) continue;
            this.refresh(root.getParent());
        }
    }

    class PopupMouseListener
    implements MouseListener {
        PopupMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.doPopupStuff(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.doPopupStuff(e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public boolean doPopupStuff(MouseEvent e) {
            if (!SmartTree.this.isActive()) {
                return false;
            }
            if (!e.isPopupTrigger()) {
                return false;
            }
            TreePath path = SmartTree.this.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                return false;
            }
            SmartTree.this.setSelectionPath(path);
            DN thisDN = SmartTree.this.treeModel.getDNForPath(path);
            if (!thisDN.equals(SmartTree.this.currentDN)) {
                SmartTree.this.currentDN = thisDN;
            }
            if (SmartTree.this.treeDataSource != null) {
                SmartTree.this.popupTreeTool.setModifiable(SmartTree.this.treeDataSource.isModifiable());
                if (SmartTree.this.getSelectedNode().getPopupMenu() != null) {
                    SmartTree.this.getSelectedNode().getPopupMenu().show(SmartTree.this, e.getX(), e.getY());
                } else {
                    Toolkit toolKit = Toolkit.getDefaultToolkit();
                    SmartTree.this.popupTreeTool.show(SmartTree.this, e.getX(), e.getY());
                    if ((int)SmartTree.this.popupTreeTool.getLocationOnScreen().getY() > toolKit.getScreenSize().height - (SmartTree.this.popupTreeTool.getHeight() + 30)) {
                        SmartTree.this.popupTreeTool.show(SmartTree.this, e.getX(), e.getY() - SmartTree.this.popupTreeTool.getHeight());
                    }
                }
            }
            return true;
        }
    }
}

