/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.tree;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.tree.SmartNode;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SmartModel
extends DefaultTreeModel {
    private static Logger log = Logger.getLogger(SmartModel.class.getName());

    public SmartModel(TreeNode root) {
        super(root);
    }

    public SmartModel(TreeNode root, boolean asksAllowsChildren) {
        super(root, asksAllowsChildren);
    }

    public void nodeChanged(TreeNode treeNode) {
        super.nodeChanged(treeNode);
    }

    public DN getDNForPath(TreePath path) {
        if (path == null) {
            return null;
        }
        DN newDN = new DN();
        Object[] cobbleStones = path.getPath();
        SmartNode myRoot = (SmartNode)cobbleStones[0];
        try {
            for (int i = 0; i < cobbleStones.length; ++i) {
                SmartNode sn = (SmartNode)cobbleStones[i];
                RDN rdn = sn.getRDN();
                if (rdn.isEmpty()) continue;
                newDN.addChildRDN(rdn);
            }
        }
        catch (InvalidNameException e) {
            log.log(Level.WARNING, "ERROR: getDNForPath(TreePath path) can't parse " + path.toString() + "\n   ", e);
            return null;
        }
        return newDN;
    }

    public DN getDNForNode(TreeNode node) {
        return this.getDNForPath(this.getPathForNode(node));
    }

    public DN getDNForPath(TreeNode[] path) {
        return this.getDNForPath(new TreePath(path));
    }

    public TreePath getPathForNode(TreeNode node) {
        Object[] nodePath = this.getPathToRoot(node);
        if (nodePath == null) {
            return null;
        }
        return new TreePath(nodePath);
    }

    public TreePath getPathForDN(DN nodeDN) {
        SmartNode node = this.getNodeForDN(nodeDN);
        if (node == null) {
            return null;
        }
        return this.getPathForNode(node);
    }

    public SmartNode getNodeForDN(DN nodeDN) {
        if (nodeDN == null) {
            return null;
        }
        if (nodeDN.size() == 0) {
            return (SmartNode)this.getRoot();
        }
        SmartNode child = null;
        SmartNode parent = (SmartNode)this.getRoot();
        for (int i = 0; i < nodeDN.size(); ++i) {
            RDN rdn = nodeDN.getRDN(i);
            Enumeration<TreeNode> children = parent.children();
            parent = null;
            while (children.hasMoreElements()) {
                child = (SmartNode)children.nextElement();
                if (!child.rdnEquals(rdn)) continue;
                parent = child;
                break;
            }
            if (parent != null) continue;
            return null;
        }
        return parent;
    }

    protected String getUniqueCopyRDN(DN activeDN, DN copyDN) {
        RDN testRDN = copyDN.getLowestRDN();
        String testValue = copyDN.getLowestRDN().getRawVal();
        String testClass = copyDN.getLowestRDN().getAttID();
        String copyPrefix = testClass + "=" + CBIntText.get("Copy");
        String copyPrefix2 = CBIntText.get("of");
        boolean originalExists = false;
        int copyNumber = 0;
        SmartNode parent = this.getNodeForDN(activeDN);
        if (parent != null) {
            Enumeration<TreeNode> children = parent.children();
            while (children.hasMoreElements()) {
                SmartNode child = (SmartNode)children.nextElement();
                RDN childRDN = child.getRDN();
                String childRDNString = childRDN.toString();
                if (!originalExists && childRDN.equals(testRDN)) {
                    originalExists = true;
                }
                if (!childRDNString.startsWith(copyPrefix) || !childRDNString.endsWith(testValue)) continue;
                int startpos = copyPrefix.length() + 1;
                if (childRDNString.charAt(startpos) == '(') {
                    int endpos = childRDNString.indexOf(41, startpos);
                    if (endpos != -1) {
                        String childCopyNumberText = childRDNString.substring(startpos + 1, endpos);
                        try {
                            int childCopyNumber = Integer.parseInt(childCopyNumberText);
                            if (childCopyNumber < copyNumber) continue;
                            copyNumber = childCopyNumber + 1;
                        }
                        catch (NumberFormatException e) {
                            if (copyNumber != 0) continue;
                            copyNumber = 2;
                        }
                        continue;
                    }
                    if (copyNumber != 0) continue;
                    copyNumber = 2;
                    continue;
                }
                if (copyNumber != 0) continue;
                copyNumber = 2;
            }
            String returnValue = originalExists ? (copyNumber != 0 ? copyPrefix + " (" + copyNumber + ") " + copyPrefix2 + " " + testValue : copyPrefix + " " + copyPrefix2 + " " + testValue) : testRDN.toString();
            return returnValue;
        }
        return testRDN.toString();
    }

    public boolean checkForAnotherNodeWithSameRDN(DN nodeDN) {
        if (nodeDN == null) {
            return false;
        }
        if (nodeDN.size() == 0) {
            return false;
        }
        RDN nodeRDN = nodeDN.getLowestRDN();
        SmartNode parent = this.getNodeForDN(nodeDN.getParent());
        SmartNode child = null;
        Enumeration<TreeNode> children = parent.children();
        int matchCount = 0;
        while (children.hasMoreElements()) {
            child = (SmartNode)children.nextElement();
            if (!child.rdnEquals(nodeRDN) || ++matchCount != 2) continue;
            return true;
        }
        return false;
    }

    public boolean exists(DN nodeDN) {
        if (nodeDN == null) {
            return false;
        }
        if (nodeDN.size() == 0) {
            return false;
        }
        return this.getNodeForDN(nodeDN) != null;
    }
}

