/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.search;

import com.ca.commons.cbutil.CBBasicComboBoxRenderer;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.jndi.SchemaOps;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.editor.generalizedtimeeditor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class BuildFilterPanel
extends CBPanel {
    SchemaOps schema;
    int rowCount = 0;
    int labelCount = 0;
    CBJComboBox andOrCombo;
    CBJComboBox[] attributeCombo = new CBJComboBox[50];
    CBJComboBox[] functionCombo = new CBJComboBox[50];
    JTextField[] filterField = new JTextField[50];
    JLabel[] andOrLabel = new JLabel[50];
    static final String[] andOrArray = new String[]{CBIntText.get("And"), CBIntText.get("Or")};
    static final String[] functionArray = new String[]{CBIntText.get("Beginning With"), CBIntText.get("Not Beginning With"), CBIntText.get("Containing"), CBIntText.get("Not Containing"), CBIntText.get("Equal To"), CBIntText.get("Not Equal To"), CBIntText.get("Ending In"), CBIntText.get("Not Ending In"), CBIntText.get("Greater Than or Equal To"), CBIntText.get("Not Greater Than or Equal To"), CBIntText.get("Less Than or Equal To"), CBIntText.get("Not Less Than or Equal To"), CBIntText.get("Present"), CBIntText.get("Not Present"), CBIntText.get("Similar To"), CBIntText.get("Not Similar To")};
    static final int BEGIN = 0;
    static final int NOTBEGIN = 1;
    static final int CONTAINING = 2;
    static final int NOTCONTAINING = 3;
    static final int EQUALS = 4;
    static final int NOTEQUALS = 5;
    static final int ENDING = 6;
    static final int NOTENDING = 7;
    static final int GREATER = 8;
    static final int NOTGREATER = 9;
    static final int LESS = 10;
    static final int NOTLESS = 11;
    static final int PRESENT = 12;
    static final int NOTPRESENT = 13;
    static final int SIMILAR = 14;
    static final int NOTSIMILAR = 15;
    CBPanel panel = new CBPanel();
    JCheckBox notCheckBox;
    String[] attrs;
    generalizedtimeeditor gte;
    JXplorerBrowser browser;
    private static Logger log = Logger.getLogger(BuildFilterPanel.class.getName());

    public BuildFilterPanel(JXplorerBrowser jx) {
        this.schema = jx.getSearchBroker().getSchemaOps();
        this.attrs = this.getAttributes();
        this.browser = jx;
        this.notCheckBox = new JCheckBox(CBIntText.get("Not"));
        this.notCheckBox.setToolTipText(CBIntText.get("Not this filter"));
        this.makeLight();
        this.add(this.notCheckBox);
        this.newLine();
        this.makeHeavy();
        this.add(new JScrollPane(this.panel));
        this.makeLight();
        this.addFilterRow();
    }

    protected boolean displayFilter(String filter) {
        while (this.rowCount > 1) {
            this.removeFilterRow();
        }
        this.notCheckBox.setSelected(false);
        try {
            if (this.getOccurrences(filter, "(") > 2) {
                if (filter.charAt(1) == '!') {
                    this.notCheckBox.setSelected(true);
                    filter = this.trimFilter(filter);
                }
                if (filter.indexOf("&") > -1) {
                    this.addFilterRow();
                    this.andOrCombo.setSelectedIndex(0);
                    filter = this.trimFilter(filter);
                } else if (filter.indexOf("|") > -1) {
                    this.addFilterRow();
                    this.andOrCombo.setSelectedIndex(1);
                    filter = this.trimFilter(filter);
                }
                this.panel.revalidate();
            }
            int items = this.getOccurrences(filter, "(") - this.getOccurrences(filter, "!");
            for (int i = 1; i <= items; ++i) {
                String temp;
                String string = temp = filter.indexOf("!") == 1 ? filter.substring(0, filter.indexOf("))") + 2) : filter.substring(0, filter.indexOf(")") + 1);
                if (i > 2) {
                    this.addFilterRow();
                }
                this.attributeCombo[i].setSelectedItem(this.getAttributeComboValue(temp));
                this.functionCombo[i].setSelectedIndex(this.getFunctionPosition(temp));
                this.filterField[i].setText(this.getFilterFieldText(temp));
                filter = filter.substring(temp.length());
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected String getAttributeComboValue(String filter) {
        String value = "";
        try {
            value = filter.indexOf("!") > -1 ? filter.substring(3) : filter.substring(1);
            if (value.indexOf(">=") > -1) {
                value = value.substring(0, value.indexOf(">="));
            } else if (value.indexOf("<=") > -1) {
                value = value.substring(0, value.indexOf("<="));
            } else if (value.indexOf("~=") > -1) {
                value = value.substring(0, value.indexOf("~="));
            } else if (value.indexOf("=") > -1) {
                value = value.substring(0, value.indexOf("="));
            }
        }
        catch (Exception e) {
            return "";
        }
        return value;
    }

    protected String getFilterFieldText(String filter) {
        String text = "";
        try {
            if (filter.indexOf("=*") > -1) {
                text = filter.substring(filter.indexOf("=*") + 2);
            } else if (filter.indexOf("=") > -1) {
                text = filter.substring(filter.indexOf("=") + 1);
            }
            text = filter.indexOf("!") > -1 ? text.substring(0, text.length() - 2) : text.substring(0, text.length() - 1);
            if (text.endsWith("*")) {
                text = text.substring(0, text.length() - 1);
            }
            text = this.replace(text, "\\28", "(");
            text = this.replace(text, "\\29", ")");
            text = this.replace(text, "\\2A", "*");
            text = this.replace(text, "\\5c", "\\");
        }
        catch (Exception e) {
            return "";
        }
        return text;
    }

    protected int getFunctionPosition(String filter) {
        int asteriskCount = this.getOccurrences(filter, "*");
        boolean containsNot = filter.indexOf("!") > -1;
        boolean endsWithStar = filter.endsWith("*)");
        boolean endsWithStars = filter.endsWith("*))");
        if (filter.indexOf("=*") > -1 && !containsNot && endsWithStar && asteriskCount > 1) {
            return 2;
        }
        if (filter.indexOf("=*") > -1 && containsNot && endsWithStars && asteriskCount > 1) {
            return 3;
        }
        if (filter.indexOf("=*)") > -1 && !containsNot) {
            return 12;
        }
        if (filter.indexOf("=*))") > -1 && containsNot) {
            return 13;
        }
        if (filter.indexOf("=") > -1 && !containsNot && endsWithStar) {
            return 0;
        }
        if (filter.indexOf("=") > -1 && containsNot && endsWithStars) {
            return 1;
        }
        if (filter.indexOf("=*") > -1 && !containsNot) {
            return 6;
        }
        if (filter.indexOf("=*") > -1 && containsNot) {
            return 7;
        }
        if (filter.indexOf(">=") > -1 && !containsNot) {
            return 8;
        }
        if (filter.indexOf(">=") > -1 && containsNot) {
            return 9;
        }
        if (filter.indexOf("<=") > -1 && !containsNot) {
            return 10;
        }
        if (filter.indexOf("<=") > -1 && containsNot) {
            return 11;
        }
        if (filter.indexOf("~=") > -1 && !containsNot) {
            return 14;
        }
        if (filter.indexOf("~=") > -1 && containsNot) {
            return 15;
        }
        if (filter.indexOf("=") > -1 && !containsNot) {
            return 4;
        }
        if (filter.indexOf("=") > -1 && containsNot) {
            return 5;
        }
        return -1;
    }

    protected int getOccurrences(String string, String substring) {
        int pos = -1;
        int count = 0;
        while ((pos = string.indexOf(substring, pos + 1)) != -1) {
            ++count;
        }
        return count;
    }

    protected String trimFilter(String filter) {
        return filter.substring(2, filter.length() - 1);
    }

    protected void addFilterRow() {
        if (this.rowCount < 49) {
            ++this.rowCount;
            this.panel.newLine();
            if (this.rowCount == 1) {
                this.andOrCombo = new CBJComboBox(andOrArray);
                this.panel.add(this.andOrCombo);
                this.andOrCombo.setPreferredSize(new Dimension(50, 20));
                this.andOrCombo.setVisible(false);
            } else if (this.rowCount == 2) {
                this.andOrCombo = new CBJComboBox(andOrArray);
                this.panel.add(this.andOrCombo);
                this.andOrCombo.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        try {
                            for (int i = 0; i < BuildFilterPanel.this.labelCount; ++i) {
                                BuildFilterPanel.this.andOrLabel[i].setText(BuildFilterPanel.this.andOrCombo.getSelectedItem().toString());
                            }
                        }
                        catch (Exception ee) {
                            log.log(Level.WARNING, "Error updating and/or labels in the search dialog: ", ee);
                        }
                    }
                });
                this.andOrCombo.setPreferredSize(new Dimension(50, 20));
            } else if (this.rowCount > 2) {
                this.andOrLabel[this.labelCount] = new JLabel();
                try {
                    this.andOrLabel[this.labelCount].setText(this.andOrCombo.getSelectedItem().toString());
                }
                catch (Exception e) {
                    this.andOrLabel[this.labelCount].setText(" ");
                    log.log(Level.WARNING, "Problem updating the 'And/Or' labels in the Join tab of the search dialog:", e);
                }
                this.panel.add(this.andOrLabel[this.labelCount]);
                ++this.labelCount;
            }
            if (this.attrs == null) {
                this.attributeCombo[this.rowCount] = new CBJComboBox();
                this.panel.add(this.attributeCombo[this.rowCount]);
                this.attributeCombo[this.rowCount].setEditable(true);
            } else {
                this.attributeCombo[this.rowCount] = new CBJComboBox(this.attrs);
                this.panel.add(this.attributeCombo[this.rowCount]);
                this.attributeCombo[this.rowCount].setRenderer(new CBBasicComboBoxRenderer(this.attrs));
                int pos = this.getPriorIndex(this.attributeCombo, this.rowCount);
                if (pos > 0) {
                    this.attributeCombo[this.rowCount].setSelectedIndex(pos);
                } else {
                    this.attributeCombo[this.rowCount].setSelectedItem("sn");
                }
            }
            this.attributeCombo[this.rowCount].setPreferredSize(new Dimension(140, 20));
            this.panel.makeLight();
            this.functionCombo[this.rowCount] = new CBJComboBox(functionArray);
            this.panel.add(this.functionCombo[this.rowCount]);
            int pos = this.getPriorIndex(this.functionCombo, this.rowCount);
            if (pos > 0) {
                this.functionCombo[this.rowCount].setSelectedIndex(pos);
            } else {
                this.functionCombo[this.rowCount].setSelectedItem(functionArray[0]);
            }
            this.functionCombo[this.rowCount].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    for (int i = 1; i <= BuildFilterPanel.this.rowCount; ++i) {
                        BuildFilterPanel.this.checkTextFieldEnabled(i);
                    }
                }
            });
            this.functionCombo[this.rowCount].setPreferredSize(new Dimension(140, 20));
            this.functionCombo[this.rowCount].setRenderer(new CBBasicComboBoxRenderer(functionArray));
            this.panel.makeWide();
            this.filterField[this.rowCount] = new JTextField();
            this.panel.add(this.filterField[this.rowCount]);
            this.filterField[this.rowCount].setRequestFocusEnabled(true);
            int row = this.rowCount;
            this.addMouseListener(row);
            this.checkTextFieldEnabled(this.rowCount);
            this.panel.makeLight();
            this.panel.revalidate();
        }
    }

    private void addMouseListener(final int row) {
        this.filterField[this.rowCount].addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                BuildFilterPanel.this.checkForSpecialEditor(BuildFilterPanel.this.attributeCombo[row].getSelectedItem().toString(), BuildFilterPanel.this.filterField[row]);
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    private void checkTextFieldEnabled(int row) {
        int item = this.functionCombo[row].getSelectedIndex();
        if (item == 12 || item == 13) {
            this.filterField[row].setEnabled(false);
            this.filterField[row].setBackground(Color.lightGray);
        } else {
            this.filterField[row].setEnabled(true);
            this.filterField[row].setBackground(Color.white);
        }
    }

    public int getPriorIndex(JComboBox[] combo, int pos) {
        int n = pos = pos <= 0 ? pos : pos - 1;
        if (pos > 0) {
            return combo[pos].getSelectedIndex();
        }
        return pos;
    }

    protected void checkForSpecialEditor(String attrName, JTextField field) {
        if (this.schema.getAttributeSyntax(attrName).indexOf("121.1.24") > -1) {
            this.gte = new generalizedtimeeditor((Frame)this.browser, field.getText(), false);
            CBUtility.center(this.gte, this.browser);
            this.gte.setVisible(true);
            try {
                while (this.gte.isVisible()) {
                    this.wait();
                }
                field.setText(this.gte.getTime());
                field.setEditable(false);
                field.transferFocus();
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Problem with getting search filter information from editor: ", e);
                field.setText("");
            }
        } else {
            field.requestFocus();
            field.setEditable(true);
        }
    }

    protected void removeFilterRow() {
        if (this.rowCount > 1) {
            if (this.rowCount == 2) {
                this.panel.remove(this.andOrCombo);
            }
            this.panel.remove(this.attributeCombo[this.rowCount]);
            this.panel.remove(this.functionCombo[this.rowCount]);
            this.panel.remove(this.filterField[this.rowCount]);
            if (this.rowCount > 2) {
                --this.labelCount;
                this.panel.remove(this.andOrLabel[this.labelCount]);
            }
            this.panel.repaint();
            --this.rowCount;
        }
        this.panel.revalidate();
    }

    protected String[] getAttributes() {
        if (this.schema == null) {
            CBUtility.error("Unable to access schema in BuildFilterPanel - no schema available.");
            return new String[0];
        }
        try {
            ArrayList<String> attributeNames = this.schema.getKnownAttributeNames();
            if (attributeNames == null) {
                return null;
            }
            String[] temp = attributeNames.toArray(new String[0]);
            Arrays.sort(temp, new CBUtility.IgnoreCaseStringComparator());
            return temp;
        }
        catch (NamingException e) {
            CBUtility.error("Unable to access schema in BuildFilterPanel " + e.toString());
            return null;
        }
    }

    protected boolean isFilterValid() {
        try {
            for (int i = 1; i <= this.rowCount; ++i) {
                String andOr;
                String attr = this.attributeCombo[i].getSelectedItem().toString();
                if (attr.trim().length() <= 0) {
                    return false;
                }
                String func = this.functionCombo[i].getSelectedItem().toString();
                if (attr.trim().length() <= 0) {
                    return false;
                }
                if (this.rowCount < 2 || (andOr = this.andOrCombo.getSelectedItem().toString()).trim().length() > 0) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    protected String getFilter() {
        StringBuffer buffy = new StringBuffer();
        for (int i = 1; i <= this.rowCount; ++i) {
            buffy.append(this.getFunctionPart(i));
        }
        if (this.rowCount >= 2) {
            switch (this.andOrCombo.getSelectedIndex()) {
                case 1: {
                    buffy.insert(0, "(|");
                    break;
                }
                default: {
                    buffy.insert(0, "(&");
                }
            }
            buffy.append(")");
        }
        if (this.notCheckBox.isSelected()) {
            buffy.insert(0, "(!");
            buffy.append(")");
        }
        return buffy.toString();
    }

    protected String getFunctionPart(int i) {
        String attr = this.attributeCombo[i].getSelectedItem().toString();
        String func = this.functionCombo[i].getSelectedItem().toString();
        String text = this.filterField[i].getText();
        int index = this.functionCombo[i].getSelectedIndex();
        text = this.replace(text, "\\", "\\5c");
        text = this.replace(text, "(", "\\28");
        text = this.replace(text, ")", "\\29");
        text = this.replace(text, "*", "\\2A");
        switch (index) {
            case 0: {
                return "(" + attr + "=" + text + "*)";
            }
            case 1: {
                return "(!(" + attr + "=" + text + "*))";
            }
            case 2: {
                return "(" + attr + "=*" + text + "*)";
            }
            case 3: {
                return "(!(" + attr + "=*" + text + "*))";
            }
            case 4: {
                return "(" + attr + "=" + text + ")";
            }
            case 5: {
                return "(!(" + attr + "=" + text + "))";
            }
            case 6: {
                return "(" + attr + "=*" + text + ")";
            }
            case 7: {
                return "(!(" + attr + "=*" + text + "))";
            }
            case 8: {
                return "(" + attr + ">=" + text + ")";
            }
            case 9: {
                return "(!(" + attr + ">=" + text + "))";
            }
            case 10: {
                return "(" + attr + "<=" + text + ")";
            }
            case 11: {
                return "(!(" + attr + "<=" + text + "))";
            }
            case 12: {
                return "(" + attr + "=*)";
            }
            case 13: {
                return "(!(" + attr + "=*))";
            }
            case 14: {
                return "(" + attr + "~=" + text + ")";
            }
            case 15: {
                return "(!(" + attr + "~=" + text + "))";
            }
        }
        return "";
    }

    protected String replace(String string, String oldString, String newString) {
        int pos = -1;
        try {
            while ((pos = string.indexOf(oldString, pos + 1)) != -1) {
                string = string.substring(0, pos) + newString + string.substring(pos + oldString.length());
            }
            return string;
        }
        catch (Exception e) {
            return string;
        }
    }
}

