/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.editor;

import com.ca.commons.cbutil.CBAction;
import com.ca.commons.cbutil.CBBase64;
import com.ca.commons.cbutil.CBBase64EncodingException;
import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBErrorWin;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.editor.abstractbinaryeditor;
import com.ca.directory.jxplorer.editor.editablebinary;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.UnsupportedEncodingException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

public class userpasswordeditor
extends JDialog
implements abstractbinaryeditor {
    public static boolean testMode = false;
    public static final String VERIFY = "Verify";
    public static final String PLAINTEXT = "plain text";
    public static final String MD5 = "MD5";
    public static final String SHA = "SHA";
    public static final String SSHA = "SSHA";
    public static final String SMD5 = "SMD5";
    public static final String SHA256 = "SHA-256";
    public static final String SSHA256 = "SSHA-256";
    public static final String SHA512 = "SHA-512";
    public static final String SSHA512 = "SSHA-512";
    public static final String[] supportedAlgorithms = new String[]{"plain text", "MD5", "SHA", "SSHA", "SMD5", "SHA-256", "SSHA-256", "SHA-512", "SSHA-512"};
    protected CBPanel basicOptions;
    protected CBPanel advancedOptions;
    protected JTextField pwdField;
    protected JTextField pwdConfirm;
    protected JTextField advanced_pwd;
    protected JTextField salt_ascii;
    protected JTextField salt_base64;
    protected JTextField base64result;
    protected JTextField ldapValueResult;
    protected JTextField ldifValueResult;
    protected CBButton btnOK;
    protected CBButton btnCancel;
    protected CBButton btnHelp;
    protected CBButton clear;
    protected CBButton basic;
    protected CBButton advanced;
    protected CBButton test;
    protected editablebinary editMe = null;
    protected CBPanel display;
    protected JLabel pwdLabel;
    protected JLabel pwdConfirmLabel;
    protected CBJComboBox comboType;
    protected CBJComboBox advancedAlgSelection;
    protected boolean firstClick = true;
    protected boolean hidingPasswords = true;
    protected static int default_encryption = 4;
    protected static boolean defaultToShowAdvancedUI = false;
    private static Logger log = Logger.getLogger(userpasswordeditor.class.getName());

    public static void main(String[] args) throws Exception {
        testMode = true;
        userpasswordeditor editor = new userpasswordeditor(new JFrame());
        editablebinary val = new editablebinary(){
            byte[] internalVal;

            public void setValue(byte[] bytes) {
                this.internalVal = bytes;
            }

            public byte[] getValue() {
                return this.internalVal;
            }
        };
        val.setValue(new String("{SSHA512}5QxZCiM/zcn0/upHX2uw6ICbgE+PLa9sJz/UpfMAMe1isyxuv+NeW4k4GjRDoTQHnB5QjCKCydJJjUQnT3DEEXJhbmRvbVN0cmluZw==").getBytes("UTF-8"));
        editor.editMe = val;
        editor.showAdvancedUI(true);
        editor.setVisible(true);
    }

    public userpasswordeditor(Frame owner) {
        super(owner);
        this.setModal(true);
        this.setTitle(CBIntText.get("User Password"));
        this.display = new CBPanel();
        if (JXConfig.getProperty("mask.raw.passwords", "true").equalsIgnoreCase("false")) {
            this.pwdField = new JTextField();
            this.pwdConfirm = new JTextField();
            this.hidingPasswords = false;
        } else {
            this.pwdField = new JPasswordField();
            this.pwdConfirm = new JPasswordField();
        }
        this.pwdField.setBackground(Color.white);
        this.pwdField.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                if (userpasswordeditor.this.firstClick) {
                    if (userpasswordeditor.this.hidingPasswords) {
                        userpasswordeditor.this.pwdField.setText("");
                    }
                    userpasswordeditor.this.firstClick = false;
                }
            }
        });
        this.pwdConfirm.setBackground(Color.white);
        this.pwdLabel = new JLabel(CBIntText.get("Enter Password") + ":");
        this.pwdConfirmLabel = new JLabel(CBIntText.get("Re-enter Password") + ":");
        this.btnOK = new CBButton(CBIntText.get("OK"), CBIntText.get("Click here to save the changes (remember to click Submit in the table editor)."));
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                userpasswordeditor.this.load();
            }
        });
        this.btnCancel = new CBButton(CBIntText.get("Cancel"), CBIntText.get("Click here to exit."));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                userpasswordeditor.this.quit();
            }
        });
        this.comboType = new CBJComboBox();
        this.comboType.addItem(VERIFY);
        for (String algorithm : supportedAlgorithms) {
            this.comboType.addItem(algorithm);
        }
        this.comboType.setEditable(false);
        this.comboType.setSelectedIndex(default_encryption);
        this.comboType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (userpasswordeditor.this.comboType.getSelectedItem().equals(userpasswordeditor.VERIFY)) {
                    userpasswordeditor.this.setNewPwdFieldEnabled(false);
                } else {
                    userpasswordeditor.this.setNewPwdFieldEnabled(true);
                }
            }
        });
        this.comboType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                default_encryption = userpasswordeditor.this.comboType.getSelectedIndex();
            }
        });
        this.btnHelp = new CBButton(CBIntText.get("Help"), CBIntText.get("Click here for Help."));
        CBHelpSystem.useDefaultHelp(this.btnHelp, "edit.password");
        this.display.makeHeavy();
        this.basicOptions = new CBPanel();
        this.basicOptions.setBorder(new TitledBorder(CBIntText.get("Password Editor")));
        this.basicOptions.addln(this.pwdLabel);
        this.basicOptions.addln(this.pwdField);
        this.basicOptions.addln(this.pwdConfirmLabel);
        this.basicOptions.addln(this.pwdConfirm);
        this.basicOptions.add(this.comboType);
        this.advanced = new CBButton(CBIntText.get("Advanced Editor"), CBIntText.get("Go to the advanced password editor"));
        this.basicOptions.add(this.advanced);
        this.advanced.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                userpasswordeditor.this.showAdvancedUI(true);
            }
        });
        this.advancedOptions = new CBPanel();
        this.advancedOptions.makeHeavy();
        this.advancedOptions.setBorder(new TitledBorder(CBIntText.get("Advanced Password Editor")));
        this.advancedOptions.addln(new JLabel(CBIntText.get("Enter Password") + ":"));
        this.advanced_pwd = new JTextField(100);
        this.advancedOptions.addln(this.advanced_pwd);
        this.advancedOptions.addln(new JLabel(CBIntText.get("salt (ascii)") + ":"));
        this.salt_ascii = new JTextField(100);
        this.advancedOptions.addln(this.salt_ascii);
        this.advancedOptions.addln(new JLabel(CBIntText.get("salt (base64)") + ":"));
        this.salt_base64 = new JTextField(100);
        this.advancedOptions.addln(this.salt_base64);
        this.advancedOptions.addln(new JLabel(CBIntText.get("base64 hash value:") + ":"));
        this.base64result = new JTextField(200);
        this.advancedOptions.addln(this.base64result);
        this.advancedOptions.addln(new JLabel(CBIntText.get("ldap value") + ":"));
        this.ldapValueResult = new JTextField("");
        this.advancedOptions.addln(this.ldapValueResult);
        this.advancedOptions.addln(new JLabel(CBIntText.get("ldif value") + ":"));
        this.ldifValueResult = new JTextField(200);
        this.advancedOptions.addln(this.ldifValueResult);
        this.advancedAlgSelection = new CBJComboBox();
        for (String algorithm : supportedAlgorithms) {
            this.advancedAlgSelection.addItem(algorithm);
        }
        this.advancedAlgSelection.setEditable(false);
        this.advancedAlgSelection.setSelectedIndex(default_encryption - 1);
        this.advancedAlgSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                default_encryption = userpasswordeditor.this.advancedAlgSelection.getSelectedIndex() + 1;
            }
        });
        this.advancedOptions.add(this.advancedAlgSelection);
        this.test = new CBButton(CBIntText.get("Test"), CBIntText.get("Test generation of password and optional salt before sending to the directory"));
        this.advancedOptions.add(this.test);
        this.clear = new CBButton(CBIntText.get("Clear"), CBIntText.get("Clear all fields"));
        this.advancedOptions.add(this.clear);
        this.basic = new CBButton(CBIntText.get("Basic Editor"), CBIntText.get("Return to the basic password editor"));
        this.advancedOptions.addln(this.basic);
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                userpasswordeditor.this.clearAdvancedTextFields();
            }
        });
        this.basic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                userpasswordeditor.this.showAdvancedUI(false);
            }
        });
        this.test.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                userpasswordeditor.this.testAdvancedUIForConsistentData();
            }
        });
        this.display.addln(this.basicOptions);
        this.display.addln(this.advancedOptions);
        this.display.makeLight();
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.btnOK);
        buttonPanel.add(this.btnCancel);
        buttonPanel.add(this.btnHelp);
        this.display.addln(buttonPanel);
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "enter");
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
        this.display.getActionMap().put("enter", new MyAction(10));
        this.display.getActionMap().put("escape", new MyAction(27));
        this.setSize(450, 600);
        CBUtility.center(this, owner);
        this.setTitle(CBIntText.get("User Password Data"));
        this.display.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add(this.display);
        if (this.comboType.getSelectedIndex() == 0) {
            this.setNewPwdFieldEnabled(false);
        } else {
            this.setNewPwdFieldEnabled(true);
        }
        this.showAdvancedUI(defaultToShowAdvancedUI);
    }

    protected void clearAdvancedTextFields() {
        this.advanced_pwd.setText("");
        this.salt_ascii.setText("");
        this.salt_base64.setText("");
        this.base64result.setText("");
        this.ldapValueResult.setText("");
        this.ldifValueResult.setText("");
    }

    protected void setNewPwdFieldEnabled(boolean enabled) {
        this.pwdConfirm.setFocusable(enabled);
        this.pwdConfirm.setEnabled(enabled);
        this.pwdConfirmLabel.setEnabled(enabled);
        if (enabled) {
            this.pwdConfirm.setBackground(Color.white);
        } else {
            this.pwdConfirm.setBackground(Color.lightGray);
        }
    }

    public void setValue(editablebinary editMe) {
        this.editMe = editMe;
        String pwdString = this.stringEncode(editMe.getValue());
        this.pwdField.setText(pwdString);
        try {
            this.setAdvancedUIFromLdapValue(pwdString);
        }
        catch (NoSuchAlgorithmException e) {
            new CBErrorWin((Dialog)this, CBIntText.get("unknown algorithm in pwd value:  " + pwdString + "\n" + e.getMessage()), (Exception)e);
        }
    }

    protected byte[] plainDecode(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, "Unexpected error encoding password ", e);
            e.printStackTrace();
            return new byte[0];
        }
    }

    protected boolean usesSalt(String algorithm) {
        return algorithm.startsWith(SSHA) || algorithm.equals(SMD5);
    }

    protected byte[] getLDAPValueBytes(String algorithm, String password, byte[] salt) {
        if (algorithm.equals(VERIFY)) {
            return this.plainDecode(password);
        }
        try {
            if (this.usesSalt(algorithm) && (salt == null || salt.length == 0)) {
                throw new InvalidParameterException("algorithm requires salt");
            }
            String ldapValue = this.getLdapValue(algorithm, password, salt);
            return ldapValue.getBytes("UTF-8");
        }
        catch (InvalidParameterException e) {
            new CBErrorWin((Dialog)this, CBIntText.get("password salt required"), (Exception)e);
            return new byte[0];
        }
        catch (UnsupportedEncodingException e) {
            new CBErrorWin((Dialog)this, CBIntText.get("Unexpected error encoding password") + " :\n" + e.getMessage(), (Exception)e);
            log.log(Level.WARNING, "Unexpected error encoding password ", e);
            e.printStackTrace();
            return new byte[0];
        }
        catch (NoSuchAlgorithmException e) {
            new CBErrorWin((Dialog)this, CBIntText.get("Unsupported Alogrithm exception") + ":\n" + e.getMessage(), (Exception)e);
            log.log(Level.WARNING, "Unsupported Alogrithm exception", e);
            e.printStackTrace();
            return new byte[0];
        }
    }

    protected String getLdapValue(String algorithm, String password, byte[] salt) throws NoSuchAlgorithmException {
        byte[] buff = this.generateRawPasswordHash(algorithm, password, salt);
        return this.constructLdapValue(algorithm, salt, buff);
    }

    private String constructLdapValue(String algorithm, byte[] salt, byte[] passwordHash) {
        StringBuffer ldapValue = new StringBuffer();
        ldapValue.append(this.getLDAPAlgorithmName(algorithm));
        if (salt != null) {
            int x;
            byte[] new_buf = new byte[passwordHash.length + salt.length];
            for (x = 0; x < passwordHash.length; ++x) {
                new_buf[x] = passwordHash[x];
            }
            for (x = passwordHash.length; x < new_buf.length; ++x) {
                new_buf[x] = salt[x - passwordHash.length];
            }
            ldapValue.append(CBBase64.toBase64(new_buf));
        } else {
            ldapValue.append(CBBase64.binaryToString(passwordHash));
        }
        return ldapValue.toString();
    }

    protected byte[] generateRawPasswordHash(String algorithm, String password, byte[] salt) throws NoSuchAlgorithmException {
        String messageDigestAlgorithmName = this.usesSalt(algorithm) ? algorithm.substring(1) : algorithm;
        MessageDigest md = MessageDigest.getInstance(messageDigestAlgorithmName);
        md.reset();
        try {
            md.update(password.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            md.update(password.getBytes());
        }
        if (salt != null) {
            md.update(salt);
        }
        return md.digest();
    }

    protected String stringEncode(byte[] b) {
        if (b == null || b.length == 0) {
            return new String();
        }
        try {
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, "Unexpected error decoding password ", e);
            e.printStackTrace();
            return new String(b);
        }
    }

    protected void setAdvancedUIFromLdapValue(String ldapValue) throws NoSuchAlgorithmException {
        this.ldapValueResult.setText(ldapValue);
        this.ldifValueResult.setText("userPassword: " + CBBase64.toBase64(this.editMe.getValue()));
        String algorithm = this.getJavaAlgorithmName(ldapValue);
        byte[] hash = this.getPasswordHashFromLdapValue(algorithm, ldapValue);
        byte[] salt = this.getSalt(algorithm, ldapValue);
        this.salt_base64.setText(CBBase64.toBase64(salt));
        this.base64result.setText(CBBase64.toBase64(hash));
        if (userpasswordeditor.isPrintableAscii(salt)) {
            this.salt_ascii.setText(new String(salt));
        }
        this.advancedAlgSelection.setSelectedItem(algorithm);
    }

    protected boolean testAdvancedUIForConsistentData() {
        String algorithm = this.advancedAlgSelection.getSelectedItem().toString();
        String newPassword = this.advanced_pwd.getText();
        byte[] salt = null;
        if (newPassword.trim().length() == 0) {
            try {
                if (this.ldapValueResult.getText().length() > 0) {
                    this.setAdvancedUIFromLdapValue(this.ldapValueResult.getText());
                } else if (this.base64result.getText().length() > 0) {
                    byte[] pwdHash = CBBase64.decode(this.base64result.getText().trim());
                    if (pwdHash.length != this.getHashLengthInBytes(algorithm)) {
                        throw new NoSuchAlgorithmException("hash length (" + pwdHash.length + ") does not match length of " + algorithm + " algorithm (" + this.getHashLengthInBytes(algorithm) + ")");
                    }
                    if (this.usesSalt(algorithm) && (salt = this.getSalt(algorithm)) == null) {
                        throw new NoSuchAlgorithmException("algorithm " + algorithm + " requires a salt");
                    }
                    String ldapValue = this.constructLdapValue(algorithm, salt, pwdHash);
                    this.ldapValueResult.setText(ldapValue);
                    this.ldifValueResult.setText("userpassword: " + CBBase64.toBase64(ldapValue.getBytes("UTF-8")));
                } else if (this.ldifValueResult.getText().length() > 0) {
                    String ldifData = this.ldifValueResult.getText().substring(14);
                    String ldapValue = new String(CBBase64.decode(ldifData), "UTF-8");
                    this.setAdvancedUIFromLdapValue(ldapValue);
                }
            }
            catch (Exception e) {
                new CBErrorWin((Dialog)this, CBIntText.get("error parsing directly entered values:\n" + e.getMessage()), e);
                return false;
            }
            return true;
        }
        try {
            if (this.usesSalt(algorithm)) {
                salt = this.getSalt(algorithm);
                if (salt == null) {
                    salt = this.getRandomSalt(algorithm);
                    this.salt_base64.setText(CBBase64.toBase64(salt));
                }
            } else {
                this.salt_ascii.setText("");
                this.salt_base64.setText("");
            }
            if (algorithm.equals(PLAINTEXT)) {
                this.advanced_pwd.setText(newPassword);
                this.ldapValueResult.setText(newPassword);
                this.base64result.setText("");
                this.ldifValueResult.setText("userpassword: " + CBBase64.toBase64(newPassword.getBytes("UTF-8")));
                return true;
            }
            byte[] pwdHash = this.generateRawPasswordHash(algorithm, newPassword, salt);
            this.base64result.setText(CBBase64.toBase64(pwdHash));
            String ldapValue = this.getLdapValue(algorithm, newPassword, salt);
            this.ldapValueResult.setText(ldapValue);
            this.ldifValueResult.setText("userpassword: " + CBBase64.toBase64(ldapValue.getBytes("UTF-8")));
            return true;
        }
        catch (UnsupportedEncodingException e) {
        }
        catch (CBBase64EncodingException e) {
            new CBErrorWin((Dialog)this, CBIntText.get("error parsing base64 encoded salt:\n" + this.salt_base64.getText()), (Exception)e);
        }
        catch (NoSuchAlgorithmException e) {
            new CBErrorWin((Dialog)this, CBIntText.get("unexpected error working with algorithm type {" + algorithm + "} :\n" + this.salt_base64.getText()), (Exception)e);
        }
        return false;
    }

    private byte[] getSalt(String algorithm) throws UnsupportedEncodingException, CBBase64EncodingException {
        byte[] salt = null;
        if (this.salt_ascii.getText().length() > 1) {
            salt = this.salt_ascii.getText().getBytes("UTF-8");
            this.salt_base64.setText(CBBase64.toBase64(salt));
        } else if (this.salt_base64.getText().length() > 1 && userpasswordeditor.isPrintableAscii(salt = CBBase64.decode(this.salt_base64.getText()))) {
            this.salt_ascii.setText(new String(salt));
        }
        return salt;
    }

    public static boolean isPrintableAscii(byte[] salt) {
        if (salt == null) {
            return false;
        }
        for (byte b : salt) {
            if (b >= 32 || b <= 126) continue;
            return false;
        }
        return true;
    }

    protected void displayAdvancedData() {
        if (this.editMe == null || this.editMe.getValue() == null) {
            return;
        }
        String oldPwdValue = this.stringEncode(this.editMe.getValue());
        try {
            this.setAdvancedUIFromLdapValue(oldPwdValue);
        }
        catch (NoSuchAlgorithmException e) {
            log.warning("unsupported password algorithm encountered. " + e.getMessage());
        }
    }

    protected void load() {
        block13: {
            if (testMode) {
                System.exit(0);
            }
            if (this.basicOptions.isVisible()) {
                if (this.comboType.getSelectedIndex() == 0) {
                    String newPasswordText = this.pwdField.getText();
                    String oldPasswordLDAPValue = this.stringEncode(this.editMe.getValue());
                    try {
                        if (this.passwordVerify(oldPasswordLDAPValue, newPasswordText)) {
                            JOptionPane.showMessageDialog(this.display, CBIntText.get("Password verified."), CBIntText.get("Password Verification."), 1);
                            break block13;
                        }
                        JOptionPane.showMessageDialog(this.display, CBIntText.get("Password not verified."), CBIntText.get("Password Verification."), 1);
                    }
                    catch (NoSuchAlgorithmException e) {
                        new CBErrorWin((Dialog)this, CBIntText.get("unknown password algorithm"), (Exception)e);
                    }
                } else if (this.passwordConfirm()) {
                    byte[] salt = null;
                    String algorithm = this.comboType.getSelectedItem().toString();
                    if (this.usesSalt(algorithm)) {
                        salt = this.getRandomSalt(algorithm);
                    }
                    this.editMe.setValue(this.getLDAPValueBytes(algorithm, this.pwdConfirm.getText(), salt));
                    this.quit();
                }
            } else if (this.testAdvancedUIForConsistentData()) {
                try {
                    this.editMe.setValue(this.ldapValueResult.getText().getBytes("UTF-8"));
                    System.out.println("Setting pwd value to: " + this.ldapValueResult.getText());
                    this.quit();
                }
                catch (UnsupportedEncodingException e) {
                    log.severe("Serious error - java has forgotten how to parse UTF-8");
                }
            }
        }
    }

    protected byte[] getRandomSalt(String algorithm) {
        byte[] salt = null;
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            salt = new byte[this.getHashLengthInBytes(algorithm)];
            random.nextBytes(salt);
        }
        catch (NoSuchAlgorithmException e) {
            log.log(Level.WARNING, "Unexpected error encoding password ", e);
            e.printStackTrace();
        }
        return salt;
    }

    protected String getLDAPAlgorithmName(String algorithm) {
        return "{" + algorithm.replace("-", "") + "}";
    }

    protected String getJavaAlgorithmName(String userPasswordValue) throws NoSuchAlgorithmException {
        if (!userPasswordValue.startsWith("{")) {
            return PLAINTEXT;
        }
        String algorithm = "unable to parse hash: " + userPasswordValue;
        try {
            algorithm = userPasswordValue.substring(1, userPasswordValue.indexOf(125));
            for (String supportedAlgorithm : supportedAlgorithms) {
                if (!algorithm.equalsIgnoreCase(supportedAlgorithm)) continue;
                return supportedAlgorithm;
            }
            algorithm = algorithm.replace(SHA, "SHA-");
            for (String supportedAlgorithm : supportedAlgorithms) {
                if (!algorithm.equalsIgnoreCase(supportedAlgorithm)) continue;
                return supportedAlgorithm;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new NoSuchAlgorithmException("unsupported hash algorithm: " + algorithm);
    }

    protected int getHashLengthInBytes(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm.equals(MD5) || algorithm.equals(SMD5)) {
            return 16;
        }
        if (algorithm.equals(SHA) || algorithm.equals(SSHA)) {
            return 20;
        }
        if (algorithm.equals(SHA256) || algorithm.equals(SSHA256)) {
            return 32;
        }
        if (algorithm.equals(SHA512) || algorithm.equals(SSHA512)) {
            return 64;
        }
        throw new NoSuchAlgorithmException("algorithm {" + algorithm + "} is unsupported");
    }

    protected byte[] getPasswordHashFromLdapValue(String algorithm, String ldapPasswordValue) throws NoSuchAlgorithmException {
        if (ldapPasswordValue != null && ldapPasswordValue.length() > 0) {
            try {
                String ldapAlgorithm = this.getLDAPAlgorithmName(algorithm);
                String encodedSection = ldapPasswordValue.substring(ldapAlgorithm.length()).trim();
                byte[] cryptData = CBBase64.stringToBinary(encodedSection);
                int hashLength = this.getHashLengthInBytes(algorithm);
                byte[] hash = new byte[hashLength];
                for (int i = 0; i < hashLength; ++i) {
                    hash[i] = cryptData[i];
                }
                return hash;
            }
            catch (Exception e) {
                log.warning("unable to parse ldapPasswordValue: " + ldapPasswordValue + ": " + e.getMessage());
            }
        }
        return null;
    }

    protected byte[] getSalt(String algorithm, String ldapPasswordValue) throws NoSuchAlgorithmException {
        int len;
        if (!this.usesSalt(algorithm)) {
            return null;
        }
        String ldapAlgorithm = this.getLDAPAlgorithmName(algorithm);
        byte[] cryptData = CBBase64.stringToBinary(ldapPasswordValue.substring(ldapAlgorithm.length()).trim());
        int hashLength = this.getHashLengthInBytes(algorithm);
        if (cryptData != null && (len = cryptData.length - hashLength) > 0) {
            byte[] salt = new byte[len];
            for (int x = 0; x < len; ++x) {
                salt[x] = cryptData[x + hashLength];
            }
            return salt;
        }
        log.warning("No Salt found for password value: " + ldapPasswordValue);
        return null;
    }

    protected boolean passwordVerify(String oldPasswordLDAPValue, String newPassword) throws NoSuchAlgorithmException {
        String algorithm = this.getJavaAlgorithmName(oldPasswordLDAPValue);
        byte[] salt = null;
        if (this.usesSalt(algorithm)) {
            salt = this.getSalt(algorithm, oldPasswordLDAPValue);
        }
        byte[] pwdHash = this.getLDAPValueBytes(algorithm, newPassword, salt);
        String newPwdLdapValue = this.getLdapValue(algorithm, newPassword, salt);
        return newPwdLdapValue.equals(oldPasswordLDAPValue);
    }

    protected boolean passwordConfirm() {
        if (this.pwdConfirm.getText().equals(this.pwdField.getText())) {
            return true;
        }
        if (this.pwdConfirm.getText().equals("")) {
            JOptionPane.showMessageDialog(this.display, CBIntText.get("Empty password field, please fill in both fields"), CBIntText.get("Warning message"), 1);
            this.pwdConfirm.setText("");
            return false;
        }
        JOptionPane.showMessageDialog(this.display, CBIntText.get("Password typed incorrectly, please try again"), CBIntText.get("Warning message"), 1);
        this.pwdConfirm.setText("");
        return false;
    }

    protected void quit() {
        this.setVisible(false);
        this.dispose();
        if (testMode) {
            System.exit(0);
        }
    }

    protected void showAdvancedUI(boolean value) {
        defaultToShowAdvancedUI = value;
        this.advancedOptions.setVisible(value);
        this.basicOptions.setVisible(!value);
        if (value) {
            this.setSize(new Dimension(600, 450));
            this.displayAdvancedData();
        } else {
            this.setSize(new Dimension(320, 240));
        }
    }

    private class MyAction
    extends CBAction {
        public MyAction(int key) {
            super(key);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.getKey() == 27) {
                userpasswordeditor.this.quit();
            } else if (this.getKey() == 10) {
                userpasswordeditor.this.load();
            }
        }
    }
}

