/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.editor;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBPanel;
import com.ca.directory.jxplorer.editor.abstractstringeditor;
import com.ca.directory.jxplorer.editor.editablestring;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class generalizedtimeeditor
extends CBDialog
implements abstractstringeditor {
    private static final int FEBRUARY = 2;
    private String[] months = new String[]{"--", CBIntText.get("January"), CBIntText.get("February"), CBIntText.get("March"), CBIntText.get("April"), CBIntText.get("May"), CBIntText.get("June"), CBIntText.get("July"), CBIntText.get("August"), CBIntText.get("September"), CBIntText.get("October"), CBIntText.get("November"), CBIntText.get("December")};
    private int[] daysInMonth = new int[]{0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private Calendar rightNow = Calendar.getInstance();
    private editablestring editableString = null;
    private CBButton btnNow = new CBButton(CBIntText.get("Now"), CBIntText.get("Display the present date & time."));
    private JCheckBox checkBox = new JCheckBox(CBIntText.get("UTC"));
    private JLabel yearLabel = new JLabel(CBIntText.get("Year") + ":");
    private WholeNumberField yearTextField = new WholeNumberField(2001, 4);
    private JLabel monthLabel = new JLabel(CBIntText.get("Month") + ":");
    private CBJComboBox monthCombo = new CBJComboBox();
    private JLabel dayLabel = new JLabel(CBIntText.get("Day") + ":");
    private CBJComboBox dayCombo = new CBJComboBox();
    private JLabel hourLabel = new JLabel(CBIntText.get("Hour") + ":");
    private CBJComboBox hourCombo = new CBJComboBox();
    private JLabel minuteLabel = new JLabel(CBIntText.get("Minute") + ":");
    private CBJComboBox minuteCombo = new CBJComboBox();
    private JLabel secondLabel = new JLabel(CBIntText.get("Second") + ":");
    private CBJComboBox secondCombo = new CBJComboBox();
    private JLabel milliSecondLabel = new JLabel(CBIntText.get("Millisecond") + ":");
    private CBJComboBox milliSecondCombo = new CBJComboBox();
    private int userMonth;
    private int userYear;
    private int userDay;
    private int userHour;
    private int userMinute;
    private int userSecond;
    private int userMilliSecond;
    private int numDays = 0;
    private int dateIndexBackup = 0;
    private String value = null;
    private boolean isTableEditor = true;
    private String time = "";
    private static final Logger log = Logger.getLogger(generalizedtimeeditor.class.getName());

    public generalizedtimeeditor(Frame owner, String value, boolean isTableEditor) {
        super(owner, CBIntText.get("Generalized Time"), "edit.time");
        this.isTableEditor = isTableEditor;
        this.value = value;
        this.display.addln(new JLabel(" "));
        this.display.makeLight();
        this.initDateTimeVariables();
        this.initMilliSeconds();
        this.initSeconds();
        this.initMinutes();
        this.initHours();
        this.initDays(31);
        this.initMonths();
        if (value.indexOf("Z") != -1) {
            this.checkBox.setSelected(true);
        }
        this.checkBox.setToolTipText(CBIntText.get("Adds a 'Z' to the end of the generalized time."));
        this.btnNow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                generalizedtimeeditor.this.displayCurrent();
            }
        });
        this.monthCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                generalizedtimeeditor.this.updateDayCombo();
            }
        });
        MyDocumentListener myDocumentListener = new MyDocumentListener();
        this.yearTextField.getDocument().addDocumentListener(myDocumentListener);
        CBPanel dateTimePanel = new CBPanel();
        dateTimePanel.add(this.dayLabel);
        dateTimePanel.add(this.dayCombo);
        dateTimePanel.add(this.monthLabel);
        dateTimePanel.addWide(this.monthCombo, 2);
        dateTimePanel.add(this.yearLabel);
        dateTimePanel.addWide(this.yearTextField, 2);
        dateTimePanel.addln(new JLabel(" "));
        dateTimePanel.addln(new JLabel(" "));
        dateTimePanel.newLine();
        dateTimePanel.add(this.hourLabel);
        dateTimePanel.add(this.hourCombo);
        dateTimePanel.add(this.minuteLabel);
        dateTimePanel.add(this.minuteCombo);
        dateTimePanel.add(new JLabel(" "));
        dateTimePanel.add(this.secondLabel);
        dateTimePanel.add(this.secondCombo);
        dateTimePanel.add(new JLabel(" "));
        dateTimePanel.add(this.milliSecondLabel);
        dateTimePanel.add(this.milliSecondCombo);
        dateTimePanel.setBorder(new TitledBorder(CBIntText.get("Date/Time")));
        CBPanel btnPanel = new CBPanel();
        btnPanel.makeLight();
        btnPanel.addln(this.btnNow);
        btnPanel.addln(this.checkBox);
        this.setSelectedIndexes();
        this.display.makeHeavy();
        this.display.add(dateTimePanel);
        this.display.makeHigh();
        this.display.add(btnPanel);
        this.display.newLine();
        this.display.makeHeavy();
        this.display.addln(new JLabel("  "));
        this.setSize(500, 200);
        this.numDays = this.getDaysInMonth(this.userMonth);
    }

    protected void initDateTimeVariables() {
        int size = 0;
        try {
            size = this.value.length();
        }
        catch (Exception e) {
            size = 0;
        }
        try {
            this.userMonth = Integer.parseInt(this.value.substring(4, 6));
            this.userYear = Integer.parseInt(this.value.substring(0, 4));
            this.userDay = Integer.parseInt(this.value.substring(6, 8));
            this.userHour = Integer.parseInt(this.value.substring(8, 10));
            this.userMinute = Integer.parseInt(this.value.substring(10, 12));
            if (size > 13) {
                this.userSecond = Integer.parseInt(this.value.substring(12, 14));
            }
            if (this.value.indexOf(".") == 14) {
                int zIndex = this.value.indexOf("Z");
                String milli = null;
                if (zIndex == 16) {
                    milli = this.value.substring(15, 16) + "00";
                } else if (zIndex == 17) {
                    milli = this.value.substring(15, 17) + "0";
                } else if (size == 18 || zIndex == 18) {
                    milli = this.value.substring(15, 18);
                } else if (size == 17) {
                    milli = this.value.substring(15, 17) + "0";
                } else if (size == 16) {
                    milli = this.value.substring(15, 16) + "00";
                }
                this.userMilliSecond = Integer.parseInt(milli);
            }
        }
        catch (Exception e) {
            this.userMonth = 0;
            this.userYear = 0;
            this.userDay = 0;
            this.userHour = 0;
            this.userMinute = 0;
            this.userSecond = 0;
            this.userMilliSecond = 0;
        }
    }

    protected int getDaysInMonth(int month) {
        return this.daysInMonth[month] + (this.isLeapYear(this.getUserYear()) && this.userMonth == 2 ? 1 : 0);
    }

    protected void displayCurrent() {
        this.rightNow = Calendar.getInstance();
        this.userYear = this.rightNow.get(1);
        this.userMonth = this.rightNow.get(2) + 1;
        this.userDay = this.rightNow.get(5);
        this.userHour = this.rightNow.get(11);
        this.userMinute = this.rightNow.get(12);
        this.userSecond = this.rightNow.get(13);
        this.userMilliSecond = this.rightNow.get(14);
        this.yearTextField.setText(String.valueOf(this.userYear));
        this.monthCombo.setSelectedIndex(this.userMonth);
        this.dayCombo.setSelectedIndex(this.userDay);
        this.hourCombo.setSelectedIndex(this.userHour);
        this.minuteCombo.setSelectedIndex(this.userMinute);
        this.secondCombo.setSelectedIndex(this.userSecond);
        this.milliSecondCombo.setSelectedIndex(this.userMilliSecond);
    }

    protected void setSelectedIndexes() {
        this.yearTextField.setText(String.valueOf(this.userYear));
        if (this.userMonth <= 13) {
            this.monthCombo.setSelectedIndex(this.userMonth);
        } else {
            this.userMonth = 0;
        }
        if (this.userDay <= this.getDaysInMonth(this.userMonth)) {
            this.dayCombo.setSelectedIndex(this.userDay);
        }
        if (this.userHour <= 23) {
            this.hourCombo.setSelectedIndex(this.userHour);
        }
        if (this.userMinute <= 59) {
            this.minuteCombo.setSelectedIndex(this.userMinute);
        }
        if (this.userSecond <= 59) {
            this.secondCombo.setSelectedIndex(this.userSecond);
        }
        if (this.userMilliSecond <= 999) {
            this.milliSecondCombo.setSelectedIndex(this.userMilliSecond);
        }
    }

    protected void initMilliSeconds() {
        for (int i = 0; i < 1000; ++i) {
            this.milliSecondCombo.addItem(new Integer(i));
        }
    }

    protected void initSeconds() {
        for (int i = 0; i < 60; ++i) {
            this.secondCombo.addItem(new Integer(i));
        }
    }

    protected void initMinutes() {
        for (int i = 0; i < 60; ++i) {
            this.minuteCombo.addItem(new Integer(i));
        }
    }

    protected void initHours() {
        for (int i = 0; i < 24; ++i) {
            this.hourCombo.addItem(new Integer(i));
        }
    }

    protected void initDays(int days) {
        for (int i = 0; i <= days; ++i) {
            if (i == 0) {
                this.dayCombo.addItem("--");
                continue;
            }
            this.dayCombo.addItem(new Integer(i));
        }
    }

    protected void initMonths() {
        for (int i = 0; i < 13; ++i) {
            this.monthCombo.addItem(this.months[i]);
        }
    }

    protected void updateDayCombo() {
        int dayPos = this.dayCombo.getSelectedIndex();
        this.userMonth = this.monthCombo.getSelectedIndex();
        this.dayCombo.removeAllItems();
        this.numDays = this.getDaysInMonth(this.userMonth);
        this.initDays(this.numDays);
        if (dayPos > -1) {
            this.setDayComboSelectedIndex(dayPos);
            this.dateIndexBackup = dayPos;
        } else {
            this.setDayComboSelectedIndex(this.dateIndexBackup);
        }
        this.dayCombo.revalidate();
    }

    protected int getUserYear() {
        int userYearInt = 0;
        try {
            userYearInt = Integer.parseInt(this.yearTextField.getText(), 10);
        }
        catch (Exception e) {
            if (this.yearTextField.getText().length() != 0) {
                JOptionPane.showMessageDialog(this, CBIntText.get("Please enter a valid year."), CBIntText.get("Invalid Year"), 1);
            }
            this.userYear = 0;
            this.yearTextField.setText(String.valueOf(this.userYear));
        }
        if (userYearInt > 1581) {
            this.userYear = userYearInt;
        }
        return this.userYear;
    }

    protected void setDayComboSelectedIndex(int index) {
        try {
            this.dayCombo.setSelectedIndex(index);
        }
        catch (Exception e) {
            int items = this.dayCombo.getItemCount();
            this.dayCombo.setSelectedIndex(items - 1);
        }
    }

    public boolean isLeapYear(int year) {
        if (year % 100 == 0) {
            return year % 400 == 0;
        }
        return year % 4 == 0;
    }

    protected String getSelectedYear() {
        String year = this.yearTextField.getText();
        int len = year.length();
        switch (len) {
            case 0: {
                year = "0000";
                break;
            }
            case 1: {
                year = "000" + year;
                break;
            }
            case 2: {
                year = "00" + year;
                break;
            }
            case 3: {
                year = "0" + year;
                break;
            }
            case 4: {
                break;
            }
            default: {
                year = year.substring(0, 4);
            }
        }
        return year;
    }

    protected String getSelectedMonth() {
        int selection = this.monthCombo.getSelectedIndex();
        String month = Integer.toString(selection);
        if (selection < 10) {
            month = "0" + month;
        }
        return month;
    }

    protected String getSelectedDay() {
        int selection = this.dayCombo.getSelectedIndex();
        String day = Integer.toString(selection);
        if (selection < 10) {
            day = "0" + day;
        }
        return day;
    }

    protected String getSelectedHour() {
        int selection = this.hourCombo.getSelectedIndex();
        String hour = Integer.toString(selection);
        if (selection < 10) {
            hour = "0" + hour;
        }
        return hour;
    }

    protected String getSelectedMinute() {
        int selection = this.minuteCombo.getSelectedIndex();
        String minute = Integer.toString(selection);
        if (selection < 10) {
            minute = "0" + minute;
        }
        return minute;
    }

    protected String getSelectedSecond() {
        int selection = this.secondCombo.getSelectedIndex();
        String second = Integer.toString(selection);
        if (selection < 10) {
            second = "0" + second;
        }
        return second;
    }

    protected String getSelectedMilliSecond() {
        int selection = this.milliSecondCombo.getSelectedIndex();
        if (selection == 0) {
            return "";
        }
        String milliSecond = Integer.toString(selection);
        if (selection < 10) {
            milliSecond = "00" + milliSecond;
        }
        if (selection < 100 && selection > 9) {
            milliSecond = "0" + milliSecond;
        }
        return "." + milliSecond;
    }

    public void setStringValue(editablestring editString) {
        this.editableString = editString;
    }

    public void doOK() {
        String date = this.getSelectedYear() + this.getSelectedMonth() + this.getSelectedDay() + this.getSelectedHour() + this.getSelectedMinute() + this.getSelectedSecond() + this.getSelectedMilliSecond();
        if (this.checkBox.isSelected()) {
            date = date + "Z";
        }
        if (this.isTableEditor) {
            this.editableString.setStringValue(date);
        } else {
            this.time = date;
        }
        this.setVisible(false);
        this.dispose();
    }

    public void doCancel() {
        if (!this.isTableEditor) {
            this.time = this.value;
        }
        super.doCancel();
    }

    public String getTime() {
        return this.time;
    }

    class WholeNumberField
    extends JTextField {
        private NumberFormat integerFormatter;

        public WholeNumberField(int value, int columns) {
            super(columns);
            this.integerFormatter = NumberFormat.getNumberInstance(Locale.getDefault());
            this.integerFormatter.setParseIntegerOnly(true);
            this.integerFormatter.setGroupingUsed(false);
            this.setValue(value);
        }

        public int getValue() {
            int retVal = 0;
            try {
                retVal = this.integerFormatter.parse(this.getText()).intValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return retVal;
        }

        public void setValue(int value) {
            this.setText(this.integerFormatter.format(value));
        }

        protected Document createDefaultModel() {
            return new WholeNumberDocument();
        }

        protected class WholeNumberDocument
        extends PlainDocument {
            protected WholeNumberDocument() {
            }

            public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
                char[] source = str.toCharArray();
                char[] result = new char[source.length];
                int j = 0;
                for (int i = 0; i < result.length; ++i) {
                    if (Character.isDigit(source[i])) {
                        result[j++] = source[i];
                        continue;
                    }
                    log.warning("Invalid data, you can't enter '" + source[i] + "' (from " + str + ") into a year field.");
                }
                super.insertString(offs, new String(result, 0, j), a);
            }
        }
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            this.checkDate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.checkDate(e);
        }

        public void changedUpdate(DocumentEvent e) {
        }

        private void checkDate(DocumentEvent e) {
            try {
                int index = generalizedtimeeditor.this.monthCombo.getSelectedIndex();
                if (index == 2) {
                    generalizedtimeeditor.this.updateDayCombo();
                }
            }
            catch (Exception ee) {
                log.log(Level.WARNING, "Problem getting the selected month from the drop down box in the Generalized Time editor. ", e);
            }
        }
    }
}

