/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.broker;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.jndi.ConnectionData;
import com.ca.commons.jndi.JNDIOps;
import com.ca.commons.jndi.SchemaOps;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.broker.CBGraphicsOps;
import com.ca.directory.jxplorer.broker.DataBroker;
import com.ca.directory.jxplorer.broker.DataQuery;
import com.ca.directory.jxplorer.broker.Special;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;

public class JNDIDataBroker
extends DataBroker {
    private static final int SEARCHLIMIT = 0;
    private static final int SEARCHTIMEOUT = 0;
    public static final int SEARCH_BASE_OBJECT = 0;
    public static final int SEARCH_ONE_LEVEL = 1;
    public static final int SEARCH_SUB_TREE = 2;
    public static final String[] RETURN_ONLY_DN = new String[]{"1.1"};
    public static final String RETURN_ALL_ENTRIES = "(objectClass=*)";
    private LdapContext ctx;
    private boolean tracing = false;
    private boolean connectionError = true;
    private Hashtable attributeNames;
    private boolean quietMode = false;
    private boolean errorWhileQuietFlag = false;
    int limit = 0;
    int timeout = 0;
    boolean pagedResults = false;
    static int threadID = 1;
    static final boolean DEBUGTHREADS = false;
    private CBGraphicsOps dirOps = null;
    private SchemaOps schemaOps;
    private HashSet specialObjectClasses;
    private static final Logger log = Logger.getLogger(JNDIDataBroker.class.getName());
    protected static boolean lockReadOnly = false;
    protected boolean readOnly = false;

    public static void lockToReadOnlyMode() {
        lockReadOnly = true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public JNDIDataBroker() {
        this.initSpecialObjectClasses();
    }

    public JNDIDataBroker(JNDIDataBroker cloneMe) {
        this.registerDirectoryConnection(cloneMe);
    }

    public void registerDirectoryConnection(JNDIDataBroker cloneMe) {
        this.ctx = cloneMe.ctx;
        this.tracing = cloneMe.tracing;
        this.connectionError = cloneMe.connectionError;
        this.attributeNames = cloneMe.attributeNames;
        this.limit = cloneMe.limit;
        this.timeout = cloneMe.timeout;
        this.pagedResults = cloneMe.pagedResults;
        this.dirOps = cloneMe.dirOps;
        this.schemaOps = cloneMe.schemaOps;
        this.readOnly = cloneMe.readOnly;
        this.specialObjectClasses = cloneMe.specialObjectClasses;
    }

    protected void initSpecialObjectClasses() {
        String fileName = System.getProperty("user.dir") + File.separator + "specialocs.txt";
        if (new File(fileName).exists()) {
            try {
                String text = CBUtility.readTextFile(new File(fileName));
                StringTokenizer st = new StringTokenizer(text);
                this.specialObjectClasses = new HashSet(10);
                while (st.hasMoreTokens()) {
                    String oc = st.nextToken();
                    this.specialObjectClasses.add(oc);
                }
            }
            catch (Exception e) {
                log.info("unable to obtain special object classes list:\n  " + e.toString());
                this.specialObjectClasses = null;
            }
        }
    }

    public void setGUIQuiet(boolean status) {
        this.quietMode = status;
        this.dirOps.setQuietMode(status);
        if (!this.quietMode) {
            this.setQuietError(false);
        }
    }

    public void setQuietError(boolean status) {
        this.errorWhileQuietFlag = status;
    }

    public boolean getQuietError() {
        return this.errorWhileQuietFlag || this.dirOps.errorWhileQuietFlag;
    }

    public void setTracing(boolean traceStatus) {
        this.tracing = traceStatus;
    }

    public boolean getTracing() {
        return this.tracing;
    }

    public DataQuery connect(String baseDN, int version, String host, int port, String userDN, char[] pwd, String referralType, String aliasType, boolean useSSL, String cacerts, String clientcerts, char[] caKeystorePwd, char[] clientKeystorePwd) {
        ConnectionData cData = new ConnectionData();
        cData.setURL(host, port);
        cData.baseDN = baseDN;
        cData.version = version;
        cData.setURL(host, port);
        cData.userDN = userDN;
        cData.pwd = pwd;
        cData.referralType = referralType;
        cData.aliasType = aliasType;
        cData.useSSL = useSSL;
        cData.cacerts = cacerts;
        cData.clientcerts = clientcerts;
        cData.caKeystorePwd = caKeystorePwd;
        cData.clientKeystorePwd = clientKeystorePwd;
        cData.tracing = this.getTracing();
        return this.connect(cData);
    }

    public DataQuery connect(ConnectionData cData) {
        cData.caKeystoreType = JXConfig.getProperty("keystoreType.cacerts", "JKS");
        cData.clientKeystoreType = JXConfig.getProperty("keystoreType.clientcerts", "JKS");
        DataConnectionQuery openCon = new DataConnectionQuery(cData);
        return this.push(openCon);
    }

    protected void processRequest(DataQuery request) {
        try {
            if (request instanceof DataConnectionQuery) {
                this.openConnection((DataConnectionQuery)request);
            } else {
                super.processRequest(request);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setException(e);
        }
    }

    protected DataQuery openConnection(DataConnectionQuery request) {
        this.disconnect();
        ConnectionData cData = request.conData;
        try {
            this.openConnection(cData);
        }
        catch (Exception ne) {
            log.warning("initial receipt of exception by jndi broker " + ne.getMessage());
            ne.printStackTrace();
            request.setException(ne);
            request.setStatus(false);
            request.finish();
            return request;
        }
        request.setStatus(true);
        request.finish();
        return request;
    }

    public void openTestConnection(LdapContext testCtx) throws Exception {
        this.ctx = testCtx;
        this.dirOps = new CBGraphicsOps(this.ctx);
    }

    public void openConnection(ConnectionData cData) throws Exception {
        String base;
        String url = cData.url;
        this.connectionError = false;
        this.ctx = null;
        this.dirOps = new CBGraphicsOps(cData);
        this.ctx = this.dirOps.getContext();
        if (this.ctx == null) {
            throw new NamingException("unable to open connection: unknown condition, no error returned.");
        }
        String string = base = cData.baseDN == null ? "" : cData.baseDN;
        if (!this.dirOps.exists(base)) {
            cData.baseDN = this.getActualDN(cData.baseDN);
        }
        try {
            this.schemaOps = new SchemaOps(this.ctx);
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "unable to init schemaOps Ops ", e);
            this.schemaOps = null;
        }
        if (this.schemaOps != null && (cData.protocol == "dsml" || cData.version > 2)) {
            try {
                String binaries = this.schemaOps.getNewBinaryAttributes();
                if (binaries.trim() != "") {
                    this.ctx.addToEnvironment("java.naming.ldap.attributes.binary", binaries);
                }
                this.initAttributeNamesHash();
            }
            catch (NamingException e) {
                log.log(Level.WARNING, "Failed to connect to schemaOps: " + url, e);
            }
        } else {
            log.info("skipped schemaOps stuff : " + cData.protocol);
        }
        if (cData.protocol.equalsIgnoreCase("dsml")) {
            log.info("Successfully connected to " + url + " using " + cData.protocol + " version 2");
        } else {
            log.info("Successfully connected to " + url + " using " + cData.protocol + " version " + cData.version);
        }
    }

    public String getActualDN(String dn) {
        return dn;
    }

    protected void initAttributeNamesHash() {
        this.attributeNames = new Hashtable(100);
        try {
            Attribute attDefs = this.schemaOps.getAttributeTypes();
            if (attDefs == null) {
                log.warning("unable to read schema attributes in JNDIDataBroker:initAttributeNamesHash");
                return;
            }
            for (int i = 0; i < attDefs.size(); ++i) {
                String parseMe = attDefs.get(i).toString();
                int namePos = parseMe.indexOf("NAME");
                if (namePos == -1) {
                    throw new NamingException("unable to parse ldap syntax '" + parseMe + "'");
                }
                String oid = parseMe.substring(1, namePos).trim();
                String names = "";
                if (parseMe.indexOf("SYNTAX") > -1) {
                    names = parseMe.substring(parseMe.indexOf("'", namePos), parseMe.indexOf("SYNTAX") - 2);
                }
                StringTokenizer tokenizer = new StringTokenizer(names, "'");
                while (tokenizer.hasMoreElements()) {
                    String name = tokenizer.nextToken().trim();
                    if (name.length() <= 0) continue;
                    this.attributeNames.put(oid, name);
                }
            }
        }
        catch (NamingException e) {
            log.warning("unable to parse schemaOps at JndiBroker:initAttributeNamesHash " + e + "\n");
        }
        catch (Exception e2) {
            log.warning("Unexpected exception parsing schemaOps at JndiBroker:initAttributeNamesHash " + e2 + "\n");
            e2.printStackTrace();
        }
    }

    public String getAttributeDescription(String attributeoid) {
        if (this.attributeNames == null) {
            return "(schemaOps not correctly read)";
        }
        String attributeName = (String)this.attributeNames.get(attributeoid);
        if (attributeName == null) {
            attributeName = "(attribute not listed in schemaOps)";
        }
        return attributeName;
    }

    public int getVersion() {
        return this.dirOps.getLdapVersion();
    }

    public void printContextList(Context C, DN dn, String message) {
        System.out.println("******* " + message + " ******\nPrinting context '" + dn + "'");
        try {
            NamingEnumeration<NameClassPair> debug = C.list(dn);
            while (debug.hasMore()) {
                System.out.println(debug.next().getName());
            }
        }
        catch (NamingException e) {
            System.out.println("error printing context " + dn + "( " + message + " )" + e);
        }
    }

    public void disconnect() {
        this.attributeNames = null;
        this.ctx = null;
        this.schemaOps = null;
        if (this.dirOps == null) {
            return;
        }
        try {
            this.dirOps.close();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        this.dirOps = null;
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
    }

    public void setLimit(int maxResponses) {
        this.limit = maxResponses;
    }

    public void setTimeout(int maxTime) {
        this.timeout = maxTime;
    }

    public void setPaging(boolean usePaging, int pageSize) {
        this.pagedResults = usePaging;
        if (usePaging) {
            JNDIOps.setPageSize(pageSize);
        } else {
            JNDIOps.setPageSize(-1);
        }
    }

    public DXNamingEnumeration unthreadedList(DN searchbase) {
        this.SetContextToBrowsingAliases();
        try {
            return new DXNamingEnumeration(this.dirOps.list(searchbase));
        }
        catch (NamingException e) {
            this.error("unable to list " + searchbase, e);
            return new DXNamingEnumeration();
        }
    }

    public DXNamingEnumeration unthreadedSearch(DN dn, String filter, int search_level, String[] returnAttributes) {
        DXNamingEnumeration ret;
        block5: {
            this.SetContextToSearchingAliases();
            try {
                if (search_level == 0) {
                    ret = new DXNamingEnumeration(this.dirOps.searchBaseEntry(dn, filter, this.limit, this.timeout, returnAttributes));
                    break block5;
                }
                if (search_level == 1) {
                    ret = new DXNamingEnumeration(this.dirOps.searchOneLevel(dn, filter, this.limit, this.timeout, returnAttributes));
                    break block5;
                }
                if (search_level == 2) {
                    ret = new DXNamingEnumeration(this.dirOps.searchSubTree(dn, filter, this.limit, this.timeout, returnAttributes));
                    break block5;
                }
                return null;
            }
            catch (NamingException e) {
                this.error("unable to search " + dn, e);
                return new DXNamingEnumeration();
            }
        }
        this.SetContextToBrowsingAliases();
        return ret;
    }

    public synchronized Attributes read(DN dn) {
        Attributes atts = null;
        try {
            atts = this.dirOps.read(dn);
        }
        catch (NamingException e) {
            this.error("unable to read " + dn, e);
        }
        return new DXAttributes(atts);
    }

    public void deleteTree(DN nodeDN) throws NamingException {
        if (this.readOnly) {
            throw new NamingException(CBIntText.get("JXplorer is in read only mode; no directory modifications allowed"));
        }
        this.dirOps.deleteTree(nodeDN);
    }

    public void moveTree(DN oldNodeDN, DN newNodeDN) throws NamingException {
        if (this.readOnly) {
            throw new NamingException(CBIntText.get("JXplorer is in read only mode; no directory modifications allowed"));
        }
        this.dirOps.moveTree(oldNodeDN, newNodeDN);
    }

    public void unthreadedCopy(DN oldNodeDN, DN newNodeDN) throws NamingException {
        if (this.readOnly) {
            throw new NamingException(CBIntText.get("JXplorer is in read only mode; no directory modifications allowed"));
        }
        this.dirOps.copyTree(oldNodeDN, newNodeDN, true);
    }

    public boolean unthreadedExists(DN checkMe) throws NamingException {
        return this.dirOps.exists(checkMe);
    }

    public boolean processQueue() {
        boolean ret;
        if (this.dirOps != null) {
            this.dirOps.setQuietMode(true);
        }
        if (!(ret = super.processQueue())) {
            return false;
        }
        if (this.dirOps != null) {
            this.dirOps.setQuietMode(false);
        }
        return true;
    }

    public Exception getException() {
        return this.dirOps.quietException;
    }

    public void clearException() {
        this.dirOps.quietException = null;
    }

    protected DataQuery finish(DataQuery request) {
        request.setException(this.dirOps.quietException);
        request.finish();
        return request;
    }

    public boolean isActive() {
        return this.ctx != null;
    }

    public boolean hasConnectionError() {
        return this.ctx == null || this.connectionError;
    }

    public DXEntry unthreadedReadEntry(DN entryDN, String[] returnAttributes) throws NamingException {
        DXAttributes atts = new DXAttributes(this.dirOps.read(entryDN, returnAttributes));
        return new DXEntry(atts, entryDN);
    }

    public void addEntry(DXEntry newEntry) throws NamingException {
        if (newEntry.getDN() == null) {
            throw new NamingException("Internal Error: Entry with null DN passed to JNDIDataBroker addEntry().  Modify Request Cancelled.");
        }
        this.dirOps.addEntry(newEntry.getDN(), (Attributes)newEntry);
    }

    protected int loadMods(ModificationItem[] mods, NamingEnumeration atts, int TYPE, int index) throws NamingException {
        while (atts.hasMore()) {
            Attribute temp = (Attribute)atts.next();
            mods[index++] = new ModificationItem(TYPE, temp);
        }
        return index;
    }

    public void unthreadedModify(DXEntry oldEntry, DXEntry newEntry) throws NamingException {
        if (this.readOnly) {
            throw new NamingException(CBIntText.get("JXplorer is in read only mode; no directory modifications allowed"));
        }
        if (this.useSpecialWriteAllAttsMode()) {
            this.doSpecialWriteAllAttsHandling(oldEntry, newEntry);
        } else {
            this.dirOps.modifyEntry(oldEntry, newEntry);
        }
    }

    private void doSpecialWriteAllAttsHandling(DXEntry oldEntry, DXEntry newEntry) throws NamingException {
        if (newEntry == null || oldEntry == null && newEntry.getStatus() == 1) {
            this.dirOps.modifyEntry(oldEntry, newEntry);
        }
        if (!oldEntry.getDN().toString().equals(newEntry.getDN().toString())) {
            this.moveTree(oldEntry.getDN(), newEntry.getDN());
        }
        if (DXAttributes.attributesEqual(oldEntry, newEntry)) {
            return;
        }
        DN nodeDN = newEntry.getDN();
        RDN newRDN = nodeDN.getLowestRDN();
        DXAttributes adds = null;
        DXAttributes reps = null;
        DXAttributes dels = null;
        try {
            reps = this.hasVerboseObjectClass(newEntry) ? Special.getReplacementSet(newRDN, oldEntry, newEntry) : new DXAttributes();
            dels = Special.getDeletionSet(newRDN, oldEntry, newEntry);
            adds = Special.getAdditionSet(newRDN, oldEntry, newEntry);
            log.fine("updateNode: " + nodeDN);
            ModificationItem[] mods = new ModificationItem[dels.size() + reps.size() + adds.size()];
            int modIndex = 0;
            modIndex = this.loadMods(mods, dels.getAll(), 3, modIndex);
            modIndex = this.loadMods(mods, adds.getAll(), 1, modIndex);
            modIndex = this.loadMods(mods, reps.getAll(), 2, modIndex);
            this.dirOps.modifyAttributes(nodeDN, mods);
        }
        catch (Exception e) {
            NamingException os390 = new NamingException("SPECIAL OS390 MODE ERROR: Unexpected Error updating node " + oldEntry.getDN() + "! " + e.toString());
            os390.initCause(e);
            throw os390;
        }
    }

    protected boolean useSpecialWriteAllAttsMode() {
        return this.specialObjectClasses != null;
    }

    protected boolean hasVerboseObjectClass(Attributes atts) {
        if (this.specialObjectClasses == null) {
            return false;
        }
        try {
            Attribute oc = !(atts instanceof DXAttributes) ? atts.get("objectClass") : ((DXAttributes)atts).getAllObjectClasses();
            NamingEnumeration<?> ocs = oc.getAll();
            while (ocs.hasMore()) {
                Object test = ocs.next();
                if (!this.specialObjectClasses.contains(test)) continue;
                return true;
            }
            return false;
        }
        catch (NamingException e) {
            log.warning("error getting object classes in jndibroker " + e);
            return false;
        }
    }

    public boolean isModifiable() {
        return !this.readOnly;
    }

    public String getSchemaRoot() {
        if (this.ctx == null) {
            return "";
        }
        String fnord = "";
        try {
            fnord = this.ctx.getSchema("").toString();
            return fnord;
        }
        catch (NamingException e) {
            log.warning("error reading schemaOps\n" + e);
            return "cn=schemaOps";
        }
    }

    public ArrayList unthreadedGetRecOCs(DN dn) {
        return this.schemaOps.getRecommendedObjectClasses(dn.toString());
    }

    public void modifyAttributes(DN dn, ModificationItem[] mods) throws NamingException {
        if (this.ctx == null) {
            throw new NamingException("no directory context to work with");
        }
        if (this.readOnly) {
            throw new NamingException(CBIntText.get("JXplorer is in read only mode; no directory modifications allowed"));
        }
        this.ctx.modifyAttributes(dn, mods);
    }

    public void error(String msg, Exception e) {
        if (!this.quietMode) {
            CBUtility.error(msg, e);
        } else {
            this.errorWhileQuietFlag = true;
            log.warning(msg + "\n   (details) " + e.toString());
        }
    }

    public LdapContext getLdapContext() throws NamingException {
        if (this.readOnly) {
            throw new NamingException(CBIntText.get("JXplorer is in read only mode; no directory modifications allowed"));
        }
        return this.dirOps == null ? null : this.dirOps.getContext();
    }

    public void addToEnvironment(String key, String value) throws NamingException {
        if (this.dirOps == null || this.dirOps.getContext() == null) {
            throw new NamingException("Unable to set environement variables; no valid environment found");
        }
        this.dirOps.getContext().addToEnvironment(key, value);
    }

    public DN[] readFallbackRoot() {
        log.finer("reading fallback root DN...");
        try {
            DXEntry a = this.unthreadedReadEntry(new DN(""), new String[]{"namingContexts"});
            if (a == null) {
                return null;
            }
            log.finer("...Got root DSE data...");
            Attribute rootDNC = a.get("namingcontexts");
            if (rootDNC == null) {
                rootDNC = a.get("namingContexts");
            }
            if (rootDNC == null || rootDNC.size() == 0) {
                return new DN[]{new DN()};
            }
            if (rootDNC.size() == 1) {
                String rootDNString = rootDNC.get().toString();
                log.info("read fallback root DN as: " + rootDNString);
                return new DN[]{new DN(rootDNString)};
            }
            DN[] contexts = new DN[rootDNC.size()];
            int index = 0;
            NamingEnumeration<?> roots = rootDNC.getAll();
            while (roots.hasMoreElements()) {
                String dn = roots.nextElement().toString();
                contexts[index++] = new DN(dn);
            }
            return contexts;
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "Error reading fallback root: ", e);
            return null;
        }
    }

    public void SetContextToSearchingAliases() {
        try {
            if (this.ctx != null) {
                this.ctx.addToEnvironment("java.naming.ldap.derefAliases", JXConfig.getProperty("option.ldap.searchAliasBehaviour"));
            }
        }
        catch (Exception e) {
            log.warning("Unexpected Exception setting search alias handling behaviour in context to " + JXConfig.getProperty("option.ldap.searchAliasBehaviour") + "\n    " + e);
        }
    }

    public void SetContextToBrowsingAliases() {
        try {
            if (this.ctx != null) {
                this.ctx.addToEnvironment("java.naming.ldap.derefAliases", JXConfig.getProperty("option.ldap.browseAliasBehaviour"));
            }
        }
        catch (Exception e) {
            log.warning("Unexpected exception setting browse alias handling behaviour in context to " + JXConfig.getProperty("option.ldap.browseAliasBehaviour") + "\n    " + e);
        }
    }

    public SchemaOps getSchemaOps() {
        return this.schemaOps;
    }

    public String id() {
        return "JNDIDataBroker " + this.id;
    }

    public class DataConnectionQuery
    extends DataQuery {
        public final ConnectionData conData;

        public DataConnectionQuery(ConnectionData cData) {
            super(256);
            this.conData = cData;
            this.setExtendedData("version", String.valueOf(this.conData.version));
            this.setExtendedData("url", this.conData.getURL());
            JNDIDataBroker.this.readOnly = lockReadOnly ? true : this.conData.readOnly;
        }

        public String getTypeString() {
            return super.getTypeString() + " Connection Request";
        }
    }
}

