/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.broker;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.CBpbar;
import com.ca.commons.jndi.SchemaOps;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.RDN;
import com.ca.directory.jxplorer.DataListener;
import com.ca.directory.jxplorer.SwingDataListener;
import com.ca.directory.jxplorer.broker.DataBrokerQueryInterface;
import com.ca.directory.jxplorer.broker.DataBrokerUnthreadedInterface;
import com.ca.directory.jxplorer.broker.DataQuery;
import com.ca.directory.jxplorer.broker.StopMonitor;
import java.util.ArrayList;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.ldap.LdapContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataBroker
implements Runnable,
DataBrokerQueryInterface,
DataBrokerUnthreadedInterface {
    protected Vector requestQueue = new Vector(10);
    protected Vector listeners = new Vector();
    private static int noBrokers = 0;
    public int id = noBrokers++;
    protected DataQuery current = null;
    StopMonitor stopMonitor = null;
    private static boolean debug = false;

    public void registerStopMonitor(StopMonitor monitor) {
        this.stopMonitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataQuery push(DataQuery request) {
        if (debug) {
            System.out.println("Thread: " + Thread.currentThread().getName() + " pushing request: " + request.getTypeString() + ": " + request.toString() + " in broker " + this.id());
            try {
                Thread.sleep(100L);
                Thread.dumpStack();
                Thread.sleep(100L);
            }
            catch (Exception e) {
                // empty catch block
            }
            System.out.println("----------");
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            request.addDataListener(new SwingDataListener((DataListener)this.listeners.get(i)));
        }
        Vector vector = this.requestQueue;
        synchronized (vector) {
            this.requestQueue.add(request);
        }
        if (this.stopMonitor != null) {
            this.stopMonitor.updateWatchers();
        }
        vector = this.requestQueue;
        synchronized (vector) {
            this.requestQueue.notifyAll();
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataQuery pop() {
        DataQuery request = null;
        Vector vector = this.requestQueue;
        synchronized (vector) {
            if (this.requestQueue.isEmpty()) {
                return null;
            }
            request = (DataQuery)this.requestQueue.firstElement();
            if (debug) {
                System.out.println("Thread: " + Thread.currentThread().getName() + " popping request: " + request.getTypeString() + ": " + request.toString() + " in broker " + this.id());
            }
            this.requestQueue.removeElementAt(0);
            request.setRunning();
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuery(DataQuery query) {
        Vector vector = this.requestQueue;
        synchronized (vector) {
            this.requestQueue.remove(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRequests() {
        Vector vector = this.requestQueue;
        synchronized (vector) {
            return !this.requestQueue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            if (debug) {
                System.out.println("Thread: " + Thread.currentThread().getName() + " processing Queue of length: " + this.requestQueue.size() + " in broker " + this.id);
            }
            if (!this.processQueue()) {
                if (debug) {
                    System.out.println("Thread: " + Thread.currentThread().getName() + " ending." + this.requestQueue.size());
                }
                return;
            }
            try {
                if (debug) {
                    System.out.println("Thread: " + Thread.currentThread().getName() + " waiting in run() loop");
                }
                Vector vector = this.requestQueue;
                synchronized (vector) {
                    this.requestQueue.wait();
                }
                if (!debug) continue;
                System.out.println("Thread: " + Thread.currentThread().getName() + " notified in run() loop");
                continue;
            }
            catch (Exception e) {
                if (!debug) continue;
                System.out.println("Thread: " + Thread.currentThread().getName() + " interrupted in run() loop \n    " + e);
                continue;
            }
            break;
        }
    }

    protected boolean processQueue() {
        while (this.hasRequests()) {
            this.current = this.pop();
            if (this.current == null) {
                return true;
            }
            this.processRequest(this.current);
            if (this.stopMonitor != null) {
                this.stopMonitor.updateWatchers();
            }
            if (this.current != null && this.current.isCancelled()) {
                return false;
            }
            this.current = null;
        }
        return true;
    }

    protected void processRequest(DataQuery request) {
        if (debug) {
            System.out.println("Thread: " + Thread.currentThread().getName() + " process request " + request.id);
        }
        if (request.isCancelled()) {
            request.finish();
            return;
        }
        try {
            if (!this.isActive()) {
                request.setException(new Exception("No Data Connection Enabled"));
            }
            if (debug) {
                System.out.println("Thread: " + Thread.currentThread().getName() + " process request " + request.id + " of type " + request.getTypeString());
            }
            switch (request.getType()) {
                case 1: {
                    this.doExistsQuery(request);
                    break;
                }
                case 2: {
                    this.doEntryQuery(request);
                    break;
                }
                case 4: {
                    this.doListQuery(request);
                    break;
                }
                case 8: {
                    this.doSearchQuery(request);
                    break;
                }
                case 16: {
                    this.doModifyQuery(request);
                    break;
                }
                case 32: {
                    this.doCopyQuery(request);
                    break;
                }
                case 64: {
                    this.doCopyBetweenWindowsQuery(request);
                    break;
                }
                case 128: {
                    this.doGetRecOCsQuery(request);
                    break;
                }
                case 256: {
                    this.doExtendedQuery(request);
                    break;
                }
                default: {
                    throw new NamingException("JX Internal Error: Unknown Data DataBroker Request type: " + request.getType());
                }
            }
        }
        catch (Exception e) {
            request.setException(e);
        }
        request.finish();
    }

    @Override
    public DataQuery getChildren(DN nodeDN) {
        return this.push(new DataQuery(4, nodeDN));
    }

    @Override
    public DataQuery getEntry(DN nodeDN) {
        return this.push(new DataQuery(2, nodeDN));
    }

    @Override
    public DataQuery exists(DN nodeDN) {
        return this.push(new DataQuery(1, nodeDN));
    }

    @Override
    public DataQuery getRecommendedObjectClasses(DN dn) {
        return this.push(new DataQuery(128, dn));
    }

    @Override
    public DataQuery modifyEntry(DXEntry oldEntry, DXEntry newEntry) {
        return this.push(new DataQuery(16, oldEntry, newEntry));
    }

    @Override
    public DataQuery copyTree(DN oldNodeDN, DN newNodeDN) {
        return this.push(new DataQuery(32, oldNodeDN, newNodeDN));
    }

    @Override
    public DataQuery copyTreeBetweenWindows(DN sourceNodeDN, DN newNodeDN, DataBrokerUnthreadedInterface sourceData, boolean overwriteExistingData) {
        return this.push(new DataQuery(64, sourceNodeDN, newNodeDN, sourceData, overwriteExistingData));
    }

    @Override
    public DataQuery search(DN nodeDN, String filter, int searchLevel, String[] returnAttributes) {
        return this.push(new DataQuery(8, nodeDN, filter, searchLevel, returnAttributes));
    }

    @Override
    public DataQuery extendedRequest(DataQuery query) {
        return this.push(query);
    }

    @Override
    public void addDataListener(DataListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeDataListener(DataListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    @Override
    public abstract boolean isModifiable();

    @Override
    public abstract LdapContext getLdapContext() throws NamingException;

    @Override
    public abstract boolean isActive();

    @Override
    public abstract SchemaOps getSchemaOps();

    protected DataQuery finish(DataQuery request) {
        if (debug) {
            System.out.println("Thread: " + Thread.currentThread().getName() + " request " + request.id + " finished ");
        }
        request.finish();
        return request;
    }

    public DataQuery getCurrent() {
        return this.current;
    }

    public synchronized Vector getRequestQueue() {
        return this.requestQueue;
    }

    protected DataQuery doExtendedQuery(DataQuery request) throws NamingException {
        request.doExtendedRequest(this);
        return this.finish(request);
    }

    protected DataQuery doExistsQuery(DataQuery request) throws NamingException {
        this.unthreadedExists(request.requestDN());
        request.setStatus(true);
        return this.finish(request);
    }

    protected DataQuery doListQuery(DataQuery request) throws NamingException {
        request.setEnumeration(this.unthreadedList(request.requestDN()));
        return this.finish(request);
    }

    protected DataQuery doEntryQuery(DataQuery request) throws NamingException {
        request.setEntry(this.unthreadedReadEntry(request.requestDN(), null));
        return this.finish(request);
    }

    protected DataQuery doSearchQuery(DataQuery request) throws NamingException {
        DXNamingEnumeration en = this.unthreadedSearch(request.requestDN(), request.filter(), request.searchLevel(), request.returnAttributes());
        request.setEnumeration(en);
        return this.finish(request);
    }

    protected DataQuery doModifyQuery(DataQuery request) throws NamingException {
        this.unthreadedModify(request.oldEntry(), request.newEntry());
        request.setStatus(true);
        return this.finish(request);
    }

    protected DataQuery doCopyQuery(DataQuery request) throws NamingException {
        this.unthreadedCopy(request.oldDN(), request.requestDN());
        request.setStatus(true);
        return this.finish(request);
    }

    protected DataQuery doCopyBetweenWindowsQuery(DataQuery request) throws NamingException {
        this.unthreadedCopyBetweenWindows(request.oldDN(), request.getExternalDataSource(), request.requestDN(), request.overwriteExistingData());
        request.setStatus(true);
        return this.finish(request);
    }

    protected DataQuery doGetRecOCsQuery(DataQuery request) throws NamingException {
        request.setArrayList(this.unthreadedGetRecOCs(request.requestDN()));
        return this.finish(request);
    }

    public Exception getException() {
        return null;
    }

    public void clearException() {
    }

    @Override
    public DataBroker getBroker() {
        return this;
    }

    @Override
    public void unthreadedCopyBetweenWindows(DN oldNodeDN, DataBrokerUnthreadedInterface externalDataSource, DN newNodeDN, boolean overwriteExistingData) throws NamingException {
        if (oldNodeDN == null || newNodeDN == null || externalDataSource == null) {
            return;
        }
        if (!externalDataSource.unthreadedExists(oldNodeDN)) {
            return;
        }
        boolean newNodeExists = this.unthreadedExists(newNodeDN);
        CBpbar progressBar = new CBpbar(CBUtility.getDefaultDisplay(), CBIntText.get("Cross-Window Copy"), CBIntText.get("estimate"));
        if (newNodeExists && oldNodeDN.getLowestRDN().equals(newNodeDN.getLowestRDN())) {
            if (overwriteExistingData) {
                System.out.println("REPLACING");
                this.unthreadedModify(new DXEntry(newNodeDN), null);
                this.unthreadedCopyBetweenWindowsLoop(oldNodeDN, externalDataSource, newNodeDN, progressBar);
            } else {
                System.out.println("MERGING");
                this.unthreadedMergeBetweenWindowsLoop(oldNodeDN, externalDataSource, newNodeDN, progressBar);
            }
        } else {
            System.out.println("COPYING");
            this.unthreadedCopyBetweenWindowsLoop(oldNodeDN, externalDataSource, newNodeDN, progressBar);
        }
    }

    protected void unthreadedCopyBetweenWindowsLoop(DN oldNodeDN, DataBrokerUnthreadedInterface externalDataSource, DN targetDN, CBpbar progressBar) throws NamingException {
        DXEntry newEntry = this.constructNewEntryData(oldNodeDN, externalDataSource, targetDN);
        this.unthreadedModify(null, newEntry);
        ArrayList<DN> children = this.getChildren(oldNodeDN, externalDataSource);
        for (DN childDN : children) {
            String newDNString = childDN.getLowestRDN().toString() + "," + targetDN.toString();
            DN targetChildDN = new DN(newDNString);
            this.unthreadedCopyBetweenWindowsLoop(childDN, externalDataSource, targetChildDN, progressBar);
        }
    }

    protected void unthreadedMergeBetweenWindowsLoop(DN oldNodeDN, DataBrokerUnthreadedInterface externalDataSource, DN targetDN, CBpbar progressBar) throws NamingException {
        DXEntry newEntry = this.constructNewEntryData(oldNodeDN, externalDataSource, targetDN);
        DXEntry existingEntry = null;
        try {
            existingEntry = this.unthreadedReadEntry(targetDN, null);
        }
        catch (NameNotFoundException e) {
            // empty catch block
        }
        this.unthreadedModify(existingEntry, newEntry);
        ArrayList<DN> children = this.getChildren(oldNodeDN, externalDataSource);
        for (DN childDN : children) {
            DN targetChildDN = new DN(childDN.getLowestRDN().toString() + "," + targetDN.toString());
            this.unthreadedMergeBetweenWindowsLoop(childDN, externalDataSource, targetChildDN, progressBar);
        }
    }

    protected DXEntry constructNewEntryData(DN oldNodeDN, DataBrokerUnthreadedInterface externalDataSource, DN targetDN) throws NamingException {
        DXEntry newEntry = externalDataSource.unthreadedReadEntry(oldNodeDN, null);
        newEntry.setDN(targetDN);
        RDN newRDN = targetDN.getLowestRDN();
        RDN oldRDN = oldNodeDN.getLowestRDN();
        if (!oldRDN.equals(newRDN)) {
            String[] atts;
            for (String attributeName : atts = newRDN.getAttIDs()) {
                String val = newRDN.getRawVal(attributeName);
                DXAttribute namingAtt = newEntry.get(attributeName);
                if (namingAtt == null || namingAtt.size() <= 1) {
                    newEntry.put(new BasicAttribute(attributeName, val));
                    continue;
                }
                newEntry.get(attributeName).add(val);
            }
        }
        return newEntry;
    }

    protected ArrayList<DN> getChildren(DN base, DataBrokerUnthreadedInterface externalDataSource) throws NamingException {
        ArrayList<DN> children = new ArrayList<DN>();
        DXNamingEnumeration rawList = externalDataSource.unthreadedList(base);
        while (rawList.hasMoreElements()) {
            NameClassPair child = (NameClassPair)rawList.next();
            DN childDN = new DN(child.getName());
            if (childDN.size() == 1 && base.size() > 0) {
                childDN = new DN(child.getName() + "," + base.toString());
                System.out.println("combining base: " + base + " and child: " + child.getName() + " to get: " + childDN.toString());
            }
            children.add(childDN);
        }
        return children;
    }

    @Override
    public String id() {
        return "DataBroker " + this.id;
    }
}

