/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.broker;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.CBpbar;
import com.ca.commons.jndi.ConnectionData;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.DXOps;
import com.ca.commons.security.JXSSLSocketFactory;
import com.ca.directory.jxplorer.JXConfig;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.naming.Name;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;

public class CBGraphicsOps
extends DXOps {
    public boolean quietMode = false;
    public boolean errorWhileQuietFlag = false;
    public Exception quietException = null;
    private CBpbar pbar = null;
    private static Logger log = Logger.getLogger(CBGraphicsOps.class.getName());

    public CBGraphicsOps(LdapContext ctx) throws NamingException {
        super(ctx);
    }

    public CBGraphicsOps(ConnectionData cData) throws NamingException {
        super(CBGraphicsOps.addSSLFactoryToConnectionData(cData));
    }

    public void setQuietMode(boolean status) {
        this.quietMode = status;
        if (this.quietMode) {
            this.errorWhileQuietFlag = false;
            this.quietException = null;
        }
    }

    public boolean error(String msg, Exception e) {
        if (this.quietMode) {
            this.errorWhileQuietFlag = true;
            this.quietException = e;
            log.warning(msg + "\n  (details) " + (e == null ? "no error details supplied" : e.toString()));
        } else {
            CBUtility.error(msg, e);
        }
        return false;
    }

    public void modifyAttributes(Name dn, ModificationItem[] modList) throws NamingException {
        super.modifyAttributes(dn, modList);
        if ("true".equalsIgnoreCase(JXConfig.getProperty("option.confirmTableEditorUpdates"))) {
            CBUtility.confirm(CBIntText.get("Entry: {0} was successfully updated", new String[]{dn.toString()}));
        }
    }

    public void startOperation(String heading, String operationName) {
        this.pbar = new CBpbar(CBUtility.getDefaultDisplay(), heading, operationName);
    }

    public void stopOperation() {
        super.stopOperation();
        if (this.pbar == null) {
            return;
        }
        this.pbar.close();
        this.pbar = null;
    }

    public void pop() {
        if (this.pbar != null) {
            this.pbar.pop();
        }
    }

    public NamingEnumeration push(NamingEnumeration elements) {
        DXNamingEnumeration DXelements = new DXNamingEnumeration(elements);
        int size = DXelements.size();
        if (this.pbar != null) {
            this.pbar.push(size);
        }
        return DXelements;
    }

    public void push(ArrayList elements) {
        int size = elements.size();
        if (this.pbar != null) {
            this.pbar.push(size);
        }
    }

    public void inc() {
        if (this.pbar != null) {
            this.pbar.inc();
        }
    }

    public static ConnectionData addSSLFactoryToConnectionData(ConnectionData connectionData) throws NamingException {
        if (connectionData.useSSL) {
            try {
                JXSSLSocketFactory.init(connectionData.cacerts, connectionData.clientcerts, connectionData.caKeystorePwd, connectionData.clientKeystorePwd, connectionData.caKeystoreType, connectionData.clientKeystoreType, CBUtility.getDefaultDisplay());
                JXSSLSocketFactory.setDebug(JXConfig.debugLevel >= 9 || JXConfig.debugSSL);
                connectionData.sslSocketFactory = "com.ca.commons.security.JXSSLSocketFactory";
            }
            catch (Exception e) {
                NamingException ne = new NamingException("error pre-initialising SSL for JNDI connection: " + e.toString() + "\ncon: " + connectionData.toString());
                ne.setRootCause(e);
                throw ne;
            }
        }
        return connectionData;
    }
}

