/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBAbout;
import com.ca.commons.cbutil.CBCache;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.Theme;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.security.KeystoreGUI;
import com.ca.directory.jxplorer.AdvancedOptions;
import com.ca.directory.jxplorer.ButtonRegister;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.JXOpenConWin;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.KeystoreOptions;
import com.ca.directory.jxplorer.LdifExport;
import com.ca.directory.jxplorer.LdifImport;
import com.ca.directory.jxplorer.broker.DataBroker;
import com.ca.directory.jxplorer.search.DeleteFilterGUI;
import com.ca.directory.jxplorer.search.ReturnAttributesDialog;
import com.ca.directory.jxplorer.search.SearchExecute;
import com.ca.directory.jxplorer.search.SearchModel;
import com.ca.directory.jxplorer.tree.SmartTree;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MainMenu
extends JMenuBar {
    private static Logger log = Logger.getLogger(MainMenu.class.getName());
    protected JXplorerBrowser browser;
    protected JXOpenConWin getConnection = null;
    protected JMenu fileMenu;
    protected JMenuItem connect;
    protected JMenuItem disconnect;
    protected JMenuItem print;
    protected JMenuItem refreshTree;
    protected JMenuItem newWindow;
    protected JMenuItem closeWindow;
    protected JMenuItem exit;
    protected JMenu editMenu;
    protected JMenuItem cut;
    protected JMenuItem copy;
    protected JMenuItem paste;
    protected JMenuItem delete;
    protected JMenuItem rename;
    protected JMenuItem copyDN;
    protected JMenuItem newEntry;
    protected JMenuItem pasteAlias;
    protected JMenu ldifMenu;
    protected JMenuItem fullExport;
    protected JMenuItem subExport;
    protected JMenuItem importFile;
    protected JMenuItem viewOffline;
    protected JMenu searchMenu;
    protected JMenuItem search;
    protected JMenuItem deleteFilter;
    protected JMenuItem attrList;
    protected JMenu bookmarkMenu;
    protected JMenuItem editBookmark;
    protected JMenuItem addBookmark;
    protected JMenuItem deleteBookmark;
    protected JMenu lookAndFeelMenu;
    protected JMenuItem refresh;
    protected JMenu optionsMenu;
    protected JMenu toolsMenu;
    protected JMenuItem advancedOptions;
    protected JMenu sslMenu;
    protected JMenuItem simpleSSL;
    protected JMenuItem authSSL;
    protected JMenuItem keystoreOptions;
    protected JMenu helpMenu;
    protected JMenuItem helpContents;
    protected JMenuItem helpSearch;
    protected JMenuItem helpAbout;
    protected SmartTree tree;
    public static Properties myProperties;
    public static String propertyFile;
    public static String localDir;
    public static String fileURLPrefix;

    public MainMenu(JXplorerBrowser jxplorerBrowser) {
        this.browser = jxplorerBrowser;
        this.fileMenu = new JMenu(CBIntText.get("File"));
        this.fileMenu.setMnemonic('F');
        this.setupFileMenu(this.fileMenu);
        this.editMenu = new JMenu(CBIntText.get("Edit"));
        this.editMenu.setMnemonic('E');
        this.setupEditMenu(this.editMenu);
        this.lookAndFeelMenu = new JMenu(CBIntText.get("View"));
        this.lookAndFeelMenu.setMnemonic('V');
        this.setupLookAndFeelMenu(this.lookAndFeelMenu);
        this.ldifMenu = new JMenu(CBIntText.get("LDIF"));
        this.ldifMenu.setMnemonic('L');
        this.setupLdifMenu(this.ldifMenu);
        this.searchMenu = new JMenu(CBIntText.get("Search"));
        this.searchMenu.setMnemonic('S');
        this.setupSearchMenu(this.searchMenu);
        this.bookmarkMenu = new JMenu(CBIntText.get("Bookmark"));
        this.bookmarkMenu.setMnemonic('B');
        this.setupBookmarkMenu(this.bookmarkMenu);
        this.optionsMenu = new JMenu(CBIntText.get("Options"));
        this.optionsMenu.setMnemonic('O');
        this.setupOptionsMenu(this.optionsMenu);
        this.toolsMenu = new JMenu(CBIntText.get("Tools"));
        this.toolsMenu.setMnemonic('T');
        this.setupToolsMenu(this.toolsMenu);
        this.sslMenu = new JMenu(CBIntText.get("Security"));
        this.sslMenu.setMnemonic('i');
        this.setupSSLMenu(this.sslMenu);
        this.helpMenu = new JMenu(CBIntText.get("Help"));
        this.helpMenu.setMnemonic('H');
        this.setupHelpMenu(this.helpMenu);
        this.add(this.fileMenu);
        this.add(this.editMenu);
        this.add(this.lookAndFeelMenu);
        this.add(this.bookmarkMenu);
        this.add(this.searchMenu);
        this.add(this.ldifMenu);
        this.add(this.optionsMenu);
        this.add(this.toolsMenu);
        this.add(this.sslMenu);
        this.add(this.helpMenu);
        jxplorerBrowser.setJMenuBar(this);
        this.setDisconnected();
    }

    protected void setupFileMenu(JMenu fileMenu) {
        ActionListener fileListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem src = (JMenuItem)e.getSource();
                MainMenu.this.tree = MainMenu.this.browser.getActiveTree();
                if (src == MainMenu.this.connect) {
                    MainMenu.this.connect();
                } else if (src == MainMenu.this.disconnect) {
                    MainMenu.this.disconnect();
                } else if (src == MainMenu.this.print) {
                    MainMenu.this.print();
                } else if (src == MainMenu.this.refreshTree) {
                    MainMenu.this.browser.mrTree.collapse();
                } else if (src == MainMenu.this.newWindow) {
                    MainMenu.this.browser.parent.createNewBrowser();
                } else if (src == MainMenu.this.closeWindow) {
                    MainMenu.this.browser.closeWindow();
                } else if (src == MainMenu.this.exit) {
                    MainMenu.this.browser.shutdown();
                }
                MainMenu.this.browser.repaint();
            }
        };
        this.connect = this.setMenuItem(fileMenu, fileListener, new String[]{CBIntText.get("Connect"), "C", CBIntText.get("Connect to a directory server."), "E", Theme.getInstance().getDirImages() + "connect.gif"});
        this.disconnect = this.setMenuItem(fileMenu, fileListener, new String[]{CBIntText.get("Disconnect"), "D", CBIntText.get("Disconnect from a directory server."), "E", Theme.getInstance().getDirImages() + "disconnect.gif"});
        this.print = this.setMenuItem(fileMenu, fileListener, new String[]{CBIntText.get("Print"), "P", CBIntText.get("Print out the current entry."), "E", Theme.getInstance().getDirImages() + "print.gif"});
        this.setMenuItem(fileMenu, fileListener, new String[]{"-", "", "", ""});
        this.refreshTree = this.setMenuItem(fileMenu, fileListener, new String[]{CBIntText.get("Refresh Tree"), "R", CBIntText.get("Forces the tree to be reloaded from the directory."), "E", Theme.getInstance().getDirImages() + "refresh_all.gif"});
        this.setMenuItem(fileMenu, fileListener, new String[]{"-", "", "", ""});
        this.newWindow = this.setMenuItem(fileMenu, fileListener, new String[]{CBIntText.get("New Window"), "N", CBIntText.get("Opens a New browser window."), "E", Theme.getInstance().getDirImages() + "new_window.gif"});
        this.closeWindow = this.setMenuItem(fileMenu, fileListener, new String[]{CBIntText.get("Close Window"), "W", CBIntText.get("Closes this browser window."), "E", Theme.getInstance().getDirImages() + "blank.gif"});
        this.setMenuItem(fileMenu, fileListener, new String[]{"-", "", "", ""});
        this.exit = this.setMenuItem(fileMenu, fileListener, new String[]{CBIntText.get("Exit JXplorer"), "x", CBIntText.get("Quit the JXplorer application."), "E", Theme.getInstance().getDirImages() + "blank.gif"});
        ButtonRegister br = this.browser.getButtonRegister();
        br.registerItem("CONNECT", this.connect);
        br.registerItem("DISCONNECT", this.disconnect);
        br.registerItem("PRINT", this.print);
        br.registerItem("REFRESH_TREE", this.refreshTree);
    }

    public void connect() {
        CBCache.cleanCache();
        if (this.getConnection == null) {
            this.getConnection = new JXOpenConWin(this.browser, this.browser.getDisplayLabel(), JXConfig.getProperty("option.ssl.clientcerts"), JXConfig.getProperty("option.ssl.cacerts"), JXConfig.getProperty("option.ldap.referral"), JXConfig.getProperty("option.ldap.searchAliasBehaviour"));
            this.getConnection.setSize(450, 340);
            CBUtility.center(this.getConnection, this.browser);
        } else {
            this.getConnection.reinit(JXConfig.getProperty("option.ssl.clientcerts"), JXConfig.getProperty("option.ssl.cacerts"), JXConfig.getProperty("option.ldap.referral"), JXConfig.getProperty("option.ldap.searchAliasBehaviour"));
        }
        this.getConnection.resetTitleAndPassword();
        this.getConnection.setVisible(true);
    }

    public void setConnected(boolean searchActive) {
        this.editMenu.setEnabled(true);
        this.searchMenu.setEnabled(searchActive);
        this.toolsMenu.setEnabled(true);
        this.bookmarkMenu.setEnabled(true);
    }

    public void disconnect() {
        this.browser.disconnect();
    }

    public void setDisconnected() {
        this.editMenu.setEnabled(false);
        this.searchMenu.setEnabled(false);
        this.toolsMenu.setEnabled(false);
        this.bookmarkMenu.setEnabled(false);
    }

    public void print() {
        this.browser.pushStatus("Printing...");
        this.browser.mainViewer.print();
        this.browser.popStatus();
    }

    public void setupEditMenu(JMenu editMenu) {
        ActionListener editListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                MainMenu.this.tree = MainMenu.this.browser.getActiveTree();
                if (item == MainMenu.this.cut) {
                    MainMenu.this.tree.getPopupTool().cut();
                } else if (item == MainMenu.this.copy) {
                    MainMenu.this.tree.getPopupTool().copy();
                } else if (item == MainMenu.this.paste) {
                    MainMenu.this.tree.getPopupTool().paste();
                } else if (item == MainMenu.this.delete) {
                    MainMenu.this.tree.getPopupTool().delete();
                } else if (item == MainMenu.this.rename) {
                    MainMenu.this.tree.getPopupTool().rename();
                } else if (item == MainMenu.this.copyDN) {
                    MainMenu.this.tree.getPopupTool().copyDN();
                } else if (item == MainMenu.this.newEntry) {
                    MainMenu.this.tree.getPopupTool().newEntry();
                } else if (item == MainMenu.this.pasteAlias) {
                    MainMenu.this.tree.getPopupTool().pasteAlias();
                }
            }
        };
        this.newEntry = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("New"), "Ctrl+N", CBIntText.get("Create a new entry."), "E", Theme.getInstance().getDirImages() + "new.gif"});
        this.copyDN = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("Copy DN"), "Ctrl+Y", CBIntText.get("Copy the Distinguished Name of an entry to the clipboard."), "E", Theme.getInstance().getDirImages() + "copy_dn.gif"});
        this.setMenuItem(editMenu, editListener, new String[]{"-", "", "", ""});
        this.cut = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("Cut Branch"), "Ctrl+U", CBIntText.get("Select a subtree to move."), "E", Theme.getInstance().getDirImages() + "cut.gif"});
        this.copy = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("Copy Branch"), "Ctrl+O", CBIntText.get("Select a subtree to copy."), "E", Theme.getInstance().getDirImages() + "copy.gif"});
        this.paste = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("Paste Branch"), "Ctrl+P", CBIntText.get("Paste a previously selected subtree."), "E", Theme.getInstance().getDirImages() + "paste.gif"});
        this.pasteAlias = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("Paste Alias"), "", CBIntText.get("Paste an Alias."), "E", Theme.getInstance().getDirIcons() + "alias.gif"});
        this.setMenuItem(editMenu, editListener, new String[]{"-", "", "", ""});
        this.delete = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("Delete"), "Ctrl+D", CBIntText.get("Delete an entry."), "E", Theme.getInstance().getDirImages() + "delete.gif"});
        this.rename = this.setMenuItem(editMenu, editListener, new String[]{CBIntText.get("Rename"), "Ctrl+M", CBIntText.get("Rename an entry."), "E", Theme.getInstance().getDirImages() + "rename.gif"});
        ButtonRegister br = this.browser.getButtonRegister();
        br.registerItem("PASTE", this.paste);
        br.registerItem("PASTE_ALIAS", this.pasteAlias);
        br.registerItem("COPY", this.copy);
        br.registerItem("COPY_DN", this.copyDN);
        br.registerItem("CUT", this.cut);
        br.registerItem("DELETE", this.delete);
        br.registerItem("NEW", this.newEntry);
        br.registerItem("RENAME", this.rename);
        br.setItemEnabled("PASTE", false);
        br.setItemEnabled("PASTE_ALIAS", false);
    }

    public void setupLdifMenu(JMenu ldifMenu) {
        ActionListener ldifListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean usingSearch;
                JMenuItem item = (JMenuItem)e.getSource();
                SmartTree activeTree = MainMenu.this.browser.getActiveTree();
                boolean bl = usingSearch = activeTree == MainMenu.this.browser.searchTree;
                if (item == MainMenu.this.fullExport) {
                    MainMenu.this.ldifFullExport(activeTree, usingSearch);
                } else if (item == MainMenu.this.subExport) {
                    MainMenu.this.ldifSubExport(activeTree, usingSearch);
                } else if (item == MainMenu.this.importFile) {
                    MainMenu.this.importFile();
                } else if (item == MainMenu.this.viewOffline) {
                    MainMenu.this.viewOffline();
                }
                MainMenu.this.browser.repaint();
            }
        };
        this.fullExport = this.setMenuItem(ldifMenu, ldifListener, new String[]{CBIntText.get("Export Full Tree"), "x", CBIntText.get("Export an LDIF file of the entire tree."), "E", ""});
        this.subExport = this.setMenuItem(ldifMenu, ldifListener, new String[]{CBIntText.get("Export Subtree"), "p", CBIntText.get("Export an LDIF file of the current subtree."), "E", ""});
        this.importFile = this.setMenuItem(ldifMenu, ldifListener, new String[]{CBIntText.get("Import File"), "I", CBIntText.get("Import an LDIF file into the directory."), "E", ""});
        this.viewOffline = this.setMenuItem(ldifMenu, ldifListener, new String[]{CBIntText.get("View Offline"), "w", CBIntText.get("View an LDIF file off-Line, without adding to a directory."), "E", ""});
        ButtonRegister br = this.browser.getButtonRegister();
        br.registerItem("LDIF", this.fullExport);
        br.registerItem("LDIF", this.subExport);
        br.registerItem("LDIF", this.importFile);
    }

    public void ldifFullExport(SmartTree activeTree, boolean usingSearch) {
        DN base = activeTree.getRootDN();
        DataBroker datasource = activeTree.getDataSource();
        LdifExport export = new LdifExport(base, datasource, this.browser.searchTree, usingSearch, this.browser, "ldif.fileio");
        export.setSize(360, 120);
        export.setTitle(CBIntText.get("Export Full Tree"));
        CBUtility.center(export, this.browser);
        export.setVisible(true);
    }

    public void ldifSubExport(SmartTree activeTree, boolean usingSearch) {
        DN base = activeTree.getCurrentDN();
        DataBroker datasource = activeTree.getDataSource();
        LdifExport export = new LdifExport(base, datasource, this.browser.searchTree, usingSearch, this.browser, "ldif.fileio");
        export.setSize(360, 120);
        export.setTitle(CBIntText.get("Export Subtree"));
        CBUtility.center(export, this.browser);
        export.setVisible(true);
    }

    public void importFile() {
        DataBroker datamodifier;
        if (this.browser.workOffline) {
            datamodifier = this.browser.offlineBroker;
        } else if (this.browser.getJndiBroker().isActive()) {
            datamodifier = this.browser.getJndiBroker();
        } else {
            CBUtility.error(this.browser, "Error: Not Connected! (Did You Want to 'View Offline'?)");
            return;
        }
        LdifImport imp = new LdifImport(datamodifier, this.browser.mrTree, this.browser, null);
        imp.selectAndImportFile();
    }

    public void viewOffline() {
        this.disconnect();
        this.browser.setStatus("Working Offline");
        this.browser.workOffline = true;
        this.browser.offlineBroker.clear();
        this.browser.mrTree.registerDataSource(this.browser.offlineBroker);
        this.browser.mrTree.setRootDN(SmartTree.NODATA_DN);
        LdifImport imp = new LdifImport(this.browser.offlineBroker, this.browser.mrTree, this.browser, null);
        imp.selectAndImportFile();
        this.browser.setTitle(CBIntText.get("JXplorer") + " - " + imp.getFileName());
        ButtonRegister br = this.browser.getButtonRegister();
        br.setItemEnabled("LDIF", true);
        br.setItemEnabled("CUT", true);
        br.setItemEnabled("COPY", true);
        br.setItemEnabled("COPY_DN", true);
        br.setItemEnabled("REFRESH", true);
    }

    protected void setupSearchMenu(JMenu searchMenu) {
        int i;
        final SearchModel sm = new SearchModel();
        searchMenu.removeAll();
        ArrayList<String> list = sm.getFilterNames(5);
        Object[] names = list.toArray();
        Arrays.sort(names, new SearchModel.StringComparator());
        ActionListener searchListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                if (item == MainMenu.this.search) {
                    MainMenu.this.tree = MainMenu.this.browser.getActiveTree();
                    MainMenu.this.tree.openSearch();
                } else if (item == MainMenu.this.deleteFilter) {
                    if (sm.getFilterNames(2).size() == 0) {
                        JOptionPane.showMessageDialog(MainMenu.this.browser, CBIntText.get("There are no filters available to delete."), CBIntText.get("Nothing to Delete"), 1);
                        return;
                    }
                    DeleteFilterGUI dfg = new DeleteFilterGUI(MainMenu.this.browser);
                    dfg.setVisible(true);
                } else if (item == MainMenu.this.attrList) {
                    ReturnAttributesDialog rad = new ReturnAttributesDialog(MainMenu.this.browser);
                    rad.setVisible(true);
                } else {
                    MainMenu.this.doSearch(item.getText(), ((myJMenuItem)item).getToolTipText());
                }
                MainMenu.this.browser.repaint();
            }
        };
        this.search = this.setMenuItem(searchMenu, searchListener, new String[]{CBIntText.get("Search Dialog"), "Ctrl+F", CBIntText.get("Search the directory."), "E", Theme.getInstance().getDirImages() + "find.gif"});
        this.deleteFilter = this.setMenuItem(searchMenu, searchListener, new String[]{CBIntText.get("Delete Filter"), "", CBIntText.get("Delete an existing filter."), "E", Theme.getInstance().getDirImages() + "delete.gif"});
        this.attrList = this.setMenuItem(searchMenu, searchListener, new String[]{CBIntText.get("Return Attributes"), "", CBIntText.get("Opens a dialog that lets you manage the attributes that you wish to be returned in a search."), "E", Theme.getInstance().getDirImages() + "return_attrs.gif"});
        if (names.length > 0) {
            this.setMenuItem(searchMenu, searchListener, new String[]{"-", "", "", "", ""});
        }
        ButtonRegister br = this.browser.getButtonRegister();
        br.registerItem("SEARCH", this.search);
        String[] searchValues = new String[names.length];
        Object[] searchNames = new String[names.length];
        for (i = 0; i < names.length; ++i) {
            String key;
            searchNames[i] = key = names[i].toString();
            searchValues[i] = sm.getLDAPFilter((String)searchNames[i]);
            searchNames[i] = ((String)searchNames[i]).startsWith("JXFilter") ? ((String)searchNames[i]).substring(9) : ((String)searchNames[i]).substring(13);
        }
        if (names.length > 15) {
            searchMenu.add(this.getScrollList(searchNames, searchValues, searchMenu));
        } else {
            for (i = 0; i < names.length; ++i) {
                myJMenuItem searchMenuItem = new myJMenuItem((String)searchNames[i]);
                searchMenuItem.name = searchValues[i];
                this.setMenuItem(searchMenu, searchMenuItem, searchListener, new String[]{"", "", searchValues[i], "E", ""});
            }
        }
    }

    public void doSearch(String name, String filter) {
        SearchModel sm = new SearchModel();
        String baseDN = sm.getValue(name + "." + "baseDN");
        DN dn = baseDN == null ? this.browser.getActiveTree().getCurrentDN() : new DN(baseDN);
        int searchLevel = 2;
        try {
            searchLevel = Integer.parseInt(sm.getValue(name + "." + "searchLevel"));
        }
        catch (NumberFormatException e) {
            searchLevel = 2;
        }
        String retAttrs = sm.getValue(name + "." + "retAttrs");
        String[] retAttrsList = null;
        if (retAttrs == null) {
            retAttrsList = new String[]{"objectClass"};
        } else if (retAttrs.equalsIgnoreCase("None")) {
            retAttrs = null;
        } else {
            retAttrsList = ReturnAttributesDialog.getReturnAttributes(retAttrs);
            sm.openRetAttrDisplay(this.browser, retAttrsList, this.browser.getSearchTree().getDataSource());
        }
        String find = name + "." + "find";
        String search = name + "." + "search";
        String aliasOption = "always";
        if (search.equalsIgnoreCase("false") && find.equalsIgnoreCase("false")) {
            aliasOption = "never";
        } else if (search.equalsIgnoreCase("true") && find.equalsIgnoreCase("false")) {
            aliasOption = "searching";
        } else if (search.equalsIgnoreCase("false") && find.equalsIgnoreCase("true")) {
            aliasOption = "finding";
        }
        log.info("Setting search alias option to: [" + aliasOption + "]");
        JXConfig.setProperty("option.ldap.searchAliasBehaviour", aliasOption);
        SearchExecute.run(this.browser.getSearchTree(), dn, filter, retAttrsList, searchLevel, this.browser.getSearchBroker());
        this.browser.getTreeTabPane().setSelectedComponent(this.browser.getResultsPanel());
    }

    public void setSearchEnabled(boolean state) {
        if (this.searchMenu == null) {
            return;
        }
        int items = this.searchMenu.getItemCount();
        for (int i = 0; i < items; ++i) {
            JMenuItem temp = this.searchMenu.getItem(i);
            if (!(temp instanceof myJMenuItem)) continue;
            temp.setEnabled(state);
        }
        this.searchMenu.repaint();
    }

    public void updateSearchMenu() {
        this.setupSearchMenu(this.searchMenu);
    }

    protected JScrollPane getScrollList(Object[] items, String[] toolTips, JMenu menuType) {
        final Object[] names = items;
        final String[] toolTps = toolTips;
        final JMenu type = menuType;
        final JList list = new JList(names){

            public String getToolTipText(MouseEvent e) {
                int index = this.locationToIndex(e.getPoint());
                if (-1 < index) {
                    return toolTps[index];
                }
                return null;
            }
        };
        list.setToolTipText("");
        list.setBackground(Color.lightGray);
        list.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getSource() == list && !e.getValueIsAdjusting()) {
                    if (type == MainMenu.this.searchMenu) {
                        MainMenu.this.doSearch(names[list.getSelectedIndex()].toString(), toolTps[list.getSelectedIndex()]);
                        MainMenu.this.searchMenu.getPopupMenu().setVisible(false);
                        MainMenu.this.searchMenu.setSelected(false);
                    } else if (type == MainMenu.this.bookmarkMenu) {
                        MainMenu.this.browser.getTreeTabPane().setSelectedIndex(0);
                        MainMenu.this.goToBookmark(toolTps[list.getSelectedIndex()].toString(), MainMenu.this.browser.getActiveTree());
                        MainMenu.this.bookmarkMenu.getPopupMenu().setVisible(false);
                        MainMenu.this.bookmarkMenu.setSelected(false);
                    }
                }
            }
        });
        JScrollPane sp = new JScrollPane(list);
        sp.setPreferredSize(new Dimension(100, 300));
        sp.setMinimumSize(new Dimension(100, 300));
        sp.setAlignmentX(0.0f);
        return sp;
    }

    protected void setupBookmarkMenu(JMenu bookmarkMenu) {
        bookmarkMenu.removeAll();
        ActionListener bookmarkListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                MainMenu.this.browser.getTreeTabPane().setSelectedIndex(0);
                MainMenu.this.tree = MainMenu.this.browser.getActiveTree();
                if (item == MainMenu.this.editBookmark) {
                    MainMenu.this.tree.openEditBookmarkDialog();
                } else if (item == MainMenu.this.addBookmark) {
                    MainMenu.this.tree.openAddBookmarkDialog(MainMenu.this.browser.mrTree.getCurrentDN());
                } else if (item == MainMenu.this.deleteBookmark) {
                    MainMenu.this.tree.openDeleteBookmarkDialog();
                } else {
                    MainMenu.this.goToBookmark(((myJMenuItem)item).name, MainMenu.this.tree);
                }
                MainMenu.this.browser.repaint();
            }
        };
        this.addBookmark = this.setMenuItem(bookmarkMenu, bookmarkListener, new String[]{CBIntText.get("Add Bookmark"), "Ctrl+B", CBIntText.get("Add a bookmark from the current DN."), "E", Theme.getInstance().getDirImages() + "plus.gif"});
        this.deleteBookmark = this.setMenuItem(bookmarkMenu, bookmarkListener, new String[]{CBIntText.get("Delete Bookmark"), "d", CBIntText.get("Delete a bookmark."), "E", Theme.getInstance().getDirImages() + "delete.gif"});
        this.editBookmark = this.setMenuItem(bookmarkMenu, bookmarkListener, new String[]{CBIntText.get("Edit Bookmark"), "i", CBIntText.get("Edit your bookmarks."), "E", Theme.getInstance().getDirImages() + "edit.gif"});
        ButtonRegister br = this.browser.getButtonRegister();
        br.registerItem("BOOKMARKS", this.addBookmark);
        Properties propertyList = CBUtility.readPropertyFile("bookmarks.txt");
        DXNamingEnumeration keys = new DXNamingEnumeration(propertyList.keys());
        if (keys.size() > 0) {
            this.setMenuItem(bookmarkMenu, bookmarkListener, new String[]{"-", "", "", "", ""});
        }
        Hashtable<String, String> bookmarkTable = new Hashtable<String, String>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (!key.toLowerCase().startsWith("dn")) continue;
            bookmarkTable.put(key.substring(key.indexOf(".") + 1), propertyList.getProperty(key));
        }
        DXNamingEnumeration en = new DXNamingEnumeration(bookmarkTable.keys());
        en.sort();
        int size = en.size();
        String[] bookmarkVals = new String[size];
        Object[] bookmarkNams = new String[size];
        int j = 0;
        while (en.hasMore()) {
            bookmarkNams[j] = (String)en.next();
            bookmarkVals[j] = (String)bookmarkTable.get(bookmarkNams[j]);
            ++j;
        }
        if (size > 15) {
            bookmarkMenu.add(this.getScrollList(bookmarkNams, bookmarkVals, bookmarkMenu));
        } else {
            for (int i = 0; i < bookmarkVals.length; ++i) {
                myJMenuItem bookmarkMenuItem = new myJMenuItem((String)bookmarkNams[i]);
                bookmarkMenuItem.name = bookmarkVals[i];
                this.setMenuItem(bookmarkMenu, bookmarkMenuItem, bookmarkListener, new String[]{"", "", CBIntText.get("Go to") + ": " + bookmarkVals[i] + ".", "E", ""});
            }
        }
    }

    public void setBookmarksEnabled(boolean state) {
        if (this.bookmarkMenu == null) {
            return;
        }
        int items = this.bookmarkMenu.getItemCount();
        for (int i = 0; i < items; ++i) {
            JMenuItem temp = this.bookmarkMenu.getItem(i);
            if (!(temp instanceof myJMenuItem)) continue;
            temp.setEnabled(state);
        }
        this.bookmarkMenu.repaint();
    }

    public void updateBookmarkMenu() {
        this.setupBookmarkMenu(this.bookmarkMenu);
    }

    public void goToBookmark(String dn, SmartTree tree) {
        tree.readAndExpandDN(new DN(dn));
    }

    protected void setupLookAndFeelMenu(JMenu lookAndFeelMenu) {
        String status = "false".equals(JXConfig.getProperty("gui.buttonbar")) ? "U" : "C";
        this.setCheckBoxMenu(lookAndFeelMenu, new String[][]{{CBIntText.get("Show Button Bar"), "B", CBIntText.get("Display the shortcut button toolbar."), "E", status, Theme.getInstance().getDirImages() + "blank.gif"}}, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean selected = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                MainMenu.this.browser.buttonBar.setVisible(selected);
                MainMenu.this.browser.repaint();
                JXConfig.setProperty("gui.buttonbar", String.valueOf(selected));
            }
        });
        status = "false".equals(JXConfig.getProperty("gui.searchbar")) ? "U" : "C";
        this.setCheckBoxMenu(lookAndFeelMenu, new String[][]{{CBIntText.get("Show Search Bar"), "w", CBIntText.get("Show the quick search tool bar."), "E", status, Theme.getInstance().getDirImages() + "blank.gif"}}, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean selected = ((JCheckBoxMenuItem)e.getSource()).isSelected();
                MainMenu.this.browser.searchBar.setVisible(selected);
                MainMenu.this.browser.repaint();
                JXConfig.setProperty("gui.searchbar", String.valueOf(selected));
            }
        });
        ActionListener viewListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                MainMenu.this.tree = MainMenu.this.browser.getActiveTree();
                if (item == MainMenu.this.refresh) {
                    MainMenu.this.tree.getPopupTool().refresh();
                }
                MainMenu.this.browser.repaint();
            }
        };
        this.setMenuItem(lookAndFeelMenu, viewListener, new String[]{"-", "", "", "", ""});
        this.refresh = this.setMenuItem(lookAndFeelMenu, viewListener, new String[]{CBIntText.get("Refresh"), "Ctrl+R", CBIntText.get("Refreshes an Entry."), "E", Theme.getInstance().getDirImages() + "refresh.gif"});
        ButtonRegister br = this.browser.getButtonRegister();
        br.registerItem("REFRESH", this.refresh);
    }

    protected void setupOptionsMenu(JMenu optionsMenu) {
        class PropertyCheckBoxMenuItem
        extends JCheckBoxMenuItem {
            final String propName;

            public PropertyCheckBoxMenuItem(String s, String propertyName) {
                super(CBIntText.get(s), true);
                this.propName = propertyName;
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        JXConfig.setProperty(propName, String.valueOf(this.getState()));
                        MainMenu.this.browser.repaint();
                    }
                });
            }

            public void paint(Graphics g) {
                boolean state;
                boolean bl = state = !"false".equalsIgnoreCase(JXConfig.getProperty(this.propName));
                if (state != this.getState()) {
                    this.setState(state);
                }
                super.paint(g);
            }
        }
        PropertyCheckBoxMenuItem confirmOps = new PropertyCheckBoxMenuItem(CBIntText.get("Confirm Tree Operations"), "option.confirmTreeOperations");
        this.setMenuItemState(optionsMenu, confirmOps, "C", CBIntText.get("Prompt the user whenever the tree will be modified?"), true);
        PropertyCheckBoxMenuItem confirmTableEditorUpdates = new PropertyCheckBoxMenuItem(CBIntText.get("Confirm Table Editor Updates"), "option.confirmTableEditorUpdates");
        this.setMenuItemState(optionsMenu, confirmTableEditorUpdates, "T", CBIntText.get("Display message to confirm successful updates in Table Editor?"), true);
        PropertyCheckBoxMenuItem checkSchema = new PropertyCheckBoxMenuItem(CBIntText.get("Ignore Schema Checking"), "option.ignoreSchemaOnSubmission");
        this.setMenuItemState(optionsMenu, checkSchema, "g", CBIntText.get("Don't check entry consistency before submission."), true);
        final JCheckBoxMenuItem browserSearchAliases = new JCheckBoxMenuItem(CBIntText.get("Resolve Aliases while Browsing"));
        this.setMenuItemState(optionsMenu, browserSearchAliases, "A", CBIntText.get("Whether to browse the referenced object, or the alias entry itself."), true);
        browserSearchAliases.setState("finding".equals(JXConfig.getProperty("option.ldap.browseAliasBehaviour")));
        ActionListener optionsListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                if (item == MainMenu.this.advancedOptions) {
                    MainMenu.this.setUpAdvancedOptions();
                }
                MainMenu.this.browser.repaint();
            }
        };
        this.advancedOptions = this.setMenuItem(optionsMenu, optionsListener, new String[]{CBIntText.get("Advanced Options"), "d", CBIntText.get("Open the Advanced Options dialog."), "E", ""});
        browserSearchAliases.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    if (browserSearchAliases.isSelected()) {
                        JXConfig.setProperty("option.ldap.browseAliasBehaviour", "finding");
                        MainMenu.this.browser.getJndiBroker().addToEnvironment("java.naming.ldap.derefAliases", "finding");
                    } else {
                        JXConfig.setProperty("option.ldap.browseAliasBehaviour", "never");
                        MainMenu.this.browser.getJndiBroker().addToEnvironment("java.naming.ldap.derefAliases", "never");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    protected void setUpAdvancedOptions() {
        AdvancedOptions adOpt = new AdvancedOptions(this.browser, this);
        CBUtility.center(adOpt, this.browser);
        adOpt.setVisible(true);
    }

    protected void setupSSLMenu(JMenu sslMenu) {
        ActionListener sslListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                if (item == MainMenu.this.simpleSSL) {
                    KeystoreGUI win = new KeystoreGUI(MainMenu.this.browser, JXConfig.getMyProperties(), JXConfig.getProperty("option.ssl.cacerts"), null, JXConfig.getProperty("keystoreType.cacerts"), CBIntText.get("Manage Your Trusted Server Certificates."), false, "ssl.certs", false);
                    win.setSize(450, 320);
                    CBUtility.center(win, MainMenu.this.browser);
                    win.setVisible(true);
                } else if (item == MainMenu.this.authSSL) {
                    KeystoreGUI win = new KeystoreGUI(MainMenu.this.browser, JXConfig.getMyProperties(), JXConfig.getProperty("option.ssl.clientcerts"), null, JXConfig.getProperty("keystoreType.clientcerts"), CBIntText.get("Manage Your Own Private Keys and Certificates."), true, "ssl.certs", false);
                    win.setSize(450, 440);
                    CBUtility.center(win, MainMenu.this.browser);
                    win.setVisible(true);
                } else if (item == MainMenu.this.keystoreOptions) {
                    KeystoreOptions options = new KeystoreOptions((Frame)MainMenu.this.browser, JXConfig.getMyProperties());
                    options.setSize(530, 260);
                    CBUtility.center(options, MainMenu.this.browser);
                    options.setVisible(true);
                }
                MainMenu.this.browser.repaint();
            }
        };
        this.simpleSSL = this.setMenuItem(sslMenu, sslListener, new String[]{CBIntText.get("Trusted Servers and CAs"), "u", CBIntText.get("Setup which servers you trust for SSL."), "E", Theme.getInstance().getDirImages() + "sslcert.gif"});
        this.authSSL = this.setMenuItem(sslMenu, sslListener, new String[]{CBIntText.get("Client Certificates"), "C", CBIntText.get("Setup client authentication (if available)."), "none".equals(JXConfig.getProperty("authprovider")) ? "D" : "E", Theme.getInstance().getDirImages() + "sslkeycert.gif"});
        this.keystoreOptions = this.setMenuItem(sslMenu, sslListener, new String[]{CBIntText.get("Advanced Keystore Options"), "K", CBIntText.get("Select your keystore locations and the type of keystore to use."), "E", Theme.getInstance().getDirImages() + "blankRec.gif"});
    }

    protected void setupToolsMenu(JMenu toolsMenu) {
        String[][] toolsMenuItems = new String[][]{{CBIntText.get("Stop Action"), "A", CBIntText.get("Stop the currently executing browser action."), "E", Theme.getInstance().getDirImages() + "stop.gif"}};
        this.setMenu(toolsMenu, toolsMenuItems, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String cmd = ((JMenuItem)e.getSource()).getName();
                if (cmd.equals(CBIntText.get("Stop Action"))) {
                    MainMenu.this.browser.getStopMonitor().show();
                }
                MainMenu.this.browser.repaint();
            }
        });
        this.browser.getStopMonitor().addWatcher(toolsMenu.getItem(0));
    }

    protected void setupHelpMenu(JMenu helpMenu) {
        ActionListener helpListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                if (MainMenu.this.browser.getRootJXplorer().helpSystem == null && item != MainMenu.this.helpAbout) {
                    CBUtility.error(MainMenu.this.browser, "Unable to open Help System", null);
                    return;
                }
                if (item == MainMenu.this.helpContents) {
                    MainMenu.this.browser.getRootJXplorer().helpSystem.openTab("TOC");
                } else if (item == MainMenu.this.helpSearch) {
                    MainMenu.this.browser.getRootJXplorer().helpSystem.openTab("Search");
                } else if (item == MainMenu.this.helpAbout) {
                    MainMenu.this.showAboutMessage();
                }
                MainMenu.this.browser.repaint();
            }
        };
        this.helpContents = this.setMenuItem(helpMenu, helpListener, new String[]{CBIntText.get("Contents"), "C", CBIntText.get("Display the help index."), "E", Theme.getInstance().getDirImages() + "content.gif"});
        this.helpSearch = this.setMenuItem(helpMenu, helpListener, new String[]{CBIntText.get("Search"), "r", CBIntText.get("Search help for a keyword."), "E", Theme.getInstance().getDirImages() + "search.gif"});
        this.setMenuItem(helpMenu, helpListener, new String[]{"-", "", "", "", ""});
        this.helpAbout = this.setMenuItem(helpMenu, helpListener, new String[]{CBIntText.get("About JXplorer"), "A", CBIntText.get("General information about JXplorer."), "E", Theme.getInstance().getDirImages() + "about.gif"});
    }

    public void showAboutMessage() {
        File licence = new File(System.getProperty("user.dir") + File.separator + "licence.txt");
        String textBody = JXConfig.version + "\n\n";
        try {
            if (licence.exists()) {
                textBody = CBUtility.readTextFile(licence);
            }
        }
        catch (IOException e) {
            log.severe("unable to read licence file - check 'licence.txt' for CA Open Source licence details");
        }
        textBody = JXConfig.version + "\n" + "\nWritten by: Chris Betts" + "\n            Trudi Ersvaer\n" + "\nThanks to:  Jason Paul" + "\n            Lachlan O'Dea" + "\n            Van Bui\n\n\n" + textBody;
        CBAbout about = new CBAbout(this.browser, textBody, new ImageIcon(Theme.getInstance().getDirTemplates() + "JXAboutBottom.gif"), new ImageIcon(Theme.getInstance().getDirTemplates() + "JXAboutTop.gif"), CBIntText.get("OK"), CBIntText.get("Close this window"), CBIntText.get("About JXplorer"));
        about.setSize(477, 350);
        about.setResizable(true);
        CBUtility.center(about, this.browser);
        about.setVisible(true);
    }

    protected void setMenu(JMenu menu, String[][] menuItems, ActionListener listener) {
        for (int i = 0; i < menuItems.length; ++i) {
            JMenuItem item = this.setMenuItem(menu, listener, menuItems[i]);
        }
    }

    protected JMenuItem setMenuItem(JMenu menu, ActionListener listener, String[] menuItems) {
        if (menuItems[0].equals("-")) {
            menu.add(new JSeparator());
            return null;
        }
        JMenuItem item = new JMenuItem(CBIntText.get(menuItems[0]), new ImageIcon(menuItems[4]));
        item.setName(menuItems[0]);
        return this.setMenuItem(menu, item, listener, menuItems);
    }

    protected JMenuItem setMenuItem(JMenu menu, JMenuItem item, ActionListener listener, String[] menuItems) {
        this.setMenuItemState(menu, item, menuItems[1], menuItems[2], menuItems[3].charAt(0) == 'E');
        if (listener != null) {
            item.addActionListener(listener);
        }
        return item;
    }

    protected void setCheckBoxMenu(JMenu menu, String[][] menuItems, ActionListener listener) {
        for (int i = 0; i < menuItems.length; ++i) {
            if (menuItems[i][0].equals("-")) {
                menu.add(new JSeparator());
                continue;
            }
            JCheckBoxMenuItem tmp = new JCheckBoxMenuItem(menuItems[i][0], new ImageIcon(menuItems[i][5]), menuItems[i][4].charAt(0) == 'C');
            this.setMenuItemState(menu, tmp, menuItems[i][1], menuItems[i][2], menuItems[i][3].charAt(0) == 'E');
            if (listener == null) continue;
            tmp.addActionListener(listener);
        }
    }

    protected void setMenuItemState(JMenu menu, JMenuItem menuItem, String mnemonic, String toolTipText, boolean enabled) {
        if (mnemonic.length() == 1) {
            menuItem.setMnemonic(mnemonic.charAt(0));
        } else if (mnemonic.startsWith("Cnt") || mnemonic.startsWith("cnt") || mnemonic.startsWith("Ctr") || mnemonic.startsWith("ctr")) {
            char C = mnemonic.charAt(mnemonic.length() - 1);
            menuItem.setAccelerator(KeyStroke.getKeyStroke(C, 2, false));
        }
        menuItem.setToolTipText(toolTipText);
        menuItem.setEnabled(enabled);
        menu.add(menuItem);
    }

    public class myJMenuItem
    extends JMenuItem {
        public String name;

        public myJMenuItem(String s) {
            super(s);
        }
    }
}

