/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.Theme;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXAttributes;
import com.ca.directory.jxplorer.ButtonBar;
import com.ca.directory.jxplorer.ButtonRegister;
import com.ca.directory.jxplorer.DataSink;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.MainMenu;
import com.ca.directory.jxplorer.broker.DataBroker;
import com.ca.directory.jxplorer.broker.JNDIDataBroker;
import com.ca.directory.jxplorer.broker.OfflineDataBroker;
import com.ca.directory.jxplorer.broker.SchemaDataBroker;
import com.ca.directory.jxplorer.broker.StopMonitor;
import com.ca.directory.jxplorer.event.JXplorerEvent;
import com.ca.directory.jxplorer.event.JXplorerEventGenerator;
import com.ca.directory.jxplorer.event.JXplorerListener;
import com.ca.directory.jxplorer.search.SearchBar;
import com.ca.directory.jxplorer.tree.SmartModel;
import com.ca.directory.jxplorer.tree.SmartNode;
import com.ca.directory.jxplorer.tree.SmartTree;
import com.ca.directory.jxplorer.viewer.AttributeDisplay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXplorerBrowser
extends JFrame
implements JXplorerEventGenerator {
    JXplorer parent;
    private JFrame rootFrame;
    Container mainPane;
    transient JXplorerListener jxplorerListener;
    EventListenerList eventListeners = new EventListenerList();
    JSplitPane splitPane;
    JScrollPane explorePanel;
    JScrollPane resultsPanel;
    JScrollPane schemaPanel;
    JTabbedPane treeTabPane;
    JPanel userViewPanel;
    CBPanel topPanel;
    JToolBar searchBar;
    ButtonBar buttonBar;
    protected Stack statusStack = new Stack();
    private JNDIDataBroker jndiBroker = null;
    JNDIDataBroker searchBroker = null;
    public OfflineDataBroker offlineBroker = null;
    SchemaDataBroker schemaBroker = null;
    public SmartTree mrTree = null;
    SmartTree searchTree = null;
    SmartTree schemaTree = null;
    AttributeDisplay mainViewer;
    CBPanel statusDisplay;
    JLabel displayLabel;
    protected MainMenu mainMenu;
    protected ButtonRegister buttonRegister = null;
    protected StopMonitor stopMonitor;
    public Thread jndiThread;
    public Thread schemaThread;
    public Thread searchThread;
    public Thread offlineThread;
    public String url = "Disconnected";
    private static Logger log = Logger.getLogger(JXplorerBrowser.class.getName());
    boolean connected = false;
    public boolean workOffline = false;

    public void init(JXplorer parent) {
        this.parent = parent;
        this.rootFrame = this;
        this.mainPane = this.rootFrame.getContentPane();
        this.mrTree = null;
        this.initJNDIBroker();
        this.initSearchBroker();
        this.initSchemaBroker();
        this.initOfflineBroker();
        this.initStopMonitor();
        this.buttonRegister = new ButtonRegister();
        this.setupGUI();
        this.setStatus(CBIntText.get("Not Connected"));
        this.setBackground(Color.white);
        OfflineDataBroker datamodifier = this.offlineBroker;
        this.setInitialOfflineTreeBroker();
        this.setVisible(true);
    }

    public void setInitialOfflineTreeBroker() {
        this.mrTree.registerDataSource(this.offlineBroker);
    }

    public JXplorer getJXplorer() {
        return this.parent;
    }

    public JNDIDataBroker getJndiBroker() {
        return this.jndiBroker;
    }

    public JLabel getDisplayLabel() {
        return this.displayLabel;
    }

    public void checkSpecialLoggingActions() {
        if (CBUtility.getTrueLogLevel(log) == Level.ALL) {
            this.jndiBroker.setTracing(true);
        } else {
            this.jndiBroker.setTracing(false);
        }
    }

    public void initJNDIBroker() {
        this.jndiBroker = new JNDIDataBroker();
        if (CBUtility.getTrueLogLevel(log) == Level.ALL) {
            this.jndiBroker.setTracing(true);
        }
        this.jndiBroker.setTimeout(JXConfig.getIntProperty("option.ldap.timeout", 0));
        this.jndiBroker.setLimit(JXConfig.getIntProperty("option.ldap.limit", 0));
        this.jndiBroker.setPaging(Boolean.parseBoolean(JXConfig.getProperty("option.ldap.pagedResults", "false")), JXConfig.getIntProperty("option.ldap.pageSize", 1000));
        this.jndiThread = new Thread((Runnable)this.jndiBroker, "jndiBroker Thread");
        this.jndiThread.start();
    }

    public void initSearchBroker() {
        this.searchBroker = new JNDIDataBroker(this.jndiBroker);
        this.searchThread = new Thread((Runnable)this.searchBroker, "searchBroker Thread");
        this.searchThread.start();
    }

    public void initSchemaBroker() {
        this.schemaBroker = new SchemaDataBroker(this.jndiBroker);
        this.schemaThread = new Thread((Runnable)this.schemaBroker, "schemaBroker Thread");
        this.schemaThread.start();
    }

    public void initOfflineBroker() {
        this.offlineBroker = new OfflineDataBroker();
        this.offlineThread = new Thread((Runnable)this.offlineBroker, "offlineBroker Thread");
        this.offlineThread.start();
    }

    public void initStopMonitor() {
        DataBroker[] brokerList = new DataBroker[]{this.jndiBroker, this.searchBroker, this.schemaBroker, this.offlineBroker};
        this.stopMonitor = new StopMonitor(brokerList, this);
    }

    public StopMonitor getStopMonitor() {
        return this.stopMonitor;
    }

    protected void setupGUI() {
        this.setupLookAndFeel();
        this.setupWindowButtons();
        this.setupMenu();
        this.setupMainPanel();
        this.setupStatusDisplay();
        this.setupFrills();
    }

    protected void setupLookAndFeel() {
        try {
            UIManager.setLookAndFeel(JXConfig.getProperty("gui.lookandfeel"));
        }
        catch (Exception exc) {
            log.warning("WARNING: Can't load Look and Feel: " + exc);
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                JXConfig.setProperty("gui.lookandfeel", UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception exc2) {
                log.warning("ERRROR: Can't load default Look and Feel either! : " + exc2);
            }
        }
    }

    protected void setupWindowButtons() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent ev) {
                JXplorerBrowser.this.closeWindow();
            }
        });
    }

    protected void closeWindow() {
        this.parent.browserClosing(this);
        super.dispose();
    }

    protected void shutdown() {
        this.parent.shutdown();
    }

    protected void setupMenu() {
        if (JXConfig.getProperty("gui.menu", "true").equals("true")) {
            this.mainMenu = new MainMenu(this);
        }
    }

    public MainMenu getMainMenu() {
        return this.mainMenu;
    }

    public JNDIDataBroker getSearchBroker() {
        return this.searchBroker;
    }

    public JTabbedPane getTreeTabPane() {
        return this.treeTabPane;
    }

    public JScrollPane getExplorePanel() {
        return this.explorePanel;
    }

    public JScrollPane getResultsPanel() {
        return this.resultsPanel;
    }

    public SmartTree getSearchTree() {
        return this.searchTree;
    }

    public SmartTree getTree() {
        return this.mrTree;
    }

    public SmartTree getSchemaTree() {
        return this.schemaTree;
    }

    public JFrame getRootFrame() {
        return this.rootFrame;
    }

    public AttributeDisplay getAttributeDisplay() {
        return this.mainViewer;
    }

    protected void setupMainPanel() {
        this.setupToolBars();
        this.setupActiveComponents();
        this.setupMainWorkArea();
        this.mainPane.setBackground(Color.lightGray);
        this.mainViewer.registerClassLoader(this.parent.getClassLoader());
        this.validate();
    }

    protected void setupToolBars() {
        this.topPanel = new CBPanel();
        this.searchBar = new SearchBar(this);
        this.buttonBar = new ButtonBar(this);
        this.topPanel.makeWide();
        this.topPanel.add(this.buttonBar);
        this.topPanel.addln(this.searchBar);
        this.mainPane.add((Component)this.topPanel, "North");
        this.mainPane.setBackground(Color.white);
        if (JXConfig.getProperty("gui.buttonbar", "true").equals("false")) {
            this.buttonBar.setVisible(false);
        }
        if (JXConfig.getProperty("gui.searchbar", "true").equals("false")) {
            this.searchBar.setVisible(false);
        }
    }

    protected void setupActiveComponents() {
        this.mainViewer = new AttributeDisplay(this, this.parent.getResourceLoader());
        this.mrTree = new SmartTree(this, CBIntText.get("Explore"), this.parent.getResourceLoader());
        this.mrTree.setBackground(new Color(0xF7F9FF));
        this.initialiseTree(this.mrTree, this.mainViewer, this);
        this.searchTree = new SmartTree(this, CBIntText.get("Results"), this.parent.getResourceLoader());
        this.searchTree.setBackground(new Color(0xEEFFFF));
        this.initialiseTree(this.searchTree, this.mainViewer, this);
        this.schemaTree = new SmartTree(this, CBIntText.get("Schema"), this.parent.getResourceLoader());
        this.schemaTree.setBackground(new Color(0xEEFFEE));
        this.schemaTree.getTree().setEditable(false);
        this.initialiseTree(this.schemaTree, this.mainViewer, this);
        this.mainViewer.registerComponents(this.mainMenu, this.buttonBar, this.mrTree.getTree(), this.mrTree.getPopupTool(), this);
    }

    public void initialiseTree(SmartTree tree, DataSink viewer, JXplorerEventGenerator gen) {
        if (viewer != null) {
            tree.registerDataSink(viewer);
        }
        if (gen != null) {
            tree.registerEventPublisher(gen);
        }
    }

    protected void setupStatusDisplay() {
        this.statusDisplay = new CBPanel();
        this.statusDisplay.makeHeavy();
        this.displayLabel = new JLabel(CBIntText.get("initialising..."));
        this.statusDisplay.addln(this.displayLabel);
        this.mainPane.add((Component)this.statusDisplay, "South");
    }

    public String getStatus() {
        return this.displayLabel.getText();
    }

    public void setStatus(String s) {
        this.displayLabel.setText(s);
        this.displayLabel.repaint();
    }

    public void pushStatus(String newMessage) {
        this.statusStack.push(this.displayLabel.getText());
        this.setStatus(newMessage);
    }

    public String popStatus() {
        String status = this.statusStack.empty() ? "" : (String)this.statusStack.pop();
        this.setStatus(status);
        return status;
    }

    public DisplayMode getDisplayMode() {
        if (this.treeTabPane == null) {
            return DisplayMode.BROWSE;
        }
        Component treePane = this.treeTabPane.getSelectedComponent();
        if (treePane == this.explorePanel) {
            return DisplayMode.BROWSE;
        }
        if (treePane == this.resultsPanel) {
            return DisplayMode.SEARCH;
        }
        if (treePane == this.schemaPanel) {
            return DisplayMode.SCHEMA;
        }
        return DisplayMode.BROWSE;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    protected void setupMainWorkArea() {
        this.splitPane = new JSplitPane(1, false);
        this.mainPane.add((Component)this.splitPane, "Center");
        this.treeTabPane = new JTabbedPane();
        this.treeTabPane.setMinimumSize(new Dimension(100, 100));
        this.treeTabPane.setPreferredSize(new Dimension(320, 100));
        this.explorePanel = new JScrollPane(this.mrTree);
        this.resultsPanel = new JScrollPane(this.searchTree);
        this.schemaPanel = new JScrollPane(this.schemaTree);
        this.explorePanel.getVerticalScrollBar().setUnitIncrement(16);
        this.resultsPanel.getVerticalScrollBar().setUnitIncrement(16);
        this.schemaPanel.getVerticalScrollBar().setUnitIncrement(16);
        this.splitPane.add(this.treeTabPane, "left", 0);
        if (JXConfig.getProperty("gui.viewPanel", "true").equals("true")) {
            this.userViewPanel = new JPanel(new BorderLayout());
            this.userViewPanel.add((Component)this.mainViewer, "Center");
            this.splitPane.add(this.userViewPanel, "right", 1);
        }
        if (this.mrTree != null) {
            this.treeTabPane.addTab(this.mrTree.getName(), new ImageIcon(Theme.getInstance().getDirImages() + "explore.gif"), this.explorePanel, "Displays the directory tree, and allows the user to graphically browse the directory.");
        }
        if (this.searchTree != null) {
            this.treeTabPane.addTab(this.searchTree.getName(), new ImageIcon(Theme.getInstance().getDirImages() + "find.gif"), this.resultsPanel, "Displays the search results, and allows the user to graphically browse these results.");
        }
        if (this.schemaTree != null) {
            this.treeTabPane.addTab(this.schemaTree.getName(), new ImageIcon(Theme.getInstance().getDirIcons() + "schema.gif"), this.schemaPanel, "Displays the directory schema, and allows the user to graphically browse the schema.");
        }
        this.treeTabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                DisplayMode mode = JXplorerBrowser.this.getDisplayMode();
                ButtonRegister br = JXplorerBrowser.this.getButtonRegister();
                if (mode == DisplayMode.BROWSE) {
                    JXplorerBrowser.this.setStatus(CBIntText.get("Connected To ''{0}''", new String[]{JXplorerBrowser.this.url}));
                    if (br != null) {
                        br.setEditingButtons(JXplorerBrowser.this.isConnected() && JXplorerBrowser.this.mrTree.isModifiable());
                    }
                    JXplorerBrowser.this.mrTree.refreshEditorPane();
                } else if (mode == DisplayMode.SEARCH) {
                    JXplorerBrowser.this.setStatus("Number of search results: " + String.valueOf(JXplorerBrowser.this.searchTree.getNumOfResults()));
                    if (br != null) {
                        br.setEditingButtons(JXplorerBrowser.this.isConnected() && JXplorerBrowser.this.searchTree.isModifiable());
                    }
                    JXplorerBrowser.this.searchTree.refreshEditorPane();
                } else if (mode == DisplayMode.SCHEMA) {
                    JXplorerBrowser.this.setStatus(CBIntText.get("Connected To ''{0}''", new String[]{JXplorerBrowser.this.url}));
                    if (br != null) {
                        br.setEditingButtons(false);
                    }
                    JXplorerBrowser.this.schemaTree.refreshEditorPane();
                }
            }
        });
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public SmartTree getActiveTree() {
        switch (this.getDisplayMode()) {
            case BROWSE: {
                return this.mrTree;
            }
            case SEARCH: {
                return this.searchTree;
            }
            case SCHEMA: {
                return this.schemaTree;
            }
        }
        log.warning("ERROR: Unable to establish active tree - panel");
        return null;
    }

    protected void setupFrills() {
        this.setTitle("JXplorer");
        this.setIconImage(JXplorer.getImageIcon("JX32.png").getImage());
    }

    public void preConnectionSetup() {
        if (this.mrTree == null) {
            return;
        }
        this.mrTree.clearTree();
        this.mrTree.setRootDN(SmartTree.NODATA_DN);
        this.treeTabPane.setSelectedIndex(0);
        if (this.searchTree == null) {
            return;
        }
        this.searchTree.clearTree();
        this.searchTree.setRootDN(SmartTree.NODATA_DN);
        if (this.schemaTree == null) {
            return;
        }
        this.schemaTree.clearTree();
        this.schemaTree.setRootDN(SmartTree.NODATA_DN);
    }

    public boolean postConnectionSetup(JNDIDataBroker.DataConnectionQuery request) {
        this.searchTree.clearTree();
        if (this.workOffline) {
            this.workOffline = false;
            this.offlineBroker.clear();
        } else if (request.conData.getTemplateName() != null) {
            this.setTitle(CBIntText.get("JXplorer") + " - " + request.conData.getTemplateName());
        } else {
            this.setTitle(CBIntText.get("JXplorer") + " - " + request.conData.getURL());
        }
        String baseDN = request.conData.baseDN;
        DN base = new DN(baseDN);
        DN[] namingContexts = null;
        int ldapV = request.conData.version;
        try {
            if (base == null || base.size() == 0 || !this.jndiBroker.unthreadedExists(base)) {
                if (ldapV == 2) {
                    if (!this.jndiBroker.unthreadedExists(base)) {
                        CBUtility.error("Error opening ldap v2 connection - bad base DN '" + (base == null ? "*null*" : base.toString()) + "' ");
                        this.disconnect();
                        return false;
                    }
                } else {
                    if (base != null && base.size() > 0) {
                        log.warning("The Base DN '" + base + "' cannot be found.");
                    }
                    base = null;
                    namingContexts = this.jndiBroker.readFallbackRoot();
                    if (baseDN.trim().length() > 0) {
                        if (namingContexts != null && namingContexts[0] != null) {
                            log.warning("Cannot find the user-specified Base DN - Using the fall back DN '" + namingContexts[0].toString() + "'");
                        } else {
                            log.warning("WARNING: Cannot find the user-specified Base DN, and cannot read alternative from directory.  Leaving unset for the present.");
                        }
                    }
                    if (namingContexts != null && namingContexts.length == 1) {
                        base = namingContexts[0];
                    }
                }
            }
            this.mrTree.clearTree();
            this.mrTree.registerDataSource(this.jndiBroker);
        }
        catch (Exception ex) {
            if (ldapV != 2) {
                CBUtility.error("Possible errors occurred while opening connection.", ex);
            }
            CBUtility.error("Error opening ldap v2 connection (possibly bad base DN?) ", ex);
            this.disconnect();
            return false;
        }
        if (base != null) {
            this.mrTree.setRootDN(base);
            this.mrTree.expandRootDN();
            if (base.size() == 0) {
                this.mrTree.expandRoot();
                this.mrTree.getRootNode().setAlwaysRefresh(true);
            } else {
                this.mrTree.expandDN(base);
                this.makeDNAutoRefreshing(base);
            }
        } else if (namingContexts != null) {
            int i;
            this.mrTree.setRootDN(new DN());
            this.mrTree.expandRootDN();
            for (i = 0; i < namingContexts.length; ++i) {
                DN namingContext = namingContexts[i];
                SmartNode node = this.mrTree.addNode(namingContext);
                if (node.getChildCount() != 0) continue;
                node.add(new SmartNode());
            }
            for (i = 0; i < namingContexts.length; ++i) {
                this.mrTree.expandDN(namingContexts[i]);
                this.makeDNAutoRefreshing(namingContexts[i]);
            }
        } else {
            this.mrTree.expandRoot();
            this.mrTree.getRootNode().setAlwaysRefresh(true);
        }
        this.searchTree.clearTree();
        this.searchBroker.registerDirectoryConnection(this.jndiBroker);
        this.searchTree.registerDataSource(this.searchBroker);
        this.searchTree.setRootDN(new DN());
        this.schemaTree.clearTree();
        if (Integer.toString(ldapV) != null && ldapV > 2) {
            this.schemaBroker.registerDirectoryConnection(this.jndiBroker);
            this.schemaTree.registerDataSource(this.schemaBroker);
            this.schemaTree.setRootDN(new DN("cn=schema"));
            DXAttribute.setDefaultSchema(this.jndiBroker.getSchemaOps());
            DXAttributes.setDefaultSchema(this.jndiBroker.getSchemaOps());
        } else {
            DXAttribute.setDefaultSchema(null);
            DXAttributes.setDefaultSchema(null);
        }
        if (base != null) {
            this.jndiBroker.getEntry(base);
            JXConfig.setDefaultProperty("baseDN", base.toString());
            this.url = request.conData.url;
            this.setStatus(CBIntText.get("Connected To ''{0}''", new String[]{this.url}));
        }
        boolean readOnlyStatus = this.jndiBroker.isReadOnly();
        this.getButtonRegister().setConnectedState(readOnlyStatus);
        this.mainMenu.setConnected(true);
        this.setConnected(true);
        return true;
    }

    protected void makeDNAutoRefreshing(DN dn) {
        try {
            TreePath path = ((SmartModel)this.mrTree.getModel()).getPathForDN(dn);
            if (path == null) {
                throw new Exception("null path returned");
            }
            Object[] nodes = path.getPath();
            for (int j = 0; j < nodes.length - 1; ++j) {
                ((SmartNode)nodes[j]).setAlwaysRefresh(true);
            }
        }
        catch (Exception e) {
            log.info("INFO: messed up setting auto-expanding nodes for context '" + dn + "'");
        }
    }

    public void disconnect() {
        this.jndiBroker.disconnect();
        this.mrTree.goOffline(this.offlineBroker);
        this.schemaTree.goOffline(null);
        this.searchTree.goOffline(null);
        this.searchTree.setNumOfResults(0);
        this.mrTree.clearTree();
        this.schemaTree.clearTree();
        this.searchTree.clearTree();
        this.getButtonRegister().setDisconnectState();
        this.mainMenu.setDisconnected();
        this.setConnected(false);
        this.setStatus(CBIntText.get("Disconnected"));
        this.setTitle(CBIntText.get("JXplorer"));
    }

    public void setDisconnectView() {
        this.mainMenu.setDisconnected();
        this.getButtonRegister().setDisconnectState();
        this.setStatus(CBIntText.get("Disconnected"));
    }

    public synchronized void addJXplorerListener(JXplorerListener l) {
        if (l != null) {
            this.eventListeners.add(JXplorerListener.class, l);
        }
    }

    public synchronized void removeJXplorerListener(JXplorerListener l) {
        if (l != null) {
            this.eventListeners.remove(JXplorerListener.class, l);
        }
    }

    @Override
    public void fireJXplorerEvent(JXplorerEvent e) {
        Object[] list = this.eventListeners.getListenerList();
        for (int index = list.length - 2; index >= 0; index -= 2) {
            if (list[index] != JXplorerListener.class) continue;
            ((JXplorerListener)list[index + 1]).JXplorerDNSelected(e);
        }
    }

    public ButtonRegister getButtonRegister() {
        return this.buttonRegister;
    }

    public JXplorer getRootJXplorer() {
        return this.parent;
    }

    public ArrayList<JXplorerBrowser> getAllBrowsers() {
        return this.parent.getBrowsers();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DisplayMode {
        BROWSE,
        SEARCH,
        SCHEMA;

    }
}

