/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBBasicComboBoxRenderer;
import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.naming.DN;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.search.SearchModel;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class BookMarks {
    JXplorerBrowser browser = null;
    static Properties propertyList = null;
    final String FILE_NAME = "bookmarks.txt";
    String bookmarkPath;
    DeleteDialog deleteDialog = null;
    EditDialog editDialog = null;
    AddDialog addDialog = null;
    private static Logger log = Logger.getLogger(BookMarks.class.getName());

    public BookMarks(JXplorerBrowser jx) {
        this.browser = jx;
        this.bookmarkPath = CBUtility.getPropertyConfigPath(JXplorer.APPLICATION_NAME, "bookmarks.txt");
        propertyList = CBUtility.readPropertyFile(this.bookmarkPath);
    }

    protected boolean isValidName(String name) {
        try {
            if (name.trim().length() <= 0) {
                return false;
            }
        }
        catch (Exception e) {
            log.warning("Name '" + name + "' not specified in Bookmarks");
            return false;
        }
        return true;
    }

    protected boolean isValidDN(String dn) {
        if (dn.equalsIgnoreCase("cn=no entries")) {
            return false;
        }
        return dn.trim().length() > 0;
    }

    protected String getCurrentRDN(String dn) {
        DN bloop = new DN(dn);
        return bloop.getLowestRDN().toString();
    }

    protected boolean checkIfBookmarkExists(String name) {
        propertyList = CBUtility.readPropertyFile(this.bookmarkPath);
        return propertyList.containsKey("dn." + name);
    }

    public DeleteDialog getDeleteDialog() {
        if (this.deleteDialog == null) {
            return new DeleteDialog();
        }
        return this.deleteDialog;
    }

    public EditDialog getEditDialog() {
        if (this.editDialog == null) {
            return new EditDialog();
        }
        return this.editDialog;
    }

    public AddDialog getAddDialog(String name, boolean edit) {
        if (this.addDialog == null) {
            this.addDialog = new AddDialog(name, edit);
        }
        if (edit) {
            this.addDialog.setHelpLink("editing_a_bookmark_htm");
        } else {
            this.addDialog.setHelpLink("adding_a_bookmark_htm");
        }
        this.addDialog.Help.setToolTipText(CBIntText.get("Click here for Help."));
        return this.addDialog;
    }

    public void deleteBookmark(String name) {
        propertyList.remove("dn." + name);
        propertyList.remove("desc." + name);
        CBUtility.writePropertyFile(this.bookmarkPath, propertyList, null);
        this.updateAllBookmarks();
    }

    public void updateAllBookmarks() {
        ArrayList<JXplorerBrowser> browsers = this.browser.getAllBrowsers();
        for (JXplorerBrowser b : browsers) {
            b.getMainMenu().updateBookmarkMenu();
        }
    }

    public Object[] getSavedBookmarkNames() {
        Enumeration<Object> keys = propertyList.keys();
        ArrayList<String> list = new ArrayList<String>();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (!key.toLowerCase().startsWith("dn")) continue;
            String name = key.substring(key.indexOf(".") + 1);
            list.add(name);
        }
        Object[] listOb = list.toArray();
        Arrays.sort(listOb, new SearchModel.StringComparator());
        return listOb;
    }

    public CBJComboBox makeComboBox(Object[] values) {
        CBJComboBox combo = new CBJComboBox(values);
        combo.setRenderer(new CBBasicComboBoxRenderer(values));
        combo.setPreferredSize(new Dimension(140, 20));
        return combo;
    }

    public class DeleteDialog {
        public DeleteDialog() {
            Object[] bookmarks = BookMarks.this.getSavedBookmarkNames();
            CBJComboBox combo = BookMarks.this.makeComboBox(bookmarks);
            combo.setToolTipText(CBIntText.get("Select the bookmark name that you want to delete."));
            int response = JOptionPane.showConfirmDialog(BookMarks.this.browser, combo, CBIntText.get("Delete Bookmark"), 2);
            if (response != 0) {
                return;
            }
            if (combo.getSelectedItem() != null) {
                String toDelete = combo.getSelectedItem().toString();
                int res = JOptionPane.showConfirmDialog(BookMarks.this.browser, CBIntText.get("Are you sure you want to delete the bookmark called ''{0}''?", new String[]{toDelete}), CBIntText.get("Confirm Delete"), 2);
                if (res != 0) {
                    return;
                }
                BookMarks.this.deleteBookmark(toDelete);
                JOptionPane.showMessageDialog(BookMarks.this.browser, CBIntText.get("The bookmark ''{0}'' was successfully deleted.", new String[]{toDelete}), CBIntText.get("Delete Succeeded"), 1);
            }
        }
    }

    public class EditDialog {
        public EditDialog() {
            Object[] bookmarks = BookMarks.this.getSavedBookmarkNames();
            CBJComboBox combo = BookMarks.this.makeComboBox(bookmarks);
            combo.setToolTipText(CBIntText.get("Select the bookmark name that you want to edit."));
            int response = JOptionPane.showConfirmDialog(BookMarks.this.browser, combo, CBIntText.get("Edit Bookmark"), 2);
            if (response != 0) {
                return;
            }
            if (combo.getSelectedItem() != null) {
                String bookmark = combo.getSelectedItem().toString();
                AddDialog ad = BookMarks.this.getAddDialog(bookmark, true);
                ad.setVisible(true);
            }
        }
    }

    public class AddDialog
    extends CBDialog {
        JTextField nameField;
        JTextField dnField;
        JTextField descField;
        String editName;
        boolean edit;

        public AddDialog(String name, boolean edit) {
            super((Frame)BookMarks.this.browser, CBIntText.get("Add Bookmark"), null);
            this.nameField = new JTextField();
            this.dnField = new JTextField();
            this.descField = new JTextField();
            this.editName = null;
            this.edit = false;
            this.edit = edit;
            if (edit) {
                this.displayBookmarkDetails(name);
                this.editName = name;
                this.setTitle(CBIntText.get("Edit Bookmark"));
            } else {
                this.displayNewBookmarkDetails(name);
            }
            CBPanel namePanel = new CBPanel();
            namePanel.add(new JLabel(CBIntText.get("Bookmark Name") + ": "));
            namePanel.makeWide();
            namePanel.add(this.nameField);
            namePanel.makeLight();
            this.OK.setToolTipText(CBIntText.get("Click here to exit when finished."));
            this.OK.setText(CBIntText.get("Save"));
            this.Cancel.setToolTipText(CBIntText.get("Click here to exit."));
            CBPanel detailsPanel = new CBPanel();
            detailsPanel.add(new JLabel(CBIntText.get("DN") + ": "));
            detailsPanel.makeWide();
            detailsPanel.addln(this.dnField);
            detailsPanel.makeLight();
            detailsPanel.add(new JLabel(CBIntText.get("Description") + ": "));
            detailsPanel.makeWide();
            detailsPanel.addln(this.descField);
            detailsPanel.setBorder(new TitledBorder(CBIntText.get("Bookmark Properties")));
            this.display.makeWide();
            this.display.addln(namePanel);
            this.display.addln(detailsPanel);
            this.setSize(480, 200);
            CBUtility.center(this, BookMarks.this.browser);
        }

        public JButton getHelpButton() {
            return this.Help;
        }

        protected void displayBookmarkDetails(String name) {
            try {
                this.nameField.setText(name);
                this.dnField.setText(propertyList.getProperty("dn." + name));
                this.descField.setText(propertyList.getProperty("desc." + name));
            }
            catch (Exception e) {
                CBUtility.error("Error loading '" + name + "' bookmark.  The bookmark cannot be found.", e);
            }
        }

        public void displayNewBookmarkDetails(String dn) {
            this.nameField.setText(BookMarks.this.getCurrentRDN(dn));
            this.dnField.setText(dn);
            this.descField.setText("");
        }

        public void doOK() {
            String name = this.nameField.getText();
            String desc = this.descField.getText();
            String dn = this.dnField.getText();
            try {
                int response;
                if (!BookMarks.this.isValidName(name)) {
                    CBUtility.error(CBIntText.get("The bookmark you are trying to save contains an invalid Name.  Please check the Name then try again."));
                    return;
                }
                if (BookMarks.this.checkIfBookmarkExists(name) && (response = JOptionPane.showConfirmDialog(this, CBIntText.get("Do you want to replace it?"), CBIntText.get("Bookmark Exists"), 2)) != 0) {
                    return;
                }
                if (!BookMarks.this.isValidDN(dn)) {
                    CBUtility.error(CBIntText.get("The bookmark you are trying to save contains an invalid DN.  Please check the DN then try again."));
                    return;
                }
                if (this.edit && !name.equals(this.editName) && (response = JOptionPane.showConfirmDialog(this, CBIntText.get("You have renamed ''{0}'' to ''{1}''.  Do you want to delete ''{0}''?", new String[]{this.editName, name}), CBIntText.get("Delete Bookmark?"), 0)) == 0) {
                    BookMarks.this.deleteBookmark(this.editName);
                }
                propertyList.setProperty("dn." + name, dn);
                propertyList.setProperty("desc." + name, desc);
                CBUtility.writePropertyFile(BookMarks.this.bookmarkPath, propertyList, null);
            }
            catch (Exception e) {
                CBUtility.error("Cannot add an empty bookmark.");
                return;
            }
            BookMarks.this.updateAllBookmarks();
            JOptionPane.showMessageDialog(BookMarks.this.browser, CBIntText.get("The bookmark ''{0}'' was successfully saved.", new String[]{name}), CBIntText.get("Save Succeeded"), 1);
            super.doOK();
        }

        public void doCancel() {
            super.doCancel();
            BookMarks.this.updateAllBookmarks();
        }
    }
}

