/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBAction;
import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBHelpSystem;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.Theme;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.MainMenu;
import com.ca.directory.jxplorer.search.SearchGUI;
import com.ca.directory.jxplorer.tree.SmartTree;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class AdvancedOptions
extends JDialog {
    private CBButton btnApply;
    private CBButton btnReset;
    private CBButton btnCancel;
    private CBButton btnHelp;
    private JTextField ldapLimit;
    private JTextField ldapTimeout;
    private JTextField pageSize;
    private JCheckBox pagedResults;
    private JComboBox urlCombo;
    private JComboBox logLevelCombo;
    private JComboBox logMethodCombo;
    private JComboBox cachePwdCombo;
    private CBPanel display;
    private JTabbedPane tabbedPane;
    private JRadioButton[] lookAndFeel;
    private String[] lookAndFeelVal;
    private final String[] logLevelVal = new String[]{CBIntText.get("Severe"), CBIntText.get("Warning"), CBIntText.get("Info"), CBIntText.get("Fine"), CBIntText.get("Finest"), CBIntText.get("All + BER Trace")};
    private final String[] logMethodVal = new String[]{CBIntText.get("None"), CBIntText.get("Console"), CBIntText.get("File"), CBIntText.get("Console & File")};
    private MainMenu mainMenu;
    private final JXplorerBrowser browser;
    private static final int WINDOWS = 0;
    private static final int JAVA = 1;
    protected static final int MOTIF = 2;
    protected static final int GTK = 3;
    protected static final int MAC = 4;
    private static Logger log = Logger.getLogger(AdvancedOptions.class.getName());
    public static final String WINDOWS_LF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String JAVA_LF = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String MOTIF_LF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String GTK_LF = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    public static final String MAC_LF = "apple.laf.AquaLookAndFeel";

    public AdvancedOptions(JXplorerBrowser jxplorer, MainMenu mainMenu) {
        super(jxplorer);
        this.setModal(true);
        this.mainMenu = mainMenu;
        this.browser = jxplorer;
        this.setTitle(CBIntText.get("JXplorer Advanced Options"));
        this.display = new CBPanel();
        this.btnApply = new CBButton(CBIntText.get("Apply"), CBIntText.get("Click here to apply the changes"));
        this.btnApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptions.this.apply();
            }
        });
        this.btnReset = new CBButton(CBIntText.get("Reset"), CBIntText.get("Click here to reset the options"));
        this.btnReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptions.this.reset();
            }
        });
        this.btnCancel = new CBButton(CBIntText.get("Cancel"), CBIntText.get("Click here to exit Advanced Options"));
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdvancedOptions.this.quit();
            }
        });
        this.btnHelp = new CBButton(CBIntText.get("Help"), CBIntText.get("Click here for Help"));
        CBHelpSystem.useDefaultHelp(this.btnHelp, "config.advanced");
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ENTER"), "enter");
        this.display.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
        this.display.getActionMap().put("enter", new MyAction(10));
        this.display.getActionMap().put("escape", new MyAction(27));
        this.tabbedPane = new JTabbedPane();
        this.ldapLevels();
        this.lookAndFeelTab();
        this.logLevel();
        this.logMethod();
        this.urlTab();
        this.pwdTab();
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.btnApply);
        buttonPanel.add(this.btnReset);
        buttonPanel.add(this.btnCancel);
        buttonPanel.add(this.btnHelp);
        this.display.addln(this.tabbedPane);
        this.display.addln(buttonPanel);
        this.setSize(360, 420);
        this.getContentPane().add(this.display);
    }

    private void lookAndFeelTab() {
        this.lookAndFeel = new JRadioButton[]{new JRadioButton(CBIntText.get("Windows Look and Feel")), new JRadioButton(CBIntText.get("Java Look and Feel")), new JRadioButton(CBIntText.get("Motif Look and Feel")), new JRadioButton(CBIntText.get("GTK Look and Feel")), new JRadioButton(CBIntText.get("Mac Look and Feel"))};
        String[] toolTip = new String[]{CBIntText.get("Sets the look and feel to: Windows"), CBIntText.get("Sets the look and feel to: Java"), CBIntText.get("Sets the look and feel to: Motif"), CBIntText.get("Sets the look and feel to: GTK"), CBIntText.get("Sets the look and feel to: Apple Mac/OSX")};
        ButtonGroup lookAndFeelButtonGroup = new ButtonGroup();
        CBPanel lookAndFeelPanel = new CBPanel();
        lookAndFeelPanel.addln(new JLabel(CBIntText.get("Select a New Look & Feel") + ": "));
        lookAndFeelPanel.addln(new JLabel(" "));
        if (CBUtility.isWindows()) {
            this.addLookAndFeelOption(lookAndFeelButtonGroup, 0, lookAndFeelPanel, toolTip);
        } else {
            this.lookAndFeel[0].setSelected(false);
        }
        this.addLookAndFeelOption(lookAndFeelButtonGroup, 1, lookAndFeelPanel, toolTip);
        this.addLookAndFeelOption(lookAndFeelButtonGroup, 2, lookAndFeelPanel, toolTip);
        this.addLookAndFeelOption(lookAndFeelButtonGroup, 3, lookAndFeelPanel, toolTip);
        if (CBUtility.isMac()) {
            this.addLookAndFeelOption(lookAndFeelButtonGroup, 4, lookAndFeelPanel, toolTip);
        } else {
            this.lookAndFeel[4].setSelected(false);
        }
        this.getLookAndFeel();
        this.tabbedPane.addTab(CBIntText.get("Look & Feel"), new ImageIcon(Theme.getInstance().getDirIcons() + "look_feel.gif"), lookAndFeelPanel, CBIntText.get("Change the 'look and feel' of JXplorer, that is, adopt a similar appearance to another application."));
    }

    private void addLookAndFeelOption(ButtonGroup lookAndFeelButtonGroup, int i, CBPanel lookAndFeelPanel, String[] toolTip) {
        lookAndFeelButtonGroup.add(this.lookAndFeel[i]);
        lookAndFeelPanel.addln(this.lookAndFeel[i]);
        this.lookAndFeel[i].setToolTipText(toolTip[i]);
    }

    private void getLookAndFeel() {
        this.lookAndFeelVal = new String[]{WINDOWS_LF, JAVA_LF, MOTIF_LF, GTK_LF, MAC_LF};
        for (int i = 0; i < this.lookAndFeelVal.length; ++i) {
            if (!String.valueOf(this.lookAndFeelVal[i]).equalsIgnoreCase(JXConfig.getProperty("gui.lookandfeel"))) continue;
            this.lookAndFeel[i].setSelected(true);
        }
    }

    private void checkLookAndFeel() {
        AbstractButton rb = null;
        String currentLF = JXConfig.getProperty("gui.lookandfeel");
        try {
            if (this.lookAndFeel[0].isSelected()) {
                if (currentLF.equalsIgnoreCase(WINDOWS_LF)) {
                    return;
                }
                rb = this.lookAndFeel[0];
                this.setNewLookAndFeel(WINDOWS_LF, 0);
            } else if (this.lookAndFeel[1].isSelected()) {
                if (currentLF.equalsIgnoreCase(JAVA_LF)) {
                    return;
                }
                rb = this.lookAndFeel[1];
                this.setNewLookAndFeel(JAVA_LF, 1);
            } else if (this.lookAndFeel[2].isSelected()) {
                if (currentLF.equalsIgnoreCase(MOTIF_LF)) {
                    return;
                }
                rb = this.lookAndFeel[2];
                this.setNewLookAndFeel(MOTIF_LF, 2);
            } else if (this.lookAndFeel[3].isSelected()) {
                if (currentLF.equalsIgnoreCase(GTK_LF)) {
                    return;
                }
                rb = this.lookAndFeel[3];
                this.setNewLookAndFeel(GTK_LF, 3);
            } else if (this.lookAndFeel[4].isSelected()) {
                if (currentLF.equalsIgnoreCase(MAC_LF)) {
                    return;
                }
                rb = this.lookAndFeel[4];
                this.setNewLookAndFeel(MAC_LF, 4);
            }
        }
        catch (UnsupportedLookAndFeelException exc) {
            if (rb != null) {
                rb.setEnabled(false);
                log.warning("Unsupported LookAndFeel: " + rb.getText());
            }
            JOptionPane.showMessageDialog(this.browser, "That 'look and feel' isn't supported on your computer.", "Unsupported Look and Feel", 0);
            return;
        }
        catch (Exception exc) {
            rb.setEnabled(false);
            exc.printStackTrace();
            log.warning("Could not load LookAndFeel: " + rb.getText());
            exc.printStackTrace();
        }
        this.getOwner().setCursor(Cursor.getPredefinedCursor(3));
        this.updateLookAndFeel();
        if (this.mainMenu.getConnection != null) {
            SwingUtilities.updateComponentTreeUI(this.mainMenu.getConnection);
        }
        this.getOwner().setCursor(Cursor.getPredefinedCursor(0));
        this.browser.getAttributeDisplay().refreshEditors();
    }

    private void setNewLookAndFeel(String lf, int pos) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(lf);
        JXConfig.setProperty("gui.lookandfeel", lf);
    }

    private void updateLookAndFeel() {
        if (!(this.getOwner() instanceof JXplorerBrowser)) {
            SwingUtilities.updateComponentTreeUI(this.getOwner());
            return;
        }
        JXplorerBrowser triggeringBrowser = (JXplorerBrowser)this.getOwner();
        JXplorer jxplorer = triggeringBrowser.getRootJXplorer();
        ArrayList<JXplorerBrowser> browsers = jxplorer.getBrowsers();
        for (JXplorerBrowser browser : browsers) {
            this.updateLookAndFeel(browser);
        }
    }

    private void updateLookAndFeel(JXplorerBrowser browser) {
        SwingUtilities.updateComponentTreeUI(browser);
        SwingUtilities.updateComponentTreeUI(this);
        SmartTree explore = browser.getTree();
        SmartTree search = browser.getSearchTree();
        SmartTree schema = browser.getSchemaTree();
        SwingUtilities.updateComponentTreeUI(explore);
        SwingUtilities.updateComponentTreeUI(search);
        SwingUtilities.updateComponentTreeUI(schema);
        SwingUtilities.updateComponentTreeUI(explore.getPopupTool());
        SwingUtilities.updateComponentTreeUI(search.getPopupTool());
        SwingUtilities.updateComponentTreeUI(schema.getPopupTool());
        SearchGUI sExplore = explore.getSearchGUI();
        SearchGUI sSearch = search.getSearchGUI();
        SearchGUI sSchema = schema.getSearchGUI();
        if (sExplore != null) {
            SwingUtilities.updateComponentTreeUI(sExplore);
        }
        if (sSearch != null) {
            SwingUtilities.updateComponentTreeUI(sSearch);
        }
        if (sSchema != null) {
            SwingUtilities.updateComponentTreeUI(sSchema);
        }
    }

    private void logMethod() {
        CBPanel logMethodPanel = new CBPanel();
        logMethodPanel.addln(new JLabel(CBIntText.get("Select a New Log Method") + ": "));
        logMethodPanel.addln(new JLabel(" "));
        this.logMethodCombo = new JComboBox<String>(this.logMethodVal);
        this.logMethodCombo.setToolTipText(CBIntText.get("Set the log method in JXplorer."));
        logMethodPanel.addln(this.logMethodCombo);
        logMethodPanel.addln(new JLabel(" "));
        this.getLogMethod();
        this.tabbedPane.addTab(CBIntText.get("Log Method"), new ImageIcon(Theme.getInstance().getDirIcons() + "log_method.gif"), logMethodPanel, CBIntText.get("Set the method of logging you want, for example, to a file."));
    }

    private void getLogMethod() {
        String logHandlers = JXConfig.getProperty("handlers");
        if (logHandlers.indexOf("ConsoleHandler") > 0 && logHandlers.indexOf("FileHandler") > 0) {
            this.logMethodCombo.setSelectedItem(this.logMethodVal[3]);
        } else if (logHandlers.indexOf("FileHandler") > 0) {
            this.logMethodCombo.setSelectedItem(this.logMethodVal[2]);
        } else if (logHandlers.indexOf("ConsoleHandler") > 0) {
            this.logMethodCombo.setSelectedItem(this.logMethodVal[1]);
        } else {
            this.logMethodCombo.setSelectedItem(this.logMethodVal[0]);
        }
    }

    private void logLevel() {
        CBPanel logLevelPanel = new CBPanel();
        logLevelPanel.addln(new JLabel(CBIntText.get("Select a New Log Level") + ": "));
        logLevelPanel.addln(new JLabel(" "));
        this.logLevelCombo = new JComboBox<String>(this.logLevelVal);
        this.logLevelCombo.setToolTipText(CBIntText.get("Set the logging level in JXplorer."));
        logLevelPanel.addln(this.logLevelCombo);
        logLevelPanel.addln(new JLabel(" "));
        this.getLogLevel();
        this.tabbedPane.addTab(CBIntText.get("Log Level"), new ImageIcon(Theme.getInstance().getDirIcons() + "log_level.gif"), logLevelPanel, CBIntText.get("Set the level of logging you want, for example, errors only."));
    }

    private void getLogLevel() {
        Level logLevel;
        try {
            logLevel = Level.parse(JXConfig.getProperty(".level"));
        }
        catch (Exception e) {
            logLevel = Level.WARNING;
        }
        if (logLevel.equals(Level.SEVERE)) {
            this.logLevelCombo.setSelectedItem(this.logLevelVal[0]);
        } else if (logLevel.equals(Level.WARNING)) {
            this.logLevelCombo.setSelectedItem(this.logLevelVal[1]);
        } else if (logLevel.equals(Level.INFO)) {
            this.logLevelCombo.setSelectedItem(this.logLevelVal[2]);
        } else if (logLevel.equals(Level.FINE)) {
            this.logLevelCombo.setSelectedItem(this.logLevelVal[3]);
        } else if (logLevel.equals(Level.FINEST)) {
            this.logLevelCombo.setSelectedItem(this.logLevelVal[4]);
        } else if (logLevel.equals(Level.ALL)) {
            this.logLevelCombo.setSelectedItem(this.logLevelVal[5]);
        } else {
            this.logLevelCombo.setSelectedItem(this.logLevelVal[1]);
        }
    }

    private void ldapLevels() {
        this.ldapLimit = new JTextField();
        this.ldapTimeout = new JTextField();
        this.pagedResults = new JCheckBox();
        this.pageSize = new JTextField();
        this.getLdapLevels();
        CBPanel ldapLevelsPanel = new CBPanel();
        ldapLevelsPanel.addln(new JLabel(CBIntText.get("Set LDAP Options") + ": "));
        ldapLevelsPanel.addln(new JLabel(" "));
        ldapLevelsPanel.add(new JLabel(CBIntText.get("LDAP Limit") + ": "));
        ldapLevelsPanel.add(this.ldapLimit);
        ldapLevelsPanel.newLine();
        ldapLevelsPanel.addln(new JLabel(" "));
        ldapLevelsPanel.add(new JLabel(CBIntText.get("LDAP Timeout") + ": "));
        ldapLevelsPanel.add(this.ldapTimeout);
        ldapLevelsPanel.newLine();
        ldapLevelsPanel.addln(new JLabel(" "));
        ldapLevelsPanel.add(new JLabel(CBIntText.get("Use Paged Results") + ": "));
        ldapLevelsPanel.add(this.pagedResults);
        ldapLevelsPanel.newLine();
        ldapLevelsPanel.addln(new JLabel(" "));
        ldapLevelsPanel.add(new JLabel(CBIntText.get("Page Size") + ": "));
        ldapLevelsPanel.add(this.pageSize);
        this.pagedResults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AdvancedOptions.this.pagedResults.isSelected()) {
                    AdvancedOptions.this.pageSize.setEnabled(true);
                    if ("-1".equals(AdvancedOptions.this.pageSize.getText().trim())) {
                        AdvancedOptions.this.pageSize.setText("1000");
                    }
                } else {
                    AdvancedOptions.this.pageSize.setText("-1");
                    AdvancedOptions.this.pageSize.setEnabled(false);
                }
            }
        });
        this.tabbedPane.addTab(CBIntText.get("Search Limits"), new ImageIcon(Theme.getInstance().getDirIcons() + "find.gif"), ldapLevelsPanel, CBIntText.get("Set the search levels, that is, the number of entries returned from a search and the timeout."));
    }

    private void getLdapLevels() {
        String limit = JXConfig.getProperty("option.ldap.limit");
        String timeout = JXConfig.getProperty("option.ldap.timeout");
        String size = JXConfig.getProperty("option.ldap.pageSize");
        String usingPaging = JXConfig.getProperty("option.ldap.pagedResults");
        this.ldapLimit.setText(limit);
        this.ldapLimit.setColumns(5);
        this.ldapLimit.setToolTipText(CBIntText.get("Enter the new limit level."));
        this.ldapTimeout.setText(timeout);
        this.ldapTimeout.setColumns(5);
        this.ldapTimeout.setToolTipText(CBIntText.get("Enter the new timeout level."));
        this.pageSize.setText(size);
        this.pageSize.setToolTipText(CBIntText.get("Enter the page size for paged results."));
        this.pageSize.setColumns(5);
        this.pagedResults.setSelected("true".equalsIgnoreCase(usingPaging));
        this.pagedResults.setToolTipText(CBIntText.get("Whether to use paged results to return large data sets"));
        this.pageSize.setEnabled(this.pagedResults.isSelected());
    }

    private void urlTab() {
        String[] url = new String[]{CBIntText.get("JXplorer"), CBIntText.get("Launch")};
        CBPanel urlPanel = new CBPanel();
        this.urlCombo = new JComboBox<String>(url);
        this.getURLHandling();
        urlPanel.addln(new JLabel(CBIntText.get("Select URL handling") + ": "));
        urlPanel.addln(new JLabel(" "));
        urlPanel.addln(this.urlCombo);
        urlPanel.addln(new JLabel(" "));
        urlPanel.addln(new JLabel(CBIntText.get("Note: Launch is for Windows only.")));
        this.tabbedPane.addTab(CBIntText.get("URL"), new ImageIcon(Theme.getInstance().getDirIcons() + "url.gif"), urlPanel, CBIntText.get("Select how you would like the URLs handled in JXplorer."));
    }

    private void getURLHandling() {
        String urlHandling = JXConfig.getProperty("option.url.handling");
        int index = 0;
        if (urlHandling != null && urlHandling.equalsIgnoreCase("Launch")) {
            index = 1;
        }
        this.urlCombo.setSelectedIndex(index);
    }

    private void pwdTab() {
        String[] cache = new String[]{CBIntText.get("Yes"), CBIntText.get("No")};
        CBPanel urlPanel = new CBPanel();
        this.cachePwdCombo = new JComboBox<String>(cache);
        this.getPasswordCachingOption();
        urlPanel.addln(new JLabel(CBIntText.get("Cache Passwords") + ": "));
        urlPanel.addln(new JLabel(" "));
        urlPanel.addln(this.cachePwdCombo);
        urlPanel.addln(new JLabel(" "));
        urlPanel.addln(new JLabel(CBIntText.get(" ")));
        this.tabbedPane.addTab(CBIntText.get("Cache Passwords"), new ImageIcon(Theme.getInstance().getDirIcons() + "cachePwds.gif"), urlPanel, CBIntText.get("Select Yes if you want passwords cached in JXplorer."));
    }

    private void getPasswordCachingOption() {
        String pwdCaching = JXConfig.getProperty("jxplorer.cache.passwords");
        int index = 0;
        if (pwdCaching != null && pwdCaching.equalsIgnoreCase("false")) {
            index = 1;
        }
        this.cachePwdCombo.setSelectedIndex(index);
    }

    private void apply() {
        this.checkLookAndFeel();
        this.checkLogMethod();
        this.checkLogLevel();
        this.checkLdapLevels();
        this.checkUrlHandling();
        this.checkCachePwds();
        this.quit();
    }

    private void checkLogMethod() {
        try {
            int logMethod = this.logMethodCombo.getSelectedIndex();
            String original = JXConfig.getProperty("handlers");
            switch (logMethod) {
                case 0: {
                    JXConfig.setProperty("handlers", "");
                    break;
                }
                case 1: {
                    JXConfig.setProperty("handlers", "java.util.logging.ConsoleHandler");
                    break;
                }
                case 2: {
                    JXConfig.setProperty("handlers", "java.util.logging.FileHandler");
                    break;
                }
                case 3: {
                    JXConfig.setProperty("handlers", "java.util.logging.ConsoleHandler,java.util.logging.FileHandler");
                    break;
                }
                default: {
                    JXConfig.setProperty("handlers", "java.util.logging.ConsoleHandler,java.util.logging.FileHandler");
                }
            }
            if (!original.equals(JXConfig.getProperty("handlers"))) {
                JXConfig.writePropertyFile();
                JXConfig.setupLogger();
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void checkLogLevel() {
        String original = JXConfig.getProperty(".level");
        switch (this.logLevelCombo.getSelectedIndex()) {
            case 0: {
                JXConfig.setProperty(".level", "SEVERE");
                JXConfig.setProperty("com.ca.level", "SEVERE");
                break;
            }
            case 1: {
                JXConfig.setProperty(".level", "WARNING");
                JXConfig.setProperty("com.ca.level", "WARNING");
                break;
            }
            case 2: {
                JXConfig.setProperty(".level", "INFO");
                JXConfig.setProperty("com.ca.level", "INFO");
                break;
            }
            case 3: {
                JXConfig.setProperty(".level", "FINE");
                JXConfig.setProperty("com.ca.level", "FINE");
                break;
            }
            case 4: {
                JXConfig.setProperty(".level", "FINEST");
                JXConfig.setProperty("com.ca.level", "FINEST");
                break;
            }
            case 5: {
                JXConfig.setProperty(".level", "ALL");
                JXConfig.setProperty("com.ca.level", "ALL");
                break;
            }
            default: {
                JXConfig.setProperty(".level", "WARNING");
                JXConfig.setProperty("com.ca.level", "WARNING");
            }
        }
        if (!original.equals(JXConfig.getProperty(".handlers"))) {
            JXConfig.writePropertyFile();
            JXConfig.setupLogger();
        }
        this.browser.checkSpecialLoggingActions();
    }

    private void checkLdapLevels() {
        String limit = this.ldapLimit.getText();
        String timeout = this.ldapTimeout.getText();
        boolean usePaging = this.pagedResults.isSelected();
        String size = this.pageSize.getText();
        try {
            Integer.valueOf(limit);
            Integer.valueOf(timeout);
            Integer.valueOf(size);
        }
        catch (NumberFormatException e) {
            CBUtility.error("Ldap limit, timeout and page size must be integers.\n" + e);
            this.getLdapLevels();
        }
        JXConfig.setProperty("option.ldap.limit", limit);
        JXConfig.setProperty("option.ldap.timeout", timeout);
        JXConfig.setProperty("option.ldap.pagedResults", Boolean.toString(usePaging));
        JXConfig.setProperty("option.ldap.pageSize", usePaging ? size : "-1");
        this.browser.searchBroker.setTimeout(Integer.parseInt(timeout));
        this.browser.searchBroker.setLimit(Integer.parseInt(limit));
        this.browser.searchBroker.setPaging(usePaging, Integer.valueOf(size));
        this.browser.getJndiBroker().setPaging(usePaging, Integer.valueOf(size));
    }

    private void checkUrlHandling() {
        int index = this.urlCombo.getSelectedIndex();
        if (index == 1) {
            JXConfig.setProperty("option.url.handling", "Launch");
        } else {
            JXConfig.setProperty("option.url.handling", "JXplorer");
        }
    }

    private void checkCachePwds() {
        int index = this.cachePwdCombo.getSelectedIndex();
        if (index == 1) {
            JXConfig.setProperty("jxplorer.cache.passwords", "false");
        } else {
            JXConfig.setProperty("jxplorer.cache.passwords", "true");
        }
    }

    private void reset() {
        this.getLookAndFeel();
        this.getLogLevel();
        this.getLogMethod();
        this.getLdapLevels();
        this.getURLHandling();
        this.getPasswordCachingOption();
    }

    private void quit() {
        this.setVisible(false);
        this.dispose();
    }

    private class MyAction
    extends CBAction {
        public MyAction(int key) {
            super(key);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.getKey() == 27) {
                AdvancedOptions.this.quit();
            } else if (this.getKey() == 10) {
                AdvancedOptions.this.apply();
            }
        }
    }
}

