/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert;

import com.ca.commons.cbutil.CBParse;
import com.ca.commons.security.asn1.ASN1OID;
import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.asn1.DERCoder;
import com.ca.commons.security.cert.CertViewer;
import com.ca.commons.security.cert.extensions.AuthorityInfoAccess;
import com.ca.commons.security.cert.extensions.AuthorityKeyIdentifier;
import com.ca.commons.security.cert.extensions.BasicConstraints;
import com.ca.commons.security.cert.extensions.CRLDistributionPoints;
import com.ca.commons.security.cert.extensions.CertificatePolicies;
import com.ca.commons.security.cert.extensions.ExtendedKeyUsage;
import com.ca.commons.security.cert.extensions.IssuerAltName;
import com.ca.commons.security.cert.extensions.KeyUsage;
import com.ca.commons.security.cert.extensions.NameConstraints;
import com.ca.commons.security.cert.extensions.NetscapeCertType;
import com.ca.commons.security.cert.extensions.PolicyConstraints;
import com.ca.commons.security.cert.extensions.PolicyMappings;
import com.ca.commons.security.cert.extensions.PrivateKeyUsagePeriod;
import com.ca.commons.security.cert.extensions.SubjectAltName;
import com.ca.commons.security.cert.extensions.SubjectKeyIdentifier;
import com.ca.commons.security.cert.extensions.V3Extension;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Hashtable;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;

class CertDetailsTableModel
extends AbstractTableModel {
    private String[] headers = new String[]{"Field", "Value"};
    private Vector data = new Vector();
    private X509Certificate cert = null;
    private Hashtable briefDetails = new Hashtable();

    public Object getDetails(String brief) {
        return this.briefDetails.get(brief);
    }

    public CertDetailsTableModel(X509Certificate cert, int viewMode) {
        this.cert = cert;
        this.setViewMode(viewMode);
    }

    public void setViewMode(int viewMode) {
        Set<String> critSet;
        String extname;
        Set<String> nonCritSet;
        this.data = new Vector();
        if (this.cert == null) {
            return;
        }
        if (viewMode == 0 || viewMode == 1) {
            Vector<Object> versionRow = new Vector<Object>();
            versionRow.add(new JLabel("Version", CertViewer.attributeIcon, 2));
            versionRow.add("V" + this.cert.getVersion());
            this.data.add(versionRow);
            Vector<Object> serialNumberRow = new Vector<Object>();
            serialNumberRow.add(new JLabel("Serial Number", CertViewer.attributeIcon, 2));
            serialNumberRow.add(CBParse.bytes2Hex(this.cert.getSerialNumber().toByteArray()));
            this.data.add(serialNumberRow);
            Vector<Object> sigAlgRow = new Vector<Object>();
            sigAlgRow.add(new JLabel("Signature Algorithm", CertViewer.attributeIcon, 2));
            sigAlgRow.add(this.cert.getSigAlgName());
            this.data.add(sigAlgRow);
            Vector<Object> issuerRow = new Vector<Object>();
            issuerRow.add(new JLabel("Issuer", CertViewer.attributeIcon, 2));
            issuerRow.add(this.cert.getIssuerX500Principal().getName());
            this.data.add(issuerRow);
            Vector<Serializable> fromRow = new Vector<Serializable>();
            fromRow.add(new JLabel("Valid From", CertViewer.attributeIcon, 2));
            fromRow.add(this.cert.getNotBefore());
            this.data.add(fromRow);
            Vector<Serializable> toRow = new Vector<Serializable>();
            toRow.add(new JLabel("Valid To", CertViewer.attributeIcon, 2));
            toRow.add(this.cert.getNotAfter());
            this.data.add(toRow);
            Vector<Object> subjectRow = new Vector<Object>();
            subjectRow.add(new JLabel("Subject", CertViewer.attributeIcon, 2));
            subjectRow.add(this.cert.getSubjectX500Principal().getName());
            this.data.add(subjectRow);
            Vector<Object> publicKeyRow = new Vector<Object>();
            publicKeyRow.add(new JLabel("Public Key", CertViewer.attributeIcon, 2));
            PublicKey pubKey = this.cert.getPublicKey();
            String publicKeyString = pubKey.getAlgorithm();
            if (pubKey instanceof RSAPublicKey) {
                publicKeyString = publicKeyString + " (" + ((RSAPublicKey)pubKey).getModulus().bitLength() + " Bits)";
            } else if (pubKey instanceof DSAPublicKey) {
                publicKeyString = publicKeyString + " (" + ((DSAPublicKey)pubKey).getY().bitLength() + " Bits)";
            }
            publicKeyRow.add(publicKeyString);
            this.data.add(publicKeyRow);
        }
        if (!(viewMode != 0 && viewMode != 2 || (nonCritSet = this.cert.getNonCriticalExtensionOIDs()) == null || nonCritSet.isEmpty())) {
            for (String oid : nonCritSet) {
                Vector<JLabel> nonCritRow = new Vector<JLabel>();
                extname = this.getNameFromOID(oid);
                nonCritRow.add(new JLabel(extname, CertViewer.extensionIcon, 2));
                this.addExtDetails(nonCritRow, this.printext(extname, this.cert.getExtensionValue(oid)).toString());
                this.data.add(nonCritRow);
            }
        }
        if (!(viewMode != 0 && viewMode != 2 && viewMode != 3 || (critSet = this.cert.getCriticalExtensionOIDs()) == null || critSet.isEmpty())) {
            for (String oid : critSet) {
                Vector<JLabel> critRow = new Vector<JLabel>();
                extname = this.getNameFromOID(oid);
                critRow.add(new JLabel(extname, CertViewer.criticalExtensionIcon, 2));
                this.addExtDetails(critRow, this.printext(extname, this.cert.getExtensionValue(oid)).toString());
                this.data.add(critRow);
            }
        }
        if (viewMode == 0 || viewMode == 4) {
            Vector<Object> thumbprintAlgorithmRow = new Vector<Object>();
            thumbprintAlgorithmRow.add(new JLabel("Thumbprint Algorithm", CertViewer.thumbprintIcon, 2));
            thumbprintAlgorithmRow.add("sha1");
            this.data.add(thumbprintAlgorithmRow);
            try {
                Vector<Object> thumbprintRow = new Vector<Object>();
                thumbprintRow.add(new JLabel("Thumbprint", CertViewer.thumbprintIcon, 2));
                MessageDigest md = MessageDigest.getInstance("SHA");
                byte[] hash = md.digest(this.cert.getEncoded());
                thumbprintRow.add(CBParse.bytes2HexSplit(hash, 4));
                this.data.add(thumbprintRow);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.fireTableStructureChanged();
    }

    private void debugPrint() {
        System.out.println("get dn: " + this.cert.getSubjectDN());
        System.out.println("get dn name: " + this.cert.getSubjectDN().getName());
        System.out.println("getName: " + this.cert.getSubjectX500Principal().getName());
        System.out.println("rfc2253: " + this.cert.getSubjectX500Principal().getName("RFC2253"));
        System.out.println("canonical: " + this.cert.getSubjectX500Principal().getName("CANONICAL"));
        System.out.println("toString: " + this.cert.getSubjectX500Principal().toString());
        System.out.print("der: ");
        byte[] bytes = this.cert.getSubjectX500Principal().getEncoded();
        for (int i = 0; i < bytes.length; ++i) {
            System.out.print(" " + bytes[i]);
        }
        String name = this.cert.getSubjectX500Principal().getName();
        System.out.println();
        System.out.println("default: ");
        bytes = name.getBytes();
        System.out.println("straight name: " + CBParse.bytes2Hex(bytes));
        try {
            System.out.println("unicode: " + CBParse.bytes2Hex(name.getBytes("UTF-16")));
            System.out.println("utf-8: " + CBParse.bytes2Hex(name.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e2) {
            e2.printStackTrace();
        }
        System.out.println();
    }

    private void addExtDetails(Vector row, String extDetails) {
        StringTokenizer tok = new StringTokenizer(extDetails, "\n");
        if (tok.countTokens() > 1) {
            String brief = tok.nextToken();
            row.addElement(brief);
            this.briefDetails.put(brief, extDetails);
        } else {
            row.addElement(extDetails);
        }
    }

    private String getNameFromOID(String oid) {
        return ASN1OID.getName(oid);
    }

    private Object printext(String extname, byte[] extvalue) {
        try {
            DERCoder derCoder = new DERCoder();
            ASN1Object ext = derCoder.decode(extvalue);
            ASN1Object rext = null;
            if (ext.isASN1Type(ASN1Type.OCTET_STRING)) {
                rext = derCoder.decode((byte[])ext.getValue());
            }
            V3Extension v3e = null;
            boolean done = false;
            if (extname.equals("Authority Information Access")) {
                v3e = new AuthorityInfoAccess();
                done = true;
            } else if (extname.equals("Subject Key Identifier")) {
                v3e = new SubjectKeyIdentifier();
                done = true;
            } else if (extname.equals("Key Usage")) {
                v3e = new KeyUsage();
                done = true;
            } else if (extname.equals("Subject Alternative Name")) {
                v3e = new SubjectAltName();
                done = true;
            } else if (extname.equals("Issuer Alternative Name")) {
                v3e = new IssuerAltName();
                done = true;
            } else if (extname.equals("Basic Constraints")) {
                v3e = new BasicConstraints();
                done = true;
            } else if (extname.equals("Name Constraints")) {
                v3e = new NameConstraints();
            } else if (extname.equals("Certificate Policies")) {
                v3e = new CertificatePolicies();
                done = true;
            } else if (extname.equals("Policy Mappings")) {
                v3e = new PolicyMappings();
            } else if (extname.equals("Authority Key Identifier")) {
                v3e = new AuthorityKeyIdentifier();
                done = true;
            } else if (extname.equals("Policy Constraints")) {
                v3e = new PolicyConstraints();
            } else if (extname.equals("Extended Key Usage")) {
                v3e = new ExtendedKeyUsage();
                done = true;
            } else if (extname.equals("CRL Distribution Points")) {
                v3e = new CRLDistributionPoints();
                done = true;
            } else if (extname.equals("Private Key Usage Period")) {
                v3e = new PrivateKeyUsagePeriod();
                done = true;
            } else if (extname.equals("Netscape Cert Type")) {
                v3e = new NetscapeCertType();
                done = true;
            }
            if (!done) {
                System.out.println("extname: " + extname);
                System.out.println("exttype: " + rext);
                System.out.println("extvalu: " + rext.getValue());
                System.out.println("extbyte: " + CBParse.bytes2HexSplit((byte[])ext.getValue(), 4, 36));
            }
            if (v3e != null) {
                v3e.init(rext);
                if (v3e.toString() == null) {
                    throw new Exception("Could not read extension: " + extname);
                }
                return v3e;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return CBParse.bytes2HexSplit(extvalue, 4, 36);
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int col) {
        return this.headers[col];
    }

    public Object getValueAt(int row, int col) {
        return ((Vector)this.data.elementAt(row)).elementAt(col);
    }

    public Class getColumnClass(int col) {
        return this.getValueAt(0, col).getClass();
    }
}

