/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security;

import com.ca.commons.security.JXTrustManager;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class JXSSLSocketFactory
extends SSLSocketFactory {
    private static SSLSocketFactory factory = null;
    private static JXSSLSocketFactory default_factory = null;
    private static KeyStore clientKeystore;
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static ClassLoader myClassLoader;
    static boolean debug;

    public static void setClassLoader(ClassLoader newLoader) {
        myClassLoader = newLoader;
    }

    private static ClassLoader getClassLoader() {
        if (myClassLoader == null) {
            myClassLoader = ClassLoader.getSystemClassLoader();
        }
        return myClassLoader;
    }

    public static void setDebug(boolean status) {
        debug = true;
        if (status) {
            System.setProperty("javax.net.debug", "ssl,handshake,verbose");
        } else {
            System.setProperty("javax.net.debug", " ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String caKeystoreFile, String clientKeystoreFile, char[] caPassphrase, char[] clientPassphrase, String caKeystoreType, String clientKeystoreType, Frame owner) throws GeneralSecurityException, IOException {
        boolean usingSASL = false;
        JXSSLSocketFactory.checkFileSanity(caKeystoreFile, clientKeystoreFile, clientPassphrase);
        if (clientPassphrase != null && clientPassphrase.length > 0 && clientKeystoreFile != null) {
            usingSASL = true;
        }
        if (caKeystoreFile == null && clientKeystoreFile != null) {
            caKeystoreFile = clientKeystoreFile;
        }
        if (caKeystoreType == null) {
            caKeystoreType = DEFAULT_KEYSTORE_TYPE;
        }
        SSLContext sslctx = JXSSLSocketFactory.setSSLContextProtocol();
        KeyManagerFactory clientKeyManagerFactory = null;
        TrustManagerFactory caTrustManagerFactory = null;
        KeyStore caKeystore = null;
        KeyManager[] clientKeyManagers = null;
        if (usingSASL) {
            if (clientKeystoreType == null) {
                clientKeystoreType = DEFAULT_KEYSTORE_TYPE;
            }
            clientKeystore = KeyStore.getInstance(clientKeystoreType);
            if (clientKeystoreFile != null) {
                clientKeystore.load(new FileInputStream(clientKeystoreFile), clientPassphrase);
            }
            clientKeyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            clientKeyManagerFactory.init(clientKeystore, clientPassphrase);
            clientKeyManagers = clientKeyManagerFactory.getKeyManagers();
        } else {
            clientKeystore = null;
        }
        caKeystore = KeyStore.getInstance(caKeystoreType);
        if (caKeystoreFile != null) {
            caKeystore.load(new FileInputStream(caKeystoreFile), caPassphrase);
        }
        String defaultTrustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        caTrustManagerFactory = TrustManagerFactory.getInstance(defaultTrustAlgorithm);
        caTrustManagerFactory.init(caKeystore);
        TrustManager[] caTrustManagers = caTrustManagerFactory.getTrustManagers();
        TrustManager[] trustedServerAndCAManagers = caTrustManagers = JXTrustManager.convert(caTrustManagers, caKeystore, caKeystoreFile, caPassphrase, caKeystoreType, owner);
        sslctx.init(clientKeyManagers, trustedServerAndCAManagers, null);
        factory = sslctx.getSocketFactory();
        Class<JXSSLSocketFactory> clazz = JXSSLSocketFactory.class;
        synchronized (JXSSLSocketFactory.class) {
            default_factory = new JXSSLSocketFactory();
            // ** MonitorExit[var16_16] (shouldn't be in output)
            return;
        }
    }

    private static SSLContext setSSLContextProtocol() throws NoSuchAlgorithmException {
        String protocol = System.getProperty("sslversion", "TLS");
        if (!"TLS".equals(protocol)) {
            System.out.println("SECURITY WARNING: Using non-standard ssl version: '" + protocol + "'\n (P.S. You can set the exact ssl protocol used with options.ssl.protocol; see jxconfig.txt)");
        }
        SSLContext sslctx = SSLContext.getInstance(protocol);
        return sslctx;
    }

    private static void checkFileSanity(String caKeystoreFile, String clientKeystoreFile, char[] clientPassphrase) throws SSLException {
        if (clientKeystoreFile == null && caKeystoreFile == null) {
            throw new SSLException("SSL Initialisation error: No valid keystore files available.");
        }
        if (caKeystoreFile != null && !new File(caKeystoreFile).exists()) {
            throw new SSLException("SSL Initialisation error: file '" + caKeystoreFile + "' does not exist.");
        }
        if (clientKeystoreFile != null && clientPassphrase != null && !new File(clientKeystoreFile).exists()) {
            throw new SSLException("SSL Initialisation error: file '" + clientKeystoreFile + "' does not exist.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketFactory getDefault() {
        Class<JXSSLSocketFactory> clazz = JXSSLSocketFactory.class;
        synchronized (JXSSLSocketFactory.class) {
            if (default_factory == null) {
                default_factory = new JXSSLSocketFactory();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return default_factory;
        }
    }

    public static KeyStore getClientKeyStore() {
        return clientKeystore;
    }

    private static void optionallySetSSLSocketProtocol(SSLSocket newSocket) {
        int i;
        String protocol;
        if (debug) {
            String[] enabledProtocols = newSocket.getEnabledProtocols();
            for (int i2 = 0; i2 < enabledProtocols.length; ++i2) {
                System.out.println("Available SSL Protocol: " + i2 + " = " + enabledProtocols[i2]);
            }
        }
        if ((protocol = System.getProperty("option.ssl.protocol")).equalsIgnoreCase("any")) {
            return;
        }
        String[] availableProtocols = newSocket.getSupportedProtocols();
        ArrayList<String> protocolsToSet = new ArrayList<String>();
        for (i = 0; i < availableProtocols.length; ++i) {
            String anAvailableProtocol = availableProtocols[i];
            if (!protocol.contains(anAvailableProtocol) && !anAvailableProtocol.startsWith(protocol)) continue;
            protocolsToSet.add(anAvailableProtocol);
            if (!debug) continue;
            System.out.println("SSL: enabling protocol '" + anAvailableProtocol + "'");
        }
        if (protocolsToSet.size() == 0) {
            System.out.println("WARNING: Unable to set SSL to use '" + protocol + "'.  Available Protocols are:");
            for (i = 0; i < availableProtocols.length; ++i) {
                System.out.println(availableProtocols[i]);
            }
        } else {
            String[] protocols = protocolsToSet.toArray(new String[0]);
            newSocket.setEnabledProtocols(protocols);
        }
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket newSocket = (SSLSocket)factory.createSocket(host, port);
        JXSSLSocketFactory.optionallySetSSLSocketProtocol(newSocket);
        return newSocket;
    }

    public Socket createSocket(InetAddress host, int port) throws IOException, UnknownHostException {
        SSLSocket newSocket = (SSLSocket)factory.createSocket(host, port);
        JXSSLSocketFactory.optionallySetSSLSocketProtocol(newSocket);
        return newSocket;
    }

    public Socket createSocket(InetAddress host, int port, InetAddress client_host, int client_port) throws IOException, UnknownHostException {
        SSLSocket newSocket = (SSLSocket)factory.createSocket(host, port, client_host, client_port);
        JXSSLSocketFactory.optionallySetSSLSocketProtocol(newSocket);
        return newSocket;
    }

    public Socket createSocket(String host, int port, InetAddress client_host, int client_port) throws IOException, UnknownHostException {
        SSLSocket newSocket = (SSLSocket)factory.createSocket(host, port, client_host, client_port);
        JXSSLSocketFactory.optionallySetSSLSocketProtocol(newSocket);
        return newSocket;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoclose) throws IOException, UnknownHostException {
        SSLSocket newSocket = (SSLSocket)factory.createSocket(socket, host, port, autoclose);
        JXSSLSocketFactory.optionallySetSSLSocketProtocol(newSocket);
        return newSocket;
    }

    public String[] getDefaultCipherSuites() {
        return factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return factory.getSupportedCipherSuites();
    }

    static {
        myClassLoader = null;
        debug = false;
    }
}

