/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.naming;

import com.ca.commons.cbutil.CBBase64;
import com.ca.commons.cbutil.CBParse;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.LdifEntry;
import com.ca.commons.naming.LdifEntryType;
import com.ca.commons.naming.LdifModifyAttribute;
import com.ca.commons.naming.LdifModifyType;
import com.ca.commons.naming.LdifStreamReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;

public class LdifUtility {
    private static boolean debug = false;
    private static boolean handleXML = false;
    private Hashtable params = null;
    private String filedir = null;
    public static String cr = "\n";
    private static final Logger log = Logger.getLogger(LdifUtility.class.getName());
    private int lineNumber = 0;
    private String fileName = "";

    public LdifUtility() {
    }

    public void resetErrorReportingInformation(String ldifFileName) {
        this.lineNumber = 0;
        this.fileName = ldifFileName;
    }

    public static void setSupportXML_LDIF_RFC(boolean state) {
        handleXML = state;
    }

    public LdifUtility(Hashtable params, String filedir) {
        this.params = params;
        this.filedir = filedir;
    }

    public int getCurrentLineNumber() {
        return this.lineNumber;
    }

    public void setFileDir(String filedir) {
        this.filedir = filedir + "\\";
    }

    public void setParams(Hashtable params) {
        this.params = params;
    }

    public String ldifEncodeAsBinary(String attributeID, Object attributeValue) {
        StringBuffer ldifData = new StringBuffer(attributeID).append(":: ");
        int offset = attributeID.length() + 3;
        if (attributeValue.getClass().isArray()) {
            try {
                byte[] b = (byte[])attributeValue;
                ldifData.append(CBBase64.binaryToString(b, offset)).append("\n");
                return ldifData.toString();
            }
            catch (ClassCastException e) {
                log.warning("unable to cast array to byte array.");
            }
        }
        ldifData.append(CBBase64.binaryToString(attributeValue.toString().getBytes(), offset)).append("\n");
        return ldifData.toString();
    }

    public static String ldifEncode(String attributeID, Object attributeValue) {
        StringBuffer ldifData = new StringBuffer();
        String val = LdifUtility.ldifEncode(attributeValue, attributeID.length());
        if (val == null || val.length() == 0) {
            return "";
        }
        ldifData.append(attributeID).append(val).append("\n");
        return ldifData.toString();
    }

    public static String ldifEncode(Object o, int offset) {
        boolean base64Encode = false;
        boolean xmlEncode = false;
        if (!(o instanceof String) && o.getClass().isArray()) {
            try {
                byte[] b = (byte[])o;
                String ret = ":: " + CBBase64.binaryToString(b, offset + 3);
                return ret;
            }
            catch (ClassCastException e) {
                log.warning("unable to cast array to byte array.");
                return null;
            }
        }
        String s = o.toString();
        int len = s.length();
        if (len == 0) {
            return ": ";
        }
        char startChar = s.charAt(0);
        if ("\n\r :".indexOf(startChar) != -1) {
            base64Encode = true;
        } else if (startChar == '<') {
            if (handleXML && s.startsWith("<?xml ")) {
                xmlEncode = true;
            } else {
                base64Encode = true;
            }
        } else {
            char[] test = new char[len];
            s.getChars(0, len, test, 0);
            for (int i = 0; i < len; ++i) {
                if (test[i] <= '~' && test[i] >= ' ') continue;
                base64Encode = true;
                break;
            }
        }
        if (s.charAt(s.length() - 1) == ' ') {
            base64Encode = true;
        }
        if (base64Encode) {
            return ":: " + LdifUtility.translateToLdifBase64(s, offset);
        }
        if (xmlEncode) {
            return ": " + LdifUtility.translateToLdifXML(s);
        }
        return ": " + s;
    }

    private static String translateToLdifBase64(String s, int offset) {
        try {
            s = CBBase64.binaryToString(s.getBytes("UTF8"), offset + 3);
        }
        catch (UnsupportedEncodingException e) {
            log.log(Level.WARNING, "error utf8 encoding strings...", e);
            s = CBBase64.binaryToString(s.getBytes(), offset + 3);
        }
        return s;
    }

    private static String translateToLdifXML(String s) {
        StringBuffer xml = new StringBuffer(";transfer-rxer>:").append(cr).append(s);
        if (s.indexOf("\r") != -1) {
            CBParse.replaceAllBufferString(xml, "\r", "\r>");
        }
        if (s.indexOf("\n") != -1) {
            CBParse.replaceAllBufferString(xml, "\n", "\n>");
        }
        return xml.toString();
    }

    public void writeLdifEntry(DXEntry entry, FileWriter saveFile, String originalPrefix, String replacementPrefix) throws NamingException, IOException {
        String dn = entry.getStringName();
        if (originalPrefix != null && dn.endsWith(originalPrefix) && !originalPrefix.equals(replacementPrefix)) {
            if (debug) {
                System.out.println("original DN = '" + dn + "'");
            }
            dn = dn.substring(0, dn.length() - originalPrefix.length()) + replacementPrefix;
            if (debug) {
                System.out.println("after replacement DN = '" + dn + "'");
            }
            entry.setDN(new DN(dn));
        }
        String ldifData = new LdifEntry(entry).toString();
        if (debug) {
            System.out.println(ldifData);
        } else {
            saveFile.write(ldifData);
            saveFile.flush();
        }
    }

    public void ldifDecode(String attributeText, LdifEntry newEntry) throws NamingException {
        if (attributeText.startsWith("-")) {
            return;
        }
        Object[] attributeValuePair = this.ldifDecodeAttribute(attributeText);
        if (attributeValuePair == null || attributeValuePair[1] == null) {
            return;
        }
        String attributeID = (String)attributeValuePair[0];
        Object value = attributeValuePair[1];
        if ("dn".equalsIgnoreCase(attributeID)) {
            DN dn = new DN(value.toString());
            newEntry.setDN(dn);
            if (dn.error()) {
                log.severe("error reading ldif DXEntry: (" + this.lineNumber + ") in LDIF file: + " + this.fileName + " value: " + value + " - skipping");
                newEntry.setDN(null);
            }
        } else {
            if ("changetype".equalsIgnoreCase(attributeID)) {
                String designatedChangeType = value.toString();
                for (LdifEntryType entryType : LdifEntryType.values()) {
                    if (!designatedChangeType.equals(entryType.toString())) continue;
                    newEntry.setChangeType(entryType);
                    return;
                }
                throw new NamingException("unknown change type in entry: " + newEntry.getStringName() + " changetype: " + designatedChangeType);
            }
            if ("add".equalsIgnoreCase(attributeID)) {
                newEntry.put(new LdifModifyAttribute(value.toString(), LdifModifyType.add));
            } else if ("replace".equalsIgnoreCase(attributeID)) {
                newEntry.put(new LdifModifyAttribute(value.toString(), LdifModifyType.replace));
            } else if ("delete".equalsIgnoreCase(attributeID)) {
                newEntry.put(new LdifModifyAttribute(value.toString(), LdifModifyType.delete));
            } else if (attributeID != null) {
                DXAttribute existing = newEntry.get(attributeID);
                if (existing == null) {
                    DXAttribute att = new DXAttribute(attributeID, value);
                    newEntry.put(att);
                } else {
                    existing.add(value);
                    newEntry.put(existing);
                }
            }
        }
    }

    public Object[] ldifDecodeAttribute(String attributeText) throws NamingException {
        int breakpos = attributeText.indexOf(58);
        if (breakpos < 0) {
            throw new NamingException("Error - no ':' separator found in attribute text");
        }
        String attributeID = attributeText.substring(0, breakpos);
        Object value = null;
        int attLen = attributeID.length();
        if (attributeID.equals("oc")) {
            attributeID = "objectClass";
        }
        int startpos = 2;
        if (attributeText.length() <= breakpos + 1) {
            value = "";
        } else if (attributeText.charAt(breakpos + 1) == ':') {
            value = this.getBase64Value(attributeText, attLen + 3);
        } else {
            if (attributeText.charAt(attLen + 1) != ' ') {
                startpos = 1;
            }
            value = attributeText.substring(attLen + startpos);
            value = this.expandValueParams(value);
        }
        return new Object[]{attributeID, value};
    }

    private Object getBase64Value(String parseableLine, int startpos) {
        byte[] testBytes;
        byte[] rawBinaryData;
        if (parseableLine == null) {
            throw new NullPointerException("null 'parseableLine' passed to getBase64Value");
        }
        String base64text = "";
        if (parseableLine.charAt(startpos) == ' ') {
            ++startpos;
        }
        if ((rawBinaryData = CBBase64.stringToBinary(base64text = parseableLine.substring(startpos))) == null) {
            throw new NullPointerException("Null Pointer exception parsing line (" + this.lineNumber + ") in LDIF file: + " + this.fileName + "\n line: " + base64text);
        }
        if (rawBinaryData.length > 256) {
            testBytes = new byte[256];
            System.arraycopy(rawBinaryData, 0, testBytes, 0, 256);
        } else {
            testBytes = rawBinaryData;
        }
        if (CBParse.isUTF8(testBytes)) {
            try {
                return new String(rawBinaryData, "UTF-8");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return rawBinaryData;
    }

    public LdifEntry readLdifEntry(LdifStreamReader textReader) throws IOException, NamingException {
        try {
            String line;
            LdifEntry ldifEntry = new LdifEntry();
            while ((line = textReader.readLine()) != null) {
                if (line.startsWith("version") || line.startsWith("#")) continue;
                if (line.length() == 0) {
                    return ldifEntry;
                }
                try {
                    this.ldifDecode(line, ldifEntry);
                }
                catch (NamingException e) {
                    log.warning("error in LDIF file line: " + textReader.currentLine);
                }
            }
            if (line == null && ldifEntry.size() == 0) {
                return null;
            }
            return ldifEntry;
        }
        catch (IOException e) {
            throw new IOException("Error reading LDIF File '" + this.fileName + "' line: " + textReader.getLineNumber() + "\n" + e.getMessage(), e);
        }
    }

    public Object expandValueParams(Object value) {
        if (this.params != null) {
            Enumeration keys = this.params.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String keyvalue = (String)this.params.get(key);
                String oldValue = (String)value;
                int index = oldValue.indexOf(key);
                if (index <= -1) continue;
                String newValue = oldValue.substring(0, index) + keyvalue + oldValue.substring(index + key.length(), oldValue.length());
                value = newValue;
            }
        }
        if (this.filedir != null) {
            String oldValue = (String)value;
            String match = "< file://";
            int index = oldValue.toLowerCase().indexOf(match);
            if (index > -1) {
                String filename = this.filedir + oldValue.substring(index + 9, oldValue.length());
                File file = new File(filename);
                try {
                    byte[] bytes;
                    int read;
                    FileInputStream input = new FileInputStream(file);
                    int length = (int)file.length();
                    if (length > 0 && (read = input.read(bytes = new byte[length])) > 0) {
                        value = bytes;
                    }
                    input.close();
                }
                catch (IOException e) {
                    log.warning("Error opening ldif included file!" + e);
                }
            }
        }
        return value;
    }
}

