/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.naming;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DXNamingEnumeration
implements NamingEnumeration {
    private int pointer = 0;
    private ArrayList data = new ArrayList();
    private static Collator myCollator = Collator.getInstance();

    public DXNamingEnumeration() {
    }

    public DXNamingEnumeration(Enumeration ne) {
        while (ne.hasMoreElements()) {
            this.add(ne.nextElement());
        }
    }

    public DXNamingEnumeration(Collection<?> c) {
        this.data.addAll(c);
    }

    public DXNamingEnumeration(NamingEnumeration ne) {
        if (ne != null) {
            while (ne.hasMoreElements()) {
                this.add(ne.nextElement());
            }
        }
    }

    public void add(Object o) {
        this.data.add(o);
    }

    public void remove(Object o) {
        this.data.remove(o);
    }

    public void reset() {
        this.pointer = 0;
    }

    public int size() {
        return this.data.size();
    }

    @Override
    public boolean hasMore() {
        return this.pointer < this.data.size();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore();
    }

    public Object next() throws NoSuchElementException {
        try {
            return this.data.get(this.pointer++);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public Object nextElement() throws NoSuchElementException {
        return this.next();
    }

    public DXNamingEnumeration sort() {
        Collections.sort(this.data, new SimpleComparator());
        return this;
    }

    public DXNamingEnumeration fastSort() {
        Collections.sort(this.data);
        return this;
    }

    public boolean contains(Object test) {
        return this.data.contains(test);
    }

    @Override
    public void close() {
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < this.data.size(); ++i) {
            Object o = this.data.get(i);
            ret.append(o == null ? "null" : o.toString() + "\n");
        }
        return ret.toString();
    }

    public Object[] toArray() {
        return this.data.toArray();
    }

    public String[] toStringArray() {
        String[] ret = new String[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            Object o = this.data.get(i);
            ret[i] = o == null ? null : o.toString();
        }
        return ret;
    }

    public ArrayList getArrayList() {
        return this.data;
    }

    private class SimpleComparator
    implements Comparator {
        private SimpleComparator() {
        }

        public int compare(Object o1, Object o2) {
            return myCollator.compare(o1.toString(), o2.toString());
        }
    }
}

