/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.jndi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.LdapContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaOps {
    protected LdapContext ctx = null;
    Attributes rawSchemaAttributes = null;
    private String schemaRoot = null;
    HashMap oids = new HashMap(1000);
    static final String subschemaAttributeName = "subschemaSubentry";
    private static final Logger log = Logger.getLogger(SchemaOps.class.getName());
    public static final String SCHEMA_FAKE_OBJECT_CLASS_NAME = "synthetic_JXplorer_schema_object";
    private static final BasicAttribute schemaObjectClassAttribute = new BasicAttribute("objectClass");
    private ArrayList fullObjectClassArray = null;
    private ArrayList fullAttributeNameArray = null;
    private int name_pos;
    private int bracket_pos;
    private int quote_pos;
    private int last_pos;
    private int pos;

    public SchemaOps(LdapContext context) throws NamingException {
        this.ctx = context;
        if (this.ctx == null) {
            this.setSchemaRoot("cn=schema");
            this.loadOIDs();
            return;
        }
        log.finest("Reading Schema info from directory context");
        this.setSchemaRoot(this.getSchemaRoot());
        this.rawSchemaAttributes = this.getRawSchema();
        this.loadOIDs();
    }

    public SchemaOps(Attributes rawSchemaAtts) {
        this.ctx = null;
        this.rawSchemaAttributes = rawSchemaAtts;
        this.setSchemaRoot("cn=schema");
        this.loadOIDs();
        log.finest("SCHEMA ROOTX:" + this.getSchemaRoot());
    }

    public String translateOID(String oid) {
        if (this.oids.containsKey(oid)) {
            return (String)this.oids.get(oid);
        }
        return oid;
    }

    public boolean knownOID(String oid) {
        return this.oids.containsKey(oid);
    }

    protected void loadOIDs() {
        this.loadOIDsFromSchema();
        this.loadStaticOIDs();
    }

    protected void loadOIDsFromSchema() {
        if (this.rawSchemaAttributes == null) {
            return;
        }
        try {
            NamingEnumeration<? extends Attribute> rawSchemaAtts = this.rawSchemaAttributes.getAll();
            while (rawSchemaAtts.hasMoreElements()) {
                Attribute rawSchemaAtt = (Attribute)rawSchemaAtts.nextElement();
                NamingEnumeration<?> values = rawSchemaAtt.getAll();
                while (values.hasMoreElements()) {
                    String value = (String)values.nextElement();
                    if (value.indexOf(40) == -1) {
                        log.finest("skipping non schema attribute: " + rawSchemaAtt.getID() + ":" + value);
                        continue;
                    }
                    this.oids.put(this.getOID(value), this.getFirstName(value));
                }
            }
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "Unable to read schema oids: ", e);
        }
    }

    protected void loadStaticOIDs() {
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.1", "ACI Item");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.2", "Access Point");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.3", "Attribute Type Description");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.4", "Audio");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.5", "Binary");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.6", "Bit String");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.7", "Boolean");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.8", "Certificate");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.9", "Certificate List");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.10", "Certificate Pair");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.11", "Country String");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.12", "DN");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.13", "Data Quality Syntax");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.14", "Delivery Method");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.15", "Directory String");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.16", "DIT Content Rule Description");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.17", "DIT Structure Rule Description");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.18", "DL Submit Permission");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.19", "DSA Quality Syntax");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.20", "DSE Type");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.21", "Enhanced Guide");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.22", "Facsimile Telephone Number");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.23", "Fax");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.24", "Generalized Time");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.25", "Guide");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.26", "IA5 String");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.27", "INTEGER");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.28", "JPEG");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.54", "LDAP Syntax Description");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.56", "LDAP Schema Definition");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.57", "LDAP Schema Description");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.29", "Master And Shadow Access Points");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.30", "Matching Rule Description");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.31", "Matching Rule Use Description");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.32", "Mail Preference");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.33", "MHS OR Address");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.55", "Modify Rights");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.34", "Name And Optional UID");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.35", "Name Form Description");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.36", "Numeric String");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.37", "Object Class Description");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.40", "Octet String");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.38", "OID");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.39", "Other Mailbox");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.41", "Postal Address");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.42", "Protocol Information");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.43", "Presentation Address");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.44", "Printable String");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.58", "Substring Assertion");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.45", "Subtree Specification");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.46", "Supplier Information");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.47", "Supplier Or Consumer");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.48", "Supplier And Consumer");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.49", "Supported Algorithm");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.50", "Telephone Number");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.51", "Teletex Terminal Identifier");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.52", "Telex Number");
        this.oids.put("1.3.6.1.4.1.1466.115.121.1.53", "UTC Time");
    }

    protected void debugPrint(String syntaxRoot) throws NamingException {
        System.out.println("---DEBUG PRINT---");
        System.out.println("schema root: " + this.getSchemaRoot());
        if (syntaxRoot.length() > 0 && !syntaxRoot.startsWith("schema=")) {
            syntaxRoot = "schema=" + syntaxRoot;
        }
        this.tabbedDebugPrint(syntaxRoot, "");
        System.out.println("-----------------");
    }

    protected void tabbedDebugPrint(String syntaxElement, String indent) throws NamingException {
        System.out.println(indent + syntaxElement);
        Attributes entry = this.getAttributes(syntaxElement);
        System.out.println(indent + "--==< " + syntaxElement + ">==--");
        if (entry == null) {
            System.out.println(indent + " ** NULL ENTRY **");
        } else {
            NamingEnumeration<? extends Attribute> atts = entry.getAll();
            while (atts.hasMoreElements()) {
                Attribute att = (Attribute)atts.nextElement();
                System.out.println(indent + "att " + att.getID());
                NamingEnumeration<?> values = att.getAll();
                while (values.hasMoreElements()) {
                    System.out.println(indent + "   " + values.nextElement().toString());
                }
            }
        }
        System.out.println(indent + "-");
        ArrayList<String> list = this.listEntryNames(syntaxElement);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String nextLevel = syntaxElement;
            if (nextLevel.length() > 0) {
                nextLevel = "," + nextLevel;
            }
            nextLevel = "schema=" + list.get(i) + nextLevel;
            this.tabbedDebugPrint(nextLevel, "\t" + indent);
        }
    }

    public void printRawSchema() {
        if (this.rawSchemaAttributes == null) {
            System.out.println("NO SCHEMA READ!");
            return;
        }
        try {
            System.out.println("---RAW SCHEMA---");
            NamingEnumeration<? extends Attribute> attEnum = this.rawSchemaAttributes.getAll();
            while (attEnum.hasMoreElements()) {
                Attribute att = (Attribute)attEnum.nextElement();
                String ID2 = att.getID();
                NamingEnumeration<?> vals = att.getAll();
                while (vals.hasMoreElements()) {
                    System.out.println(ID2 + " : " + vals.nextElement());
                }
            }
        }
        catch (NamingException e) {
            System.out.println("error printing raw schema:" + e);
        }
    }

    public Attributes getRawSchema() throws NamingException {
        String rawSchemaRoot = this.getSchemaRoot();
        log.finest("reading raw schema from " + rawSchemaRoot);
        Attributes rawSchema = null;
        if (this.ctx != null) {
            rawSchema = this.ctx.getAttributes(rawSchemaRoot, new String[]{"attributeTypes", "objectClasses", "matchingRules", "ldapSyntaxes", "*"});
        }
        if (rawSchema == null) {
            log.warning("null schema read - returning empty schema list.");
            rawSchema = new BasicAttributes();
        } else {
            if (rawSchema.size() == 0) {
                log.warning("Unable to read schema details from directory.");
                rawSchema = new BasicAttributes();
                return rawSchema;
            }
            log.finest("some schema read...");
            rawSchema.remove("objectClass");
            rawSchema.remove("oc");
            rawSchema.remove("objectclass");
            String nameAttribute = rawSchemaRoot.substring(0, rawSchemaRoot.indexOf(61));
            rawSchema.remove(nameAttribute);
        }
        return rawSchema;
    }

    private void setSchemaRoot(String schema) {
        this.schemaRoot = schema;
    }

    public String getSchemaRoot() {
        if (this.schemaRoot != null) {
            return this.schemaRoot;
        }
        if (this.ctx != null) {
            try {
                log.finest("start get schema root call");
                Attributes SSSE = this.ctx.getAttributes("", new String[]{subschemaAttributeName});
                if (SSSE != null && SSSE.get(subschemaAttributeName) != null) {
                    this.schemaRoot = (String)SSSE.get(subschemaAttributeName).get();
                }
                log.finest("schema root read as being: '" + String.valueOf(this.schemaRoot) + "'");
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        if (this.schemaRoot == null) {
            log.finest("forcing value of schema root to 'cn=schema', since can't read subschema attribute name");
            this.schemaRoot = "cn=schema";
        }
        return this.schemaRoot;
    }

    public Attributes getAttributes(String entryName) throws NamingException {
        entryName = this.mangleEntryName(entryName);
        BasicAttributes schemaAttributes = new BasicAttributes();
        schemaAttributes.put(schemaObjectClassAttribute);
        if (entryName == null || entryName.length() == 0) {
            schemaAttributes.put(subschemaAttributeName, this.schemaRoot);
        } else if (entryName.indexOf(44) == -1 && entryName.indexOf(47) == -1) {
            String schemaType = entryName.substring(entryName.indexOf(61) + 1);
            schemaAttributes.put("schemaType", schemaType);
        } else {
            schemaAttributes = this.getAttributesFromSchemaName(entryName);
        }
        return schemaAttributes;
    }

    protected String mangleEntryName(String entryName) {
        if (entryName.indexOf("ClassDefinition") > -1) {
            entryName = entryName.replaceAll("(ClassDefinition)", "objectClasses");
        }
        if (entryName.indexOf("SyntaxDefinition") > -1) {
            entryName = entryName.replaceAll("(SyntaxDefinition)", "ldapSyntaxes");
        }
        if (entryName.indexOf("AttributeDefinition") > -1) {
            entryName = entryName.replaceAll("(AttributeDefinition)", "attributeTypes");
        }
        if (entryName.indexOf(47) > 0) {
            int pos = entryName.indexOf(";binary");
            if (pos > -1) {
                entryName = entryName.substring(0, pos);
            }
            int slashpos = entryName.indexOf(47);
            String topLevelName = entryName.substring(0, slashpos);
            String specificName = entryName.substring(++slashpos);
            return "schema=" + specificName + ",schema=" + topLevelName;
        }
        int pos = entryName.indexOf(this.schemaRoot);
        if (pos > 0) {
            entryName = entryName.substring(0, pos - 1);
        }
        if ((pos = entryName.indexOf("cn=schema")) > 0) {
            entryName = entryName.substring(0, pos - 1);
        }
        return entryName;
    }

    protected String getSpecificName(String entryName) throws NamingException {
        int equalpos = entryName.indexOf(61) + 1;
        int commapos = entryName.indexOf(44);
        if (equalpos <= 0 || commapos == -1 || equalpos > commapos) {
            throw new NamingException("error parsing schema dn '" + entryName + "' ");
        }
        return entryName.substring(equalpos, commapos);
    }

    protected String getTypeName(String entryName) throws NamingException {
        if (entryName.endsWith(",cn=schema")) {
            entryName = entryName.substring(0, entryName.length() - 10);
        }
        int equalpos = entryName.lastIndexOf(61) + 1;
        return entryName.substring(equalpos);
    }

    protected BasicAttributes getAttributesFromSchemaName(String entryName) throws NamingException {
        if (this.rawSchemaAttributes == null) {
            return null;
        }
        entryName = this.mangleEntryName(entryName);
        String schemaTypeName = this.getTypeName(entryName);
        String specificName = this.getSpecificName(entryName);
        Attribute schemaGroup = this.rawSchemaAttributes.get(schemaTypeName);
        if (schemaGroup == null) {
            schemaGroup = this.rawSchemaAttributes.get(schemaTypeName.toLowerCase());
            throw new NamingException("Unable to find schema entry for schema type '" + schemaTypeName + "'");
        }
        NamingEnumeration<?> schemaValues = schemaGroup.getAll();
        while (schemaValues.hasMore()) {
            String schemaValue = (String)schemaValues.next();
            String[] names = this.getNames(schemaValue);
            for (int i = 0; i < names.length; ++i) {
                if (!specificName.equalsIgnoreCase(names[i])) continue;
                return this.getAttributesFromSchemaValue(schemaValue);
            }
        }
        return null;
    }

    private void addBracketedValues(Attribute schemaAttribute, StringTokenizer st) {
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.endsWith(")")) {
                if (token.length() > 1) {
                    schemaAttribute.add(this.getQuotedTokens(token.substring(0, token.length() - 1), st));
                }
                return;
            }
            schemaAttribute.add(this.getQuotedTokens(token, st));
        }
    }

    private String getQuotedTokens(String token, StringTokenizer st) {
        if (token.charAt(0) != '\'') {
            return token;
        }
        if (token.length() < 2) {
            return token;
        }
        if (token.charAt(0) == '\'' && token.charAt(token.length() - 1) == '\'') {
            return token.substring(1, token.length() - 1);
        }
        StringBuffer returnText = new StringBuffer(token.substring(1));
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.endsWith("'")) {
                return returnText.append(" ").append(token.substring(0, token.length() - 1)).toString();
            }
            returnText.append(" ").append(token);
        }
        return returnText.toString();
    }

    protected BasicAttributes getAttributesFromSchemaValue(String syntaxValue) {
        BasicAttributes schemaValues = new BasicAttributes();
        schemaValues.put(schemaObjectClassAttribute);
        StringTokenizer st = new StringTokenizer(syntaxValue, " \t\n\r\f$");
        if (st.hasMoreTokens()) {
            String oid = st.nextToken();
            if (oid.startsWith("(")) {
                oid = oid.length() == 1 ? st.nextToken() : oid.substring(1);
            }
            schemaValues.put(new BasicAttribute("OID", oid));
        }
        while (st.hasMoreTokens()) {
            String attributeID = st.nextToken();
            if (!attributeID.endsWith(")")) {
                this.addAttribute(schemaValues, attributeID, st);
                continue;
            }
            if (attributeID.length() <= 1) continue;
            this.addAttribute(schemaValues, attributeID.substring(1), st);
        }
        try {
            Attribute syntaxOID = schemaValues.get("SYNTAX");
            if (syntaxOID != null) {
                String syntaxOIDString = (String)syntaxOID.get();
                String syntaxDescription = this.translateOID(syntaxOIDString);
                schemaValues.put(new BasicAttribute("SYNTAX Description", syntaxDescription));
            }
        }
        catch (Exception e) {
            log.log(Level.INFO, "unable to translate syntax oid ", e);
        }
        return schemaValues;
    }

    private void addAttribute(Attributes schemaValues, String attributeName, StringTokenizer st) {
        BasicAttribute schemaAttribute = new BasicAttribute(attributeName);
        schemaValues.put(schemaAttribute);
        if (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.startsWith("(")) {
                if (token.length() > 1) {
                    if (token.endsWith(")")) {
                        token = token.substring(0, token.length() - 1);
                        schemaAttribute.add(token.substring(1));
                    } else {
                        schemaAttribute.add(token.substring(1));
                        this.addBracketedValues(schemaAttribute, st);
                    }
                } else {
                    this.addBracketedValues(schemaAttribute, st);
                }
            } else if (!token.endsWith(")")) {
                if (SchemaOps.isSyntaxKeyword(token)) {
                    this.addAttribute(schemaValues, token, st);
                } else {
                    token = this.getQuotedTokens(token, st);
                    schemaAttribute.add(token);
                }
            }
        }
    }

    private static String readQuoteBlock(StringTokenizer st) {
        StringBuffer returnBuffer = new StringBuffer();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            returnBuffer.append(" ");
            returnBuffer.append(token);
            if (!token.endsWith("'")) continue;
            returnBuffer.deleteCharAt(returnBuffer.length() - 1);
            return returnBuffer.toString();
        }
        log.finest("unexpected end of schema text in single quoted block");
        return returnBuffer.toString();
    }

    private static boolean isSyntaxKeyword(String token) {
        String[] reservedKeywords = new String[]{"ABSTRACT", "APPLIES", "AUXILIARY", "COLLECTIVE", "DESC", "EQUALITY", "MAY", "MUST", "NAME", "NO-USER-MODIFICATION", "OBSOLETE", "ORDERING", "SINGLE-VALUE", "STRUCTURAL", "SUBSTR", "SUP", "SYNTAX", "USAGE"};
        int size = reservedKeywords.length;
        for (int i = 0; i < size; ++i) {
            if (!reservedKeywords[i].equals(token)) continue;
            return true;
        }
        return token.startsWith("X-");
    }

    public ArrayList<String> listEntryNames(String entryName) throws NamingException {
        ArrayList<String> schemaNames;
        if (this.rawSchemaAttributes == null) {
            return new ArrayList<String>();
        }
        if ((entryName = this.mangleEntryName(entryName)) == null || entryName.length() == 0 || entryName.equals("cn=schema") || entryName.equals(this.schemaRoot)) {
            schemaNames = new ArrayList<String>(10);
            NamingEnumeration<String> schemaTopLevelNames = this.rawSchemaAttributes.getIDs();
            while (schemaTopLevelNames.hasMoreElements()) {
                String name = (String)schemaTopLevelNames.nextElement();
                if (schemaNames.contains(name)) continue;
                schemaNames.add(name);
            }
        } else if (entryName.indexOf(44) == -1 && entryName.indexOf(47) == -1) {
            Attribute rawSyntaxAttribute;
            schemaNames = new ArrayList(1000);
            if (entryName.indexOf(61) > 0) {
                entryName = entryName.substring(entryName.indexOf(61) + 1);
            }
            if ((rawSyntaxAttribute = this.rawSchemaAttributes.get(entryName)) == null) {
                throw new NamingException("unable to list syntaxes of type '" + entryName + "'");
            }
            NamingEnumeration<?> values = rawSyntaxAttribute.getAll();
            while (values.hasMoreElements()) {
                String[] names;
                for (String name : names = this.getNames((String)values.nextElement())) {
                    if (schemaNames.contains(name)) continue;
                    schemaNames.add(name);
                }
            }
        } else {
            schemaNames = new ArrayList(0);
        }
        return schemaNames;
    }

    public final String getOID(String ldapSchemaDescription) {
        if (ldapSchemaDescription == null) {
            return "0";
        }
        int start = 0;
        if (ldapSchemaDescription.charAt(0) == '(') {
            ++start;
        }
        while (ldapSchemaDescription.charAt(start) == ' ') {
            ++start;
        }
        try {
            int endpos = ldapSchemaDescription.indexOf(32, start);
            if (endpos == -1) {
                endpos = ldapSchemaDescription.indexOf(41, start);
            }
            if (endpos == -1) {
                endpos = ldapSchemaDescription.length();
            }
            String ret = ldapSchemaDescription.substring(start, endpos);
            return ret;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "can't parse '" + ldapSchemaDescription + "'");
            e.printStackTrace();
            return "0";
        }
    }

    public final String getFirstName(String ldapSchemaDescription) {
        this.name_pos = ldapSchemaDescription.indexOf("NAME");
        if (this.name_pos == -1) {
            this.name_pos = ldapSchemaDescription.indexOf("DESC");
        }
        if (this.name_pos == -1) {
            if (ldapSchemaDescription.startsWith("{")) {
                ldapSchemaDescription = ldapSchemaDescription.substring(1).trim();
            }
            this.pos = ldapSchemaDescription.indexOf(32);
            if (this.pos == -1) {
                log.log(Level.WARNING, "unable to get name from " + ldapSchemaDescription);
                return "syntax_error";
            }
            return ldapSchemaDescription.substring(0, this.pos).trim();
        }
        this.quote_pos = ldapSchemaDescription.indexOf(39, this.name_pos);
        ++this.quote_pos;
        this.last_pos = ldapSchemaDescription.indexOf(39, this.quote_pos);
        if (this.quote_pos != 0 && this.last_pos != -1) {
            return ldapSchemaDescription.substring(this.quote_pos, this.last_pos);
        }
        log.log(Level.WARNING, "unable to parse " + ldapSchemaDescription);
        return "syntax_error";
    }

    public final String[] getNames(String ldapSyntaxDescription) {
        try {
            this.name_pos = ldapSyntaxDescription.indexOf("NAME");
            if (this.name_pos == -1) {
                this.name_pos = ldapSyntaxDescription.indexOf("DESC");
            }
            if (this.name_pos == -1) {
                if (ldapSyntaxDescription.startsWith("{")) {
                    ldapSyntaxDescription = ldapSyntaxDescription.substring(1).trim();
                }
                return new String[]{ldapSyntaxDescription.substring(0, ldapSyntaxDescription.indexOf(32)).trim()};
            }
            this.bracket_pos = ldapSyntaxDescription.indexOf(40, this.name_pos);
            this.quote_pos = ldapSyntaxDescription.indexOf(39, this.name_pos);
            if (this.bracket_pos != -1 && this.bracket_pos < this.quote_pos) {
                this.bracket_pos = ldapSyntaxDescription.indexOf(41, this.bracket_pos);
                ArrayList<String> newList = new ArrayList<String>(5);
                while (this.quote_pos < this.bracket_pos && this.quote_pos != -1) {
                    int start = ++this.quote_pos;
                    this.quote_pos = ldapSyntaxDescription.indexOf(39, this.quote_pos);
                    String temp = ldapSyntaxDescription.substring(start, this.quote_pos);
                    newList.add(temp);
                    ++this.quote_pos;
                    this.quote_pos = ldapSyntaxDescription.indexOf(39, this.quote_pos);
                }
                return newList.toArray(new String[0]);
            }
            ++this.quote_pos;
            int next_quote = ldapSyntaxDescription.indexOf(39, this.quote_pos);
            String temp = ldapSyntaxDescription.substring(this.quote_pos, next_quote);
            return new String[]{temp};
        }
        catch (StringIndexOutOfBoundsException e) {
            log.log(Level.WARNING, "unable to parse line: " + ldapSyntaxDescription, e);
            return new String[]{"syntax_error"};
        }
    }

    public ArrayList getKnownObjectClasses() throws NamingException {
        if (this.fullObjectClassArray == null) {
            ArrayList<String> temp = this.listEntryNames("schema=objectClasses,cn=schema");
            if (temp == null) {
                throw new NamingException("unable to read list of object classes from schema");
            }
            String[] OCs = temp.toArray(new String[temp.size()]);
            Arrays.sort(OCs, new Comparator(){

                public int compare(Object a, Object b) {
                    return ((String)a).compareToIgnoreCase((String)b);
                }

                public boolean equals(Object a, Object b) {
                    return ((String)a).equalsIgnoreCase((String)b);
                }
            });
            int size = OCs.length;
            this.fullObjectClassArray = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.fullObjectClassArray.add(i, OCs[i]);
            }
        }
        return this.fullObjectClassArray;
    }

    public ArrayList<String> getKnownAttributeNames() throws NamingException {
        ArrayList<String> attributeNames = this.listEntryNames("schema=AttributeDefinition,cn=schema");
        if (attributeNames == null) {
            return null;
        }
        String[] temp = attributeNames.toArray(new String[0]);
        Arrays.sort(temp, new IgnoreCaseStringComparator());
        ArrayList<String> attList = new ArrayList<String>(Arrays.asList(temp));
        return attList;
    }

    public ArrayList<String> getKnownLowerCaseAttributeNames() throws NamingException {
        ArrayList<String> attributeNames = this.listEntryNames("schema=AttributeDefinition,cn=schema");
        if (attributeNames == null) {
            return null;
        }
        String[] temp = attributeNames.toArray(new String[0]);
        Arrays.sort(temp, new IgnoreCaseStringComparator());
        ArrayList<String> attList = new ArrayList<String>(temp.length);
        for (String att : temp) {
            attList.add(att.toLowerCase());
        }
        return attList;
    }

    public ArrayList attributeNames() throws NamingException {
        if (this.fullAttributeNameArray == null) {
            ArrayList<String> temp = this.listEntryNames("schema=attributeTypes,cn=schema");
            if (temp == null) {
                throw new NamingException("unable to read list of attribute types from schema");
            }
            String[] ATs = temp.toArray(new String[temp.size()]);
            Arrays.sort(ATs, new Comparator(){

                public int compare(Object a, Object b) {
                    return ((String)a).compareToIgnoreCase((String)b);
                }

                public boolean equals(Object a, Object b) {
                    return ((String)a).equalsIgnoreCase((String)b);
                }
            });
            int size = ATs.length;
            this.fullAttributeNameArray = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                this.fullAttributeNameArray.add(i, ATs[i]);
            }
        }
        return this.fullAttributeNameArray;
    }

    public ArrayList getRecommendedObjectClasses(String dn) {
        block8: {
            try {
                if (dn == null || this.ctx == null) break block8;
                Attributes atts = this.ctx.getAttributes(dn);
                if (atts == null) {
                    log.log(Level.WARNING, "error reading object classes for " + dn);
                    break block8;
                }
                Attribute objectClasses = atts.get("objectclass");
                if (objectClasses == null) {
                    objectClasses = atts.get("objectClass");
                }
                if (objectClasses == null) {
                    objectClasses = atts.get("oc");
                }
                if (objectClasses == null) {
                    log.log(Level.WARNING, "unable to recognize object classes for " + dn);
                    break block8;
                }
                NamingEnumeration<?> names = objectClasses.getAll();
                if (names == null) {
                    log.log(Level.WARNING, "object class has no attributes!");
                }
                ArrayList returnArray = new ArrayList(10);
                while (names.hasMore()) {
                    returnArray.add(names.next());
                }
                return returnArray;
            }
            catch (NamingException e) {
                log.log(Level.WARNING, "error reading object classes for " + dn + "\n  internal error III:  ", e);
            }
        }
        return null;
    }

    public String getNewBinaryAttributes() {
        if (this.rawSchemaAttributes == null) {
            return "";
        }
        String patternStr = "SYNTAX\\s+(.*?)\\s+";
        Pattern pattern = Pattern.compile(patternStr);
        try {
            StringBuffer binaryAttributeList = new StringBuffer(1000);
            Attribute rawSyntaxAttribute = this.getAttributeTypes();
            if (rawSyntaxAttribute == null) {
                return "";
            }
            NamingEnumeration<?> values = rawSyntaxAttribute.getAll();
            while (values.hasMore()) {
                String attOIDSuffix;
                String attSyntax;
                String attributeDescription = (String)values.next();
                Matcher matcher = pattern.matcher(attributeDescription);
                boolean matchFound = matcher.find();
                if (!matchFound || !(attSyntax = matcher.group(1)).startsWith("1.3.6.1.4.1.1466.115.121.1.") || !(attOIDSuffix = attSyntax.substring(27)).equals("4") && !attOIDSuffix.equals("5") && !attOIDSuffix.equals("8") && !attOIDSuffix.equals("9") && !attOIDSuffix.equals("10") && !attOIDSuffix.equals("28") && !attOIDSuffix.equals("40")) continue;
                String[] names = this.getNames(attributeDescription);
                for (int i = 0; i < names.length; ++i) {
                    binaryAttributeList.append(names[i]);
                    binaryAttributeList.append(' ');
                }
            }
            return binaryAttributeList.toString();
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "unable to get binary attributes from schema", e);
            return "";
        }
    }

    public Attribute getAttributeTypes() {
        return this.rawSchemaAttributes.get("attributeTypes");
    }

    public String getAttributeSyntax(String attID) {
        if (attID == null) {
            return null;
        }
        if (attID.indexOf(59) > 0) {
            attID = attID.substring(0, attID.indexOf(59));
        }
        return this.schemaLookup("schema=" + attID + ",schema=attributeTypes", "SYNTAX");
    }

    public String schemaLookup(String entryName, String schemaAttribute) {
        block5: {
            entryName = this.mangleEntryName(entryName);
            try {
                Attributes schemaAtts = this.getAttributes(entryName);
                Attribute schemaAtt = schemaAtts.get(schemaAttribute);
                String att = (String)schemaAtt.get();
                return att;
            }
            catch (NamingException e) {
                log.log(Level.WARNING, "unable to get value for " + entryName + " value: " + schemaAttribute, e);
            }
            catch (NullPointerException e2) {
                if (!"DESC".equals(schemaAttribute)) {
                    log.log(Level.WARNING, "unable to read any schema entry for " + entryName + "and attribute: " + schemaAttribute, e2);
                }
            }
            catch (NoSuchElementException e) {
                if ("DESC".equals(schemaAttribute)) break block5;
                log.log(Level.WARNING, "unable to read any schema entry for " + entryName + "and attribute: " + schemaAttribute, e);
            }
        }
        return null;
    }

    public String getNameOfObjectClassAttribute() {
        return this.schemaLookup("schema=objectClass,schema=attributeTypes", "NAME");
    }

    public boolean isAttributeSingleValued(String name) {
        if (this.rawSchemaAttributes == null) {
            return false;
        }
        try {
            Attribute attributeTypes = this.getAttributeTypes();
            NamingEnumeration<?> en = attributeTypes.getAll();
            while (en.hasMore()) {
                String attr = (String)en.next();
                String[] attrName = this.getNames(attr);
                for (int i = 0; i < attrName.length; ++i) {
                    if (!attrName[i].equals(name) || attr.indexOf("SINGLE-VALUE") < 0) continue;
                    return true;
                }
            }
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "Unable to determine if attribute '" + name + "' is SINGLE-VALUE." + e);
        }
        return false;
    }

    static {
        schemaObjectClassAttribute.add("top");
        schemaObjectClassAttribute.add(SCHEMA_FAKE_OBJECT_CLASS_NAME);
    }

    public static class IgnoreCaseStringComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null || o2 == null) {
                return o1 == null ? 1 : -1;
            }
            return o1.toString().toLowerCase().compareTo(o2.toString().toLowerCase());
        }
    }
}

