/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.jndi;

import com.ca.commons.jndi.ConnectionData;
import com.ca.commons.jndi.JNDIOps;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class BasicOps
extends JNDIOps {
    private static final Logger log = Logger.getLogger(BasicOps.class.getName());
    protected int ldapVersion = -1;
    String errorMsg;
    Exception errorException = null;

    public BasicOps(LdapContext c) throws NamingException {
        super(c);
        this.setLdapVersion(c.getEnvironment());
    }

    public BasicOps(ConnectionData cData) throws NamingException {
        super(cData.getJNDIEnvironment());
    }

    public static BasicOps getInstance(ConnectionData cData) throws NamingException {
        BasicOps newObject = new BasicOps(cData);
        return newObject;
    }

    public static LdapContext openContext(ConnectionData connectionData) throws NamingException {
        return BasicOps.openContext(connectionData.getJNDIEnvironment());
    }

    public static LdapContext openContext(int version, String host, int port, String user, char[] pwd, boolean tracing, String referralType, String aliasHandling) throws NamingException {
        if (host == null) {
            throw new NamingException("Host not specified in openContext()!");
        }
        if (port == 0) {
            port = 389;
        }
        return BasicOps.openContext(version, "ldap://" + host + ":" + port, user, pwd, tracing, referralType, aliasHandling);
    }

    public static LdapContext openContext(String url) throws NamingException {
        ConnectionData myData = new ConnectionData();
        myData.url = url;
        return BasicOps.openContext(3, url, "", null, false, null, null, false, null, null, null, null, null, null, false, null);
    }

    public static LdapContext openContext(int version, String url, String managerUserDN, char[] pwd) throws NamingException {
        return BasicOps.openContext(version, url, managerUserDN, pwd, false, null, null, false, null, null, null, null, null, null, false, null);
    }

    public static LdapContext openContext(int version, String url, String userDN, char[] pwd, boolean tracing, String referralType, String aliasHandling) throws NamingException {
        return BasicOps.openContext(version, url, userDN, pwd, tracing, referralType, aliasHandling, false, null, null, null, null, null, null, false, null);
    }

    public static LdapContext openContext(int version, String url, String userDN, char[] pwd, boolean tracing, String referralType, String aliasType, boolean useSSL, String cacerts, String clientcerts, char[] caKeystorePwd, char[] clientKeystorePwd, String caKeystoreType, String clientKeystoreType) throws NamingException {
        return BasicOps.openContext(version, url, userDN, pwd, tracing, referralType, aliasType, useSSL, cacerts, clientcerts, caKeystorePwd, clientKeystorePwd, caKeystoreType, clientKeystoreType, false, null);
    }

    public static LdapContext openContext(int version, String url, String userDN, char[] pwd, boolean tracing, String referralType, String aliasType, boolean useSSL, String cacerts, String clientcerts, char[] caKeystorePwd, char[] clientKeystorePwd, String caKeystoreType, String clientKeystoreType, boolean useGSSAPI, String templateName) throws NamingException {
        ConnectionData connectionData = new ConnectionData(version, url, userDN, pwd, tracing, referralType, aliasType, useSSL, cacerts, clientcerts, caKeystorePwd, clientKeystorePwd, caKeystoreType, clientKeystoreType, useGSSAPI, templateName, null);
        return JNDIOps.openContext(connectionData.getJNDIEnvironment());
    }

    public static LdapContext openContext(Properties env) throws NamingException {
        log.fine("opening Directory Context to " + env.get("java.naming.provider.url") + "\n using: " + env.get("java.naming.factory.initial"));
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        log.fine("context successfully opened " + (ctx != null));
        if (ctx != null) {
            // empty if block
        }
        return ctx;
    }

    private void setLdapVersion(Hashtable env) throws NamingException {
        try {
            this.ldapVersion = Integer.parseInt(env.get("java.naming.ldap.version").toString());
        }
        catch (Exception e) {
            throw new NamingException("BasicOps.openContext(): unable to determine ldap version of connection.");
        }
    }

    public void renameObject(Name OldDN, Name NewDN) throws NamingException {
        this.renameEntry(OldDN, NewDN);
    }

    public void copyObject(Name FromDN, Name ToDN) throws NamingException {
        this.copyEntry(FromDN, ToDN);
    }

    public void addObject(Name Dn, Attributes atts) throws NamingException {
        this.addEntry(Dn, atts);
    }

    public void deleteObject(Name Dn) throws NamingException {
        this.deleteEntry(Dn);
    }

    public void updateObject(Name Dn, Attributes atts) throws NamingException {
        this.updateEntry(Dn, atts);
    }

    public NamingEnumeration searchBaseObject(Name Searchbase, String filter, int limit, int timeout) throws NamingException {
        return this.searchBaseEntry(Searchbase, filter, limit, timeout, new String[]{"objectClass"});
    }

    public NamingEnumeration searchBaseObject(Name Searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.searchBaseEntry(Searchbase, filter, limit, timeout, returnAttributes);
    }

    public void close() throws NamingException {
        super.close();
        log.fine("closing context");
        this.ldapVersion = -1;
    }

    public NameParser getBaseNameParser() throws NamingException {
        log.finer("getting base name parser");
        if (this.getContext() == null) {
            throw new NamingException("Null Directory Context\n  in BasicOps.searchSubTree()\n  (so can't do anything!)");
        }
        return this.getContext().getNameParser("");
    }

    public int getLdapVersion() {
        return this.ldapVersion;
    }
}

