/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class Theme {
    private static Theme instance;
    private String dirHtmlDocs;
    private String dirIcons;
    private String dirImages;
    private String dirTemplates;

    public static Theme getInstance() {
        if (instance == null) {
            instance = new Theme();
        }
        return instance;
    }

    private Theme() {
        String localDir = System.getProperty("user.dir") + File.separator;
        String theme = this.findActiveTheme(localDir);
        this.init(localDir, theme);
    }

    private String findActiveTheme(String localDir) {
        Properties themeProp = new Properties();
        try {
            themeProp.load(new FileInputStream(localDir + "themes" + File.separator + "themes.properties"));
        }
        catch (IOException e) {
            // empty catch block
        }
        String theme = themeProp.getProperty("settings.theme", "classic-theme");
        return theme;
    }

    private void init(String localDir, String theme) {
        String themeDirectory = localDir + "themes" + File.separator + theme + File.separator;
        File themeLocation = new File(themeDirectory);
        if (!themeLocation.exists()) {
            themeDirectory = localDir;
        }
        this.dirHtmlDocs = themeDirectory + "htmldocs" + File.separator;
        this.dirIcons = themeDirectory + "icons" + File.separator;
        this.dirImages = themeDirectory + "images" + File.separator;
        this.dirTemplates = themeDirectory + "templates" + File.separator;
    }

    public String getDirHtmlDocs() {
        return this.dirHtmlDocs;
    }

    public String getDirIcons() {
        return this.dirIcons;
    }

    public String getDirImages() {
        return this.dirImages;
    }

    public String getDirTemplates() {
        return this.dirTemplates;
    }
}

