/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import java.awt.Component;
import java.io.Closeable;
import javax.swing.ProgressMonitor;

public class CBpbar
implements Closeable {
    ProgressMonitor pbar;
    int count;
    int pcntg;
    int level;
    static int MAXLEVEL = 6;
    int[] fanout = new int[MAXLEVEL];
    int[] visited = new int[MAXLEVEL];
    String notePrefix;

    public CBpbar(Component C, String title, String prefix) {
        this.pbar = new ProgressMonitor(C, title, prefix + " 0", 0, 100);
        this.notePrefix = prefix;
        this.level = 0;
        this.fanout[this.level] = 1;
    }

    public void setPrefix(String prefix) {
        this.notePrefix = prefix;
        this.pbar.setNote(prefix);
    }

    public void reset(String prefix) {
        this.setPrefix(prefix);
        this.level = 0;
        this.fanout[this.level] = 1;
    }

    public void inc() {
        ++this.count;
        int oldpcntg = this.pcntg;
        if (this.level < MAXLEVEL && this.level >= 0) {
            int n = this.level;
            this.visited[n] = this.visited[n] + 1;
            this.pcntg = 0;
            int spread = 100;
            for (int i = 0; i < this.level; ++i) {
                this.pcntg += spread * this.visited[i] / this.fanout[i];
                spread /= this.fanout[i];
            }
            if (this.pcntg != oldpcntg) {
                this.pbar.setProgress(this.pcntg);
                this.pbar.setNote(this.notePrefix + " " + this.count);
            }
        }
    }

    public void pop() {
        if (this.level > 0) {
            --this.level;
        }
    }

    public void push(int fanout) {
        ++this.level;
        if (this.level < MAXLEVEL) {
            this.fanout[this.level] = fanout;
        }
    }

    public void close() {
        this.pbar.close();
    }

    public boolean isCanceled() {
        return this.pbar.isCanceled();
    }

    public ProgressMonitor getBaseMonitor() {
        return this.pbar;
    }
}

