/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBErrorWin;
import com.ca.commons.cbutil.CBFileFilter;
import com.ca.commons.cbutil.CBParse;
import com.ca.commons.cbutil.CBProperties;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class CBUtility {
    private static Cursor savedCursor;
    private static Frame displayFrame;
    private static String defaultConfigDirectory;
    private static Logger log;

    private CBUtility() {
    }

    public static StringBuffer readURLText(URL url) {
        return CBUtility.readURLText(url, new StringBuffer("error: can't read URL " + url.toString()));
    }

    public static StringBuffer readURLText(URL url, StringBuffer errorText) {
        StringBuffer page = new StringBuffer("");
        try {
            String thisLine;
            BufferedReader source = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((thisLine = source.readLine()) != null) {
                page.append(thisLine + "\n");
            }
            return page;
        }
        catch (Exception e) {
            return errorText;
        }
    }

    public static byte[] readStream(InputStream is) throws IOException {
        byte[] data = null;
        byte[] buffer = new byte[16384];
        int blockSize = 0;
        int size = 0;
        while ((blockSize = is.read(buffer)) != -1) {
            byte[] temp = new byte[size + blockSize];
            if (size != 0) {
                System.arraycopy(data, 0, temp, 0, size);
            }
            System.arraycopy(buffer, 0, temp, size, blockSize);
            data = temp;
            size += blockSize;
        }
        return data;
    }

    public static String readTextFile(File file) throws IOException {
        if (!Locale.getDefault().getLanguage().equals("en")) {
            return CBUtility.readI18NFile(file);
        }
        FileReader in = new FileReader(file);
        int size = (int)file.length();
        char[] data = new char[size];
        for (int chars_read = 0; chars_read < size; chars_read += in.read(data, chars_read, size - chars_read)) {
        }
        return new String(data);
    }

    public static String readI18NFile(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        int size = (int)file.length();
        byte[] data = new byte[size];
        for (int bytes_read = 0; bytes_read < size; bytes_read += in.read(data, bytes_read, size - bytes_read)) {
        }
        return CBUtility.readUnicode(data);
    }

    public static String readUnicode(byte[] data) {
        try {
            if (CBParse.isUnicode(data)) {
                log.finer("reading unicode 16 bit text");
                String text = new String(data, "UTF-16");
                if (text.length() > 0) {
                    return text;
                }
            } else {
                log.finer("reading utf8 text");
                String text = new String(data, "UTF-8");
                if (text.length() > 0) {
                    return CBUtility.translateJavaUnicodeEscapes(text);
                }
            }
            return new String(data);
        }
        catch (Exception e) {
            log.warning("Confused Reading File: " + e.toString() + "\n -> reverting to default encoding");
            return new String(data);
        }
    }

    public static String readI18NByteArray(byte[] data) {
        try {
            if (CBParse.isUnicode(data)) {
                log.finer("reading unicode 16 bit text");
                String text = new String(data, "UTF-16");
                if (text.length() > 0) {
                    return text;
                }
                return new String(data);
            }
            byte[] test = new byte[250];
            if (data.length < 250) {
                test = data;
            } else {
                System.arraycopy(data, 0, test, 0, 250);
            }
            if (CBParse.isNonAsciiUTF8(test)) {
                log.finer("reading utf8 text");
                String text = new String(data, "UTF-8");
                if (text.length() > 0) {
                    return text;
                }
                return new String(data);
            }
            log.finer("reading local encoding text");
            String newString = new String(data);
            return CBUtility.translateJavaUnicodeEscapes(newString);
        }
        catch (Exception e) {
            log.warning("Confused Reading File: " + e.toString() + "\n -> reverting to default encoding");
            return new String(data);
        }
    }

    public static String[] readStringArrayFile(String fileName) {
        Properties props = CBUtility.readPropertyFile(fileName);
        String[] values = new String[props.size()];
        Enumeration<Object> en = props.elements();
        int count = 0;
        while (en.hasMoreElements()) {
            values[count++] = en.nextElement().toString();
        }
        return values;
    }

    public static String translateJavaUnicodeEscapes(String text) {
        if (text.indexOf("\\u") == -1) {
            return text;
        }
        StringBuffer buffer = new StringBuffer(text);
        int pos = 0;
        while (pos + 6 < buffer.length()) {
            if (buffer.charAt(pos) != '\\') {
                ++pos;
                continue;
            }
            if (buffer.charAt(pos + 1) != 'u') {
                pos += 2;
                continue;
            }
            String unicode = buffer.substring(pos + 2, pos + 6);
            int uni = Integer.parseInt(unicode, 16);
            buffer = buffer.delete(pos, pos + 6);
            buffer = buffer.insert(pos, (char)uni);
            ++pos;
        }
        return buffer.toString();
    }

    public static Properties readPropertyFile(String fileName) {
        Properties propertyList = new Properties();
        try {
            File propertyFile = new File(fileName);
            if (propertyFile == null || !propertyFile.exists()) {
                log.warning("No property list:\n" + fileName);
                return propertyList;
            }
            FileInputStream in = new FileInputStream(propertyFile);
            propertyList.load(in);
            return propertyList;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can't read property list:\n" + fileName + "\n", e);
            return propertyList;
        }
    }

    public static void writeStringArrayFile(String fileName, String[] strings) {
        Properties props = new Properties();
        for (int i = 0; i < strings.length; ++i) {
            props.put(strings[i], strings[i]);
        }
        CBUtility.writePropertyFile(fileName, props, "# generated string array list");
    }

    public static void writePropertyFile(String fileName, Properties propertyList, String comments) {
        CBProperties orderedPropertyList = new CBProperties(propertyList);
        try {
            File propertyFile = new File(fileName);
            FileOutputStream out = new FileOutputStream(propertyFile);
            orderedPropertyList.store(out, "Generated Property List " + fileName + "\n" + (comments != null ? comments : ""));
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Can't write property list:\n" + fileName + "\n", e);
        }
    }

    public static String toHTML(String rawText) {
        String test = rawText.length() > 14 ? rawText.substring(0, 14).toLowerCase() : rawText.toLowerCase();
        if (test.startsWith("<html>") || test.startsWith("<!doctype html>")) {
            if (test.startsWith("<html>")) {
                rawText = rawText.substring(6);
            } else if (test.startsWith("<!doctype html>")) {
                rawText = rawText.substring(15);
            }
            if (rawText.toLowerCase().endsWith("</html>")) {
                rawText = rawText.substring(0, rawText.length() - 7);
            }
            return rawText;
        }
        StringBuffer temp = new StringBuffer(rawText);
        block7: for (int pos = 0; pos < temp.length(); ++pos) {
            char C = temp.charAt(pos);
            switch (C) {
                case '<': {
                    CBParse.replaceChar(temp, pos, "&lt;");
                    continue block7;
                }
                case '>': {
                    CBParse.replaceChar(temp, pos, "&gt;");
                    continue block7;
                }
                case '&': {
                    CBParse.replaceChar(temp, pos, "&amp;");
                    continue block7;
                }
                case '\"': {
                    CBParse.replaceChar(temp, pos, "&quot;");
                    continue block7;
                }
                case '#': {
                    CBParse.replaceChar(temp, pos, "&#35;");
                    ++pos;
                }
            }
        }
        return temp.toString();
    }

    public static int replaceChar(StringBuffer text, int pos, String replacement) {
        text.deleteCharAt(pos);
        text.insert(pos, replacement);
        return pos + replacement.length();
    }

    public static String replaceAllChar(StringBuffer text, char c, String replacement) {
        return CBParse.replaceAllBufferChar(text, c, replacement).toString();
    }

    public static StringBuffer replaceAllBufferChar(StringBuffer text, char c, String replacement) {
        int pos = 0;
        while (pos != -1) {
            pos = text.toString().indexOf(c, pos);
            if (pos == -1) continue;
            pos = CBParse.replaceChar(text, pos, replacement);
        }
        return text;
    }

    public static int replaceString(StringBuffer text, int pos, int len, String replacement) {
        text.replace(pos, pos + len, replacement);
        return pos + replacement.length();
    }

    public static String replaceAllString(StringBuffer text, String orig, String replacement) {
        return CBParse.replaceAllBufferString(text, orig, replacement).toString();
    }

    public static StringBuffer replaceAllBufferString(StringBuffer text, String orig, String replacement) {
        int pos = 0;
        while (pos != -1) {
            pos = text.toString().indexOf(orig, pos);
            if (pos == -1) continue;
            pos = CBParse.replaceString(text, pos, orig.length(), replacement);
        }
        return text;
    }

    public static int nextCharIn(int pos, String searchMe, String compare, boolean match) {
        int length = searchMe.length();
        while (pos < length) {
            char test = searchMe.charAt(pos);
            if (compare.indexOf(test) != -1 == match) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public static String[] readFilteredDirectory(String dirPath, String extension) {
        String[] extensions = new String[]{extension};
        return CBUtility.readFilteredDirectory(dirPath, extensions);
    }

    public static String[] readFilteredDirectory(String dirPath, String[] fileExtensions) {
        final String[] extensions = fileExtensions;
        File dir = new File(dirPath);
        String[] templates = dir.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                for (int i = 0; i < extensions.length; ++i) {
                    if (!name.endsWith(extensions[i])) continue;
                    return true;
                }
                return false;
            }
        });
        return templates;
    }

    public static void setWaitCursor(Component C) {
        C.setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void setNormalCursor(Component C) {
        C.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void setHandCursor(Component C) {
        C.setCursor(Cursor.getPredefinedCursor(12));
    }

    public static Cursor getCursor(Component C) {
        return C.getCursor();
    }

    public static void saveCursor(Component C) {
        savedCursor = C.getCursor();
    }

    public static void restoreCursor(Component C) {
        if (savedCursor != null) {
            C.setCursor(savedCursor);
        } else {
            log.info("graphics error: can't restore cursor; no cursor saved...");
        }
    }

    public static void initDefaultDisplay(Frame owner) {
        displayFrame = owner;
    }

    public static Frame getDefaultDisplay() {
        return displayFrame;
    }

    public static boolean error(Component owner, String Msg) {
        return CBUtility.error(CBUtility.getParentFrame(owner), Msg, null);
    }

    public static boolean error(Frame owner, String Msg) {
        if (displayFrame == null) {
            log.warning("graphics error: error display not initialised! (root error was: " + Msg + ")");
            return false;
        }
        return CBUtility.error(owner, Msg, null);
    }

    public static boolean error(String Msg) {
        if (displayFrame == null) {
            log.warning("graphics error: error display not initialised! (error was: " + Msg + ")");
            return false;
        }
        return CBUtility.error(displayFrame, Msg, null);
    }

    public static boolean error(String Msg, Exception e) {
        return CBUtility.error(displayFrame, Msg, e);
    }

    public static boolean error(Component owner, String Msg, Exception e) {
        return CBUtility.error(CBUtility.getParentFrame(owner), Msg, e);
    }

    public static boolean error(Frame owner, String Msg, Exception e) {
        if (owner == null) {
            if (displayFrame == null) {
                log.warning("error display not initialised! (error was: " + Msg + ")");
                return false;
            }
            owner = displayFrame;
        }
        CBErrorWin errWin = new CBErrorWin(owner, Msg, e);
        log.log(Level.WARNING, "error displayed to user: " + Msg, e);
        return false;
    }

    public static void confirm(String Msg) {
        if (displayFrame == null) {
            log.warning("error display not initialised! (error was: " + Msg + ")");
            return;
        }
        new CBErrorWin(displayFrame, Msg, "Confirmation Message");
    }

    public static boolean warning(Component caller, String Msg, String Title) {
        JOptionPane.showMessageDialog(caller, Msg, Title, 2);
        return false;
    }

    public static boolean warning(String Msg) {
        if (displayFrame == null) {
            log.warning("warning display not initialised! (error was: " + Msg + ")");
            return false;
        }
        return CBUtility.warning(displayFrame, Msg, "Warning");
    }

    public static void printEnumeration(Enumeration e) {
        while (e.hasMoreElements()) {
            Object raw = e.nextElement();
            String value = raw == null ? "*null*" : raw.toString();
            System.out.println("    " + value);
        }
    }

    public static Frame getParentFrame(Component c) {
        Container parent;
        if (c == null) {
            return null;
        }
        for (parent = c.getParent(); !(parent instanceof Frame) && parent != null; parent = parent.getParent()) {
        }
        return parent == null ? null : (Frame)parent;
    }

    public static String convertPathToUnix(String dosPath) {
        String ret = dosPath.replace('\\', '/');
        return ret;
    }

    public static void center(Component centerMe, Component positioner) {
        if (centerMe == null) {
            return;
        }
        if (positioner != null && positioner.isShowing()) {
            Rectangle pos = positioner.getBounds();
            Point absPos = positioner.getLocationOnScreen();
            int centerX = absPos.x + pos.width / 2;
            int centerY = absPos.y + pos.height / 2;
            pos = centerMe.getBounds();
            int x = 0;
            int y = 0;
            if (centerMe.isShowing()) {
                absPos = centerMe.getLocationOnScreen();
                int currentX = absPos.x + pos.width / 2;
                int currentY = absPos.y + pos.height / 2;
                int deltaX = centerX - currentX;
                int deltaY = centerY - currentY;
                x = pos.x + deltaX;
                y = pos.y + deltaY;
            } else {
                x = centerX - pos.width / 2;
                y = centerY - pos.height / 2;
            }
            Toolkit toolKit = Toolkit.getDefaultToolkit();
            if (x - 100 < 0 || x + 100 > toolKit.getScreenSize().width || y - 100 < 0 || y + 100 > toolKit.getScreenSize().height) {
                CBUtility.centerOnScreen(centerMe);
            } else {
                centerMe.setLocation(x, y);
            }
        } else {
            CBUtility.centerOnScreen(centerMe);
        }
    }

    private static void centerOnScreen(Component centerMe) {
        Dimension screen = centerMe.getToolkit().getScreenSize();
        Dimension object = centerMe.getSize();
        centerMe.setLocation((int)(screen.getWidth() - object.getWidth()) / 2, (int)(screen.getHeight() - object.getHeight()) / 2);
    }

    public static String chooseFileToSave(Component parent, String title, String[] filter, String fileType) {
        int returnVal;
        JFileChooser chooser = new JFileChooser(System.getProperty("PKIHOME"));
        chooser.setToolTipText(title);
        chooser.setDialogTitle(title);
        if (filter != null && fileType != null) {
            CBFileFilter filt = new CBFileFilter(filter, fileType);
            chooser.setFileFilter(filt);
        }
        if ((returnVal = chooser.showSaveDialog(parent)) == 0 && chooser.getSelectedFile() != null) {
            return chooser.getSelectedFile().toString();
        }
        return null;
    }

    public static boolean okToWriteFile(Frame parent, String fileName) {
        File f = new File(fileName);
        if (f.isDirectory()) {
            JOptionPane.showMessageDialog(parent, fileName + " is a directory.", "Error!", 0);
            return false;
        }
        if (f.exists()) {
            int saveAnswer = JOptionPane.showConfirmDialog(parent, "File " + fileName + " already exists.\nDo you want to overwrite?", "Question", 2);
            return saveAnswer == 0;
        }
        return true;
    }

    public static boolean isSolaris() {
        String os = System.getProperty("os.name");
        if (os == null) {
            return false;
        }
        if ((os = os.toLowerCase()).indexOf("sun") > -1) {
            return true;
        }
        return os.indexOf("solaris") > -1;
    }

    public static boolean isLinux() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("linux") > -1;
    }

    public static boolean isMac() {
        String os = System.getProperty("mrj.version");
        return os != null;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().indexOf("win") > -1;
    }

    public static boolean isWindowsVistaOrBetter() {
        String version;
        Float versionF;
        return CBUtility.isWindows() && (versionF = new Float(version = System.getProperty("os.version"))).floatValue() >= 6.0f;
    }

    public static boolean checkAndCreateWorkingDirectory(String workingDirectory) {
        File jx = new File(workingDirectory);
        try {
            File testFile;
            if (!jx.exists()) {
                jx.mkdirs();
            }
            if ((testFile = new File(jx, "jx_file_write.test")).exists()) {
                testFile.delete();
            }
            FileOutputStream out = new FileOutputStream(testFile);
            out.write("bloop".getBytes());
            out.close();
        }
        catch (Exception e) {
            log.warning("ERROR: unable to save config or store user data in " + workingDirectory + " (may try elsewhere)");
            return false;
        }
        return true;
    }

    public static String getConfigDirectory(String applicationName) {
        if (defaultConfigDirectory != null) {
            return defaultConfigDirectory;
        }
        boolean forceUseOfApplicationsDir = false;
        if (System.getProperty(applicationName + ".config") != null) {
            defaultConfigDirectory = System.getProperty(applicationName + ".config");
            if (defaultConfigDirectory.equalsIgnoreCase("home") || defaultConfigDirectory.equalsIgnoreCase("user.home")) {
                forceUseOfApplicationsDir = true;
            } else if (CBUtility.checkAndCreateWorkingDirectory(defaultConfigDirectory)) {
                return defaultConfigDirectory;
            }
        }
        if (!forceUseOfApplicationsDir) {
            defaultConfigDirectory = System.getProperty("user.dir") + File.separator;
            if (CBUtility.checkAndCreateWorkingDirectory(defaultConfigDirectory)) {
                return defaultConfigDirectory;
            }
            System.out.println("unable to use user.dir");
        }
        if (CBUtility.isWindowsVistaOrBetter()) {
            System.out.println("On Windows");
            defaultConfigDirectory = System.getenv("APPDATA") + File.separator + applicationName + File.separator;
            if (CBUtility.checkAndCreateWorkingDirectory(defaultConfigDirectory)) {
                return defaultConfigDirectory;
            }
            System.out.println("unable to use windows default dir: " + defaultConfigDirectory);
        } else if (CBUtility.isMac() && CBUtility.checkAndCreateWorkingDirectory(defaultConfigDirectory = System.getProperty("user.home") + File.separator + "Library" + File.separator + applicationName + File.separator)) {
            return defaultConfigDirectory;
        }
        defaultConfigDirectory = System.getProperty("user.home") + File.separator + applicationName;
        if (CBUtility.checkAndCreateWorkingDirectory(defaultConfigDirectory)) {
            return defaultConfigDirectory;
        }
        log.severe("ERROR: unable to save config or store user data - running on defaults only.  \nChange permissions in app directory or manually set a writeable configuration directory on the command line to fix.");
        return "";
    }

    public static String getPropertyConfigPath(String applicationName, String configFileName) {
        String configDir = CBUtility.getConfigDirectory(applicationName) + configFileName;
        log.fine("USING CONFIG DIR: " + configDir);
        return configDir;
    }

    public static Level getTrueLogLevel(Logger log) {
        if (log.getLevel() != null) {
            return log.getLevel();
        }
        if (log.getParent() != null) {
            return CBUtility.getTrueLogLevel(log.getParent());
        }
        log.severe("no active log level initialised");
        System.err.println("no active log level initialised");
        return Level.ALL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    static {
        displayFrame = null;
        defaultConfigDirectory = null;
        log = Logger.getLogger(CBUtility.class.getName());
    }

    public static class IgnoreCaseStringComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o2 == null && o1 != null) {
                return -1;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            try {
                return o1.toString().toLowerCase().compareTo(o2.toString().toLowerCase());
            }
            catch (ClassCastException e) {
                return 0;
            }
        }
    }

    public static class BasicWindowMonitor
    extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            Window w = e.getWindow();
            w.setVisible(false);
            w.dispose();
        }
    }
}

