/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBUtility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.border.TitledBorder;

public class CBSaveLoadTemplate
extends JPanel {
    protected CBButton save = new CBButton(CBIntText.get("Save"), CBIntText.get("Click here to save current settings."));
    protected CBButton delete;
    protected CBButton makeDefault = new CBButton(CBIntText.get("Default"), CBIntText.get("Click here to make the current setting the default."));
    protected CBJComboBox loadops;
    public Properties templates;
    public String configFile;
    int numTemplates;
    private boolean saveFlag = false;
    static final String NUMTEMPLATES = "number_of_templates";
    static final String TEMPLATENAME = "template_name";
    static final String DEFAULT = "default";
    private static Logger log = Logger.getLogger(CBSaveLoadTemplate.class.getName());

    public CBSaveLoadTemplate(String applicationName, String fileName) {
        this.delete = new CBButton(CBIntText.get("Delete"), CBIntText.get("Click here to delete a previously saved setting."));
        this.loadops = new CBJComboBox();
        this.templates = new Properties();
        this.configFile = this.parseConfigFile(applicationName, fileName);
        CBPanel main = new CBPanel();
        main.add(this.save);
        main.makeHeavy();
        main.add(this.loadops);
        main.makeLight();
        main.add(this.delete);
        main.add(this.makeDefault);
        this.setBorder(new TitledBorder(CBIntText.get("Use a Template")));
        this.setLayout(new BorderLayout());
        this.add(main);
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CBSaveLoadTemplate.this.saveFlag = true;
                CBSaveLoadTemplate.this.save();
            }
        });
        this.loadops.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!CBSaveLoadTemplate.this.saveFlag) {
                    CBSaveLoadTemplate.this.load();
                }
                CBSaveLoadTemplate.this.saveFlag = false;
            }
        });
        this.loadops.setToolTipText(CBIntText.get("Click here to load a previously saved setting."));
        this.delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int response = CBSaveLoadTemplate.this.showMessage();
                if (response != 0) {
                    return;
                }
                CBSaveLoadTemplate.this.delete();
            }
        });
        this.makeDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CBSaveLoadTemplate.this.makeDefault();
            }
        });
    }

    public CBJComboBox getLoadComboBox() {
        return this.loadops;
    }

    public CBButton getSaveButton() {
        return this.save;
    }

    public int showMessage() {
        return JOptionPane.showConfirmDialog(this, CBIntText.get("Are you sure you want to delete the template?"), CBIntText.get("Delete Confirmation"), 0);
    }

    public void loadDefault() {
        String defaultName = this.templates.getProperty(DEFAULT);
        if (defaultName != null && defaultName.length() != 0) {
            this.loadTemplateName(defaultName);
        }
    }

    protected String parseConfigFile(String applicationName, String fileName) {
        int i;
        String configFile = CBUtility.getPropertyConfigPath(applicationName, fileName);
        if (configFile == null) {
            CBUtility.error(this, "Unable to read user home directory ", null);
            return fileName;
        }
        this.templates = CBUtility.readPropertyFile(configFile);
        if (this.templates.size() == 0) {
            log.info("Initialising config file: " + configFile);
            return configFile;
        }
        String temp = this.templates.getProperty(NUMTEMPLATES);
        if (temp == null) {
            CBUtility.error(this, "Unable to read number of templates parameter from: " + configFile, null);
            return configFile;
        }
        this.numTemplates = Integer.parseInt(temp);
        ArrayList<String> names = new ArrayList<String>(this.numTemplates);
        for (i = 0; i < this.numTemplates; ++i) {
            temp = this.templates.getProperty(TEMPLATENAME + i);
            names.add(temp);
        }
        Collections.sort(names);
        for (i = 0; i < this.numTemplates; ++i) {
            this.loadops.addItem(names.get(i));
        }
        String defaultName = this.templates.getProperty(DEFAULT);
        this.loadops.setSelectedItem(defaultName);
        return configFile;
    }

    public String getCurrentTemplateName() {
        String currentTemplateName = (String)this.loadops.getSelectedItem();
        if (currentTemplateName == null) {
            return "";
        }
        return currentTemplateName;
    }

    public void setCurrentTemplateName(String displayTemplateName) {
        if (displayTemplateName != null && !"".equals(displayTemplateName)) {
            this.loadops.setSelectedItem(displayTemplateName);
        }
    }

    public void save() {
        String currentTemplateName = this.getCurrentTemplateName();
        String templateName = (String)JOptionPane.showInputDialog(this, CBIntText.get("Enter template name") + ":", CBIntText.get("Replace/Create Template"), 3, null, null, currentTemplateName);
        if (templateName == null) {
            return;
        }
        this.saveTemplateName(templateName);
        this.loadops.setSelectedItem(templateName);
    }

    public void saveTemplateName(String templateName) {
        if ((templateName = templateName.replace('.', '-')) == null) {
            return;
        }
        Container parent = this.getParent();
        this.saveContainerInfo(parent, templateName);
        boolean we_already_got_one = false;
        for (int i = 0; i < this.numTemplates; ++i) {
            String test = this.templates.getProperty(TEMPLATENAME + i);
            if (test == null || !test.equals(templateName)) continue;
            we_already_got_one = true;
            break;
        }
        if (!we_already_got_one) {
            this.templates.setProperty(TEMPLATENAME + this.numTemplates, templateName);
            ++this.numTemplates;
            this.templates.setProperty(NUMTEMPLATES, Integer.toString(this.numTemplates));
            this.loadops.addItem(templateName);
        }
        this.saveToFile();
    }

    public void saveContainerInfo(Container myContainer, String templateName) {
        if (myContainer == null) {
            log.warning("Unexpected error in CBSaveLoadTemplate.save() - no parent found");
            return;
        }
        Component[] components = myContainer.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            this.saveComponent(c, i, templateName);
        }
    }

    protected void saveComponent(Component c, int componentNo, String templateName) {
        if (c instanceof JPanel && c != this) {
            this.saveContainerInfo((Container)c, templateName + "." + componentNo);
        } else if (c instanceof JScrollPane && c != this) {
            this.saveContainerInfo((Container)c, templateName + "." + componentNo);
        } else if (c instanceof JViewport && c != this) {
            this.saveContainerInfo((Container)c, templateName + "." + componentNo);
        } else if (c.getName() != null) {
            this.saveComponentText(c, templateName + "." + c.getName());
        } else {
            this.saveComponentText(c, templateName + "." + componentNo);
        }
    }

    protected void saveComponentText(Component c, String templateKey) {
        if (c == null) {
            return;
        }
        String saveText = null;
        try {
            if (c instanceof JPasswordField) {
                saveText = this.getPasswordDataToSave(new String(((JPasswordField)c).getPassword()));
            } else if (c instanceof JTextField) {
                saveText = ((JTextField)c).getText();
            } else if (c instanceof JTextArea) {
                saveText = ((JTextArea)c).getText();
            } else if (c instanceof JToggleButton) {
                saveText = String.valueOf(((JToggleButton)c).isSelected());
            } else if (c instanceof CBJComboBox) {
                saveText = ((CBJComboBox)c).getSelectedItem().toString();
            }
            if (saveText != null) {
                this.templates.setProperty(templateKey, saveText);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected String getPasswordDataToSave(String passwordToSave) {
        return null;
    }

    protected String getPasswordDataFromLoad(String savedPasswordData) {
        return "";
    }

    public void load() {
        String templateName = this.getCurrentTemplateName();
        if (templateName.length() == 0) {
            CBUtility.error(this, CBIntText.get("No template selected!"), null);
            return;
        }
        this.loadTemplateName(templateName);
    }

    public void loadTemplateName(String templateName) {
        Container parent = this.getParent();
        this.loadContainerInfo(parent, templateName);
    }

    public void loadContainerInfo(Container myContainer, String templateName) {
        if (myContainer == null) {
            log.warning("Unexpected error in CBSaveLoadTemplate.load() - no parent found");
            return;
        }
        Component[] components = myContainer.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Component c = components[i];
            this.loadComponent(c, i, templateName);
        }
    }

    protected void loadComponent(Component c, int componentNo, String templateName) {
        if (c instanceof JPanel) {
            this.loadContainerInfo((Container)c, templateName + "." + componentNo);
        } else if (c instanceof JScrollPane) {
            this.loadContainerInfo((Container)c, templateName + "." + componentNo);
        } else if (c instanceof JViewport) {
            this.loadContainerInfo((Container)c, templateName + "." + componentNo);
        } else {
            String text = (String)this.templates.get(templateName + "." + componentNo);
            if (text == null && c.getName() != null) {
                text = (String)this.templates.get(templateName + "." + c.getName());
            }
            if (text != null) {
                this.loadComponentText(c, text);
            }
        }
    }

    public void loadComponentText(Component c, String text) {
        if (c instanceof JTextField) {
            ((JTextField)c).setText(text);
        }
        if (c instanceof JPasswordField) {
            ((JPasswordField)c).setText(this.getPasswordDataFromLoad(text));
        } else if (c instanceof JTextArea) {
            ((JTextArea)c).setText(text);
        } else if (c instanceof TextField) {
            ((TextField)c).setText(text);
        } else if (c instanceof JToggleButton) {
            ((JToggleButton)c).setSelected("true".equalsIgnoreCase(text));
        } else if (c instanceof CBJComboBox) {
            ((CBJComboBox)c).setSelectedItem(text);
        }
    }

    public void delete() {
        String templateName = this.getCurrentTemplateName();
        if (templateName.length() == 0) {
            CBUtility.error(this, "No template selected!", null);
            return;
        }
        Container parent = this.getParent();
        if (parent == null) {
            log.warning("Unexpected error in CBSaveLoadTemplate.delete() - no parent found");
            return;
        }
        this.deleteComponentInfo(parent, templateName);
        for (int i = 0; i < this.numTemplates; ++i) {
            if (!templateName.equals((String)this.templates.get(TEMPLATENAME + i))) continue;
            this.templates.remove(TEMPLATENAME + i);
            --this.numTemplates;
            this.templates.put(NUMTEMPLATES, Integer.toString(this.numTemplates));
            this.loadops.removeItem(templateName);
            for (int j = i + 1; j <= this.numTemplates; ++j) {
                templateName = (String)this.templates.get(TEMPLATENAME + j);
                this.templates.put(TEMPLATENAME + (j - 1), templateName);
            }
            this.templates.remove(TEMPLATENAME + this.numTemplates);
            break;
        }
        this.saveToFile();
    }

    public void deleteComponentInfo(Container myContainer, String templateName) {
        Component[] components = myContainer.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof JPanel) {
                this.deleteComponentInfo((Container)components[i], templateName + "." + i);
                continue;
            }
            if (components[i] instanceof JScrollPane) {
                this.deleteComponentInfo((Container)components[i], templateName + "." + i);
                continue;
            }
            if (components[i] instanceof JViewport) {
                this.deleteComponentInfo((Container)components[i], templateName + "." + i);
                continue;
            }
            this.deleteComponentInfo(templateName + "." + i);
        }
        try {
            if (this.templates.getProperty(DEFAULT) != null && this.templates.getProperty(DEFAULT).equalsIgnoreCase(templateName)) {
                this.templates.remove(DEFAULT);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "No default template. ", e);
        }
    }

    public void deleteComponentInfo(String templateName) {
        this.templates.remove(templateName);
    }

    public void makeDefault() {
        this.templates.setProperty(DEFAULT, this.getCurrentTemplateName());
        this.saveToFile();
    }

    public void saveToFile() {
        CBUtility.writePropertyFile(this.configFile, this.templates, "");
    }
}

