/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBSingleSelectionModel;
import com.ca.commons.cbutil.CBUtility;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class CBListSelector
extends CBDialog {
    JList availableList;
    JList selectedList;
    JScrollPane availableScrollPane;
    JScrollPane selectedScrollPane;
    CBButton btnAdd;
    CBButton btnRemove;
    JLabel availableLabel;
    JLabel selectedLabel;
    CBPanel leftPanel;
    CBPanel middlePanel;
    CBPanel rightPanel;
    ArrayList arrayList = new ArrayList();
    private static Logger log = Logger.getLogger(CBListSelector.class.getName());

    public static ArrayList getSelectedValues(Frame owner, String[] list, String title, String helpID) {
        CBListSelector listSelector = new CBListSelector(owner, list, title, helpID);
        listSelector.setVisible(true);
        return listSelector.getSelectedValues();
    }

    public CBListSelector(Frame owner, String[] list, String title, String helpID) {
        super(owner, CBIntText.get(title), helpID);
        this.leftPanel = new CBPanel();
        this.middlePanel = new CBPanel();
        this.rightPanel = new CBPanel();
        this.availableLabel = new JLabel(CBIntText.get("Available Attributes") + ":");
        this.leftPanel.addln(this.availableLabel);
        this.leftPanel.makeHeavy();
        this.availableList = new JList<String>(list);
        this.availableList.setSelectionMode(0);
        this.availableList.setSelectionModel(new CBSingleSelectionModel(this.availableList));
        this.availableScrollPane = new JScrollPane(this.availableList);
        this.leftPanel.addln(this.availableScrollPane);
        this.btnAdd = new CBButton(CBIntText.get(">>"), CBIntText.get("Add an attribute from the attribute list on the left to the selection list on the right."));
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CBListSelector.this.add();
            }
        });
        this.btnRemove = new CBButton(CBIntText.get("<<"), CBIntText.get("Remove an attribute from the selection list on the right."));
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CBListSelector.this.remove();
            }
        });
        this.middlePanel.makeHeavy();
        this.middlePanel.addln(new JLabel("  "));
        this.middlePanel.makeLight();
        this.middlePanel.addln(this.btnAdd);
        this.middlePanel.addln(this.btnRemove);
        this.middlePanel.makeHeavy();
        this.middlePanel.addln(new JLabel("  "));
        this.selectedLabel = new JLabel(CBIntText.get("Selected Attributes") + ":");
        this.rightPanel.addln(this.selectedLabel);
        this.rightPanel.makeHeavy();
        this.selectedList = new JList();
        this.selectedList.setSelectionMode(0);
        this.selectedList.setSelectionModel(new CBSingleSelectionModel(this.selectedList));
        this.selectedScrollPane = new JScrollPane(this.selectedList);
        this.rightPanel.addln(this.selectedScrollPane);
        this.display.addln(new JLabel("  "));
        this.display.makeHeavy();
        this.display.add(this.leftPanel);
        this.display.makeLight();
        this.display.add(this.middlePanel);
        this.display.makeHeavy();
        this.display.add(this.rightPanel);
        this.setSize(400, 300);
        CBUtility.center(this, owner);
        this.registerMouseListeners();
    }

    protected void registerMouseListeners() {
        this.availableList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CBListSelector.this.add();
                }
            }
        });
        this.selectedList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    CBListSelector.this.remove();
                }
            }
        });
    }

    public void add() {
        try {
            if (!this.arrayList.contains(this.availableList.getSelectedValue())) {
                this.arrayList.add(this.availableList.getSelectedValue());
            }
            this.selectedList.setListData(this.arrayList.toArray());
        }
        catch (Exception e) {
            log.log(Level.FINER, "No selection to add.", e);
        }
    }

    public void remove() {
        try {
            this.arrayList.remove(this.selectedList.getSelectedIndex());
            this.selectedList.setListData(this.arrayList.toArray());
        }
        catch (Exception e) {
            log.log(Level.FINER, "No selection to remove.", e);
        }
    }

    public ArrayList getSelectedValues() {
        if (this.arrayList.isEmpty()) {
            return null;
        }
        return this.arrayList;
    }
}

