/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import java.awt.Dimension;
import java.awt.Point;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.JButton;

public class CBHelpSystem {
    private String helpSetName;
    private HelpSet helpSet = null;
    private HelpBroker helpBroker;
    private ClassLoader myClassLoader;
    boolean setup = false;
    private static CBHelpSystem defaultHelpSystem;
    private static Point defaultLocation;
    private static Logger log;

    public CBHelpSystem(String helpset_Name) {
        this(helpset_Name, null, null);
    }

    public CBHelpSystem(String helpset_Name, Dimension initialSize) {
        this(helpset_Name, null, initialSize);
    }

    public CBHelpSystem(String helpset_Name, ClassLoader cl, Dimension initialSize) {
        if (cl != null) {
            this.myClassLoader = cl;
        }
        if (helpset_Name != null) {
            this.helpSetName = helpset_Name;
        }
        if (this.setup) {
            return;
        }
        if (this.myClassLoader == null) {
            this.myClassLoader = this.getClass().getClassLoader();
        }
        this.helpSet = CBHelpSystem.getHelpSet(this.helpSetName, this.myClassLoader);
        if (this.helpSet == null) {
            log.warning("Error creating help set!  Can't find: " + this.helpSetName);
            return;
        }
        this.helpBroker = this.helpSet.createHelpBroker();
        if (initialSize != null) {
            this.helpBroker.setSize(initialSize);
        }
        log.info("Initial HelpSet created: " + this.helpSet.toString());
        this.setup = true;
        defaultHelpSystem = this;
    }

    public boolean ready() {
        return this.setup;
    }

    public synchronized HelpSet getHelpSet() {
        return this.helpSet;
    }

    public synchronized HelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public static HelpSet getHelpSet(String newHelpSetName, ClassLoader loader) {
        HelpSet newHelpSet = null;
        try {
            URL url = HelpSet.findHelpSet(loader, newHelpSetName);
            if (url != null) {
                newHelpSet = new HelpSet(loader, url);
            }
        }
        catch (NoClassDefFoundError ec) {
            log.log(Level.WARNING, "Help DataBroker initialization error: couldn't find help set ", ec);
        }
        catch (ExceptionInInitializerError ex) {
            log.log(Level.WARNING, "Help DataBroker initialization error: ", ex);
            ex.getException().printStackTrace();
        }
        catch (Exception ee) {
            log.log(Level.WARNING, "Help Set '" + newHelpSetName + "' not found", ee);
        }
        return newHelpSet;
    }

    public void addHelpSet(String pluginHelpSet, ClassLoader loader) {
        if (this.helpSet != null) {
            this.helpSet.add(CBHelpSystem.getHelpSet(pluginHelpSet, loader));
        } else {
            this.helpSet = CBHelpSystem.getHelpSet(pluginHelpSet, loader);
            if (this.helpSet != null) {
                this.helpBroker = this.helpSet.createHelpBroker();
            }
        }
    }

    public void addHelpSet(HelpSet newSet) {
        if (newSet == null) {
            return;
        }
        if (this.helpSet != null) {
            this.helpSet.add(newSet);
        } else {
            this.helpSet = newSet;
            if (this.helpSet != null) {
                this.helpBroker = this.helpSet.createHelpBroker();
            }
        }
    }

    public void open() {
        if (this.helpBroker != null) {
            this.helpBroker.setLocation(defaultLocation);
            this.helpBroker.setDisplayed(true);
        }
    }

    public void openTab(String tab) {
        if (this.helpBroker != null) {
            try {
                this.helpBroker.setCurrentView(tab);
            }
            catch (IllegalArgumentException ia) {
                log.warning("Caught Illegal Argument Exception - an incorrect Help view was asked for: " + ia + "\n\nOpening help with default view...");
                this.open();
                return;
            }
            this.helpBroker.setLocation(defaultLocation);
            this.helpBroker.setDisplayed(true);
        }
    }

    public void open(String contentID) {
        if (this.helpBroker != null) {
            this.helpBroker.setLocation(defaultLocation);
            this.helpBroker.setDisplayed(true);
        }
        try {
            this.helpBroker.setCurrentID(contentID);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Caught exception: ", e);
        }
    }

    public static void setdefaultHelpSystem(CBHelpSystem set) {
        defaultHelpSystem = set;
    }

    public static CBHelpSystem getDefaultHelpSystem() {
        return defaultHelpSystem;
    }

    public static void addToDefaultHelpSystem(String newHelpSet, ClassLoader loader) {
        log.info("attempting to add help set: '" + newHelpSet + "' using loader: " + loader.toString());
        if (defaultHelpSystem == null) {
            CBHelpSystem newDefault = new CBHelpSystem(newHelpSet, loader, null);
            log.info("trying to set default help system to: " + (newDefault == null ? "null" : newDefault.toString()));
            if (newDefault != null) {
                CBHelpSystem.setdefaultHelpSystem(newDefault);
            }
        } else {
            HelpSet bloop = CBHelpSystem.getHelpSet(newHelpSet, loader);
            log.info("found help set: " + (bloop == null ? " null " : bloop.toString()));
            defaultHelpSystem.addHelpSet(bloop);
        }
    }

    public static void useDefaultHelp(JButton button, String helpString) {
        if (helpString == null) {
            return;
        }
        if (defaultHelpSystem == null) {
            log.warning("No default HelpSystem.");
        }
        if (defaultHelpSystem == null || !defaultHelpSystem.ready()) {
            log.warning("using default help system with no name...");
            defaultHelpSystem = new CBHelpSystem(null);
        }
        try {
            HelpBroker helpBroker = defaultHelpSystem.getHelpSet().createHelpBroker();
            helpBroker.enableHelpOnButton(button, helpString, defaultHelpSystem.getHelpSet());
        }
        catch (Exception e) {
            log.log(Level.WARNING, "No HelpSet available: ", e);
        }
    }

    static {
        defaultLocation = new Point(100, 100);
        log = Logger.getLogger(CBHelpSystem.class.getName());
    }
}

