/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.cbutil;

import com.ca.commons.cbutil.CBJarResource;
import com.ca.commons.cbutil.CBResourceLoader;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Logger;
import java.util.zip.ZipException;

public class CBClassLoader
extends ClassLoader {
    protected Hashtable classes = new Hashtable();
    protected Hashtable lowerCaseClasses = new Hashtable();
    protected CBResourceLoader resourceLoader;
    private static Logger log = Logger.getLogger(CBClassLoader.class.getName());

    public CBClassLoader(CBResourceLoader loader) {
        log.fine("Started CBClassLoader");
        this.resourceLoader = loader;
    }

    protected String translateClassName(String name) {
        name = name.endsWith(".class") ? name.replace('.', '/') : name.replace('.', '/') + ".class";
        log.finer("looking for class: " + name);
        return name;
    }

    private byte[] getClassFromResourceFiles(String className) throws ZipException {
        className = this.translateClassName(className);
        return this.resourceLoader.getResource(className);
    }

    public Class findClass(String className) throws ClassNotFoundException {
        return this.findClass(className, true);
    }

    void addClass(Class c) {
        log.finer("adding class " + c.toString());
    }

    public synchronized Class findClass(String className, boolean resolveIt) throws ClassNotFoundException {
        log.finer("        >>>>>> Load class : " + className);
        Object local = this.classes.get(className);
        if (local != null) {
            if (local instanceof String && "".equals((String)local)) {
                log.finer("        >>>>>> ignoring '" + className + "' (failed to load previously).");
                throw new ClassNotFoundException("ignoring class '" + className + "' (failed to load previously).");
            }
            log.finer("        >>>>>> returning cached result.");
            return (Class)local;
        }
        try {
            Class<?> result = super.findSystemClass(className);
            log.finer("        >>>>>> returning system class (in CLASSPATH).");
            return result;
        }
        catch (ClassNotFoundException e) {
            byte[] classData;
            log.finer("        >>>>>> Not a system class - looking in zip files.");
            try {
                classData = this.getClassFromResourceFiles(className);
            }
            catch (ZipException e2) {
                this.classes.put(className, "");
                this.lowerCaseClasses.put(className.toLowerCase(), "");
                throw new ClassNotFoundException("Error getting className: '" + className + "' : " + e2);
            }
            if (classData == null) {
                this.classes.put(className, "");
                this.lowerCaseClasses.put(className.toLowerCase(), "");
                throw new ClassNotFoundException();
            }
            Class<?> result = this.defineClass(className, classData, 0, classData.length);
            if (result == null) {
                this.classes.put(className, "");
                this.lowerCaseClasses.put(className.toLowerCase(), "");
                throw new ClassFormatError();
            }
            if (resolveIt) {
                this.resolveClass(result);
            }
            this.classes.put(className, result);
            this.lowerCaseClasses.put(className.toLowerCase(), result);
            log.finer("        >>>>>> Returning newly loaded zipped class. " + className);
            return result;
        }
    }

    public URL getResource(String name) {
        URL bloop = super.getResource(name);
        return bloop;
    }

    protected URL findResource(String name) {
        CBJarResource container = this.resourceLoader.getJarContainingResource(name);
        if (container == null) {
            return this.findFileResource(name);
        }
        String zipFile = container.getZipFileName();
        String url = "jar:file:" + zipFile + "!/" + name;
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            log.warning("Unable to construct url: " + url + "\n -> due to " + e);
            return null;
        }
    }

    protected URL findFileResource(String name) {
        try {
            File candidate = new File(name);
            if (candidate.exists()) {
                return candidate.toURI().toURL();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return "CBClassLoader";
    }

    public InputStream getResourceAsStream(String name) {
        return super.getResourceAsStream(name);
    }
}

