/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.jxworkbench.reports;

import com.ca.commons.naming.DN;
import com.ca.directory.jxplorer.broker.JNDIDataBroker;
import com.pegacat.jxworkbench.reports.JRLDAPDataSource;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRLDAPQueryExecuter
extends JRAbstractQueryExecuter {
    protected static JNDIDataBroker broker;
    protected static DN dn;
    protected String filter;
    protected String sort;
    private static Logger log;

    protected JRLDAPQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
        this.parseQueryString(dataset.getQuery().getText(), parametersMap);
        System.out.println("*** JRLDAPQueryExecuter (constructor I)");
    }

    public void parseQueryString(String query, Map<String, ? extends JRValueParameter> parametersMap) {
        System.out.println("READ FILTER: " + query);
        Matcher m = Pattern.compile("\\$P\\{(\\S+)\\}").matcher(query);
        StringBuffer buffy = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(buffy, parametersMap.get(m.group(1)).getValue().toString());
        }
        m.appendTail(buffy);
        query = buffy.toString();
        System.out.println("READ BUFFY: " + query);
        try {
            String[] components;
            this.filter = "(objectClass=*)";
            this.sort = null;
            for (String component : components = query.split(":")) {
                if ((component = component.toLowerCase()).startsWith("filter=")) {
                    this.filter = component.substring(7);
                    continue;
                }
                if (component.startsWith("dn=") && dn == null) {
                    dn = new DN(component.substring(3));
                    continue;
                }
                if (component.startsWith("sort=")) {
                    this.sort = component.substring(5);
                    continue;
                }
                System.out.println("XXX QUERY IGNORING: " + component);
            }
            System.out.println("XXX Filter = " + this.filter + " DN = " + dn + " SORT ATT = " + this.sort);
            if (dn == null) {
                dn = broker.readFallbackRoot()[0];
                log.warning("no dn provided: read default root as: " + dn.toString());
            }
            log.warning("REPORT USING FILTER: " + this.filter + " DN: " + dn.toString() + (this.sort == null ? " <no sorting> " : this.sort));
        }
        catch (Exception e) {
            log.severe("unable to parse query string: " + query + ".  Expected (filter):dn ; e.g. '(objectClass=person):ou=legal,o=pegacat'");
        }
    }

    public static void setDefaultJNDIBroker(JNDIDataBroker defaultBroker) {
        broker = defaultBroker;
    }

    public static void setDefaultDN(DN defaultDN) {
        dn = defaultDN;
    }

    protected JRLDAPQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(dataset, parametersMap);
    }

    public JRDataSource createDatasource() throws JRException {
        JRLDAPDataSource dataSource = new JRLDAPDataSource(broker, dn, this.filter, this.sort);
        return dataSource;
    }

    public void close() {
    }

    public boolean cancelQuery() throws JRException {
        return false;
    }

    protected String getParameterReplacement(String s) {
        return null;
    }

    protected void parseQuery() {
        super.parseQuery();
    }

    static {
        log = Logger.getLogger(JRLDAPQueryExecuter.class.getName());
    }
}

