/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.jxworkbench;

import com.ca.commons.cbutil.CBBase64;
import com.ca.commons.cbutil.CBParse;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXEntry;
import com.ca.directory.jxplorer.broker.DataBroker;
import com.ca.directory.jxplorer.tree.SmartTree;
import com.pegacat.jxworkbench.JXWCSVFieldBuffer;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXWCSVImportUtil {
    int lineCount = 0;
    static binaryHandlingEnum binaryHandling;
    ArrayList<String> columnNames = null;
    int DN_index = -1;
    int[] columnSizes;
    private static Logger log;

    public void loadTree(SmartTree tree, BufferedReader textReader) throws IOException, NamingException {
        String line;
        if (tree == null || textReader == null) {
            return;
        }
        this.parseHeader(this.getNextLine(textReader));
        DataBroker broker = tree.getDataSource();
        ArrayList<DN> roots = new ArrayList<DN>();
        while ((line = this.getNextLine(textReader)) != null) {
            DXEntry entry = this.createEntry(line);
            if (entry == null) continue;
            try {
                broker.unthreadedModify(null, entry);
                this.checkForNewRoot(roots, entry.getDN());
            }
            catch (NamingException e) {
                log.severe("error creating entry for line " + this.lineCount + ": " + line + "\n   => " + e.getMessage());
            }
        }
        tree.unthreadedRefresh(roots);
    }

    void checkForNewRoot(ArrayList<DN> roots, DN test) {
        if (roots.contains(test)) {
            return;
        }
        for (int i = roots.size() - 1; i >= 0; --i) {
            DN knownRoot = roots.get(i);
            if (test.startsWith(knownRoot)) {
                return;
            }
            if (!knownRoot.startsWith(test)) continue;
            roots.remove(knownRoot);
        }
        roots.add(test);
    }

    protected String getNextLine(BufferedReader textReader) throws IOException {
        ++this.lineCount;
        return textReader.readLine();
    }

    private ArrayList<String> unescape(ArrayList<String> values) {
        ArrayList<String> finalValues = new ArrayList<String>(values.size());
        for (String value : values) {
            finalValues.add(this.unescape(value));
        }
        return finalValues;
    }

    private String unescape(String value) {
        if (value == null || value.length() == 0) {
            return value;
        }
        JXWCSVFieldBuffer field = new JXWCSVFieldBuffer(value);
        field.unescape();
        return field.toString();
    }

    private ArrayList<String> split(String text, char splitChar) {
        ArrayList<String> values = new ArrayList<String>();
        boolean excelHack = JXWCSVFieldBuffer.escapeChar == JXWCSVFieldBuffer.quoteChar;
        boolean quoting = false;
        char lastChar = ' ';
        int splitStart = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (quoting) {
                if (c == JXWCSVFieldBuffer.quoteChar && (lastChar != JXWCSVFieldBuffer.escapeChar || excelHack)) {
                    quoting = false;
                }
            } else if (c == splitChar && (lastChar != JXWCSVFieldBuffer.escapeChar || excelHack)) {
                values.add(text.substring(splitStart, i).trim());
                splitStart = i + 1;
            } else if (c == JXWCSVFieldBuffer.quoteChar && lastChar != JXWCSVFieldBuffer.escapeChar) {
                quoting = true;
            }
            lastChar = c;
        }
        values.add(text.substring(splitStart).trim());
        return values;
    }

    void parseHeader(String header) throws NamingException {
        this.columnNames = this.split(header, JXWCSVFieldBuffer.columnDelimeter);
        this.columnNames = this.unescape(this.columnNames);
        this.DN_index = this.columnNames.contains("DN") ? this.columnNames.indexOf("DN") : this.columnNames.indexOf("dn");
        if (this.DN_index < 0) {
            throw new NamingException("unable to find 'dn' column in csv header - unable to continue");
        }
    }

    private void addAttributeValue(DXEntry entry, String attributeName, String attributeValue) {
        DXAttribute att;
        if (entry.get(attributeName) == null) {
            att = new DXAttribute(attributeName);
            entry.put((Attribute)att);
        } else {
            att = entry.get(attributeName);
        }
        if (DXAttribute.isString((String)attributeName)) {
            att.add((Object)attributeValue);
        } else if (JXWCSVFieldBuffer.binaryHandling != JXWCSVFieldBuffer.binaryHandlingEnum.ignore) {
            try {
                if (JXWCSVFieldBuffer.binaryHandling == JXWCSVFieldBuffer.binaryHandlingEnum.useBase64) {
                    att.add((Object)CBBase64.decode((String)attributeValue));
                } else if (JXWCSVFieldBuffer.binaryHandling == JXWCSVFieldBuffer.binaryHandlingEnum.useHex) {
                    att.add((Object)CBParse.hex2bytes((String)attributeValue));
                }
            }
            catch (Exception e) {
                log.severe("Error decoding non-string value on line " + this.lineCount + ": (" + attributeName + ") value = " + attributeValue + "\n  => " + e.getMessage());
            }
        }
    }

    DXEntry createEntry(String line) {
        boolean excelHack = JXWCSVFieldBuffer.useExcelHack();
        ArrayList<String> columns = this.split(line, JXWCSVFieldBuffer.columnDelimeter);
        if (columns.size() != this.columnNames.size()) {
            log.severe("Error in line " + this.lineCount + ": " + line + "\n => found " + columns.size() + " values, which does not match " + this.columnNames.size() + " header values");
            return null;
        }
        DXEntry entry = new DXEntry();
        if (JXWCSVFieldBuffer.useMultipleColumns) {
            columns = this.unescape(columns);
        }
        for (int col = 0; col < columns.size(); ++col) {
            String att = this.columnNames.get(col);
            String value = columns.get(col);
            if (value == null || value.length() <= 0) continue;
            if (JXWCSVFieldBuffer.useMultipleColumns) {
                if (col == this.DN_index) {
                    entry.setDN(new DN(value));
                    continue;
                }
                this.addAttributeValue(entry, att, value);
                continue;
            }
            if (col == this.DN_index) {
                entry.setDN(new DN(this.unescape(value)));
                continue;
            }
            if (excelHack && value.length() > 1 && value.charAt(0) == JXWCSVFieldBuffer.quoteChar && value.charAt(value.length() - 1) == JXWCSVFieldBuffer.quoteChar) {
                value = value.substring(1, value.length() - 1);
            }
            ArrayList<String> values = this.split(value, JXWCSVFieldBuffer.multiValuedAttDelimeter);
            values = this.unescape(values);
            for (String attVal : values) {
                this.addAttributeValue(entry, att, attVal);
            }
        }
        return entry;
    }

    static {
        log = Logger.getLogger(JXWCSVImportUtil.class.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum binaryHandlingEnum {
        ignore,
        useHex,
        useBase64;

    }
}

