/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.jxworkbench;

import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBFileFilter;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBSaveLoadTemplate;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.cbutil.CBpbar;
import com.ca.commons.naming.DN;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.broker.DataBroker;
import com.ca.directory.jxplorer.broker.DataQuery;
import com.ca.directory.jxplorer.tree.SmartTree;
import com.pegacat.jxworkbench.JXWCSVExportUtil;
import com.pegacat.jxworkbench.JXWCSVFieldBuffer;
import com.pegacat.jxworkbench.JXWCSVImportUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;

public class JXWCSV
extends CBDialog {
    private static String currentTemplateName = "";
    protected JXplorerBrowser owningBrowser;
    final JRadioButton single = new JRadioButton(CBIntText.get((String)"Single Column"), !JXWCSVFieldBuffer.useMultipleColumns);
    final JRadioButton multi = new JRadioButton(CBIntText.get((String)"Multiple Columns"), JXWCSVFieldBuffer.useMultipleColumns);
    final JRadioButton base64 = new JRadioButton(CBIntText.get((String)"Base 64"), JXWCSVFieldBuffer.binaryHandling == JXWCSVFieldBuffer.binaryHandlingEnum.useBase64);
    final JRadioButton hex = new JRadioButton(CBIntText.get((String)"Hex"), JXWCSVFieldBuffer.binaryHandling == JXWCSVFieldBuffer.binaryHandlingEnum.useHex);
    final JRadioButton ignore = new JRadioButton(CBIntText.get((String)"Ignore"), JXWCSVFieldBuffer.binaryHandling == JXWCSVFieldBuffer.binaryHandlingEnum.ignore);
    final JRadioButton fullTree = new JRadioButton("...", false);
    final JRadioButton currentSelection = new JRadioButton("...", true);
    final JTextField columnDelimeterField = new JTextField(Character.toString(JXWCSVFieldBuffer.columnDelimeter), 1);
    final JTextField mvaDelimeterField = new JTextField(Character.toString(JXWCSVFieldBuffer.multiValuedAttDelimeter), 1);
    final JTextField stringQuoteField = new JTextField(Character.toString(JXWCSVFieldBuffer.quoteChar), 1);
    final JTextField escapeCharField = new JTextField(Character.toString(JXWCSVFieldBuffer.escapeChar), 1);
    final JLabel mvaDelimeterLabel = new JLabel("        " + CBIntText.get((String)"delimeter:"));
    final CBSaveLoadTemplate myTemplater = new CBSaveLoadTemplate(JXplorer.APPLICATION_NAME, "csvconfig.txt");
    final CBPanel rootDNinset = new CBPanel();
    protected boolean saving = true;
    private static boolean firstTime = true;
    private static Logger log = Logger.getLogger(JXWCSV.class.getName());
    static ProgressMonitorInputStream pmonitor;

    public JXWCSV(JXplorerBrowser owner) {
        super((Frame)owner, "csv display error", "workbench.io");
        this.owningBrowser = owner;
        this.setupBaseOptionsDialog();
    }

    public void showSaveUI() {
        this.setTitle(CBIntText.get((String)"Export CSV File"));
        this.OK.setText(CBIntText.get((String)"Export"));
        this.saving = true;
        SmartTree tree = this.owningBrowser.getActiveTree();
        if (tree == null) {
            log.warning("Attempt to show csv export screen with no active tree");
        } else {
            this.rootDNinset.setVisible(true);
            DN root = tree.getRootDN();
            DN selected = tree.getCurrentDN();
            this.fullTree.setText(root == null ? "error" : root.toString());
            this.currentSelection.setText(selected == null ? "error" : selected.toString());
        }
        this.setVisible(true);
    }

    public void showLoadUI() {
        this.setTitle(CBIntText.get((String)"Import CSV File"));
        this.OK.setText(CBIntText.get((String)"Import"));
        this.saving = false;
        this.rootDNinset.setVisible(false);
        this.setVisible(true);
    }

    public char getControlCharacter(JTextField textfield) {
        String text = textfield.getText();
        if (text == null || text.length() == 0) {
            return '\u0000';
        }
        return textfield.getText().charAt(0);
    }

    public void doOK() {
        JXWCSVFieldBuffer.useMultipleColumns = this.multi.isSelected();
        JXWCSVFieldBuffer.columnDelimeter = this.getControlCharacter(this.columnDelimeterField);
        JXWCSVFieldBuffer.quoteChar = this.getControlCharacter(this.stringQuoteField);
        JXWCSVFieldBuffer.multiValuedAttDelimeter = this.getControlCharacter(this.mvaDelimeterField);
        JXWCSVFieldBuffer.escapeChar = this.getControlCharacter(this.escapeCharField);
        if (this.base64.isSelected()) {
            JXWCSVFieldBuffer.binaryHandling = JXWCSVFieldBuffer.binaryHandlingEnum.useBase64;
        } else if (this.hex.isSelected()) {
            JXWCSVFieldBuffer.binaryHandling = JXWCSVFieldBuffer.binaryHandlingEnum.useHex;
        } else if (this.ignore.isSelected()) {
            JXWCSVFieldBuffer.binaryHandling = JXWCSVFieldBuffer.binaryHandlingEnum.ignore;
        }
        currentTemplateName = this.myTemplater.getCurrentTemplateName();
        if (this.validateData()) {
            if (this.saving) {
                File exportFile = this.getExportFile();
                if (exportFile != null) {
                    this.writeFile(exportFile);
                }
            } else {
                File importFile = this.getImportFile();
                if (importFile != null) {
                    this.doFileRead(importFile);
                }
            }
            this.quit();
        }
    }

    public boolean validateData() {
        String mva;
        boolean useMultipleColumns = this.multi.isSelected();
        String cd = this.columnDelimeterField.getText().trim();
        String qc = this.stringQuoteField.getText().trim();
        String ec = this.escapeCharField.getText().trim();
        String string = mva = useMultipleColumns ? this.mvaDelimeterField.getText().trim() : null;
        if (ec.length() != 1) {
            return this.errorMessage(CBIntText.get((String)"Escape Character must be a single character"));
        }
        if (cd.equals(qc) || cd.equals(mva) || cd.equals(ec) || qc.equals(mva) || ec.equals(mva)) {
            return this.errorMessage(CBIntText.get((String)"Duplicate control characters are not allowed") + "\n" + "{ " + cd + " " + qc + "  " + mva + "  " + ec + " }");
        }
        return true;
    }

    public boolean errorMessage(String msg) {
        CBUtility.error((String)msg);
        return false;
    }

    public void setupBaseOptionsDialog() {
        this.setSize(480, 430);
        CBPanel display = this.getDisplayPanel();
        this.rootDNinset.setBorder((Border)new TitledBorder(CBIntText.get((String)"Export from:")));
        this.rootDNinset.addln((Component)this.fullTree);
        this.rootDNinset.addln((Component)this.currentSelection);
        ButtonGroup dnGroup = new ButtonGroup();
        dnGroup.add(this.fullTree);
        dnGroup.add(this.currentSelection);
        display.addln((Component)this.rootDNinset);
        CBPanel separatorsInset = new CBPanel();
        separatorsInset.setBorder((Border)new TitledBorder(CBIntText.get((String)"Text Management:")));
        separatorsInset.add((Component)new JLabel(CBIntText.get((String)"column separator")));
        separatorsInset.addln((Component)this.columnDelimeterField);
        separatorsInset.add((Component)new JLabel(CBIntText.get((String)"quote strings (optional)")));
        separatorsInset.addln((Component)this.stringQuoteField);
        separatorsInset.add((Component)new JLabel(CBIntText.get((String)"escape character:")));
        separatorsInset.addln((Component)this.escapeCharField);
        display.addln((Component)separatorsInset);
        CBPanel mvaInset = new CBPanel();
        mvaInset.setBorder((Border)new TitledBorder(CBIntText.get((String)"Multivalued Attributes:")));
        mvaInset.addln((Component)this.multi);
        mvaInset.addln((Component)this.single);
        mvaInset.add((Component)this.mvaDelimeterLabel);
        mvaInset.add((Component)this.mvaDelimeterField);
        mvaInset.addln((Component)new JLabel(" "));
        ButtonGroup methodGroup = new ButtonGroup();
        methodGroup.add(this.single);
        methodGroup.add(this.multi);
        display.add((Component)mvaInset);
        if (!JXWCSVFieldBuffer.useMultipleColumns) {
            this.mvaDelimeterLabel.setEnabled(false);
            this.mvaDelimeterField.setEnabled(false);
        }
        this.single.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JXWCSV.this.mvaDelimeterLabel.setEnabled(true);
                JXWCSV.this.mvaDelimeterField.setEnabled(true);
                if ("".equals(JXWCSV.this.mvaDelimeterField.getText().trim())) {
                    JXWCSV.this.mvaDelimeterField.setText(";");
                }
            }
        });
        this.multi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JXWCSV.this.mvaDelimeterLabel.setEnabled(false);
                JXWCSV.this.mvaDelimeterField.setEnabled(false);
            }
        });
        CBPanel dataInset = new CBPanel();
        dataInset.setBorder((Border)new TitledBorder(CBIntText.get((String)"Binary Data Format:")));
        dataInset.addln((Component)this.base64);
        dataInset.addln((Component)this.hex);
        dataInset.addln((Component)this.ignore);
        ButtonGroup dataGroup = new ButtonGroup();
        dataGroup.add(this.base64);
        dataGroup.add(this.hex);
        dataGroup.add(this.ignore);
        display.addln((Component)dataInset);
        display.addln((Component)this.myTemplater);
        CBUtility.center((Component)((Object)this), (Component)this.owningBrowser);
        if (firstTime) {
            this.myTemplater.loadDefault();
            firstTime = false;
        } else {
            this.myTemplater.setCurrentTemplateName(currentTemplateName);
        }
    }

    public File getExportFile() {
        this.setVisible(false);
        JFileChooser chooser = new JFileChooser(JXConfig.getProperty((String)"csv.homeDir"));
        chooser.addChoosableFileFilter((FileFilter)new CBFileFilter(new String[]{"csv"}, "CSV Files (*.csv)"));
        if (chooser.showSaveDialog((Component)((Object)this)) == 0) {
            File readFile = chooser.getSelectedFile();
            if (readFile == null) {
                CBUtility.error((String)CBIntText.get((String)"Please select a file"));
            } else {
                int response;
                if ((readFile = this.adjustFileName(readFile)).exists() && (response = JOptionPane.showConfirmDialog((Component)((Object)this), CBIntText.get((String)"The File ''{0}'' already exists. Do you want to replace it?", (Object[])new String[]{readFile.toString()}), CBIntText.get((String)"Overwrite Confirmation"), 0)) != 0) {
                    this.setVisible(true);
                    return null;
                }
                JXConfig.setProperty((String)"csv.homeDir", (String)readFile.getParent());
                return readFile;
            }
        }
        return null;
    }

    protected File adjustFileName(File readFile) {
        if (readFile == null) {
            return null;
        }
        if (readFile.exists()) {
            return readFile;
        }
        String name = readFile.getName();
        if (name.indexOf(46) != -1) {
            return readFile;
        }
        name = name + ".csv";
        return new File(readFile.getParentFile(), name);
    }

    protected boolean writeFile(File exportFile) {
        final SmartTree tree = this.owningBrowser.getActiveTree();
        if (tree.isEmpty()) {
            CBUtility.error((String)CBIntText.get((String)"Unable to export empty tree"), null);
            return true;
        }
        DataBroker dataSource = tree.getDataSource();
        if (exportFile == null) {
            CBUtility.error((String)CBIntText.get((String)"Unable to find file"), null);
            return false;
        }
        final File myFile = exportFile;
        dataSource.extendedRequest(new DataQuery(256){

            public void doExtendedRequest(DataBroker b) {
                CBpbar pbar = new CBpbar((Component)((Object)JXWCSV.this), CBIntText.get((String)"Saving CSV file"), CBIntText.get((String)"Saving Data"));
                DN exportRoot = JXWCSV.this.fullTree.isSelected() ? new DN(JXWCSV.this.fullTree.getText()) : new DN(JXWCSV.this.currentSelection.getText());
                try {
                    JXWCSVExportUtil cvsUtil = new JXWCSVExportUtil();
                    if (JXWCSV.this.owningBrowser.getDisplayMode() == JXplorerBrowser.DisplayMode.SEARCH) {
                        cvsUtil.saveList(tree, exportRoot, myFile, pbar);
                    } else {
                        cvsUtil.saveTree(tree, exportRoot, myFile, pbar);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.setException(e);
                }
                if (pbar.isCanceled() && myFile != null) {
                    myFile.delete();
                }
                JXWCSV.this.closeDown(null, (Closeable)pbar);
            }
        });
        return true;
    }

    public File getImportFile() {
        JFileChooser chooser = new JFileChooser(JXConfig.getProperty((String)"csv.homeDir"));
        chooser.addChoosableFileFilter((FileFilter)new CBFileFilter(new String[]{"csv"}, "CSV Files (*.csv)"));
        int option = chooser.showOpenDialog(this.owner);
        if (option == 0) {
            File readFile = chooser.getSelectedFile();
            if (readFile == null) {
                CBUtility.error((String)CBIntText.get((String)"Please select a file"));
            } else {
                JXConfig.setProperty((String)"csv.homeDir", (String)chooser.getSelectedFile().getParent());
                return readFile;
            }
        }
        return null;
    }

    protected void doFileRead(File readFile) {
        final SmartTree tree = this.owningBrowser.getActiveTree();
        DataBroker dataSource = tree.getDataSource();
        if (readFile == null) {
            CBUtility.error((String)CBIntText.get((String)"unable to read null LDIF file"), null);
        }
        final File myFile = readFile;
        DataQuery csvQuery = new DataQuery(256){

            public void doExtendedRequest(DataBroker offlineDataBroker) {
                FileInputStream rawBytes;
                try {
                    rawBytes = new FileInputStream(myFile);
                }
                catch (FileNotFoundException e) {
                    CBUtility.error((String)CBIntText.get((String)"Unable to read the CSV file ''{0}''.", (Object[])new String[]{myFile.toString()}), (Exception)e);
                    return;
                }
                try {
                    JXWCSVImportUtil cvsUtil = new JXWCSVImportUtil();
                    pmonitor = new ProgressMonitorInputStream(JXWCSV.this.owner, CBIntText.get((String)"Reading LDIF file"), rawBytes);
                    BufferedReader textReader = new BufferedReader(new InputStreamReader((InputStream)rawBytes, "UTF-8"));
                    cvsUtil.loadTree(tree, textReader);
                }
                catch (InterruptedIOException e) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.setException(e);
                }
                JXWCSV.this.closeDown(null, pmonitor);
            }
        };
        dataSource.extendedRequest(csvQuery);
    }

    private void closeDown(Closeable fileStream, Closeable progressThingy) {
        try {
            if (fileStream != null) {
                fileStream.close();
            }
            log.warning("Closed CSV file");
            if (progressThingy != null) {
                progressThingy.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setVisible(false);
        this.dispose();
    }
}

