/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.util.ConstructorReflection;
import mockit.internal.util.DefaultValues;
import mockit.internal.util.ObjectMethods;

public final class MockInvocationHandler
implements InvocationHandler {
    public static final InvocationHandler INSTANCE = new MockInvocationHandler();
    private static final Class<?>[] CONSTRUCTOR_PARAMETERS_FOR_PROXY_CLASS = new Class[]{InvocationHandler.class};

    @Nonnull
    public static Object newMockedInstance(@Nonnull Class<?> proxyClass) {
        Constructor<?> publicConstructor;
        try {
            publicConstructor = proxyClass.getConstructor(CONSTRUCTOR_PARAMETERS_FOR_PROXY_CLASS);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return ConstructorReflection.invoke(publicConstructor, INSTANCE);
    }

    @Override
    @Nullable
    public Object invoke(@Nonnull Object proxy, @Nonnull Method method, @Nonnull Object[] args) {
        Class<?> declaringClass = method.getDeclaringClass();
        String methodName = method.getName();
        if (declaringClass == Object.class) {
            if ("equals".equals(methodName)) {
                return proxy == args[0];
            }
            if ("hashCode".equals(methodName)) {
                return System.identityHashCode(proxy);
            }
            return ObjectMethods.objectIdentity(proxy);
        }
        if (declaringClass == Annotation.class) {
            return proxy.getClass().getInterfaces()[0];
        }
        Class<?> retType = method.getReturnType();
        return DefaultValues.computeForType(retType);
    }
}

