/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.state;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mockit.internal.ClassIdentification;
import mockit.internal.expectations.RecordAndReplayExecution;
import mockit.internal.state.MockClasses;
import mockit.internal.state.MockFixture;
import mockit.internal.state.TestRun;

public final class SavePoint {
    @Nonnull
    private final Set<ClassIdentification> previousTransformedClasses;
    @Nonnull
    private final Map<Class<?>, byte[]> previousRedefinedClasses;
    private final int previousCaptureTransformerCount;
    @Nonnull
    private final List<Class<?>> previousMockedClasses;
    @Nonnull
    private final MockClasses.SavePoint previousMockClasses;

    public SavePoint() {
        MockFixture mockFixture = TestRun.mockFixture();
        this.previousTransformedClasses = mockFixture.getTransformedClasses();
        this.previousRedefinedClasses = mockFixture.getRedefinedClasses();
        this.previousCaptureTransformerCount = mockFixture.getCaptureTransformerCount();
        this.previousMockedClasses = mockFixture.getMockedClasses();
        this.previousMockClasses = TestRun.getMockClasses().new MockClasses.SavePoint();
    }

    public synchronized void rollback() {
        RecordAndReplayExecution.RECORD_OR_REPLAY_LOCK.lock();
        try {
            MockFixture mockFixture = TestRun.mockFixture();
            mockFixture.removeCaptureTransformers(this.previousCaptureTransformerCount);
            mockFixture.restoreTransformedClasses(this.previousTransformedClasses);
            mockFixture.restoreRedefinedClasses(this.previousRedefinedClasses);
            mockFixture.removeMockedClasses(this.previousMockedClasses);
            this.previousMockClasses.rollback();
        }
        finally {
            RecordAndReplayExecution.RECORD_OR_REPLAY_LOCK.unlock();
        }
    }
}

