/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.CodeCoverage;
import mockit.coverage.standalone.CoverageControl;
import mockit.internal.expectations.transformation.ExpectationsTransformer;
import mockit.internal.startup.AgentLoader;
import mockit.internal.startup.InstrumentationHolder;
import mockit.internal.startup.JMockitInitialization;
import mockit.internal.startup.MockingBridgeFields;
import mockit.internal.state.CachedClassfiles;
import mockit.internal.util.StackTrace;

public final class Startup {
    public static boolean initializing;
    private static boolean initializedOnDemand;

    private Startup() {
    }

    public static void premain(@Nullable String agentArgs, @Nonnull Instrumentation inst) {
        if (!Startup.activateCodeCoverageIfRequested(agentArgs, inst)) {
            String hostJREClassName = MockingBridgeFields.createSyntheticFieldsInJREClassToHoldMockingBridges(inst);
            Instrumentation wrappedInst = InstrumentationHolder.set(inst, hostJREClassName);
            Startup.initialize(wrappedInst);
        }
    }

    private static void initialize(@Nonnull Instrumentation inst) {
        inst.addTransformer(CachedClassfiles.INSTANCE, true);
        Startup.applyStartupMocks(inst);
        inst.addTransformer(new ExpectationsTransformer(inst));
    }

    private static void applyStartupMocks(@Nonnull Instrumentation inst) {
        initializing = true;
        try {
            new JMockitInitialization().initialize(inst);
        }
        finally {
            initializing = false;
        }
    }

    public static void agentmain(@Nullable String agentArgs, @Nonnull Instrumentation inst) {
        if (!inst.isRedefineClassesSupported()) {
            throw new UnsupportedOperationException("This JRE must be started in debug mode, or with -javaagent:<proper path>/jmockit.jar");
        }
        String hostJREClassName = InstrumentationHolder.hostJREClassName;
        if (hostJREClassName == null) {
            hostJREClassName = MockingBridgeFields.createSyntheticFieldsInJREClassToHoldMockingBridges(inst);
        }
        InstrumentationHolder.set(inst, hostJREClassName);
        Startup.activateCodeCoverageIfRequested(agentArgs, inst);
    }

    private static boolean activateCodeCoverageIfRequested(@Nullable String agentArgs, @Nonnull Instrumentation inst) {
        boolean standalone = "standalone".equals(agentArgs);
        if (standalone || "coverage".equals(agentArgs)) {
            try {
                if (standalone) {
                    CoverageControl.create();
                }
                CodeCoverage coverage = CodeCoverage.create(standalone, true);
                inst.addTransformer(coverage);
                return true;
            }
            catch (Throwable t) {
                try {
                    PrintWriter out = new PrintWriter("coverage-failure.txt");
                    t.printStackTrace(out);
                    out.close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Nonnull
    public static Instrumentation instrumentation() {
        Startup.verifyInitialization();
        return InstrumentationHolder.get();
    }

    public static boolean wasInitializedOnDemand() {
        return initializedOnDemand;
    }

    public static void verifyInitialization() {
        if (InstrumentationHolder.get() == null) {
            new AgentLoader().loadAgent(null);
            initializedOnDemand = true;
        }
    }

    public static boolean initializeIfPossible() {
        InstrumentationHolder wrappedInst = InstrumentationHolder.get();
        if (wrappedInst == null) {
            try {
                new AgentLoader().loadAgent(null);
                InstrumentationHolder inst = InstrumentationHolder.get();
                String hostJREClassName = MockingBridgeFields.createSyntheticFieldsInJREClassToHoldMockingBridges(inst);
                InstrumentationHolder.setHostJREClassName(hostJREClassName);
                Startup.initialize(inst);
                return true;
            }
            catch (IllegalStateException e) {
                StackTrace.filterStackTrace(e);
                e.printStackTrace();
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
            return false;
        }
        if (wrappedInst.wasRecreated()) {
            Startup.initialize(wrappedInst);
        }
        return true;
    }

    public static void retransformClass(@Nonnull Class<?> aClass) {
        try {
            Startup.instrumentation().retransformClasses(aClass);
        }
        catch (UnmodifiableClassException unmodifiableClassException) {
            // empty catch block
        }
    }

    public static void redefineMethods(@Nonnull Class<?> classToRedefine, @Nonnull byte[] modifiedClassfile) {
        Startup.redefineMethods(new ClassDefinition(classToRedefine, modifiedClassfile));
    }

    public static void redefineMethods(ClassDefinition ... classDefs) {
        try {
            Startup.instrumentation().redefineClasses(classDefs);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (UnmodifiableClassException e) {
            throw new RuntimeException(e);
        }
        catch (InternalError ignore) {
            for (ClassDefinition classDef : classDefs) {
                Startup.detectMissingDependenciesIfAny(classDef.getDefinitionClass());
            }
        }
    }

    private static void detectMissingDependenciesIfAny(@Nonnull Class<?> mockedClass) {
        try {
            Class.forName(mockedClass.getName(), false, mockedClass.getClassLoader());
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("Unable to mock " + mockedClass + " due to a missing dependency", e);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Nullable
    public static Class<?> getClassIfLoaded(@Nonnull String classDescOrName) {
        InstrumentationHolder instrumentation = InstrumentationHolder.get();
        if (instrumentation != null) {
            String className = classDescOrName.replace('/', '.');
            for (Class aClass : instrumentation.getAllLoadedClasses()) {
                if (!aClass.getName().equals(className)) continue;
                return aClass;
            }
        }
        return null;
    }
}

