/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.mockups;

import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.MockUp;
import mockit.external.asm.ClassReader;
import mockit.external.asm.ClassVisitor;
import mockit.internal.classGeneration.ImplementationClass;
import mockit.internal.mockups.InterfaceImplementationGenerator;
import mockit.internal.mockups.MockClassSetup;
import mockit.internal.util.Utilities;

public final class MockedImplementationClass<T> {
    private static final ClassLoader THIS_CL = MockedImplementationClass.class.getClassLoader();
    @Nonnull
    private final MockUp<?> mockUpInstance;
    @Nullable
    private ImplementationClass<T> implementationClass;
    private Class<T> generatedClass;

    public MockedImplementationClass(@Nonnull MockUp<?> mockUpInstance) {
        this.mockUpInstance = mockUpInstance;
    }

    @Nonnull
    public Class<T> createImplementation(@Nonnull Class<T> interfaceToBeMocked, @Nullable Type typeToMock) {
        this.createImplementation(interfaceToBeMocked);
        byte[] generatedBytecode = this.implementationClass == null ? null : this.implementationClass.getGeneratedBytecode();
        MockClassSetup mockClassSetup = new MockClassSetup(this.generatedClass, typeToMock, this.mockUpInstance, generatedBytecode);
        mockClassSetup.redefineMethodsInGeneratedClass();
        return this.generatedClass;
    }

    @Nonnull
    Class<T> createImplementation(@Nonnull Class<T> interfaceToBeMocked) {
        if (Modifier.isPublic(interfaceToBeMocked.getModifiers())) {
            this.generateImplementationForPublicInterface(interfaceToBeMocked);
        } else {
            this.generatedClass = Proxy.getProxyClass(interfaceToBeMocked.getClassLoader(), interfaceToBeMocked);
        }
        return this.generatedClass;
    }

    private void generateImplementationForPublicInterface(@Nonnull Class<T> interfaceToBeMocked) {
        this.implementationClass = new ImplementationClass<T>(interfaceToBeMocked){

            @Override
            @Nonnull
            protected ClassVisitor createMethodBodyGenerator(@Nonnull ClassReader typeReader) {
                return new InterfaceImplementationGenerator(typeReader, this.generatedClassName);
            }
        };
        this.generatedClass = this.implementationClass.generateClass();
    }

    @Nonnull
    public Class<T> createImplementation(@Nonnull Type[] interfacesToBeMocked) {
        Class[] interfacesToMock = new Class[interfacesToBeMocked.length];
        for (int i = 0; i < interfacesToMock.length; ++i) {
            interfacesToMock[i] = Utilities.getClassType(interfacesToBeMocked[i]);
        }
        this.generatedClass = Proxy.getProxyClass(THIS_CL, interfacesToMock);
        new MockClassSetup(this.generatedClass, null, this.mockUpInstance, null).redefineMethods();
        return this.generatedClass;
    }
}

