/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.mockups;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.MockingBridge;
import mockit.internal.mockups.MockState;
import mockit.internal.mockups.MockStates;
import mockit.internal.state.TestRun;
import mockit.internal.util.GenericTypeReflection;
import mockit.internal.util.ObjectMethods;
import mockit.internal.util.Utilities;

final class MockMethods {
    @Nonnull
    final Class<?> realClass;
    private final boolean targetTypeIsAClass;
    private final boolean reentrantRealClass;
    @Nonnull
    private final List<MockMethod> methods;
    @Nullable
    private MockMethod adviceMethod;
    @Nonnull
    private final GenericTypeReflection typeParametersToTypeArguments;
    @Nonnull
    private String mockClassInternalName;
    @Nullable
    private List<MockState> mockStates;

    MockMethods(@Nonnull Class<?> realClass, @Nullable Type targetType) {
        Class<?> targetClass;
        this.realClass = realClass;
        this.targetTypeIsAClass = targetType == null || realClass == targetType ? true : !(targetClass = Utilities.getClassType(targetType)).isInterface();
        this.reentrantRealClass = this.targetTypeIsAClass && MockingBridge.instanceOfClassThatParticipatesInClassLoading(realClass);
        this.methods = new ArrayList<MockMethod>();
        this.typeParametersToTypeArguments = new GenericTypeReflection(realClass, targetType);
        this.mockClassInternalName = "";
    }

    @Nonnull
    Class<?> getRealClass() {
        return this.realClass;
    }

    @Nullable
    MockMethod addMethod(boolean fromSuperClass, int access, @Nonnull String name, @Nonnull String desc) {
        if (fromSuperClass && this.isMethodAlreadyAdded(name, desc)) {
            return null;
        }
        MockMethod mockMethod = new MockMethod(access, name, desc);
        if (mockMethod.isAdvice) {
            this.adviceMethod = mockMethod;
        } else {
            this.methods.add(mockMethod);
        }
        return mockMethod;
    }

    private boolean isMethodAlreadyAdded(@Nonnull String name, @Nonnull String desc) {
        int p = desc.lastIndexOf(41);
        String params = desc.substring(0, p + 1);
        for (MockMethod mockMethod : this.methods) {
            if (!mockMethod.name.equals(name) || !mockMethod.desc.startsWith(params)) continue;
            return true;
        }
        return false;
    }

    void addMockState(@Nonnull MockState mockState) {
        if (this.mockStates == null) {
            this.mockStates = new ArrayList<MockState>(4);
        }
        mockState.mockMethod.indexForMockState = this.mockStates.size();
        this.mockStates.add(mockState);
    }

    @Nullable
    List<MockState> getMockStates() {
        return this.mockStates;
    }

    @Nullable
    MockMethod findMethod(int access, @Nonnull String name, @Nonnull String desc, @Nullable String signature) {
        for (MockMethod mockMethod : this.methods) {
            if (!mockMethod.isMatch(access, name, desc, signature)) continue;
            return mockMethod;
        }
        if (!(this.adviceMethod == null || Modifier.isNative(access) || "$init".equals(name) || "$clinit".equals(name) || ObjectMethods.isMethodFromObject(name, desc))) {
            return this.adviceMethod;
        }
        return null;
    }

    @Nonnull
    String getMockClassInternalName() {
        return this.mockClassInternalName;
    }

    void setMockClassInternalName(@Nonnull String mockClassInternalName) {
        this.mockClassInternalName = mockClassInternalName.intern();
    }

    boolean hasUnusedMocks() {
        if (this.adviceMethod != null) {
            return true;
        }
        for (MockMethod method : this.methods) {
            if (method.hasMatchingRealMethod) continue;
            return true;
        }
        return false;
    }

    void registerMockStates(@Nonnull Object mockUp, boolean forStartupMock) {
        if (this.mockStates != null) {
            MockStates allMockStates = TestRun.getMockStates();
            if (forStartupMock) {
                allMockStates.addStartupMockUpAndItsMockStates(mockUp, this.mockStates);
            } else {
                allMockStates.addMockUpAndItsMockStates(mockUp, this.mockStates);
            }
        }
    }

    final class MockMethod {
        private final int access;
        @Nonnull
        final String name;
        @Nonnull
        final String desc;
        final boolean isAdvice;
        final boolean hasInvocationParameter;
        @Nonnull
        final String mockDescWithoutInvocationParameter;
        private boolean hasMatchingRealMethod;
        @Nullable
        private GenericTypeReflection.GenericSignature mockSignature;
        private int indexForMockState;
        private boolean nativeRealMethod;

        private MockMethod(@Nonnull int access, @Nonnull String name, String desc) {
            this.access = access;
            this.name = name;
            this.desc = desc;
            if (desc.contains("Lmockit/Invocation;")) {
                this.hasInvocationParameter = true;
                this.mockDescWithoutInvocationParameter = '(' + desc.substring(20);
                this.isAdvice = "$advice".equals(name) && "()Ljava/lang/Object;".equals(this.mockDescWithoutInvocationParameter);
            } else {
                this.hasInvocationParameter = false;
                this.mockDescWithoutInvocationParameter = desc;
                this.isAdvice = false;
            }
            this.hasMatchingRealMethod = false;
            this.indexForMockState = -1;
        }

        boolean isMatch(int realAccess, @Nonnull String realName, @Nonnull String realDesc, @Nullable String signature) {
            if (this.name.equals(realName) && this.hasMatchingParameters(realDesc, signature)) {
                this.hasMatchingRealMethod = true;
                this.nativeRealMethod = Modifier.isNative(realAccess);
                return true;
            }
            return false;
        }

        private boolean hasMatchingParameters(@Nonnull String methodDesc, @Nullable String signature) {
            boolean sameParametersIgnoringGenerics = this.mockDescWithoutInvocationParameter.equals(methodDesc);
            if (sameParametersIgnoringGenerics || signature == null) {
                return sameParametersIgnoringGenerics;
            }
            if (this.mockSignature == null) {
                this.mockSignature = MockMethods.this.typeParametersToTypeArguments.parseSignature(this.mockDescWithoutInvocationParameter);
            }
            return this.mockSignature.satisfiesGenericSignature(signature);
        }

        @Nonnull
        Class<?> getRealClass() {
            return MockMethods.this.realClass;
        }

        @Nonnull
        String getMockNameAndDesc() {
            return this.name + this.desc;
        }

        int getIndexForMockState() {
            return this.indexForMockState;
        }

        boolean isStatic() {
            return Modifier.isStatic(this.access);
        }

        boolean isPublic() {
            return Modifier.isPublic(this.access);
        }

        boolean isForGenericMethod() {
            return this.mockSignature != null;
        }

        boolean isForNativeMethod() {
            return this.nativeRealMethod;
        }

        boolean requiresMockState() {
            return this.hasInvocationParameter || MockMethods.this.reentrantRealClass;
        }

        boolean canBeReentered() {
            return MockMethods.this.targetTypeIsAClass && !this.nativeRealMethod;
        }

        public boolean equals(Object obj) {
            MockMethod other = (MockMethod)obj;
            return MockMethods.this.realClass == other.getRealClass() && this.name.equals(other.name) && this.desc.equals(other.desc);
        }

        public int hashCode() {
            return 31 * (31 * MockMethods.this.realClass.hashCode() + this.name.hashCode()) + this.desc.hashCode();
        }
    }
}

