/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.sql.DataSourceDefinition;
import javax.annotation.sql.DataSourceDefinitions;
import javax.sql.CommonDataSource;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.TestedClass;

final class TestDataSource {
    @Nullable
    private final String dsName;
    private Class<? extends CommonDataSource> dsClass;
    private CommonDataSource ds;

    TestDataSource(@Nonnull InjectionPoint injectionPoint) {
        this.dsName = injectionPoint.name;
    }

    @Nullable
    CommonDataSource createIfDataSourceDefinitionAvailable(@Nonnull TestedClass testedClass) {
        if (this.dsName == null) {
            return null;
        }
        Class<?> targetClass = testedClass.targetClass;
        do {
            this.createDataSource(targetClass);
            if (this.ds == null) continue;
            return this.ds;
        } while ((targetClass = targetClass.getSuperclass()) != Object.class);
        throw new IllegalStateException("Missing @DataSourceDefinition of name \"" + this.dsName + "\" on " + testedClass.nameOfTestedClass);
    }

    private void createDataSource(@Nonnull Class<?> targetClass) {
        for (Annotation annotation : targetClass.getDeclaredAnnotations()) {
            String annotationName = annotation.annotationType().getName();
            if ("javax.annotation.sql.DataSourceDefinitions".equals(annotationName)) {
                this.createDataSource((DataSourceDefinitions)annotation);
            } else if ("javax.annotation.sql.DataSourceDefinition".equals(annotationName)) {
                this.createDataSource((DataSourceDefinition)annotation);
            }
            if (this.ds == null) continue;
            return;
        }
    }

    private void createDataSource(@Nonnull DataSourceDefinitions dsDefs) {
        for (DataSourceDefinition dsDef : dsDefs.value()) {
            this.createDataSource(dsDef);
            if (this.ds == null) continue;
            return;
        }
    }

    private void createDataSource(@Nonnull DataSourceDefinition dsDef) {
        String configuredDataSourceName = InjectionPoint.getNameFromJNDILookup(dsDef.name());
        if (configuredDataSourceName.equals(this.dsName)) {
            this.instantiateConfiguredDataSourceClass(dsDef);
            this.setDataSourcePropertiesFromConfiguredValues(dsDef);
        }
    }

    private void instantiateConfiguredDataSourceClass(@Nonnull DataSourceDefinition dsDef) {
        String className = dsDef.className();
        try {
            this.dsClass = Class.forName(className);
            this.ds = this.dsClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void setDataSourcePropertiesFromConfiguredValues(@Nonnull DataSourceDefinition dsDef) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.dsClass, Object.class);
            PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
            this.setProperty(properties, "url", dsDef.url());
            this.setProperty(properties, "user", dsDef.user());
            this.setProperty(properties, "password", dsDef.password());
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void setProperty(@Nonnull PropertyDescriptor[] properties, @Nonnull String name, @Nonnull String value) throws InvocationTargetException, IllegalAccessException {
        for (PropertyDescriptor property : properties) {
            if (!property.getName().equals(name)) continue;
            Method writeMethod = property.getWriteMethod();
            if (writeMethod != null) {
                writeMethod.invoke((Object)this.ds, value);
            }
            return;
        }
    }
}

