/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.injection.InjectionPointProvider;
import mockit.internal.util.Utilities;

final class MultiValuedProvider
extends InjectionPointProvider {
    @Nonnull
    private final List<InjectionPointProvider> individualProviders = new ArrayList<InjectionPointProvider>();

    MultiValuedProvider(@Nonnull Type elementType) {
        super(elementType, "");
    }

    void addInjectable(@Nonnull InjectionPointProvider provider) {
        this.individualProviders.add(provider);
    }

    @Override
    @Nonnull
    protected Class<?> getClassOfDeclaredType() {
        return Utilities.getClassType(this.declaredType);
    }

    @Override
    @Nullable
    protected Object getValue(@Nullable Object owner) {
        ArrayList<Object> values = new ArrayList<Object>(this.individualProviders.size());
        for (InjectionPointProvider provider : this.individualProviders) {
            Object value = provider.getValue(owner);
            values.add(value);
        }
        return values;
    }
}

